/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Objects;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;

public final class StandardAcl
implements Comparable<StandardAcl> {
    private final ResourceType resourceType;
    private final String resourceName;
    private final PatternType patternType;
    private final String principal;
    private final String host;
    private final AclOperation operation;
    private final AclPermissionType permissionType;

    public static StandardAcl fromRecord(AccessControlEntryRecord record) {
        return new StandardAcl(ResourceType.fromCode((byte)record.resourceType()), record.resourceName(), PatternType.fromCode((byte)record.patternType()), record.principal(), record.host(), AclOperation.fromCode((byte)record.operation()), AclPermissionType.fromCode((byte)record.permissionType()));
    }

    public static StandardAcl fromAclBinding(AclBinding acl) {
        return new StandardAcl(acl.pattern().resourceType(), acl.pattern().name(), acl.pattern().patternType(), acl.entry().principal(), acl.entry().host(), acl.entry().operation(), acl.entry().permissionType());
    }

    public StandardAcl(ResourceType resourceType, String resourceName, PatternType patternType, String principal, String host, AclOperation operation, AclPermissionType permissionType) {
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.patternType = patternType;
        this.principal = principal;
        this.host = host;
        this.operation = operation;
        this.permissionType = permissionType;
    }

    public ResourceType resourceType() {
        return this.resourceType;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public PatternType patternType() {
        return this.patternType;
    }

    public String principal() {
        return this.principal;
    }

    public String host() {
        return this.host;
    }

    public AclOperation operation() {
        return this.operation;
    }

    public AclPermissionType permissionType() {
        return this.permissionType;
    }

    public AclBinding toBinding() {
        ResourcePattern resourcePattern = new ResourcePattern(this.resourceType, this.resourceName, this.patternType);
        AccessControlEntry accessControlEntry = new AccessControlEntry(this.principal, this.host, this.operation, this.permissionType);
        return new AclBinding(resourcePattern, accessControlEntry);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(StandardAcl.class)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        StandardAcl other = (StandardAcl)o;
        return this.resourceType.equals((Object)other.resourceType) && this.resourceName.equals(other.resourceName) && this.patternType.equals((Object)other.patternType) && this.principal.equals(other.principal) && this.host.equals(other.host) && this.operation.equals((Object)other.operation) && this.permissionType.equals((Object)other.permissionType);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.resourceName, this.patternType, this.principal, this.host, this.operation, this.permissionType);
    }

    @Override
    public int compareTo(StandardAcl other) {
        int result = this.resourceType.compareTo((Enum)other.resourceType);
        if (result != 0) {
            return result;
        }
        result = other.resourceName.compareTo(this.resourceName);
        if (result != 0) {
            return result;
        }
        result = this.patternType.compareTo((Enum)other.patternType);
        if (result != 0) {
            return result;
        }
        result = this.operation.compareTo((Enum)other.operation);
        if (result != 0) {
            return result;
        }
        result = this.principal.compareTo(other.principal);
        if (result != 0) {
            return result;
        }
        result = this.host.compareTo(other.host);
        if (result != 0) {
            return result;
        }
        result = this.permissionType.compareTo((Enum)other.permissionType);
        return result;
    }

    public String toString() {
        return "StandardAcl(resourceType=" + this.resourceType + ", resourceName=" + this.resourceName + ", patternType=" + this.patternType + ", principal=" + this.principal + ", host=" + this.host + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
    }
}

