/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.CreateTopicRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_CreateTopicRequest
extends CreateTopicRequest {
    private final String topicName;
    private final Optional<Integer> partitionsCount;
    private final Optional<Short> replicationFactor;
    private final Map<Integer, List<Integer>> replicasAssignments;
    private final ImmutableList<CreateTopicRequest.ConfigEntry> configs;

    private AutoValue_CreateTopicRequest(String topicName, Optional<Integer> partitionsCount, Optional<Short> replicationFactor, Map<Integer, List<Integer>> replicasAssignments, ImmutableList<CreateTopicRequest.ConfigEntry> configs) {
        this.topicName = topicName;
        this.partitionsCount = partitionsCount;
        this.replicationFactor = replicationFactor;
        this.replicasAssignments = replicasAssignments;
        this.configs = configs;
    }

    @Override
    @JsonProperty(value="topic_name")
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @JsonProperty(value="partitions_count")
    public Optional<Integer> getPartitionsCount() {
        return this.partitionsCount;
    }

    @Override
    @JsonProperty(value="replication_factor")
    public Optional<Short> getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @JsonProperty(value="replicas_assignments")
    public Map<Integer, List<Integer>> getReplicasAssignments() {
        return this.replicasAssignments;
    }

    @Override
    @JsonProperty(value="configs")
    public ImmutableList<CreateTopicRequest.ConfigEntry> getConfigs() {
        return this.configs;
    }

    public String toString() {
        return "CreateTopicRequest{topicName=" + this.topicName + ", partitionsCount=" + this.partitionsCount + ", replicationFactor=" + this.replicationFactor + ", replicasAssignments=" + this.replicasAssignments + ", configs=" + this.configs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CreateTopicRequest) {
            CreateTopicRequest that = (CreateTopicRequest)o;
            return this.topicName.equals(that.getTopicName()) && this.partitionsCount.equals(that.getPartitionsCount()) && this.replicationFactor.equals(that.getReplicationFactor()) && this.replicasAssignments.equals(that.getReplicasAssignments()) && this.configs.equals(that.getConfigs());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionsCount.hashCode();
        h$ *= 1000003;
        h$ ^= this.replicationFactor.hashCode();
        h$ *= 1000003;
        h$ ^= this.replicasAssignments.hashCode();
        h$ *= 1000003;
        return h$ ^= this.configs.hashCode();
    }

    static final class Builder
    extends CreateTopicRequest.Builder {
        private String topicName;
        private Optional<Integer> partitionsCount = Optional.empty();
        private Optional<Short> replicationFactor = Optional.empty();
        private Map<Integer, List<Integer>> replicasAssignments;
        private ImmutableList<CreateTopicRequest.ConfigEntry> configs;

        Builder() {
        }

        @Override
        public CreateTopicRequest.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public CreateTopicRequest.Builder setPartitionsCount(@Nullable Integer partitionsCount) {
            this.partitionsCount = Optional.ofNullable(partitionsCount);
            return this;
        }

        @Override
        public CreateTopicRequest.Builder setReplicationFactor(@Nullable Short replicationFactor) {
            this.replicationFactor = Optional.ofNullable(replicationFactor);
            return this;
        }

        @Override
        public CreateTopicRequest.Builder setReplicasAssignments(Map<Integer, List<Integer>> replicasAssignments) {
            if (replicasAssignments == null) {
                throw new NullPointerException("Null replicasAssignments");
            }
            this.replicasAssignments = replicasAssignments;
            return this;
        }

        @Override
        public CreateTopicRequest.Builder setConfigs(List<CreateTopicRequest.ConfigEntry> configs) {
            this.configs = ImmutableList.copyOf(configs);
            return this;
        }

        @Override
        public CreateTopicRequest build() {
            String missing = "";
            if (this.topicName == null) {
                missing = missing + " topicName";
            }
            if (this.replicasAssignments == null) {
                missing = missing + " replicasAssignments";
            }
            if (this.configs == null) {
                missing = missing + " configs";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CreateTopicRequest(this.topicName, this.partitionsCount, this.replicationFactor, this.replicasAssignments, this.configs);
        }
    }
}

