/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.ratelimit;

import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.ratelimit.DoNotRateLimit;
import io.confluent.kafkarest.ratelimit.FixedCostRateLimitRequestFilter;
import io.confluent.kafkarest.ratelimit.FixedCostRateLimiterImpl;
import io.confluent.kafkarest.ratelimit.NullFixedCostRateLimiter;
import io.confluent.kafkarest.ratelimit.RateLimitModule;
import io.confluent.kafkarest.ratelimit.RequestRateLimiter;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.FeatureContext;

final class FixedCostRateLimitFeature
implements DynamicFeature {
    private final Map<String, Integer> costs;
    private final int defaultCost;
    private final RequestRateLimiter requestRateLimiter;

    @Inject
    FixedCostRateLimitFeature(@ConfigModule.RateLimitCostsConfig Map<String, Integer> costs, @ConfigModule.RateLimitDefaultCostConfig Integer defaultCost, @Context @RateLimitModule.RequestRateLimiterGeneric RequestRateLimiter requestRateLimiter) {
        this.costs = Objects.requireNonNull(costs);
        this.defaultCost = defaultCost;
        this.requestRateLimiter = Objects.requireNonNull(requestRateLimiter);
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        int cost = this.getCost(resourceInfo);
        if (cost == 0) {
            context.register((Object)new FixedCostRateLimitRequestFilter(new NullFixedCostRateLimiter()));
        } else {
            context.register((Object)new FixedCostRateLimitRequestFilter(new FixedCostRateLimiterImpl(this.requestRateLimiter, cost)));
        }
    }

    private int getCost(ResourceInfo resourceInfo) {
        DoNotRateLimit methodIgnore = resourceInfo.getResourceMethod().getAnnotation(DoNotRateLimit.class);
        if (methodIgnore != null) {
            return 0;
        }
        DoNotRateLimit classIgnore = resourceInfo.getResourceClass().getAnnotation(DoNotRateLimit.class);
        if (classIgnore != null) {
            return 0;
        }
        ResourceAccesslistFeature.ResourceName methodName = resourceInfo.getResourceMethod().getAnnotation(ResourceAccesslistFeature.ResourceName.class);
        if (methodName != null && this.costs.containsKey(methodName.value())) {
            return this.costs.get(methodName.value());
        }
        ResourceAccesslistFeature.ResourceName className = resourceInfo.getResourceClass().getAnnotation(ResourceAccesslistFeature.ResourceName.class);
        if (className != null && this.costs.containsKey(className.value())) {
            return this.costs.get(className.value());
        }
        return this.defaultCost;
    }
}

