/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.protobuf.ByteString;
import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.ProduceController;
import io.confluent.kafkarest.controllers.RecordSerializer;
import io.confluent.kafkarest.controllers.SchemaManager;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.ProduceResult;
import io.confluent.kafkarest.entities.RegisteredSchema;
import io.confluent.kafkarest.entities.v3.ProduceRequest;
import io.confluent.kafkarest.entities.v3.ProduceResponse;
import io.confluent.kafkarest.exceptions.BadRequestException;
import io.confluent.kafkarest.exceptions.StacklessCompletionException;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.ratelimit.DoNotRateLimit;
import io.confluent.kafkarest.ratelimit.RateLimitExceededException;
import io.confluent.kafkarest.resources.v3.ProduceRateLimiters;
import io.confluent.kafkarest.resources.v3.ProducerMetrics;
import io.confluent.kafkarest.resources.v3.V3ResourcesModule;
import io.confluent.kafkarest.response.StreamingResponseFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collector;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.apache.kafka.common.errors.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DoNotRateLimit
@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/records")
@ResourceAccesslistFeature.ResourceName(value="api.v3.produce.*")
public final class ProduceAction {
    private static final Logger log = LoggerFactory.getLogger(ProduceAction.class);
    private static final Collector<ProduceRequest.ProduceRequestHeader, ImmutableMultimap.Builder<String, Optional<ByteString>>, ImmutableMultimap<String, Optional<ByteString>>> PRODUCE_REQUEST_HEADER_COLLECTOR = Collector.of(ImmutableMultimap::builder, (builder, header) -> builder.put((Object)header.getName(), header.getValue()), (left, right) -> left.putAll((Multimap)right.build()), ImmutableMultimap.Builder::build, new Collector.Characteristics[0]);
    private final Provider<SchemaManager> schemaManagerProvider;
    private final Provider<RecordSerializer> recordSerializerProvider;
    private final Provider<ProduceController> produceControllerProvider;
    private final Provider<ProducerMetrics> producerMetrics;
    private final StreamingResponseFactory streamingResponseFactory;
    private final ProduceRateLimiters produceRateLimiters;
    private final ExecutorService executorService;

    @Inject
    public ProduceAction(Provider<SchemaManager> schemaManagerProvider, Provider<RecordSerializer> recordSerializer, Provider<ProduceController> produceControllerProvider, Provider<ProducerMetrics> producerMetrics, StreamingResponseFactory streamingResponseFactory, ProduceRateLimiters produceRateLimiters, @V3ResourcesModule.ProduceResponseThreadPool ExecutorService executorService) {
        this.schemaManagerProvider = Objects.requireNonNull(schemaManagerProvider);
        this.recordSerializerProvider = Objects.requireNonNull(recordSerializer);
        this.produceControllerProvider = Objects.requireNonNull(produceControllerProvider);
        this.producerMetrics = Objects.requireNonNull(producerMetrics);
        this.streamingResponseFactory = Objects.requireNonNull(streamingResponseFactory);
        this.produceRateLimiters = Objects.requireNonNull(produceRateLimiters);
        this.executorService = Objects.requireNonNull(executorService);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.produce.produce-to-topic")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.produce.produce-to-topic")
    public void produce(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, MappingIterator<ProduceRequest> requests) throws Exception {
        if (requests == null) {
            throw Errors.invalidPayloadException("Null input provided. Data is required.");
        }
        ProduceController controller = (ProduceController)this.produceControllerProvider.get();
        this.streamingResponseFactory.from(requests).compose(request -> this.produce(clusterId, topicName, (ProduceRequest)request, controller)).resume(asyncResponse);
    }

    private CompletableFuture<ProduceResponse> produce(String clusterId, String topicName, ProduceRequest request, ProduceController controller) {
        try {
            this.produceRateLimiters.rateLimit(clusterId, request.getOriginalSize());
        }
        catch (RateLimitExceededException e) {
            throw new StacklessCompletionException(e);
        }
        Instant requestInstant = Instant.now();
        Optional<RegisteredSchema> keySchema = request.getKey().flatMap(key -> this.getSchema(topicName, true, (ProduceRequest.ProduceRequestData)key));
        Optional<EmbeddedFormat> keyFormat = keySchema.map(schema -> Optional.of(schema.getFormat())).orElse(request.getKey().flatMap(ProduceRequest.ProduceRequestData::getFormat));
        Optional<ByteString> serializedKey = this.serialize(topicName, keyFormat, keySchema, request.getKey(), true);
        Optional<RegisteredSchema> valueSchema = request.getValue().flatMap(value -> this.getSchema(topicName, false, (ProduceRequest.ProduceRequestData)value));
        Optional<EmbeddedFormat> valueFormat = valueSchema.map(schema -> Optional.of(schema.getFormat())).orElse(request.getValue().flatMap(ProduceRequest.ProduceRequestData::getFormat));
        Optional<ByteString> serializedValue = this.serialize(topicName, valueFormat, valueSchema, request.getValue(), false);
        this.recordRequestMetrics(request.getOriginalSize());
        CompletableFuture<ProduceResult> produceResult = controller.produce(clusterId, topicName, request.getPartitionId(), (Multimap<String, Optional<ByteString>>)((Multimap)request.getHeaders().stream().collect(PRODUCE_REQUEST_HEADER_COLLECTOR)), serializedKey, serializedValue, request.getTimestamp().orElse(Instant.now()));
        return ((CompletableFuture)produceResult.handleAsync((result, error) -> {
            if (error != null) {
                long latency = Duration.between(requestInstant, Instant.now()).toMillis();
                this.recordErrorMetrics(latency);
                throw new StacklessCompletionException((Throwable)error);
            }
            return result;
        }, (Executor)this.executorService)).thenApplyAsync(result -> {
            ProduceResponse response = ProduceAction.toProduceResponse(clusterId, topicName, keyFormat, keySchema, valueFormat, valueSchema, result);
            long latency = Duration.between(requestInstant, result.getCompletionTimestamp()).toMillis();
            this.recordResponseMetrics(latency);
            return response;
        }, (Executor)this.executorService);
    }

    private Optional<RegisteredSchema> getSchema(String topicName, boolean isKey, ProduceRequest.ProduceRequestData data) {
        if (data.getFormat().isPresent() && !data.getFormat().get().requiresSchema()) {
            return Optional.empty();
        }
        try {
            return Optional.of(((SchemaManager)this.schemaManagerProvider.get()).getSchema(topicName, data.getFormat(), data.getSubject(), data.getSubjectNameStrategy().map(Function.identity()), data.getSchemaId(), data.getSchemaVersion(), data.getRawSchema(), isKey));
        }
        catch (SerializationException se) {
            throw Errors.messageSerializationException(se.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), iae);
        }
    }

    private Optional<ByteString> serialize(String topicName, Optional<EmbeddedFormat> format, Optional<RegisteredSchema> schema, Optional<ProduceRequest.ProduceRequestData> data, boolean isKey) {
        return ((RecordSerializer)this.recordSerializerProvider.get()).serialize(format.orElse(EmbeddedFormat.BINARY), topicName, schema, data.map(ProduceRequest.ProduceRequestData::getData).orElse((JsonNode)NullNode.getInstance()), isKey);
    }

    private static ProduceResponse toProduceResponse(String clusterId, String topicName, Optional<EmbeddedFormat> keyFormat, Optional<RegisteredSchema> keySchema, Optional<EmbeddedFormat> valueFormat, Optional<RegisteredSchema> valueSchema, ProduceResult result) {
        return ProduceResponse.builder().setClusterId(clusterId).setTopicName(topicName).setPartitionId(result.getPartitionId()).setOffset(result.getOffset()).setTimestamp(result.getTimestamp()).setKey(keyFormat.map(format -> ProduceResponse.ProduceResponseData.builder().setType(keyFormat).setSubject(keySchema.map(RegisteredSchema::getSubject)).setSchemaId(keySchema.map(RegisteredSchema::getSchemaId)).setSchemaVersion(keySchema.map(RegisteredSchema::getSchemaVersion)).setSize(result.getSerializedKeySize()).build())).setValue(valueFormat.map(format -> ProduceResponse.ProduceResponseData.builder().setType(valueFormat).setSubject(valueSchema.map(RegisteredSchema::getSubject)).setSchemaId(valueSchema.map(RegisteredSchema::getSchemaId)).setSchemaVersion(valueSchema.map(RegisteredSchema::getSchemaVersion)).setSize(result.getSerializedValueSize()).build())).build();
    }

    private void recordResponseMetrics(long latency) {
        ((ProducerMetrics)this.producerMetrics.get()).recordResponse();
        ((ProducerMetrics)this.producerMetrics.get()).recordRequestLatency(latency);
    }

    private void recordErrorMetrics(long latency) {
        ((ProducerMetrics)this.producerMetrics.get()).recordError();
        ((ProducerMetrics)this.producerMetrics.get()).recordRequestLatency(latency);
    }

    private void recordRequestMetrics(long size) {
        ((ProducerMetrics)this.producerMetrics.get()).recordRequest();
        ((ProducerMetrics)this.producerMetrics.get()).recordRequestSize(size);
    }
}

