/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.squareup.wire.Syntax;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.ExtensionsElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.GroupElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ReservedElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.ranges.IntRange;

public class ProtobufSchemaUtils {
    private static final ObjectMapper jsonMapper = JacksonMapper.INSTANCE;

    public static ProtobufSchema copyOf(ProtobufSchema schema) {
        return schema.copy();
    }

    public static ProtobufSchema getSchema(Message message) {
        return message != null ? new ProtobufSchema(message.getDescriptorForType()) : null;
    }

    public static Object toObject(JsonNode value, ProtobufSchema schema) throws IOException {
        StringWriter out = new StringWriter();
        jsonMapper.writeValue((Writer)out, (Object)value);
        return ProtobufSchemaUtils.toObject(out.toString(), schema);
    }

    public static Object toObject(String value, ProtobufSchema schema) throws InvalidProtocolBufferException {
        DynamicMessage.Builder message = schema.newMessageBuilder();
        JsonFormat.parser().merge(value, (Message.Builder)message);
        return message.build();
    }

    public static byte[] toJson(Message message) throws IOException {
        if (message == null) {
            return null;
        }
        String jsonString = JsonFormat.printer().includingDefaultValueFields().omittingInsignificantWhitespace().print((MessageOrBuilder)message);
        return jsonString.getBytes(StandardCharsets.UTF_8);
    }

    protected static String toNormalizedString(ProtobufSchema schema) {
        Context ctx = new Context();
        ctx.collectTypeInfo(schema, true);
        return ProtobufSchemaUtils.toString(ctx, schema.rawSchema(), true);
    }

    protected static String toString(ProtoFileElement protoFile) {
        return ProtobufSchemaUtils.toString(new Context(), protoFile, false);
    }

    private static String toString(Context ctx, ProtoFileElement protoFile, boolean normalize) {
        List<TypeElement> types;
        StringBuilder sb = new StringBuilder();
        if (!(protoFile.getSyntax() == null || normalize && protoFile.getSyntax() != Syntax.PROTO_3)) {
            sb.append("syntax = \"");
            sb.append(protoFile.getSyntax());
            sb.append("\";\n");
        }
        if (protoFile.getPackageName() != null) {
            sb.append("package ");
            sb.append(protoFile.getPackageName());
            sb.append(";\n");
        }
        if (!protoFile.getImports().isEmpty() || !protoFile.getPublicImports().isEmpty()) {
            sb.append('\n');
            List imports = protoFile.getImports();
            if (normalize) {
                imports = imports.stream().sorted().distinct().collect(Collectors.toList());
            }
            for (Object file : imports) {
                sb.append("import \"");
                sb.append((String)file);
                sb.append("\";\n");
            }
            List publicImports = protoFile.getPublicImports();
            if (normalize) {
                publicImports = publicImports.stream().sorted().distinct().collect(Collectors.toList());
            }
            for (String file : publicImports) {
                sb.append("import public \"");
                sb.append(file);
                sb.append("\";\n");
            }
        }
        if (!protoFile.getOptions().isEmpty()) {
            sb.append('\n');
            ArrayList<OptionElement> options = protoFile.getOptions();
            if (normalize) {
                options = new ArrayList<OptionElement>(options);
                options.sort(Comparator.comparing(OptionElement::getName));
            }
            for (OptionElement option : options) {
                sb.append(ProtobufSchemaUtils.toOptionString(option, normalize));
            }
        }
        if (!(types = ProtobufSchemaUtils.filterTypes(ctx, protoFile.getTypes(), normalize)).isEmpty()) {
            Throwable throwable;
            Context.NamedScope nameScope;
            sb.append('\n');
            for (TypeElement typeElement : types) {
                if (!(typeElement instanceof MessageElement)) continue;
                nameScope = ctx.enterName(typeElement.getName());
                throwable = null;
                try {
                    sb.append(ProtobufSchemaUtils.toString(ctx, (MessageElement)typeElement, normalize));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (nameScope == null) continue;
                    if (throwable != null) {
                        try {
                            nameScope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    nameScope.close();
                }
            }
            for (TypeElement typeElement : types) {
                if (!(typeElement instanceof EnumElement)) continue;
                nameScope = ctx.enterName(typeElement.getName());
                throwable = null;
                try {
                    sb.append(ProtobufSchemaUtils.toString(ctx, (EnumElement)typeElement, normalize));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (nameScope == null) continue;
                    if (throwable != null) {
                        try {
                            nameScope.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    nameScope.close();
                }
            }
        }
        if (!protoFile.getExtendDeclarations().isEmpty()) {
            sb.append('\n');
            for (ExtendElement extendDeclaration : protoFile.getExtendDeclarations()) {
                sb.append(extendDeclaration.toSchema());
            }
        }
        if (!protoFile.getServices().isEmpty()) {
            sb.append('\n');
            for (ServiceElement service : protoFile.getServices()) {
                sb.append(ProtobufSchemaUtils.toString(ctx, service, normalize));
            }
        }
        return sb.toString();
    }

    private static String toString(Context ctx, ServiceElement service, boolean normalize) {
        StringBuilder sb = new StringBuilder();
        sb.append("service ");
        sb.append(service.getName());
        sb.append(" {");
        if (!service.getOptions().isEmpty()) {
            sb.append('\n');
            ArrayList<OptionElement> options = service.getOptions();
            if (normalize) {
                options = new ArrayList<OptionElement>(options);
                options.sort(Comparator.comparing(OptionElement::getName));
            }
            for (OptionElement option : options) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toOptionString(option, normalize));
            }
        }
        if (!service.getRpcs().isEmpty()) {
            sb.append('\n');
            for (RpcElement rpc : service.getRpcs()) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, rpc, normalize));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String toString(Context ctx, RpcElement rpc, boolean normalize) {
        StringBuilder sb = new StringBuilder();
        sb.append("rpc ");
        sb.append(rpc.getName());
        sb.append(" (");
        if (rpc.getRequestStreaming()) {
            sb.append("stream ");
        }
        String requestType = rpc.getRequestType();
        if (normalize) {
            requestType = ProtobufSchemaUtils.resolve(ctx, requestType);
        }
        sb.append(requestType);
        sb.append(") returns (");
        if (rpc.getResponseStreaming()) {
            sb.append("stream ");
        }
        String responseType = rpc.getResponseType();
        if (normalize) {
            responseType = ProtobufSchemaUtils.resolve(ctx, responseType);
        }
        sb.append(responseType);
        sb.append(")");
        if (!rpc.getOptions().isEmpty()) {
            sb.append(" {\n");
            ArrayList<OptionElement> options = rpc.getOptions();
            if (normalize) {
                options = new ArrayList<OptionElement>(options);
                options.sort(Comparator.comparing(OptionElement::getName));
            }
            for (OptionElement option : options) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toOptionString(option, normalize));
            }
            sb.append('}');
        }
        sb.append(";\n");
        return sb.toString();
    }

    private static String toString(Context ctx, EnumElement type, boolean normalize) {
        StringBuilder sb = new StringBuilder();
        sb.append("enum ");
        sb.append(type.getName());
        sb.append(" {");
        if (!type.getReserveds().isEmpty()) {
            sb.append('\n');
            List reserveds = type.getReserveds();
            if (normalize) {
                reserveds = reserveds.stream().flatMap(r -> r.getValues().stream().map(o -> new ReservedElement(r.getLocation(), r.getDocumentation(), Collections.singletonList(o)))).collect(Collectors.toList());
                Comparator<Object> cmp = Comparator.comparing(r -> {
                    Object o = ((ReservedElement)r).getValues().get(0);
                    if (o instanceof IntRange) {
                        return ((IntRange)o).getStart();
                    }
                    if (o instanceof Integer) {
                        return (Integer)o;
                    }
                    return Integer.MAX_VALUE;
                }).thenComparing(r -> ((ReservedElement)r).getValues().get(0).toString());
                reserveds.sort(cmp);
            }
            for (ReservedElement reserved : reserveds) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, reserved, normalize));
            }
        }
        if (!(!type.getReserveds().isEmpty() || type.getOptions().isEmpty() && type.getConstants().isEmpty())) {
            sb.append('\n');
        }
        if (!type.getOptions().isEmpty()) {
            ArrayList<OptionElement> options = type.getOptions();
            if (normalize) {
                options = new ArrayList<OptionElement>(options);
                options.sort(Comparator.comparing(OptionElement::getName));
            }
            for (OptionElement option : options) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toOptionString(option, normalize));
            }
        }
        if (!type.getConstants().isEmpty()) {
            ArrayList<EnumConstantElement> constants = type.getConstants();
            if (normalize) {
                constants = new ArrayList<EnumConstantElement>(constants);
                constants.sort(Comparator.comparing(EnumConstantElement::getTag).thenComparing(EnumConstantElement::getName));
            }
            for (EnumConstantElement constant : constants) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, constant, normalize));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String toString(Context ctx, EnumConstantElement type, boolean normalize) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getName());
        sb.append(" = ");
        sb.append(type.getTag());
        ArrayList<OptionElement> options = type.getOptions();
        if (!options.isEmpty()) {
            if (normalize) {
                options = new ArrayList<OptionElement>(options);
                options.sort(Comparator.comparing(OptionElement::getName));
            }
            sb.append(" ");
            ProtobufSchemaUtils.appendOptions(sb, options, normalize);
        }
        sb.append(";\n");
        return sb.toString();
    }

    private static String toString(Context ctx, MessageElement type, boolean normalize) {
        List<TypeElement> types;
        Iterator cmp;
        StringBuilder sb = new StringBuilder();
        sb.append("message ");
        sb.append(type.getName());
        sb.append(" {");
        if (!type.getReserveds().isEmpty()) {
            sb.append('\n');
            List reserveds = type.getReserveds();
            if (normalize) {
                reserveds = reserveds.stream().flatMap(r -> r.getValues().stream().map(o -> new ReservedElement(r.getLocation(), r.getDocumentation(), Collections.singletonList(o)))).collect(Collectors.toList());
                cmp = Comparator.comparing(r -> {
                    Object o = ((ReservedElement)r).getValues().get(0);
                    if (o instanceof IntRange) {
                        return ((IntRange)o).getStart();
                    }
                    if (o instanceof Integer) {
                        return (Integer)o;
                    }
                    return Integer.MAX_VALUE;
                }).thenComparing(r -> ((ReservedElement)r).getValues().get(0).toString());
                reserveds.sort(cmp);
            }
            for (ReservedElement reserved : reserveds) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, reserved, normalize));
            }
        }
        if (!type.getOptions().isEmpty()) {
            sb.append('\n');
            ArrayList<OptionElement> options = type.getOptions();
            if (normalize) {
                options = new ArrayList<OptionElement>(options);
                options.sort(Comparator.comparing(OptionElement::getName));
            }
            for (OptionElement option : options) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toOptionString(option, normalize));
            }
        }
        if (!type.getFields().isEmpty()) {
            sb.append('\n');
            ArrayList<FieldElement> fields = type.getFields();
            if (normalize) {
                fields = new ArrayList<FieldElement>(fields);
                fields.sort(Comparator.comparing(FieldElement::getTag));
            }
            for (FieldElement field : fields) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, field, normalize));
            }
        }
        if (!type.getOneOfs().isEmpty()) {
            sb.append('\n');
            Object oneOfs = type.getOneOfs();
            if (normalize) {
                oneOfs = oneOfs.stream().filter(o -> !o.getFields().isEmpty()).map(o -> {
                    ArrayList<FieldElement> fields = new ArrayList<FieldElement>(o.getFields());
                    fields.sort(Comparator.comparing(FieldElement::getTag));
                    return new OneOfElement(o.getName(), o.getDocumentation(), fields, o.getGroups(), o.getOptions(), ProtobufSchema.DEFAULT_LOCATION);
                }).collect(Collectors.toList());
                oneOfs.sort(Comparator.comparing(o -> ((FieldElement)o.getFields().get(0)).getTag()));
            }
            cmp = oneOfs.iterator();
            while (cmp.hasNext()) {
                OneOfElement oneOf = (OneOfElement)cmp.next();
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, oneOf, normalize));
            }
        }
        if (!type.getGroups().isEmpty()) {
            sb.append('\n');
            for (GroupElement group : type.getGroups()) {
                ProtobufSchemaUtils.appendIndented(sb, group.toSchema());
            }
        }
        if (!type.getExtensions().isEmpty()) {
            sb.append('\n');
            for (ExtensionsElement extension : type.getExtensions()) {
                ProtobufSchemaUtils.appendIndented(sb, extension.toSchema());
            }
        }
        if (!(types = ProtobufSchemaUtils.filterTypes(ctx, type.getNestedTypes(), normalize)).isEmpty()) {
            Throwable throwable;
            Context.NamedScope nameScope;
            sb.append('\n');
            for (TypeElement typeElement : types) {
                if (!(typeElement instanceof MessageElement)) continue;
                nameScope = ctx.enterName(typeElement.getName());
                throwable = null;
                try {
                    ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, (MessageElement)typeElement, normalize));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (nameScope == null) continue;
                    if (throwable != null) {
                        try {
                            nameScope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    nameScope.close();
                }
            }
            for (TypeElement typeElement : types) {
                if (!(typeElement instanceof EnumElement)) continue;
                nameScope = ctx.enterName(typeElement.getName());
                throwable = null;
                try {
                    ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, (EnumElement)typeElement, normalize));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (nameScope == null) continue;
                    if (throwable != null) {
                        try {
                            nameScope.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    nameScope.close();
                }
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String toString(Context ctx, ReservedElement type, boolean normalize) {
        StringBuilder sb = new StringBuilder();
        sb.append("reserved ");
        boolean first = true;
        for (Object value : type.getValues()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
                continue;
            }
            if (value instanceof Integer) {
                sb.append(value);
                continue;
            }
            if (value instanceof IntRange) {
                IntRange range = (IntRange)value;
                sb.append(range.getStart());
                sb.append(" to ");
                int last = range.getEndInclusive();
                if (last < 0x1FFFFFFF) {
                    sb.append(last);
                    continue;
                }
                sb.append("max");
                continue;
            }
            throw new IllegalArgumentException();
        }
        sb.append(";\n");
        return sb.toString();
    }

    private static String toString(Context ctx, OneOfElement type, boolean normalize) {
        StringBuilder sb = new StringBuilder();
        sb.append("oneof ");
        sb.append(type.getName());
        sb.append(" {");
        if (!type.getOptions().isEmpty()) {
            sb.append('\n');
            ArrayList<OptionElement> options = type.getOptions();
            if (normalize) {
                options = new ArrayList<OptionElement>(options);
                options.sort(Comparator.comparing(OptionElement::getName));
            }
            for (OptionElement option : options) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toOptionString(option, normalize));
            }
        }
        if (!type.getFields().isEmpty()) {
            sb.append('\n');
            List fields = type.getFields();
            for (FieldElement field : fields) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, field, normalize));
            }
        }
        if (!type.getGroups().isEmpty()) {
            sb.append('\n');
            for (GroupElement group : type.getGroups()) {
                ProtobufSchemaUtils.appendIndented(sb, group.toSchema());
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String toString(Context ctx, FieldElement field, boolean normalize) {
        String jsonName;
        StringBuilder sb = new StringBuilder();
        Field.Label label = field.getLabel();
        String fieldType = field.getType();
        ProtoType fieldProtoType = ProtoType.get((String)fieldType);
        if (normalize) {
            if (!fieldProtoType.isScalar() && !fieldProtoType.isMap()) {
                Context.TypeElementInfo typeInfo = ctx.getTypeForFullName(fieldType = ProtobufSchemaUtils.resolve(ctx, fieldType), true);
                fieldProtoType = typeInfo != null && typeInfo.isMap() ? typeInfo.getMapType() : ProtoType.get((String)fieldType);
            }
            ProtoType mapValueType = fieldProtoType.getValueType();
            if (fieldProtoType.isMap() && mapValueType != null) {
                String valueType = ctx.resolve(mapValueType.toString(), true);
                if (valueType != null) {
                    fieldProtoType = ProtoType.get((String)("map<" + fieldProtoType.getKeyType() + ", ." + valueType + ">"));
                }
                label = null;
            }
            fieldType = fieldProtoType.toString();
        }
        if (label != null) {
            sb.append(label.name().toLowerCase(Locale.US));
            sb.append(" ");
        }
        sb.append(fieldType);
        sb.append(" ");
        sb.append(field.getName());
        sb.append(" = ");
        sb.append(field.getTag());
        ArrayList<OptionElement> optionsWithSpecialValues = new ArrayList<OptionElement>(field.getOptions());
        String defaultValue = field.getDefaultValue();
        if (defaultValue != null) {
            optionsWithSpecialValues.add(OptionElement.Companion.create("default", ProtobufSchemaUtils.toKind(fieldProtoType), (Object)defaultValue));
        }
        if ((jsonName = field.getJsonName()) != null) {
            optionsWithSpecialValues.add(OptionElement.Companion.create("json_name", OptionElement.Kind.STRING, (Object)jsonName));
        }
        if (!optionsWithSpecialValues.isEmpty()) {
            sb.append(" ");
            if (normalize) {
                optionsWithSpecialValues.sort(Comparator.comparing(OptionElement::getName));
            }
            ProtobufSchemaUtils.appendOptions(sb, optionsWithSpecialValues, normalize);
        }
        sb.append(";\n");
        return sb.toString();
    }

    private static String toString(OptionElement option, boolean normalize) {
        StringBuilder sb = new StringBuilder();
        String name = option.getName();
        if (option.isParenthesized()) {
            sb.append("(").append(name).append(")");
        } else {
            sb.append(name);
        }
        Object value = option.getValue();
        switch (option.getKind()) {
            case STRING: {
                sb.append(" = \"");
                sb.append(ProtobufSchemaUtils.escapeChars(value.toString()));
                sb.append("\"");
                break;
            }
            case BOOLEAN: 
            case NUMBER: 
            case ENUM: {
                sb.append(" = ");
                sb.append(value);
                break;
            }
            case OPTION: {
                sb.append(".");
                sb.append(ProtobufSchemaUtils.toString((OptionElement)value, normalize));
                break;
            }
            case MAP: {
                sb.append(" = {\n");
                ProtobufSchemaUtils.formatOptionMap(sb, (Map)value, normalize);
                sb.append('}');
                break;
            }
            case LIST: {
                sb.append(" = ");
                ProtobufSchemaUtils.appendOptions(sb, (List)value, normalize);
                break;
            }
        }
        return sb.toString();
    }

    private static List<TypeElement> filterTypes(Context ctx, List<TypeElement> types, boolean normalize) {
        if (normalize) {
            return types.stream().filter(type -> {
                if (type instanceof MessageElement) {
                    Context.TypeElementInfo typeInfo = ctx.getType(type.getName(), true);
                    return typeInfo == null || !typeInfo.isMap();
                }
                return true;
            }).collect(Collectors.toList());
        }
        return types;
    }

    private static void formatOptionMap(StringBuilder sb, Map<String, Object> valueMap, boolean normalize) {
        int lastIndex = valueMap.size() - 1;
        int index = 0;
        Collection<String> keys = valueMap.keySet();
        if (normalize) {
            keys = keys.stream().sorted().collect(Collectors.toList());
        }
        for (String key : keys) {
            String endl = index != lastIndex ? "," : "";
            String kv = key + ": " + ProtobufSchemaUtils.formatOptionMapOrListValue(valueMap.get(key), normalize) + endl;
            ProtobufSchemaUtils.appendIndented(sb, kv);
            ++index;
        }
    }

    private static String formatOptionMapOrListValue(Object value, boolean normalize) {
        StringBuilder sb = new StringBuilder();
        if (value instanceof String) {
            sb.append("\"");
            sb.append(ProtobufSchemaUtils.escapeChars(value.toString()));
            sb.append("\"");
        } else if (value instanceof Map) {
            sb.append("{\n");
            ProtobufSchemaUtils.formatOptionMap(sb, (Map)value, normalize);
            sb.append('}');
        } else if (value instanceof List) {
            List list = (List)value;
            if (normalize && list.size() == 1) {
                sb.append(ProtobufSchemaUtils.formatOptionMapOrListValue(list.get(0), normalize));
            } else {
                sb.append("[\n");
                int lastIndex = list.size() - 1;
                for (int i = 0; i < list.size(); ++i) {
                    String endl = i != lastIndex ? "," : "";
                    String v = ProtobufSchemaUtils.formatOptionMapOrListValue(list.get(i), normalize) + endl;
                    ProtobufSchemaUtils.appendIndented(sb, v);
                }
                sb.append("]");
            }
        } else if (value instanceof OptionElement.OptionPrimitive) {
            OptionElement.OptionPrimitive primitive = (OptionElement.OptionPrimitive)value;
            switch (primitive.getKind()) {
                case BOOLEAN: 
                case NUMBER: 
                case ENUM: {
                    sb.append(primitive.getValue());
                    break;
                }
                default: {
                    sb.append(ProtobufSchemaUtils.formatOptionMapOrListValue(primitive.getValue(), normalize));
                    break;
                }
            }
        } else if (value instanceof OptionElement) {
            sb.append(ProtobufSchemaUtils.toString((OptionElement)value, normalize));
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    private static String toOptionString(OptionElement option, boolean normalize) {
        StringBuilder sb = new StringBuilder();
        sb.append("option ").append(ProtobufSchemaUtils.toString(option, normalize)).append(";\n");
        return sb.toString();
    }

    private static void appendOptions(StringBuilder sb, List<?> options, boolean normalize) {
        int count = options.size();
        if (count == 1) {
            sb.append('[').append(ProtobufSchemaUtils.formatOptionMapOrListValue(options.get(0), normalize)).append(']');
            return;
        }
        sb.append("[\n");
        for (int i = 0; i < count; ++i) {
            String endl = i < count - 1 ? "," : "";
            ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.formatOptionMapOrListValue(options.get(i), normalize) + endl);
        }
        sb.append(']');
    }

    private static OptionElement.Kind toKind(ProtoType protoType) {
        switch (protoType.getSimpleName()) {
            case "bool": {
                return OptionElement.Kind.BOOLEAN;
            }
            case "string": {
                return OptionElement.Kind.STRING;
            }
            case "bytes": 
            case "double": 
            case "float": 
            case "fixed32": 
            case "fixed64": 
            case "int32": 
            case "int64": 
            case "sfixed32": 
            case "sfixed64": 
            case "sint32": 
            case "sint64": 
            case "uint32": 
            case "uint64": {
                return OptionElement.Kind.NUMBER;
            }
        }
        return OptionElement.Kind.ENUM;
    }

    private static void appendIndented(StringBuilder sb, String value) {
        List<String> lines = Arrays.asList(value.split("\n"));
        if (lines.size() > 1 && lines.get(lines.size() - 1).isEmpty()) {
            lines.remove(lines.size() - 1);
        }
        for (String line : lines) {
            sb.append("  ").append(line).append('\n');
        }
    }

    public static String escapeChars(String input) {
        StringBuilder buffer = new StringBuilder(input.length());
        block12: for (int i = 0; i < input.length(); ++i) {
            char curr = input.charAt(i);
            switch (curr) {
                case '\u0007': {
                    buffer.append("\\a");
                    continue block12;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block12;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block12;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block12;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block12;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block12;
                }
                case '\u000b': {
                    buffer.append("\\v");
                    continue block12;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block12;
                }
                case '\'': {
                    buffer.append("\\'");
                    continue block12;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block12;
                }
                default: {
                    buffer.append(curr);
                }
            }
        }
        return buffer.toString();
    }

    private static String resolve(Context ctx, String type) {
        String resolved = ctx.resolve(type, true);
        if (resolved == null) {
            throw new IllegalArgumentException("Could not resolve type: " + type);
        }
        return "." + resolved;
    }
}

