/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.log.LogCleaner$;
import kafka.network.SocketServer$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.DynamicLogConfig$;
import kafka.server.DynamicThreadPool$;
import kafka.server.KafkaConfig$;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.SetOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class DynamicBrokerConfig$ {
    public static final DynamicBrokerConfig$ MODULE$ = new DynamicBrokerConfig$();
    private static final scala.collection.mutable.Set<String> DynamicSecurityConfigs = CollectionConverters$.MODULE$.SetHasAsScala(SslConfigs.RECONFIGURABLE_CONFIGS).asScala();
    private static final scala.collection.mutable.Set<String> AllDynamicConfigs = (scala.collection.mutable.Set)MODULE$.DynamicSecurityConfigs().$plus$plus(LogCleaner$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicThreadPool$.MODULE$.ReconfigurableConfigs()).$plus$plus((IterableOnce)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MetricReporterClassesProp()}))).$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(SocketServer$.MODULE$.ReconfigurableConfigs());
    private static final Set<String> ClusterLevelListenerConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MaxConnectionsProp(), KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), KafkaConfig$.MODULE$.NumNetworkThreadsProp()}));
    private static final scala.collection.mutable.Set<String> PerBrokerConfigs = (scala.collection.mutable.Set)((SetOps)MODULE$.DynamicSecurityConfigs().$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs())).diff(MODULE$.ClusterLevelListenerConfigs());
    private static final Set<String> ListenerMechanismConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.SaslJaasConfigProp(), KafkaConfig$.MODULE$.SaslLoginCallbackHandlerClassProp(), KafkaConfig$.MODULE$.SaslLoginClassProp(), KafkaConfig$.MODULE$.SaslServerCallbackHandlerClassProp(), KafkaConfig$.MODULE$.ConnectionsMaxReauthMsProp()}));
    private static final Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.truststore.location"}));
    private static final Regex ListenerConfigRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("listener\\.name\\.[^.]*\\.(.*)"));
    private static final scala.collection.mutable.Set<String> DynamicPasswordConfigs;

    static {
        Set passwordConfigs = ((MapOps)KafkaConfig$.MODULE$.configKeys().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.$anonfun$DynamicPasswordConfigs$1(x$1)))).keySet();
        DynamicPasswordConfigs = (scala.collection.mutable.Set)MODULE$.AllDynamicConfigs().intersect(passwordConfigs);
    }

    public scala.collection.mutable.Set<String> DynamicSecurityConfigs() {
        return DynamicSecurityConfigs;
    }

    public scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return AllDynamicConfigs;
    }

    private Set<String> ClusterLevelListenerConfigs() {
        return ClusterLevelListenerConfigs;
    }

    private scala.collection.mutable.Set<String> PerBrokerConfigs() {
        return PerBrokerConfigs;
    }

    private Set<String> ListenerMechanismConfigs() {
        return ListenerMechanismConfigs;
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs() {
        return kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    }

    public Regex ListenerConfigRegex() {
        return ListenerConfigRegex;
    }

    private scala.collection.mutable.Set<String> DynamicPasswordConfigs() {
        return DynamicPasswordConfigs;
    }

    public boolean isPasswordConfig(String name) {
        return this.DynamicPasswordConfigs().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(x$1)));
    }

    public List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        Option option;
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string = KafkaConfig$.MODULE$.LogRollTimeMillisProp();
        if (!(string != null ? !string.equals(name) : name != null)) {
            bl3 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.LogRollTimeHoursProp();
            bl3 = !(string2 != null ? !string2.equals(name) : name != null);
        }
        if (bl3) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$));
        }
        String string3 = KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp();
        if (!(string3 != null ? !string3.equals(name) : name != null)) {
            bl2 = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp();
            bl2 = !(string4 != null ? !string4.equals(name) : name != null);
        }
        if (bl2) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), (List)Nil$.MODULE$));
        }
        String string5 = KafkaConfig$.MODULE$.LogFlushIntervalMsProp();
        if (!(string5 != null ? !string5.equals(name) : name != null)) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogFlushIntervalMsProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), (List)Nil$.MODULE$));
        }
        String string6 = KafkaConfig$.MODULE$.LogRetentionTimeMillisProp();
        if (!(string6 != null ? !string6.equals(name) : name != null)) {
            bl = true;
        } else {
            String string7 = KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp();
            if (!(string7 != null ? !string7.equals(name) : name != null)) {
                bl = true;
            } else {
                String string8 = KafkaConfig$.MODULE$.LogRetentionTimeHoursProp();
                bl = !(string8 != null ? !string8.equals(name) : name != null);
            }
        }
        if (bl) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), (List)Nil$.MODULE$)));
        }
        if (name != null && !(option = this.ListenerConfigRegex().unapplySeq((CharSequence)name)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOps)option.get()).apply(0);
            if (matchListenerOverride) {
                Option mechanismConfig = this.ListenerMechanismConfigs().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)baseName.endsWith(x$1)));
                return new .colon.colon((Object)name, (List)new .colon.colon((Object)((String)mechanismConfig.getOrElse((Function0 & Serializable)() -> baseName)), (List)Nil$.MODULE$));
            }
        }
        return new .colon.colon((Object)name, (List)Nil$.MODULE$);
    }

    public void validateConfigs(Properties props, boolean perBrokerConfig) {
        DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Cannot update these configs dynamically");
        DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "These security configs can be dynamically updated only per-listener using the listener prefix");
        this.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
        if (!perBrokerConfig) {
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Cannot update these configs at default cluster level, broker id must be specified");
            return;
        }
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$perBrokerConfigs(Properties props) {
        Set configNames = CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().keySet();
        return (Set)configNames.intersect(this.PerBrokerConfigs()).$plus$plus((IterableOnce)configNames.filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)this.perBrokerListenerConfig$1(name))));
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(Properties props) {
        return (Set)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().keySet().intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(Properties props) {
        return (Set)this.DynamicSecurityConfigs().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)props.containsKey(x$1)));
    }

    public void kafka$server$DynamicBrokerConfig$$validateConfigTypes(Properties props) {
        Properties baseProps = new Properties();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Option option;
                String string = (String)x0$1._1();
                String v = (String)x0$1._2();
                if (string != null && !(option = MODULE$.ListenerConfigRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                    String baseName = (String)((LinearSeqOps)option.get()).apply(0);
                    return baseProps.put(baseName, v);
                }
            }
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return baseProps.put(k, v);
            }
            throw new MatchError(null);
        });
        DynamicConfig$Broker$.MODULE$.validate(baseProps);
    }

    public void addDynamicConfigs(ConfigDef configDef) {
        KafkaConfig$.MODULE$.configKeys().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(configName, config) -> {
            if (MODULE$.AllDynamicConfigs().contains(configName)) {
                return configDef.define(config.name, config.type, config.defaultValue, config.validator, config.importance, config.documentation, config.group, config.orderInGroup, config.width, config.displayName, config.dependents, config.recommender);
            }
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
    }

    public java.util.Map<String, String> dynamicConfigUpdateModes() {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)this.AllDynamicConfigs().map((Function1 & Serializable)name -> {
            String mode = MODULE$.PerBrokerConfigs().contains(name) ? "per-broker" : "cluster-wide";
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)mode);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public Properties resolveVariableConfigs(Properties propsOriginal) {
        Properties props = new Properties();
        AbstractConfig config = new AbstractConfig(new ConfigDef(), (java.util.Map)propsOriginal, Utils.castToStringObjectMap((java.util.Map)propsOriginal), false);
        ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(config.originals()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.$anonfun$resolveVariableConfigs$1(x$2)))).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                Object value = x0$1._2();
                if (key != null && value != null) {
                    return props.put(key, value);
                }
            }
            throw new MatchError(x0$1);
        });
        return props;
    }

    public static final /* synthetic */ boolean $anonfun$DynamicPasswordConfigs$1(Tuple2 x$1) {
        ConfigDef.Type type = ((ConfigDef.ConfigKey)x$1._2()).type;
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    private static final void checkInvalidProps$1(Set invalidPropNames, String errorMessage) {
        if (invalidPropNames.nonEmpty()) {
            throw new ConfigException(new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final boolean perBrokerListenerConfig$1(String name) {
        Option option;
        if (name != null && !(option = this.ListenerConfigRegex().unapplySeq((CharSequence)name)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOps)option.get()).apply(0);
            return !this.ClusterLevelListenerConfigs().contains((Object)baseName);
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$resolveVariableConfigs$1(Tuple2 x$2) {
        return !((String)x$2._1()).startsWith("config.providers");
    }

    private DynamicBrokerConfig$() {
    }
}

