/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t=d\u0001\u0002\u001e<\u0001\u0001C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t+\u0002\u0011\t\u0011)A\u0005-\"A!\r\u0001B\u0001B\u0003%1\rC\u0003r\u0001\u0011\u0005!\u000f\u0003\u0006x\u0001A\u0005\t1!Q\u0001\naD\u0011\"!\u0003\u0001\u0005\u0004%I!a\u0003\t\u000f\u00055\u0001\u0001)A\u0005w\"I\u0011q\u0002\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\b\u0003'\u0001\u0001\u0015!\u0003\u007f\u0011%\t)\u0002\u0001b\u0001\n\u0013\t9\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\r\u0011%\t)\u0003\u0001b\u0001\n\u0013\t9\u0003\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA\u0015\u0011%\t9\u0007\u0001b\u0001\n\u0013\tI\u0007\u0003\u0005\u0002\u0002\u0002\u0001\u000b\u0011BA6\u0011%\t\u0019\t\u0001b\u0001\n\u0013\t)\t\u0003\u0005\u0002\u0010\u0002\u0001\u000b\u0011BAD\u0011%\t\t\n\u0001b\u0001\n\u0013\t\u0019\n\u0003\u0005\u0002\u001e\u0002\u0001\u000b\u0011BAK\u0011\u001d\ty\n\u0001C!\u0003CCq!!+\u0001\t\u0003\n\t\u000bC\u0004\u0002,\u0002!\t%!)\b\u000f\u000556\b#\u0001\u00020\u001a1!h\u000fE\u0001\u0003cCa!\u001d\r\u0005\u0002\u0005M\u0006\"CA[1\t\u0007I\u0011AA\\\u0011!\ti\f\u0007Q\u0001\n\u0005e\u0006\"CA`1\t\u0007I\u0011AAa\u0011!\tY\r\u0007Q\u0001\n\u0005\r\u0007\"CAg1\t\u0007I\u0011AAh\u0011!\t9\u000e\u0007Q\u0001\n\u0005Eg!CAm1A\u0005\u0019\u0013EAn\u000f\u001d\u0011\u0019\u0006\u0007EA\u0005\u00031q!a8\u0019\u0011\u0003\u000b\t\u000f\u0003\u0004rE\u0011\u0005\u0011q \u0005\n\u0005\u0007\u0011\u0013\u0011!C!\u0003oC\u0011B!\u0002#\u0003\u0003%\tAa\u0002\t\u0013\t=!%!A\u0005\u0002\tE\u0001\"\u0003B\u000eE\u0005\u0005I\u0011\tB\u000f\u0011%\u0011)CIA\u0001\n\u0003\u00119\u0003C\u0005\u00032\t\n\t\u0011\"\u0011\u00034!I!Q\u0007\u0012\u0002\u0002\u0013\u0005#q\u0007\u0005\n\u0005s\u0011\u0013\u0011!C\u0005\u0005w9qA!\u0016\u0019\u0011\u0003\u0013IEB\u0004\u0003DaA\tI!\u0012\t\rElC\u0011\u0001B$\u0011%\u0011\u0019!LA\u0001\n\u0003\n9\fC\u0005\u0003\u00065\n\t\u0011\"\u0001\u0003\b!I!qB\u0017\u0002\u0002\u0013\u0005!1\n\u0005\n\u00057i\u0013\u0011!C!\u0005;A\u0011B!\n.\u0003\u0003%\tAa\u0014\t\u0013\tER&!A\u0005B\tM\u0002\"\u0003B\u001b[\u0005\u0005I\u0011\tB\u001c\u0011%\u0011I$LA\u0001\n\u0013\u0011Y\u0004C\u0004\u0003Xa!\tA!\u0017\t\u0013\tu\u0003D1A\u0005\u0002\t}\u0003\u0002\u0003B71\u0001\u0006IA!\u0019\u0003\u001f-\u000bgm[1SC\u001a$8+\u001a:wKJT!\u0001P\u001f\u0002\rM,'O^3s\u0015\u0005q\u0014!B6bM.\f7\u0001A\n\u0005\u0001\u0005;5\n\u0005\u0002C\u000b6\t1IC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15I\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0011&k\u0011aO\u0005\u0003\u0015n\u0012aaU3sm\u0016\u0014\bC\u0001'P\u001b\u0005i%B\u0001(>\u0003\u0015)H/\u001b7t\u0013\t\u0001VJA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\tA5+\u0003\u0002Uw\tY1*\u00194lC\u000e{gNZ5h\u0003\u0011!\u0018.\\3\u0011\u0005]\u0003W\"\u0001-\u000b\u00059K&B\u0001.\\\u0003\u0019\u0019w.\\7p]*\u0011a\b\u0018\u0006\u0003;z\u000ba!\u00199bG\",'\"A0\u0002\u0007=\u0014x-\u0003\u0002b1\n!A+[7f\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010E\u0002CI\u001aL!!Z\"\u0003\r=\u0003H/[8o!\t9gN\u0004\u0002iYB\u0011\u0011nQ\u0007\u0002U*\u00111nP\u0001\u0007yI|w\u000e\u001e \n\u00055\u001c\u0015A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\\\"\u0002\rqJg.\u001b;?)\u0011\u0019H/\u001e<\u0011\u0005!\u0003\u0001\"B)\u0005\u0001\u0004\u0011\u0006\"B+\u0005\u0001\u00041\u0006\"\u00022\u0005\u0001\u0004\u0019\u0017a\u0001=%cA!!)_>\u007f\u0013\tQ8I\u0001\u0004UkBdWM\r\t\u0003\u0011rL!!`\u001e\u0003\u001d5+G/\u0019)s_B,'\u000f^5fgB!q0!\u0002g\u001b\t\t\tAC\u0002\u0002\u0004\r\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9!!\u0001\u0003\u0007M+\u0017/A\u0005nKR\f\u0007K]8qgV\t10\u0001\u0006nKR\f\u0007K]8qg\u0002\n1b\u001c4gY&tW\rR5sgV\ta0\u0001\u0007pM\u001ad\u0017N\\3ESJ\u001c\b%A\u0004nKR\u0014\u0018nY:\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003?i!!!\b\u000b\u0007\u0005U\u0011,\u0003\u0003\u0002\"\u0005u!aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005a2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,WCAA\u0015!\u0019\tY#!\u000f\u0002>5\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\r\u00026\u0005!Q\u000f^5m\u0015\t\t9$\u0001\u0003kCZ\f\u0017\u0002BA\u001e\u0003[\u0011\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!!\ty$!\u0011\u0002F\u0005ESBAA\u0019\u0013\u0011\t\u0019%!\r\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002H\u00055SBAA%\u0015\u0011\tY%!\u000e\u0002\t1\fgnZ\u0005\u0005\u0003\u001f\nIEA\u0004J]R,w-\u001a:\u0011\t\u0005M\u0013q\f\b\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011L.\u0002\tI\fg\r^\u0005\u0005\u0003;\n9&\u0001\u0006SC\u001a$8i\u001c8gS\u001eLA!!\u0019\u0002d\tY\u0011\t\u001a3sKN\u001c8\u000b]3d\u0015\u0011\ti&a\u0016\u0002;\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sK\u0002\n1B]1gi6\u000bg.Y4feV\u0011\u00111\u000e\t\u0007\u0003[\n\t(!\u001e\u000e\u0005\u0005=$bAA-{%!\u00111OA8\u0005AY\u0015MZ6b%\u00064G/T1oC\u001e,'\u000f\u0005\u0003\u0002x\u0005uTBAA=\u0015\rQ\u00161\u0010\u0006\u0003ymKA!a \u0002z\t!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:\fAB]1gi6\u000bg.Y4fe\u0002\naA\u0019:pW\u0016\u0014XCAAD!\u0011\u0011E-!#\u0011\u0007!\u000bY)C\u0002\u0002\u000en\u0012AB\u0011:pW\u0016\u00148+\u001a:wKJ\fqA\u0019:pW\u0016\u0014\b%\u0001\u0006d_:$(o\u001c7mKJ,\"!!&\u0011\t\t#\u0017q\u0013\t\u0004\u0011\u0006e\u0015bAANw\t\u00012i\u001c8ue>dG.\u001a:TKJ4XM]\u0001\fG>tGO]8mY\u0016\u0014\b%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005\r\u0006c\u0001\"\u0002&&\u0019\u0011qU\"\u0003\tUs\u0017\u000e^\u0001\tg\",H\u000fZ8x]\u0006i\u0011m^1jiNCW\u000f\u001e3po:\fqbS1gW\u0006\u0014\u0016M\u001a;TKJ4XM\u001d\t\u0003\u0011b\u0019\"\u0001G!\u0015\u0005\u0005=\u0016!D'fi\u0006$\u0017\r^1U_BL7-\u0006\u0002\u0002:B!\u0011qIA^\u0013\ry\u0017\u0011J\u0001\u000f\u001b\u0016$\u0018\rZ1uCR{\u0007/[2!\u0003EiU\r^1eCR\f\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u0007\u0004B!!2\u0002H6\t\u0011,C\u0002\u0002Jf\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\nNKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u0004\u0013aD'fi\u0006$\u0017\r^1U_BL7-\u00133\u0016\u0005\u0005E\u0007\u0003BAc\u0003'L1!!6Z\u0005\u0011)V/\u001b3\u0002!5+G/\u00193bi\u0006$v\u000e]5d\u0013\u0012\u0004#a\u0003)s_\u000e,7o\u001d*pY\u0016\u001c\"\u0001I!*\u0007\u0001\u0012SF\u0001\u0006Ce>\\WM\u001d*pY\u0016\u001c\u0002BI!\u0002d\u0006\u001d\u0018Q\u001e\t\u0004\u0003K\u0004S\"\u0001\r\u0011\u0007\t\u000bI/C\u0002\u0002l\u000e\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002p\u0006eh\u0002BAy\u0003kt1![Az\u0013\u0005!\u0015bAA|\u0007\u00069\u0001/Y2lC\u001e,\u0017\u0002BA~\u0003{\u0014AbU3sS\u0006d\u0017N_1cY\u0016T1!a>D)\t\u0011\t\u0001E\u0002\u0002f\n\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0005!\r\u0011%1B\u0005\u0004\u0005\u001b\u0019%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\n\u00053\u00012A\u0011B\u000b\u0013\r\u00119b\u0011\u0002\u0004\u0003:L\b\u0002C<'\u0003\u0003\u0005\rA!\u0003\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\b\u0011\u000b}\u0014\tCa\u0005\n\t\t\r\u0012\u0011\u0001\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003*\t=\u0002c\u0001\"\u0003,%\u0019!QF\"\u0003\u000f\t{w\u000e\\3b]\"Aq\u000fKA\u0001\u0002\u0004\u0011\u0019\"\u0001\u0005iCND7i\u001c3f)\t\u0011I!\u0001\u0005u_N#(/\u001b8h)\t\tI,\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003>A!\u0011q\tB \u0013\u0011\u0011\t%!\u0013\u0003\r=\u0013'.Z2u\u00059\u0019uN\u001c;s_2dWM\u001d*pY\u0016\u001c\u0002\"L!\u0002d\u0006\u001d\u0018Q\u001e\u000b\u0003\u0005\u0013\u00022!!:.)\u0011\u0011\u0019B!\u0014\t\u0011]\f\u0014\u0011!a\u0001\u0005\u0013!BA!\u000b\u0003R!AqoMA\u0001\u0002\u0004\u0011\u0019\"\u0001\u0006Ce>\\WM\u001d*pY\u0016\fabQ8oiJ|G\u000e\\3s%>dW-A\tj]&$\u0018.\u00197ju\u0016dun\u001a#jeN$2\u0001\u001fB.\u0011\u0015\tv\u00071\u0001S\u00031\u0019wN\u001c4jON\u001b\u0007.Z7b+\t\u0011\t\u0007\u0005\u0003\u0003d\t%TB\u0001B3\u0015\r\u00119gW\u0001\t[\u0016$\u0018\rZ1uC&!!1\u000eB3\u0005EY\u0015MZ6b\u0007>tg-[4TG\",W.Y\u0001\u000eG>tg-[4TG\",W.\u0019\u0011")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple2 x$1;
    private final MetaProperties metaProps;
    private final Seq<String> offlineDirs;
    private final Metrics metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaConfigSchema configSchema() {
        return KafkaRaftServer$.MODULE$.configSchema();
    }

    public static Tuple2<MetaProperties, Seq<String>> initializeLogDirs(KafkaConfig config) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(config);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaProperties metaProps() {
        return this.metaProps;
    }

    private Seq<String> offlineDirs() {
        return this.offlineDirs;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.raftManager().startup();
        this.controller().foreach((Function1 & Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.raftManager().shutdown();
        this.controller().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, Level.WARN);
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public KafkaRaftServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        this.config = config;
        this.time = time;
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple2<MetaProperties, Seq<String>> tuple2 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MetaProperties metaProps = (MetaProperties)tuple2._1();
        Seq offlineDirs = (Seq)tuple2._2();
        this.x$1 = new Tuple2((Object)metaProps, (Object)offlineDirs);
        this.metaProps = (MetaProperties)this.x$1._1();
        this.offlineDirs = (Seq)this.x$1._2();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaProps().clusterId());
        this.controllerQuorumVotersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections(config.quorumVoters()));
        this.raftManager = new KafkaRaftManager(this.metaProps(), config, new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), time, this.metrics(), threadNamePrefix, this.controllerQuorumVotersFuture());
        this.broker = config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) ? new Some((Object)new BrokerServer(config, this.metaProps(), this.raftManager(), time, this.metrics(), threadNamePrefix, this.offlineDirs(), this.controllerQuorumVotersFuture(), Server$.MODULE$.SUPPORTED_FEATURES())) : None$.MODULE$;
        this.controller = config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$) ? new Some((Object)new ControllerServer(this.metaProps(), config, this.raftManager(), time, this.metrics(), threadNamePrefix, this.controllerQuorumVotersFuture(), KafkaRaftServer$.MODULE$.configSchema())) : None$.MODULE$;
    }

    public static interface ProcessRole {
    }
}

