/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.regex.Pattern;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.SplitSegmentResult;
import kafka.server.FetchDataInfo;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

public final class LocalLog$
implements Logging {
    public static final LocalLog$ MODULE$ = new LocalLog$();
    private static final String LogFileSuffix = ".log";
    private static final String IndexFileSuffix = ".index";
    private static final String TimeIndexFileSuffix = ".timeindex";
    private static final String TxnIndexFileSuffix = ".txnindex";
    private static final String DeletedFileSuffix = ".deleted";
    private static final String CleanedFileSuffix = ".cleaned";
    private static final String SwapFileSuffix = ".swap";
    private static final String DeleteDirSuffix = "-delete";
    private static final String FutureDirSuffix = "-future";
    private static final Pattern DeleteDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(MODULE$.DeleteDirSuffix()).toString());
    private static final Pattern FutureDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(MODULE$.FutureDirSuffix()).toString());
    private static final long UnknownOffset = -1L;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String LogFileSuffix() {
        return LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return TimeIndexFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return TxnIndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return SwapFileSuffix;
    }

    public String DeleteDirSuffix() {
        return DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return FutureDirSuffix;
    }

    public Pattern DeleteDirPattern() {
        return DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return FutureDirPattern;
    }

    public long UnknownOffset() {
        return UnknownOffset;
    }

    public String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public File logFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.LogFileSuffix()).append(suffix).toString());
    }

    public String logFile$default$3() {
        return "";
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        String suffix = new StringBuilder(2).append("-").append(topicPartition.partition()).append(".").append(uniqueId).append(this.DeleteDirSuffix()).toString();
        int prefixLength = Math.min(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(topicPartition.topic())), 255 - StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(suffix)));
        return new StringBuilder(0).append(topicPartition.topic().substring(0, prefixLength)).append(suffix).toString();
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffix(topicPartition, this.FutureDirSuffix());
    }

    public String logDirNameWithSuffix(TopicPartition topicPartition, String suffix) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        return new StringBuilder(1).append(this.logDirName(topicPartition)).append(".").append(uniqueId).append(suffix).toString();
    }

    public String logDirName(TopicPartition topicPartition) {
        return new StringBuilder(1).append(topicPartition.topic()).append("-").append(topicPartition.partition()).toString();
    }

    public File offsetIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.IndexFileSuffix()).append(suffix).toString());
    }

    public String offsetIndexFile$default$3() {
        return "";
    }

    public File timeIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TimeIndexFileSuffix()).append(suffix).toString());
    }

    public String timeIndexFile$default$3() {
        return "";
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TxnIndexFileSuffix()).append(suffix).toString());
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public long offsetFromFileName(String filename) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(filename.substring(0, filename.indexOf(46))));
    }

    public long offsetFromFile(File file) {
        return this.offsetFromFileName(file.getName());
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        int n;
        if (dir == null) {
            throw new KafkaException("dir should not be null");
        }
        String dirName = dir.getName();
        if (dirName == null || dirName.isEmpty() || !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(dirName), '-')) {
            throw LocalLog$.exception$1(dir);
        }
        if (dirName.endsWith(this.DeleteDirSuffix()) && !this.DeleteDirPattern().matcher(dirName).matches() || dirName.endsWith(this.FutureDirSuffix()) && !this.FutureDirPattern().matcher(dirName).matches()) {
            throw LocalLog$.exception$1(dir);
        }
        String name = dirName.endsWith(this.DeleteDirSuffix()) || dirName.endsWith(this.FutureDirSuffix()) ? dirName.substring(0, dirName.lastIndexOf(46)) : dirName;
        int index = name.lastIndexOf(45);
        String topic = name.substring(0, index);
        String partitionString = name.substring(index + 1);
        if (topic.isEmpty() || partitionString.isEmpty()) {
            throw LocalLog$.exception$1(dir);
        }
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partitionString));
        }
        catch (NumberFormatException numberFormatException) {
            throw LocalLog$.exception$1(dir);
        }
        int partition = n;
        return new TopicPartition(topic, partition);
    }

    public boolean isIndexFile(File file) {
        String filename = file.getName();
        return filename.endsWith(this.IndexFileSuffix()) || filename.endsWith(this.TimeIndexFileSuffix()) || filename.endsWith(this.TxnIndexFileSuffix());
    }

    public boolean isLogFile(File file) {
        return file.getPath().endsWith(this.LogFileSuffix());
    }

    public <T> T maybeHandleIOException(LogDirFailureChannel logDirFailureChannel, String logDir, Function0<String> errorMsg, Function0<T> fun) {
        if (logDirFailureChannel.hasOfflineLogDir(logDir)) {
            throw new KafkaStorageException(new StringBuilder(63).append("The log dir ").append(logDir).append(" is already offline due to a previous IO exception.").toString());
        }
        try {
            return (T)fun.apply();
        }
        catch (IOException e) {
            logDirFailureChannel.maybeAddOfflineLogDir(logDir, errorMsg, e);
            throw new KafkaStorageException((String)errorMsg.apply(), (Throwable)e);
        }
    }

    public SplitSegmentResult splitOverflowedSegment(LogSegment segment, LogSegments existingSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        Predef$.MODULE$.require(this.isLogFile(segment.log().file()), (Function0 & Serializable)() -> new StringBuilder(18).append("Cannot split file ").append(segment.log().file().getAbsoluteFile()).toString());
        Predef$.MODULE$.require(segment.hasOverflow(), (Function0 & Serializable)() -> new StringBuilder(86).append("Split operation is only permitted for segments with overflow, and the problem path is ").append(segment.log().file().getAbsoluteFile()).toString());
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = LocalLog$.$anonfun$splitOverflowedSegment$3(logPrefix, segment);
            Object var19_9 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        ListBuffer newSegments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            int bytesAppended;
            FileRecords sourceRecords = segment.log();
            for (int position = 0; position < sourceRecords.sizeInBytes(); position += bytesAppended) {
                FileLogInputStream.FileChannelRecordBatch firstBatch = (FileLogInputStream.FileChannelRecordBatch)CollectionConverters$.MODULE$.IterableHasAsScala(sourceRecords.batchesFrom(position)).asScala().head();
                LogSegment newSegment = this.createNewCleanedSegment(dir, config, firstBatch.baseOffset());
                newSegments.$plus$eq((Object)newSegment);
                bytesAppended = newSegment.appendFromFile(sourceRecords, position);
                if (bytesAppended != 0) continue;
                throw new IllegalStateException(new StringBuilder(43).append("Failed to append records from position ").append(position).append(" in ").append(segment).toString());
            }
            IntRef totalSizeOfNewSegments = IntRef.create((int)0);
            newSegments.foreach((Function1 & Serializable)splitSegment -> {
                LocalLog$.$anonfun$splitOverflowedSegment$4(segment, totalSizeOfNewSegments, splitSegment);
                return BoxedUnit.UNIT;
            });
            if (totalSizeOfNewSegments.elem != segment.log().sizeInBytes()) {
                throw new IllegalStateException(new StringBuilder(55).append("Inconsistent segment sizes after split").append(" before: ").append(segment.log().sizeInBytes()).append(" after: ").append(totalSizeOfNewSegments.elem).toString());
            }
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = LocalLog$.$anonfun$splitOverflowedSegment$5(logPrefix, segment, newSegments);
                Object var20_17 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            scala.collection.immutable.Seq newSegmentsToAdd = newSegments.toSeq();
            Iterable<LogSegment> deletedSegments = this.replaceSegments(existingSegments, (Seq<LogSegment>)newSegmentsToAdd, (Seq<LogSegment>)new .colon.colon((Object)segment, (List)Nil$.MODULE$), dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix, false);
            return new SplitSegmentResult((Iterable<LogSegment>)deletedSegments.toSeq(), (Iterable<LogSegment>)newSegmentsToAdd);
        }
        catch (Exception e) {
            newSegments.foreach((Function1 & Serializable)splitSegment -> {
                LocalLog$.$anonfun$splitOverflowedSegment$6(splitSegment);
                return BoxedUnit.UNIT;
            });
            throw e;
        }
    }

    public Iterable<LogSegment> replaceSegments(LogSegments existingSegments, Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix, boolean isRecoveredSwapFile) {
        Seq sortedNewSegments = (Seq)newSegments.sortBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()), (Ordering)Ordering.Long$.MODULE$);
        Seq sortedOldSegments = (Seq)((SeqOps)oldSegments.filter((Function1 & Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)existingSegments.contains(seg.baseOffset())))).sortBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.baseOffset()), (Ordering)Ordering.Long$.MODULE$);
        if (!isRecoveredSwapFile) {
            ((IterableOnceOps)sortedNewSegments.reverse()).foreach((Function1 & Serializable)x$8 -> {
                x$8.changeFileSuffixes(LocalLog$.MODULE$.CleanedFileSuffix(), LocalLog$.MODULE$.SwapFileSuffix());
                return BoxedUnit.UNIT;
            });
        }
        ((IterableOnceOps)sortedNewSegments.reverse()).foreach((Function1 & Serializable)x$9 -> existingSegments.add((LogSegment)x$9));
        Set newSegmentBaseOffsets = ((IterableOnceOps)sortedNewSegments.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.baseOffset()))).toSet();
        Seq deletedNotReplaced = (Seq)((IterableOps)((IterableOps)sortedOldSegments.map((Function1 & Serializable)seg -> {
            if (seg.baseOffset() != ((LogSegment)sortedNewSegments.head()).baseOffset()) {
                existingSegments.remove(seg.baseOffset());
            }
            MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)new .colon.colon(seg, (List)Nil$.MODULE$), true, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
            if (newSegmentBaseOffsets.contains((Object)BoxesRunTime.boxToLong((long)seg.baseOffset()))) {
                return Option$.MODULE$.empty();
            }
            return new Some(seg);
        })).filter((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)item.isDefined()))).map((Function1 & Serializable)item -> (LogSegment)item.get());
        sortedNewSegments.foreach((Function1 & Serializable)x$11 -> {
            x$11.changeFileSuffixes(LocalLog$.MODULE$.SwapFileSuffix(), "");
            return BoxedUnit.UNIT;
        });
        Utils.flushDir((Path)dir.toPath());
        return deletedNotReplaced;
    }

    public boolean replaceSegments$default$10() {
        return false;
    }

    public void deleteSegmentFiles(scala.collection.immutable.Iterable<LogSegment> segmentsToDelete, boolean asyncDelete, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        segmentsToDelete.foreach((Function1 & Serializable)x$12 -> {
            x$12.changeFileSuffixes("", LocalLog$.MODULE$.DeletedFileSuffix());
            return BoxedUnit.UNIT;
        });
        if (asyncDelete) {
            scheduler.schedule("delete-file", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.deleteSegments$1(logPrefix, segmentsToDelete, dir, logDirFailureChannel, topicPartition), Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()), scheduler.schedule$default$4(), scheduler.schedule$default$5());
            return;
        }
        this.deleteSegments$1(logPrefix, segmentsToDelete, dir, logDirFailureChannel, topicPartition);
    }

    public FetchDataInfo emptyFetchDataInfo(LogOffsetMetadata fetchOffsetMetadata, boolean includeAbortedTxns) {
        None$ abortedTransactions = includeAbortedTxns ? new Some((Object)package$.MODULE$.List().empty()) : None$.MODULE$;
        MemoryRecords x$2 = MemoryRecords.EMPTY;
        boolean x$4 = false;
        return new FetchDataInfo(fetchOffsetMetadata, (Records)x$2, x$4, (Option<List<FetchResponseData.AbortedTransaction>>)abortedTransactions);
    }

    public LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset) {
        LogSegment$.MODULE$.deleteIfExists(dir, baseOffset, this.CleanedFileSuffix());
        Time x$4 = Time.SYSTEM;
        String x$5 = this.CleanedFileSuffix();
        int x$6 = logConfig.initFileSize();
        boolean x$7 = Predef$.MODULE$.Boolean2boolean(logConfig.preallocate());
        boolean x$8 = false;
        return LogSegment$.MODULE$.open(dir, baseOffset, logConfig, x$4, x$8, x$6, x$7, x$5);
    }

    public <T> Option<T> kafka$log$LocalLog$$nextOption(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            return new Some(iterator.next());
        }
        return None$.MODULE$;
    }

    private static final KafkaException exception$1(File dir) {
        return new KafkaException(new StringBuilder(196).append("Found directory ").append(dir.getCanonicalPath()).append(", '").append(dir.getName()).append("' is not in the form of ").append("topic-partition or topic-partition.uniqueId-delete (if marked for deletion).\n").append("Kafka's log directories (and children) should only contain Kafka topic data.").toString());
    }

    public static final /* synthetic */ String $anonfun$splitOverflowedSegment$3(String logPrefix$1, LogSegment segment$2) {
        return new StringBuilder(29).append(logPrefix$1).append("Splitting overflowed segment ").append(segment$2).toString();
    }

    public static final /* synthetic */ void $anonfun$splitOverflowedSegment$4(LogSegment segment$2, IntRef totalSizeOfNewSegments$1, LogSegment splitSegment) {
        splitSegment.onBecomeInactiveSegment();
        splitSegment.flush();
        splitSegment.lastModified_$eq(segment$2.lastModified());
        totalSizeOfNewSegments$1.elem += splitSegment.log().sizeInBytes();
    }

    public static final /* synthetic */ String $anonfun$splitOverflowedSegment$5(String logPrefix$1, LogSegment segment$2, ListBuffer newSegments$1) {
        return new StringBuilder(50).append(logPrefix$1).append("Replacing overflowed segment ").append(segment$2).append(" with split segments ").append(newSegments$1).toString();
    }

    public static final /* synthetic */ void $anonfun$splitOverflowedSegment$6(LogSegment splitSegment) {
        splitSegment.close();
        splitSegment.deleteIfExists();
    }

    public static final /* synthetic */ String $anonfun$deleteSegmentFiles$2(String logPrefix$3, scala.collection.immutable.Iterable segmentsToDelete$1) {
        return new StringBuilder(23).append(logPrefix$3).append("Deleting segment files ").append(segmentsToDelete$1.mkString(",")).toString();
    }

    private final void deleteSegments$1(String logPrefix$3, scala.collection.immutable.Iterable segmentsToDelete$1, File dir$2, LogDirFailureChannel logDirFailureChannel$2, TopicPartition topicPartition$2) {
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = LocalLog$.$anonfun$deleteSegmentFiles$2(logPrefix$3, segmentsToDelete$1);
            Object var9_6 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        String parentDir = dir$2.getParent();
        Function0 & Serializable maybeHandleIOException_errorMsg = (Function0 & Serializable)() -> new StringBuilder(42).append("Error while deleting segments for ").append(topicPartition$2).append(" in dir ").append(parentDir).toString();
        if (logDirFailureChannel$2.hasOfflineLogDir(parentDir)) {
            throw new KafkaStorageException(new StringBuilder(63).append("The log dir ").append(parentDir).append(" is already offline due to a previous IO exception.").toString());
        }
        try {
            segmentsToDelete$1.foreach((Function1 & Serializable)segment -> {
                segment.deleteIfExists();
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (IOException maybeHandleIOException_e) {
            logDirFailureChannel$2.maybeAddOfflineLogDir(parentDir, (Function0<String>)maybeHandleIOException_errorMsg, maybeHandleIOException_e);
            throw new KafkaStorageException(LocalLog$.$anonfun$deleteSegmentFiles$3(topicPartition$2, parentDir), (Throwable)maybeHandleIOException_e);
        }
    }

    private LocalLog$() {
    }
}

