/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.BrokerMetadata;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.metadata.ZkMetadataCache$MetadataSnapshot$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.;
import scala.$less$colon$less$;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011]c\u0001B'O\u0001UC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0011\u0019i\b\u0001)A\u0005c\"9a\u0010\u0001a\u0001\n\u0013y\b\"\u0003B<\u0001\u0001\u0007I\u0011\u0002B=\u0011!\u0011\u0019\t\u0001Q!\n\u0005\u0005\u0001\"\u0003BG\u0001\t\u0007I\u0011\u0002BH\u0011!\u0011i\n\u0001Q\u0001\n\tE\u0005b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\b\u0005\u0003\u0004A\u0011\u0002Bb\u0011\u001d\u0011Y\u000f\u0001C\u0005\u0005[DqA!>\u0001\t\u0013\u00119\u0010C\u0004\u0004\u0002\u0001!\taa\u0001\t\u0013\r\u0005\u0002!%A\u0005\u0002\r\r\u0002\"CB\u0014\u0001E\u0005I\u0011AB\u0012\u0011\u001d\u0019I\u0003\u0001C\u0001\u0007WAqa!\r\u0001\t\u0003\u0019\u0019\u0004C\u0004\u00048\u0001!\ta!\u000f\t\u000f\r\u0005\u0003\u0001\"\u0011\u0004D!91Q\t\u0001\u0005B\r\u001d\u0003bBB!\u0001\u0011%1Q\u000b\u0005\b\u00073\u0002A\u0011BB.\u0011\u001d\u0019\t\u0007\u0001C\u0001\u0007GBqaa\u001a\u0001\t\u0003\u001aI\u0007C\u0004\u0004n\u0001!\tea\u001c\t\u000f\r}\u0004\u0001\"\u0011\u0004\u0002\"91q\u0011\u0001\u0005B\r%\u0005bBBH\u0001\u0011\u00051\u0011\u0013\u0005\b\u0007+\u0003A\u0011ABL\u0011\u001d\u0019y\n\u0001C\u0005\u0007CCqaa,\u0001\t\u0003\u0019\t\fC\u0004\u0004:\u0002!\taa/\t\u000f\r}\u0006\u0001\"\u0001\u0004B\"91\u0011\u001a\u0001\u0005\u0002\r-\u0007bBBk\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0007/\u0004A\u0011ABm\u0011\u001d\u00199\u000f\u0001C\u0001\u0007SDq\u0001\"\u0001\u0001\t\u0003!\u0019\u0001C\u0004\u0005\u0002\u0001!\t\u0001b\u0002\t\u000f\u0011-\u0001\u0001\"\u0003\u0005\u000e\u00191\u0011Q\u0001\u0001A\u0003\u000fA!\"a\n+\u0005+\u0007I\u0011AA\u0015\u0011)\t)I\u000bB\tB\u0003%\u00111\u0006\u0005\u000b\u0003\u000fS#Q3A\u0005\u0002\u0005%\u0005BCAMU\tE\t\u0015!\u0003\u0002\f\"Q\u00111\u0014\u0016\u0003\u0016\u0004%\t!!(\t\u0015\u0005\u0015&F!E!\u0002\u0013\ty\n\u0003\u0006\u0002(*\u0012)\u001a!C\u0001\u0003SC!\"!/+\u0005#\u0005\u000b\u0011BAV\u0011)\tYL\u000bBK\u0002\u0013\u0005\u0011Q\u0018\u0005\u000b\u00033T#\u0011#Q\u0001\n\u0005}\u0006B\u00026+\t\u0003\tY\u000eC\u0005\u0002h*\u0012\r\u0011\"\u0001\u0002j\"A\u0011Q\u001e\u0016!\u0002\u0013\tY\u000fC\u0005\u0002p*\n\t\u0011\"\u0001\u0002r\"I\u0011Q \u0016\u0012\u0002\u0013\u0005\u0011q \u0005\n\u0005+Q\u0013\u0013!C\u0001\u0005/A\u0011Ba\u0007+#\u0003%\tA!\b\t\u0013\t\u0005\"&%A\u0005\u0002\t\r\u0002\"\u0003B\u0014UE\u0005I\u0011\u0001B\u0015\u0011%\u0011iCKA\u0001\n\u0003\u0012y\u0003C\u0005\u0003<)\n\t\u0011\"\u0001\u0003>!I!q\b\u0016\u0002\u0002\u0013\u0005!\u0011\t\u0005\n\u0005\u001bR\u0013\u0011!C!\u0005\u001fB\u0011Ba\u0016+\u0003\u0003%\tA!\u0017\t\u0013\t\r$&!A\u0005B\t\u0015\u0004\"\u0003B5U\u0005\u0005I\u0011\tB6\u0011%\u0011iGKA\u0001\n\u0003\u0012y\u0007C\u0005\u0003r)\n\t\u0011\"\u0011\u0003t\u001dIA1\u0004\u0001\u0002\u0002#\u0005AQ\u0004\u0004\n\u0003\u000b\u0001\u0011\u0011!E\u0001\t?AaA\u001b%\u0005\u0002\u0011]\u0002\"\u0003B7\u0011\u0006\u0005IQ\tB8\u0011%!I\u0004SA\u0001\n\u0003#Y\u0004C\u0005\u0005H!\u000b\t\u0011\"!\u0005J\ty!l['fi\u0006$\u0017\r^1DC\u000eDWM\u0003\u0002P!\u0006AQ.\u001a;bI\u0006$\u0018M\u0003\u0002R%\u000611/\u001a:wKJT\u0011aU\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001a\u000b\u00181\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\r\u0005s\u0017PU3g!\tif,D\u0001Q\u0013\ty\u0006KA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0003GJ\u000bQ!\u001e;jYNL!!\u001a2\u0003\u000f1{wmZ5oO\u0006A!M]8lKJLE\r\u0005\u0002XQ&\u0011\u0011\u000e\u0017\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002m]B\u0011Q\u000eA\u0007\u0002\u001d\")aM\u0001a\u0001O\u0006)\u0002/\u0019:uSRLwN\\'fi\u0006$\u0017\r^1M_\u000e\\W#A9\u0011\u0005I\\X\"A:\u000b\u0005Q,\u0018!\u00027pG.\u001c(B\u0001<x\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003qf\fA!\u001e;jY*\t!0\u0001\u0003kCZ\f\u0017B\u0001?t\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017A\u00069beRLG/[8o\u001b\u0016$\u0018\rZ1uC2{7m\u001b\u0011\u0002!5,G/\u00193bi\u0006\u001cf.\u00199tQ>$XCAA\u0001!\r\t\u0019AK\u0007\u0002\u0001\t\u0001R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^\n\u0007UY\u000bI!a\u0004\u0011\u0007]\u000bY!C\u0002\u0002\u000ea\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\u0012\u0005\u0005b\u0002BA\n\u0003;qA!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033!\u0016A\u0002\u001fs_>$h(C\u0001Z\u0013\r\ty\u0002W\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019#!\n\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005}\u0001,A\bqCJ$\u0018\u000e^5p]N#\u0018\r^3t+\t\tY\u0003\u0005\u0005\u0002.\u0005]\u00121HA&\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003kA\u0016AC2pY2,7\r^5p]&!\u0011\u0011HA\u0018\u0005%\te.\u001f*fM6\u000b\u0007\u000f\u0005\u0003\u0002>\u0005\u0015c\u0002BA \u0003\u0003\u00022!!\u0006Y\u0013\r\t\u0019\u0005W\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0013\u0011\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r\u0003\f\u0005\u0004\u0002.\u00055\u0013\u0011K\u0005\u0005\u0003\u001f\nyCA\u0004M_:<W*\u00199\u0011\t\u0005M\u0013q\u0010\b\u0005\u0003+\nIH\u0004\u0003\u0002X\u0005Md\u0002BA-\u0003[rA!a\u0017\u0002j9!\u0011QLA2\u001d\u0011\t)\"a\u0018\n\u0005\u0005\u0005\u0014aA8sO&!\u0011QMA4\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011M\u0005\u0004'\u0006-$\u0002BA3\u0003OJA!a\u001c\u0002r\u000511m\\7n_:T1aUA6\u0013\u0011\t)(a\u001e\u0002\u000f5,7o]1hK*!\u0011qNA9\u0013\u0011\tY(! \u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0005\u0003k\n9(\u0003\u0003\u0002\u0002\u0006\r%\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0003w\ni(\u0001\tqCJ$\u0018\u000e^5p]N#\u0018\r^3tA\u0005AAo\u001c9jG&#7/\u0006\u0002\u0002\fBA\u0011QHAG\u0003w\t\t*\u0003\u0003\u0002\u0010\u0006%#aA'baB!\u00111SAK\u001b\t\t9(\u0003\u0003\u0002\u0018\u0006]$\u0001B+vS\u0012\f\u0011\u0002^8qS\u000eLEm\u001d\u0011\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0005\u0005}\u0005\u0003B,\u0002\"\u001eL1!a)Y\u0005\u0019y\u0005\u000f^5p]\u0006i1m\u001c8ue>dG.\u001a:JI\u0002\nA\"\u00197jm\u0016\u0014%o\\6feN,\"!a+\u0011\r\u00055\u0012QJAW!\u0011\ty+!.\u000e\u0005\u0005E&bAAZ%\u000691\r\\;ti\u0016\u0014\u0018\u0002BA\\\u0003c\u0013aA\u0011:pW\u0016\u0014\u0018!D1mSZ,'I]8lKJ\u001c\b%\u0001\u0006bY&4XMT8eKN,\"!a0\u0011\r\u00055\u0012QJAa!!\t\u0019-!2\u0002H\u0006MWBAA\u001a\u0013\u0011\ty)a\r\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017TA!!4\u0002x\u00059a.\u001a;x_J\\\u0017\u0002BAi\u0003\u0017\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016\u0004B!a%\u0002V&!\u0011q[A<\u0005\u0011qu\u000eZ3\u0002\u0017\u0005d\u0017N^3O_\u0012,7\u000f\t\u000b\r\u0003\u0003\ti.a8\u0002b\u0006\r\u0018Q\u001d\u0005\b\u0003O)\u0004\u0019AA\u0016\u0011\u001d\t9)\u000ea\u0001\u0003\u0017Cq!a'6\u0001\u0004\ty\nC\u0004\u0002(V\u0002\r!a+\t\u000f\u0005mV\u00071\u0001\u0002@\u0006QAo\u001c9jG:\u000bW.Z:\u0016\u0005\u0005-\b\u0003CA\u001f\u0003\u001b\u000b\t*a\u000f\u0002\u0017Q|\u0007/[2OC6,7\u000fI\u0001\u0005G>\u0004\u0018\u0010\u0006\u0007\u0002\u0002\u0005M\u0018Q_A|\u0003s\fY\u0010C\u0005\u0002(a\u0002\n\u00111\u0001\u0002,!I\u0011q\u0011\u001d\u0011\u0002\u0003\u0007\u00111\u0012\u0005\n\u00037C\u0004\u0013!a\u0001\u0003?C\u0011\"a*9!\u0003\u0005\r!a+\t\u0013\u0005m\u0006\b%AA\u0002\u0005}\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0003QC!a\u000b\u0003\u0004-\u0012!Q\u0001\t\u0005\u0005\u000f\u0011\t\"\u0004\u0002\u0003\n)!!1\u0002B\u0007\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0010a\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019B!\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\te!\u0006BAF\u0005\u0007\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003 )\"\u0011q\u0014B\u0002\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!\n+\t\u0005-&1A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011YC\u000b\u0003\u0002@\n\r\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00032A!!1\u0007B\u001d\u001b\t\u0011)DC\u0002\u00038e\fA\u0001\\1oO&!\u0011q\tB\u001b\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u00059\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0007\u0012I\u0005E\u0002X\u0005\u000bJ1Aa\u0012Y\u0005\r\te.\u001f\u0005\t\u0005\u0017\u0002\u0015\u0011!a\u0001O\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0015\u0011\r\u0005\r'1\u000bB\"\u0013\u0011\u0011)&a\r\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00057\u0012\t\u0007E\u0002X\u0005;J1Aa\u0018Y\u0005\u001d\u0011un\u001c7fC:D\u0011Ba\u0013C\u0003\u0003\u0005\rAa\u0011\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005c\u00119\u0007\u0003\u0005\u0003L\r\u000b\t\u00111\u0001h\u0003!A\u0017m\u001d5D_\u0012,G#A4\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\r\u0002\r\u0015\fX/\u00197t)\u0011\u0011YF!\u001e\t\u0013\t-c)!AA\u0002\t\r\u0013\u0001F7fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u?\u0012*\u0017\u000f\u0006\u0003\u0003|\t\u0005\u0005cA,\u0003~%\u0019!q\u0010-\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005\u00172\u0011\u0011!a\u0001\u0003\u0003\t\u0011#\\3uC\u0012\fG/Y*oCB\u001c\bn\u001c;!Q\r9!q\u0011\t\u0004/\n%\u0015b\u0001BF1\nAao\u001c7bi&dW-A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ,\"A!%\u0011\t\tM%\u0011T\u0007\u0003\u0005+S1Aa&S\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0005\u00057\u0013)JA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\f!c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3sA\u0005AR.Y=cK\u001aKG\u000e^3s\u00032Lg/\u001a*fa2L7-Y:\u0015\u0015\t\r&\u0011\u0017B[\u0005s\u0013i\f\u0005\u0004\u0003&\n\u001d&1V\u0007\u0002o&\u0019!\u0011V<\u0003\t1K7\u000f\u001e\t\u0005\u0005g\u0011i+\u0003\u0003\u00030\nU\"aB%oi\u0016<WM\u001d\u0005\b\u0005gS\u0001\u0019AA\u0001\u0003!\u0019h.\u00199tQ>$\bb\u0002B\\\u0015\u0001\u0007!1U\u0001\bEJ|7.\u001a:t\u0011\u001d\u0011YL\u0003a\u0001\u0003\u000f\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016DqAa0\u000b\u0001\u0004\u0011Y&\u0001\u000egS2$XM]+oCZ\f\u0017\u000e\\1cY\u0016,e\u000e\u001a9pS:$8/\u0001\u000bhKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u000b\r\u0005\u000b\u0014YN!8\u0003b\n\r(q\u001d\t\u0006/\u0006\u0005&q\u0019\t\u0007\u0003#\u0011IM!4\n\t\t-\u0017Q\u0005\u0002\t\u0013R,'/\u00192mKB!!q\u001aBk\u001d\u0011\t)F!5\n\t\tM\u0017QP\u0001\u0015\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$\u0015\r^1\n\t\t]'\u0011\u001c\u0002\u001a\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|gN\u0003\u0003\u0003T\u0006u\u0004b\u0002BZ\u0017\u0001\u0007\u0011\u0011\u0001\u0005\b\u0005?\\\u0001\u0019AA\u001e\u0003\u0015!x\u000e]5d\u0011\u001d\u0011Yl\u0003a\u0001\u0003\u000fDqA!:\f\u0001\u0004\u0011Y&A\rfeJ|'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bb\u0002Bu\u0017\u0001\u0007!1L\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148/\u0001\tiCN\fE.\u001b<f\u000b:$\u0007o\\5oiRA!1\fBx\u0005c\u0014\u0019\u0010C\u0004\u000342\u0001\r!!\u0001\t\u000b\u0019d\u0001\u0019A4\t\u000f\tmF\u00021\u0001\u0002H\u0006\u0001r-\u001a;BY&4X-\u00128ea>Lg\u000e\u001e\u000b\t\u0005s\u0014YP!@\u0003\u0000B)q+!)\u0002T\"9!1W\u0007A\u0002\u0005\u0005\u0001\"\u00024\u000e\u0001\u00049\u0007b\u0002B^\u001b\u0001\u0007\u0011qY\u0001\u0011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$\"b!\u0002\u0004\u0012\rm1QDB\u0010!\u0019\t\u0019ma\u0002\u0004\f%!1\u0011BA\u001a\u0005\r\u0019V-\u001d\t\u0005\u0005\u001f\u001ci!\u0003\u0003\u0004\u0010\te'!F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f)>\u0004\u0018n\u0019\u0005\b\u0007'q\u0001\u0019AB\u000b\u0003\u0019!x\u000e]5dgB1\u00111YB\f\u0003wIAa!\u0007\u00024\t\u00191+\u001a;\t\u000f\tmf\u00021\u0001\u0002H\"I!Q\u001d\b\u0011\u0002\u0003\u0007!1\f\u0005\n\u0005St\u0001\u0013!a\u0001\u00057\n!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM*\"a!\n+\t\tm#1A\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$H\u0005N\u0001\u0010i>\u0004\u0018n\u0019(b[\u0016\u001cHk\\%egR\u00111Q\u0006\t\t\u0005K\u001by#a\u000f\u0002\u0012&\u0019\u0011qR<\u0002\u001fQ|\u0007/[2JIN$vNT1nKN$\"a!\u000e\u0011\u0011\t\u00156qFAI\u0003w\t1\u0002^8qS\u000eLE-\u00138g_R\u001111\b\t\b/\u000eu2QFB\u001b\u0013\r\u0019y\u0004\u0017\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0019\u001d,G/\u00117m)>\u0004\u0018nY:\u0015\u0005\rU\u0011AE4fiR{\u0007/[2QCJ$\u0018\u000e^5p]N$Ba!\u0013\u0004RA1\u00111YB\f\u0007\u0017\u0002B!a%\u0004N%!1qJA<\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dqaa\u0015\u0016\u0001\u0004\tY$A\u0005u_BL7MT1nKR!1QCB,\u0011\u001d\u0011\u0019L\u0006a\u0001\u0003\u0003\t\u0001cZ3u\u00032d\u0007+\u0019:uSRLwN\\:\u0015\t\ru3q\f\t\t\u0003{\tiia\u0013\u0002R!9!1W\fA\u0002\u0005\u0005\u0011\u0001F4fi:{g.\u0012=jgRLgn\u001a+pa&\u001c7\u000f\u0006\u0003\u0004\u0016\r\u0015\u0004bBB\n1\u0001\u00071QC\u0001\u000fQ\u0006\u001c\u0018\t\\5wK\n\u0013xn[3s)\u0011\u0011Yfa\u001b\t\u000b\u0019L\u0002\u0019A4\u0002\u001f\u001d,G/\u00117jm\u0016\u0014%o\\6feN$\"a!\u001d\u0011\r\u0005E!\u0011ZB:!\u0011\u0019)ha\u001f\u000e\u0005\r]$bAB=%\u0006)\u0011\rZ7j]&!1QPB<\u00059\u0011%o\\6fe6+G/\u00193bi\u0006\f!cZ3u\u00032Lg/\u001a\"s_.,'OT8eKR1!\u0011`BB\u0007\u000bCQAZ\u000eA\u0002\u001dDqAa/\u001c\u0001\u0004\t9-A\nhKR\fE.\u001b<f\u0005J|7.\u001a:O_\u0012,7\u000f\u0006\u0003\u0004\f\u000e5\u0005CBA\t\u0005\u0013\f\u0019\u000eC\u0004\u0003<r\u0001\r!a2\u0002\u0015\u001d,G\u000fV8qS\u000eLE\r\u0006\u0003\u0002\u0012\u000eM\u0005bBB*;\u0001\u0007\u00111H\u0001\rO\u0016$Hk\u001c9jG:\u000bW.\u001a\u000b\u0005\u00073\u001bY\nE\u0003X\u0003C\u000bY\u0004C\u0004\u0004\u001ez\u0001\r!!%\u0002\u000fQ|\u0007/[2JI\u0006A\u0012\r\u001a3PeV\u0003H-\u0019;f!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\u0015\tm41UBS\u0007O\u001bY\u000bC\u0004\u0002(}\u0001\r!a\u000b\t\u000f\t}w\u00041\u0001\u0002<!11\u0011V\u0010A\u0002\u001d\f1\u0002]1si&$\u0018n\u001c8JI\"91QV\u0010A\u0002\u0005E\u0013!C:uCR,\u0017J\u001c4p\u0003A9W\r\u001e)beRLG/[8o\u0013:4w\u000e\u0006\u0004\u00044\u000eU6q\u0017\t\u0006/\u0006\u0005\u0016\u0011\u000b\u0005\b\u0005?\u0004\u0003\u0019AA\u001e\u0011\u0019\u0019I\u000b\ta\u0001O\u0006ia.^7QCJ$\u0018\u000e^5p]N$B!a(\u0004>\"9!q\\\u0011A\u0002\u0005m\u0012AG4fiB\u000b'\u000f^5uS>tG*Z1eKJ,e\u000e\u001a9pS:$H\u0003\u0003B}\u0007\u0007\u001c)ma2\t\u000f\t}'\u00051\u0001\u0002<!11\u0011\u0016\u0012A\u0002\u001dDqAa/#\u0001\u0004\t9-\u0001\u000fhKR\u0004\u0016M\u001d;ji&|gNU3qY&\u001c\u0017-\u00128ea>Lg\u000e^:\u0015\r\r57qZBj!\u001d\ti$!$h\u0003'Dqa!5$\u0001\u0004\u0019Y%\u0001\u0002ua\"9!1X\u0012A\u0002\u0005\u001d\u0017aD4fi\u000e{g\u000e\u001e:pY2,'/\u00133\u0002%\u001d,Go\u00117vgR,'/T3uC\u0012\fG/\u0019\u000b\u0007\u00077\u001c\to!:\u0011\t\u0005M5Q\\\u0005\u0005\u0007?\f9HA\u0004DYV\u001cH/\u001a:\t\u000f\r\rX\u00051\u0001\u0002<\u0005I1\r\\;ti\u0016\u0014\u0018\n\u001a\u0005\b\u0005w+\u0003\u0019AAd\u00039)\b\u000fZ1uK6+G/\u00193bi\u0006$baa;\u0004n\u000eE\bCBAb\u0007\u000f\u0019Y\u0005\u0003\u0004\u0004p\u001a\u0002\raZ\u0001\u000eG>\u0014(/\u001a7bi&|g.\u00133\t\u000f\rMh\u00051\u0001\u0004v\u0006)R\u000f\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\b\u0003BB|\u0007{l!a!?\u000b\t\rm\u0018qO\u0001\te\u0016\fX/Z:ug&!1q`B}\u0005U)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\f\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u00057\")\u0001C\u0004\u0003`\u001e\u0002\r!a\u000f\u0015\t\tmC\u0011\u0002\u0005\b\u0007#D\u0003\u0019AB&\u0003M\u0011X-\\8wKB\u000b'\u000f^5uS>t\u0017J\u001c4p))\u0011Y\u0006b\u0004\u0005\u0012\u0011]A\u0011\u0004\u0005\b\u0003OI\u0003\u0019AA\u0016\u0011\u001d\t9)\u000ba\u0001\t'\u0001\u0002\"!\f\u0005\u0016\u0005m\u0012\u0011S\u0005\u0005\u0003\u001f\u000by\u0003C\u0004\u0003`&\u0002\r!a\u000f\t\r\r%\u0016\u00061\u0001h\u0003AiU\r^1eCR\f7K\\1qg\"|G\u000fE\u0002\u0002\u0004!\u001bR\u0001\u0013C\u0011\t[\u0001\u0002\u0003b\t\u0005*\u0005-\u00121RAP\u0003W\u000by,!\u0001\u000e\u0005\u0011\u0015\"b\u0001C\u00141\u00069!/\u001e8uS6,\u0017\u0002\u0002C\u0016\tK\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c86!\u0011!y\u0003\"\u000e\u000e\u0005\u0011E\"b\u0001C\u001as\u0006\u0011\u0011n\\\u0005\u0005\u0003G!\t\u0004\u0006\u0002\u0005\u001e\u0005)\u0011\r\u001d9msRa\u0011\u0011\u0001C\u001f\t\u007f!\t\u0005b\u0011\u0005F!9\u0011qE&A\u0002\u0005-\u0002bBAD\u0017\u0002\u0007\u00111\u0012\u0005\b\u00037[\u0005\u0019AAP\u0011\u001d\t9k\u0013a\u0001\u0003WCq!a/L\u0001\u0004\ty,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0011-C1\u000b\t\u0006/\u0006\u0005FQ\n\t\u000e/\u0012=\u00131FAF\u0003?\u000bY+a0\n\u0007\u0011E\u0003L\u0001\u0004UkBdW-\u000e\u0005\n\t+b\u0015\u0011!a\u0001\u0003\u0003\t1\u0001\u001f\u00131\u0001")
public class ZkMetadataCache
implements MetadataCache,
Logging {
    private volatile ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        CollectionConverters$.MODULE$.ListHasAsScala(brokers).asScala().foreach((Function1 & Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable)partitions -> (scala.collection.mutable.Iterable)partitions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long partitionId = x0$1._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
                TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
                int leaderBrokerId = partitionState.leader();
                int leaderEpoch = partitionState.leaderEpoch();
                Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
                List replicas = partitionState.replicas();
                List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
                List isr = partitionState.isr();
                List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
                List offlineReplicas = partitionState.offlineReplicas();
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!snapshot.aliveBrokers().contains((long)leaderBrokerId)) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(leaderBrokerId).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    if (filteredReplicas.size() < replicas.size()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicas).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < isr.size()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(100).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(isr).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt((Object)maybeLeader.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            }
            throw new MatchError(null);
        }));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable)x$3 -> x$3.get((Object)listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)snapshot.topicIds().getOrElse(topic, (Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava(this.metadataSnapshot().topicIds()).asJava());
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava(this.metadataSnapshot().topicNames()).asJava());
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return new Tuple2(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava(snapshot.topicIds()).asJava()), Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava(snapshot.topicNames()).asJava()));
    }

    @Override
    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        return ((IterableOnceOps)((MapOps)this.metadataSnapshot().partitionStates().getOrElse((Object)topicName, (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).values().map((Function1 & Serializable)p -> new TopicPartition(topicName, p.partitionIndex()))).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                return (scala.collection.mutable.Map)((LongMap)x0$1._2()).map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        long partition = x0$2._1$mcJ$sp();
                        UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                        return new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        }, DummyImplicit$.MODULE$.dummyImplicit()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)topics.diff(this.metadataSnapshot().partitionStates().keySet());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains((long)brokerId);
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId).flatMap((Function1 & Serializable)x$4 -> x$4.getNode(listenerName));
    }

    @Override
    public Iterable<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().flatMap((Function1 & Serializable)x$5 -> x$5.getNode(listenerName));
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)this.metadataSnapshot().topicIds().getOrElse((Object)topicName, (Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return this.metadataSnapshot().topicNames().get((Object)topicId);
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        ((LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable)() -> LongMap$.MODULE$.empty())).update((long)partitionId, (Object)stateInfo);
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$6 -> x$6.get((long)partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$8 -> x$8.get((long)partitionId)).map((Function1 & Serializable)partitionInfo -> {
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                return (Node)((Map)((Some)option).value()).getOrElse((Object)listenerName, (Function0 & Serializable)() -> Node.noNode());
            }
            if (None$.MODULE$.equals(option)) {
                return Node.noNode();
            }
            throw new MatchError((Object)option);
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable)x$9 -> x$9.get((long)tp.partition())).map((Function1 & Serializable)partitionInfo -> {
            List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicaIds).asScala().map((Function1 & Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0 & Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = snapshot.aliveNodes().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long id = x0$1._1$mcJ$sp();
                return ((Map)x0$1._2()).get((Object)listenerName).map((Function1 & Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), node));
            }
            throw new MatchError(null);
        });
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((IterableOps)this.getAllPartitions(snapshot).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$4(x0$2)))).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                TopicPartition tp = (TopicPartition)x0$3._1();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
                return new PartitionInfo(tp.topic(), tp.partition(), ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.replicas()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.isr()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.offlineReplicas()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)));
            }
            throw new MatchError(null);
        });
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = CollectionConverters$.MODULE$.SetHasAsJava((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$9(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)CollectionConverters$.MODULE$.BufferHasAsJava(nodes.values().toBuffer()).asJava(), (Collection)CollectionConverters$.MODULE$.BufferHasAsJava(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        ArrayBuffer arrayBuffer;
        Lock inWriteLock_inLock_lock = this.partitionMetadataLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            arrayBuffer = ZkMetadataCache.$anonfun$updateMetadata$1(this, updateMetadataRequest, correlationId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return arrayBuffer;
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, topicIds, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        synchronized (this) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new ZkMetadataCache$MetadataSnapshot$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair != null) {
            return !((Node)pair._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse((long)Predef$.MODULE$.Integer2int(id), (Function0 & Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$9(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$10) {
        Set set = x$10.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$5(listeners, x$10)))) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$8(Tuple2 x0$1) {
        if (x0$1 != null) {
            Uuid uuid = (Uuid)x0$1._2();
            Uuid uuid2 = Uuid.ZERO_UUID;
            return uuid == null ? uuid2 != null : !uuid.equals(uuid2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$10(AnyRefMap partitionStates$1, String topic, LongMap oldPartitionStates) {
        LongMap copy = new LongMap(oldPartitionStates.size());
        copy.$plus$plus$eq((IterableOnce)oldPartitionStates);
        partitionStates$1.update((Object)topic, (Object)copy);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuffer $anonfun$updateMetadata$1(ZkMetadataCache $this, UpdateMetadataRequest updateMetadataRequest$1, int correlationId$1) {
        void var9_9;
        void var10_10;
        LongMap aliveBrokers = new LongMap($this.metadataSnapshot().aliveBrokers().size());
        LongMap aliveNodes = new LongMap($this.metadataSnapshot().aliveNodes().size());
        int n = updateMetadataRequest$1.controllerId();
        switch (n) {
            default: 
        }
        None$ controllerIdOpt = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
        updateMetadataRequest$1.liveBrokers().forEach(broker -> {
            HashMap nodes = new HashMap();
            ArrayBuffer endPoints = new ArrayBuffer();
            broker.endpoints().forEach(ep -> {
                ListenerName listenerName = new ListenerName(ep.listener());
                endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port()));
            });
            aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack())));
            aliveNodes.update((long)broker.id(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(nodes).asScala());
        });
        aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable)listenerMap -> {
            ZkMetadataCache.$anonfun$updateMetadata$4($this, aliveNodes, listenerMap);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map topicIds = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        topicIds.$plus$plus$eq($this.metadataSnapshot().topicIds());
        Tuple2 tuple2 = ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(updateMetadataRequest$1.topicStates()).asScala().map((Function1 & Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()))).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$8(x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer newTopicIds = (Buffer)tuple2._1();
        Buffer newZeroIds = (Buffer)tuple2._2();
        var10_10.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String zeroIdTopic = (String)x0$2._1();
                return topicIds.remove((Object)zeroIdTopic);
            }
            throw new MatchError(null);
        });
        topicIds.$plus$plus$eq((IterableOnce)var9_9.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        ArrayBuffer deletedPartitions = new ArrayBuffer();
        if (!updateMetadataRequest$1.partitionStates().iterator().hasNext()) {
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, $this.metadataSnapshot().partitionStates(), (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        } else {
            AnyRefMap partitionStates = new AnyRefMap($this.metadataSnapshot().partitionStates().size());
            $this.metadataSnapshot().partitionStates().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(topic, oldPartitionStates) -> {
                ZkMetadataCache.$anonfun$updateMetadata$10(partitionStates, topic, oldPartitionStates);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1));
            boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
            int controllerId = updateMetadataRequest$1.controllerId();
            int controllerEpoch = updateMetadataRequest$1.controllerEpoch();
            Iterable newStates = CollectionConverters$.MODULE$.IterableHasAsScala(updateMetadataRequest$1.partitionStates()).asScala();
            newStates.foreach((Function1 & Serializable)state -> {
                TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                    $this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                    if (traceEnabled) {
                        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    }
                    return deletedPartitions.$plus$eq((Object)tp);
                }
                $this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                if (traceEnabled) {
                    $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
            $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(145).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        }
        return deletedPartitions;
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        if (infos.isEmpty()) {
            partitionStates$2.remove((Object)topic$4);
            topicIds$2.remove((Object)topic$4);
        }
        return true;
    }

    public ZkMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final scala.collection.immutable.Map<String, Uuid> topicIds;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        private final scala.collection.immutable.Map<Uuid, String> topicNames;
        public final /* synthetic */ ZkMetadataCache $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public scala.collection.immutable.Map<String, Uuid> topicIds() {
            return this.topicIds;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public scala.collection.immutable.Map<Uuid, String> topicNames() {
            return this.topicNames;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$metadata$ZkMetadataCache$MetadataSnapshot$$$outer(), partitionStates, topicIds, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public scala.collection.immutable.Map<String, Uuid> copy$default$2() {
            return this.topicIds();
        }

        public Option<Object> copy$default$3() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$4() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$5() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partitionStates();
                }
                case 1: {
                    return this.topicIds();
                }
                case 2: {
                    return this.controllerId();
                }
                case 3: {
                    return this.aliveBrokers();
                }
                case 4: {
                    return this.aliveNodes();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "partitionStates";
                }
                case 1: {
                    return "topicIds";
                }
                case 2: {
                    return "controllerId";
                }
                case 3: {
                    return "aliveBrokers";
                }
                case 4: {
                    return "aliveNodes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof MetadataSnapshot && ((MetadataSnapshot)x$1).kafka$server$metadata$ZkMetadataCache$MetadataSnapshot$$$outer() == this.kafka$server$metadata$ZkMetadataCache$MetadataSnapshot$$$outer())) break block3;
                    MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
                    AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
                    AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
                    if (anyRefMap != null ? !anyRefMap.equals(anyRefMap2) : anyRefMap2 != null) break block3;
                    scala.collection.immutable.Map<String, Uuid> map = this.topicIds();
                    scala.collection.immutable.Map<String, Uuid> map2 = metadataSnapshot.topicIds();
                    if (map != null ? !map.equals(map2) : map2 != null) break block3;
                    Option<Object> option = this.controllerId();
                    Option<Object> option2 = metadataSnapshot.controllerId();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    LongMap<Broker> longMap = this.aliveBrokers();
                    LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
                    if (longMap != null ? !longMap.equals(longMap2) : longMap2 != null) break block3;
                    LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
                    LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
                    if ((longMap3 != null ? !longMap3.equals(longMap4) : longMap4 != null) || !metadataSnapshot.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ZkMetadataCache kafka$server$metadata$ZkMetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(ZkMetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.topicIds = topicIds;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.topicNames = (scala.collection.immutable.Map)topicIds.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String topicName = (String)x0$1._1();
                    Uuid topicId = (Uuid)x0$1._2();
                    return new Tuple2((Object)topicId, (Object)topicName);
                }
                throw new MatchError(null);
            });
        }
    }
}

