/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializerConfig;
import io.confluent.kafka.serializers.protobuf.ProtobufSchemaAndValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;

public abstract class AbstractKafkaProtobufDeserializer<T extends Message>
extends AbstractKafkaSchemaSerDe {
    private static int DEFAULT_CACHE_CAPACITY = 1000;
    protected boolean isKey;
    protected Class<T> specificProtobufClass;
    protected Method parseMethod;
    protected boolean deriveType;
    private Map<Pair<String, ProtobufSchema>, ProtobufSchema> schemaCache = new BoundedConcurrentHashMap(DEFAULT_CACHE_CAPACITY);

    protected void configure(KafkaProtobufDeserializerConfig config, Class<T> type) {
        this.configureClientProperties(config, (SchemaProvider)new ProtobufSchemaProvider());
        try {
            this.specificProtobufClass = type;
            if (this.specificProtobufClass != null && !this.specificProtobufClass.equals(Object.class)) {
                this.parseMethod = this.specificProtobufClass.getDeclaredMethod("parseFrom", ByteBuffer.class);
            }
            this.deriveType = config.getBoolean("derive.type");
        }
        catch (Exception e) {
            throw new ConfigException("Class " + this.specificProtobufClass.getCanonicalName() + " is not a valid protobuf message class", (Object)e);
        }
    }

    protected KafkaProtobufDeserializerConfig deserializerConfig(Map<String, ?> props) {
        try {
            return new KafkaProtobufDeserializerConfig(props);
        }
        catch (ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected KafkaProtobufDeserializerConfig deserializerConfig(Properties props) {
        return new KafkaProtobufDeserializerConfig(props);
    }

    protected T deserialize(byte[] payload) throws SerializationException, InvalidConfigurationException {
        return (T)((Message)this.deserialize(false, null, this.isKey, payload));
    }

    protected Object deserialize(boolean includeSchemaAndVersion, String topic, Boolean isKey, byte[] payload) throws SerializationException, InvalidConfigurationException {
        if (this.schemaRegistry == null) {
            throw new InvalidConfigurationException("SchemaRegistryClient not found. You need to configure the deserializer or use deserializer constructor with SchemaRegistryClient.");
        }
        if (payload == null) {
            return null;
        }
        int id = -1;
        try {
            Object value;
            ByteBuffer buffer = this.getByteBuffer(payload);
            id = buffer.getInt();
            String subject = isKey == null || this.strategyUsesSchema(isKey) ? this.getContextName(topic) : this.subjectName(topic, isKey, null);
            ProtobufSchema schema = (ProtobufSchema)this.schemaRegistry.getSchemaBySubjectAndId(subject, id);
            MessageIndexes indexes = MessageIndexes.readFrom((ByteBuffer)buffer);
            String name = schema.toMessageName(indexes);
            schema = this.schemaWithName(schema, name);
            if (includeSchemaAndVersion) {
                subject = this.subjectName(topic, isKey, schema);
                schema = this.schemaForDeserialize(id, schema, subject, isKey);
                schema = this.schemaWithName(schema, name);
            }
            int length = buffer.limit() - 1 - 4;
            int start = buffer.position() + buffer.arrayOffset();
            if (this.parseMethod != null) {
                try {
                    value = this.parseMethod.invoke(null, buffer);
                }
                catch (Exception e) {
                    throw new ConfigException("Not a valid protobuf builder", (Object)e);
                }
            } else if (this.deriveType) {
                value = this.deriveType(buffer, schema);
            } else {
                Descriptors.Descriptor descriptor = schema.toDescriptor();
                if (descriptor == null) {
                    throw new SerializationException("Could not find descriptor with name " + schema.name());
                }
                value = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (InputStream)new ByteArrayInputStream(buffer.array(), start, length));
            }
            if (includeSchemaAndVersion) {
                Integer version = this.schemaVersion(topic, isKey, id, subject, schema, value);
                return new ProtobufSchemaAndValue(schema.copy(version), value);
            }
            return value;
        }
        catch (InterruptedIOException e) {
            throw new TimeoutException("Error deserializing Protobuf message for id " + id, (Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error deserializing Protobuf message for id " + id, (Throwable)e);
        }
        catch (RestClientException e) {
            throw AbstractKafkaProtobufDeserializer.toKafkaException((RestClientException)e, (String)("Error retrieving Protobuf schema for id " + id));
        }
    }

    private ProtobufSchema schemaWithName(ProtobufSchema schema, String name) {
        Pair<String, ProtobufSchema> cacheKey = new Pair<String, ProtobufSchema>(name, schema);
        return this.schemaCache.computeIfAbsent(cacheKey, k -> schema.copy(name));
    }

    private Object deriveType(ByteBuffer buffer, ProtobufSchema schema) {
        String clsName = schema.fullName();
        if (clsName == null) {
            throw new SerializationException("If `derive.type` is true, then either `java_outer_classname` or `java_multiple_files = true` must be set in the Protobuf schema");
        }
        try {
            Class<?> cls = Class.forName(clsName);
            Method parseMethod = cls.getDeclaredMethod("parseFrom", ByteBuffer.class);
            return parseMethod.invoke(null, buffer);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Class " + clsName + " could not be found.");
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException("Class " + clsName + " is not a valid protobuf message class", (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SerializationException("Not a valid protobuf builder");
        }
    }

    private Integer schemaVersion(String topic, boolean isKey, int id, String subject, ProtobufSchema schema, Object value) throws IOException, RestClientException {
        if (this.isDeprecatedSubjectNameStrategy(isKey)) {
            subject = this.getSubjectName(topic, isKey, value, (ParsedSchema)schema);
        }
        ProtobufSchema subjectSchema = (ProtobufSchema)this.schemaRegistry.getSchemaBySubjectAndId(subject, id);
        Integer version = this.schemaRegistry.getVersion(subject, (ParsedSchema)subjectSchema);
        return version;
    }

    private String subjectName(String topic, boolean isKey, ProtobufSchema schemaFromRegistry) {
        return this.isDeprecatedSubjectNameStrategy(isKey) ? null : this.getSubjectName(topic, isKey, null, (ParsedSchema)schemaFromRegistry);
    }

    private ProtobufSchema schemaForDeserialize(int id, ProtobufSchema schemaFromRegistry, String subject, boolean isKey) throws IOException, RestClientException {
        return this.isDeprecatedSubjectNameStrategy(isKey) ? ProtobufSchemaUtils.copyOf((ProtobufSchema)schemaFromRegistry) : (ProtobufSchema)this.schemaRegistry.getSchemaBySubjectAndId(subject, id);
    }

    protected ProtobufSchemaAndValue deserializeWithSchemaAndVersion(String topic, boolean isKey, byte[] payload) throws SerializationException {
        return (ProtobufSchemaAndValue)this.deserialize(true, topic, isKey, payload);
    }

    static class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equals(this.key, pair.key) && Objects.equals(this.value, pair.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "Pair{key=" + this.key + ", value=" + this.value + '}';
        }
    }
}

