/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalLong;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.slf4j.Logger;

final class SnapshotGenerator {
    private final Logger log;
    private final SnapshotWriter<ApiMessageAndVersion> writer;
    private final int maxBatchesPerGenerateCall;
    private final List<Section> sections;
    private final Iterator<Section> sectionIterator;
    private Iterator<List<ApiMessageAndVersion>> batchIterator;
    private List<ApiMessageAndVersion> batch;
    private Section section;
    private long numRecords;

    SnapshotGenerator(LogContext logContext, SnapshotWriter<ApiMessageAndVersion> writer, int maxBatchesPerGenerateCall, List<Section> sections) {
        this.log = logContext.logger(SnapshotGenerator.class);
        this.writer = writer;
        this.maxBatchesPerGenerateCall = maxBatchesPerGenerateCall;
        this.sections = sections;
        this.sectionIterator = this.sections.iterator();
        this.batchIterator = Collections.emptyIterator();
        this.batch = null;
        this.section = null;
        this.numRecords = 0L;
    }

    long lastContainedLogOffset() {
        return this.writer.lastContainedLogOffset();
    }

    SnapshotWriter writer() {
        return this.writer;
    }

    private boolean generateBatch() throws Exception {
        if (this.batch == null) {
            while (!this.batchIterator.hasNext()) {
                if (this.section != null) {
                    this.log.info("Generated {} record(s) for the {} section of snapshot {}.", new Object[]{this.numRecords, this.section.name(), this.writer.snapshotId()});
                    this.section = null;
                    this.numRecords = 0L;
                }
                if (!this.sectionIterator.hasNext()) {
                    this.writer.freeze();
                    return true;
                }
                this.section = this.sectionIterator.next();
                this.log.info("Generating records for the {} section of snapshot {}.", (Object)this.section.name(), (Object)this.writer.snapshotId());
                this.batchIterator = this.section.iterator();
            }
            this.batch = this.batchIterator.next();
        }
        this.writer.append(this.batch);
        this.numRecords += (long)this.batch.size();
        this.batch = null;
        return false;
    }

    OptionalLong generateBatches() throws Exception {
        for (int numBatches = 0; numBatches < this.maxBatchesPerGenerateCall; ++numBatches) {
            if (!this.generateBatch()) continue;
            return OptionalLong.empty();
        }
        return OptionalLong.of(0L);
    }

    static class Section {
        private final String name;
        private final Iterator<List<ApiMessageAndVersion>> iterator;

        Section(String name, Iterator<List<ApiMessageAndVersion>> iterator) {
            this.name = name;
            this.iterator = iterator;
        }

        String name() {
            return this.name;
        }

        Iterator<List<ApiMessageAndVersion>> iterator() {
            return this.iterator;
        }
    }
}

