/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.TooManyConnectionsException;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r=hA\u0002+V\u0003\u00039\u0016\f\u0003\u0005e\u0001\t\u0015\r\u0011\"\u0001g\u0011!Q\u0007A!A!\u0002\u00139\u0007\u0002C6\u0001\u0005\u000b\u0007I\u0011\u00017\t\u0011M\u0004!\u0011!Q\u0001\n5D\u0001\u0002\u001e\u0001\u0003\u0002\u0004%\t!\u001e\u0005\ty\u0002\u0011\t\u0019!C\u0001{\"I\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006KA\u001e\u0005\u000b\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005E\u0001BCA\f\u0001\t\u0005\t\u0015!\u0003\u0002\u001a!Q\u0011q\u0004\u0001\u0003\u0002\u0003\u0006I!!\t\t\u0015\u0005m\u0002A!A!\u0002\u0013\ti\u0004\u0003\u0006\u0002D\u0001\u0011\t\u0011)A\u0005\u0003\u000bB\u0011\"\u0019\u0001\u0003\u0002\u0003\u0006I!a\u0013\t\u0015\u0005U\u0003A!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002d\u0001\u0011\t\u0011)A\u0005\u0003KB!\"a\u001b\u0001\u0005\u0003\u0005\u000b\u0011BA7\u0011)\tI\b\u0001B\u0001B\u0003%\u00111\u0010\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\t\t\u000b\u0001D\u0001\u0003GCq!a/\u0001\r\u0003\t\u0019\u000bC\u0005\u0002>\u0002\u0011\r\u0011\"\u0003\u0002@\"A\u0011\u0011\u001b\u0001!\u0002\u0013\t\t\rC\u0005\u0002T\u0002\u0011\r\u0011\"\u0003\u0002@\"A\u0011Q\u001b\u0001!\u0002\u0013\t\t\rC\u0005\u0002X\u0002\u0011\r\u0011\"\u0003\u0002@\"A\u0011\u0011\u001c\u0001!\u0002\u0013\t\t\rC\u0005\u0002\\\u0002\u0011\r\u0011\"\u0003\u0002^\"A\u0011q\u001e\u0001!\u0002\u0013\ty\u000e\u0003\u0006\u0002r\u0002\u0011\r\u0011\"\u0001V\u0003gD\u0001\"a?\u0001A\u0003%\u0011Q\u001f\u0005\u000b\u0003{\u0004!\u0019!C\u0001+\u0006}\b\u0002\u0003B\f\u0001\u0001\u0006IA!\u0001\t\u0013\te\u0001A1A\u0005\n\tm\u0001\u0002\u0003B\u0019\u0001\u0001\u0006IA!\b\t\u0013\tM\u0002A1A\u0005\n\tU\u0002\u0002\u0003B'\u0001\u0001\u0006IAa\u000e\t\u0013\t=\u0003A1A\u0005\n\tE\u0003\u0002\u0003B-\u0001\u0001\u0006IAa\u0015\t\u0013\tm\u0003\u00011A\u0005\n\tu\u0003\"\u0003B0\u0001\u0001\u0007I\u0011\u0002B1\u0011!\u0011)\u0007\u0001Q!\n\u0005E\u0001B\u0003B4\u0001\t\u0007I\u0011A+\u0003j!A1Q\u0005\u0001!\u0002\u0013\u0011YGB\u0004\u0003v\u0001\u0001UKa\u001e\t\u0015\tuEF!f\u0001\n\u0003\u0011y\n\u0003\u0006\u0003(2\u0012\t\u0012)A\u0005\u0005CC!B!+-\u0005+\u0007I\u0011\u0001BV\u0011)\u0011\u0019\f\fB\tB\u0003%!Q\u0016\u0005\b\u0003\u0003cC\u0011\u0001B[\u0011\u001d\u0011Y\f\fC!\u0005{C\u0011Ba1-\u0003\u0003%\tA!2\t\u0013\t-G&%A\u0005\u0002\t5\u0007\"\u0003BrYE\u0005I\u0011\u0001Bs\u0011%\u0011I\u000fLA\u0001\n\u0003\u0012Y\u000fC\u0005\u0003r2\n\t\u0011\"\u0001\u0003^!I!1\u001f\u0017\u0002\u0002\u0013\u0005!Q\u001f\u0005\n\u0005\u007fd\u0013\u0011!C!\u0007\u0003A\u0011ba\u0003-\u0003\u0003%\ta!\u0004\t\u0013\rEA&!A\u0005B\rM\u0001\"CB\fY\u0005\u0005I\u0011IB\r\u0011%\u0019Y\u0002LA\u0001\n\u0003\u001ai\u0002C\u0005\u0004 1\n\t\u0011\"\u0011\u0004\"\u001dQ1q\u0005\u0001\u0002\u0002#\u0005Qk!\u000b\u0007\u0015\tU\u0004!!A\t\u0002U\u001bY\u0003C\u0004\u0002\u0002\u0002#\taa\u0011\t\u0013\rm\u0001)!A\u0005F\ru\u0001\"CB#\u0001\u0006\u0005I\u0011QB$\u0011%\u0019i\u0005QA\u0001\n\u0003\u001by\u0005\u0003\u0005\u0004b\u0001!\t!VB2\u0011\u001d\u0019\t\u0007\u0001C\u0005\u0007KB\u0001ba\u001c\u0001\t\u0003)6\u0011\u000f\u0005\b\u0007o\u0002A\u0011IB2\u0011\u001d\u0019I\b\u0001C!\u0007GBqaa\u001f\u0001\t\u0003\u0019\u0019\u0007C\u0004\u0004~\u0001!Iaa \t\u000f\r-\u0005\u0001\"\u0003\u0004d!91Q\u0012\u0001\u0005\n\r=\u0005bBBO\u0001\u0011E1q\u0014\u0005\b\u0007K\u0003A\u0011BB2\u0011\u001d\u00199\u000b\u0001C\u0005\u0007SCqa!.\u0001\t\u0003\u0019\u0019\u0007C\u0004\u0004@\u0002!\ta!1\t\u000f\r\u001d\u0007\u0001\"\u0001\u0004J\nA\u0011iY2faR|'O\u0003\u0002W/\u00069a.\u001a;x_J\\'\"\u0001-\u0002\u000b-\fgm[1\u0014\u0007\u0001Qf\f\u0005\u0002\\96\tQ+\u0003\u0002^+\n!\u0012IY:ue\u0006\u001cGoU3sm\u0016\u0014H\u000b\u001b:fC\u0012\u0004\"a\u00182\u000e\u0003\u0001T!!Y,\u0002\u000f5,GO]5dg&\u00111\r\u0019\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018\u0001D:pG.,GoU3sm\u0016\u00148\u0001A\u000b\u0002OB\u00111\f[\u0005\u0003SV\u0013AbU8dW\u0016$8+\u001a:wKJ\fQb]8dW\u0016$8+\u001a:wKJ\u0004\u0013\u0001C3oIB{\u0017N\u001c;\u0016\u00035\u0004\"A\\9\u000e\u0003=T!\u0001],\u0002\u000f\rdWo\u001d;fe&\u0011!o\u001c\u0002\t\u000b:$\u0007k\\5oi\u0006IQM\u001c3Q_&tG\u000fI\u0001\u0007G>tg-[4\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!_,\u0002\rM,'O^3s\u0013\tY\bPA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR\u0019a0!\u0003\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0011\u00111A\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u000f\t\tA\u0001\u0003V]&$\b\u0002CA\u0006\r\u0005\u0005\t\u0019\u0001<\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\r9|G-Z%e!\ry\u00181C\u0005\u0005\u0003+\t\tAA\u0002J]R\f\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0011\u0007m\u000bY\"C\u0002\u0002\u001eU\u0013\u0001cQ8o]\u0016\u001cG/[8o#V|G/Y:\u0002\tQLW.\u001a\t\u0005\u0003G\t9$\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\u0015)H/\u001b7t\u0015\u0011\tY#!\f\u0002\r\r|W.\\8o\u0015\rA\u0016q\u0006\u0006\u0005\u0003c\t\u0019$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003k\t1a\u001c:h\u0013\u0011\tI$!\n\u0003\tQKW.Z\u0001\u0015SN\u0004&/\u001b<jY\u0016<W\r\u001a'jgR,g.\u001a:\u0011\u0007}\fy$\u0003\u0003\u0002B\u0005\u0005!a\u0002\"p_2,\u0017M\\\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\rY\u0016qI\u0005\u0004\u0003\u0013*&A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\t\u0005\u0003\u001b\n\t&\u0004\u0002\u0002P)\u0019\u0011-!\u000b\n\t\u0005M\u0013q\n\u0002\b\u001b\u0016$(/[2t\u0003I\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018X\u0003!\u0019XmY;sSRL\u0018\u0002BA1\u00037\u0012!c\u0011:fI\u0016tG/[1m!J|g/\u001b3fe\u0006QAn\\4D_:$X\r\u001f;\u0011\t\u0005\r\u0012qM\u0005\u0005\u0003S\n)C\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f!\"\\3n_JL\bk\\8m!\u0011\ty'!\u001e\u000e\u0005\u0005E$\u0002BA:\u0003S\ta!\\3n_JL\u0018\u0002BA<\u0003c\u0012!\"T3n_JL\bk\\8m\u0003E\t\u0007/\u001b,feNLwN\\'b]\u0006<WM\u001d\t\u0004o\u0006u\u0014bAA@q\n\t\u0012\t]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002\rqJg.\u001b;?)q\t))a\"\u0002\n\u0006-\u0015QRAH\u0003#\u000b\u0019*!&\u0002\u0018\u0006e\u00151TAO\u0003?\u0003\"a\u0017\u0001\t\u000b\u0011\u0014\u0002\u0019A4\t\u000b-\u0014\u0002\u0019A7\t\u000bQ\u0014\u0002\u0019\u0001<\t\u000f\u0005=!\u00031\u0001\u0002\u0012!9\u0011q\u0003\nA\u0002\u0005e\u0001bBA\u0010%\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003w\u0011\u0002\u0019AA\u001f\u0011\u001d\t\u0019E\u0005a\u0001\u0003\u000bBa!\u0019\nA\u0002\u0005-\u0003bBA+%\u0001\u0007\u0011q\u000b\u0005\b\u0003G\u0012\u0002\u0019AA3\u0011\u001d\tYG\u0005a\u0001\u0003[Bq!!\u001f\u0013\u0001\u0004\tY(\u0001\u0007nKR\u0014\u0018n\u0019)sK\u001aL\u0007\u0010\u0006\u0002\u0002&B!\u0011qUA[\u001d\u0011\tI+!-\u0011\t\u0005-\u0016\u0011A\u0007\u0003\u0003[S1!a,f\u0003\u0019a$o\\8u}%!\u00111WA\u0001\u0003\u0019\u0001&/\u001a3fM&!\u0011qWA]\u0005\u0019\u0019FO]5oO*!\u00111WA\u0001\u00031!\bN]3bIB\u0013XMZ5y\u00039\u0019XM\u001c3Ck\u001a4WM]*ju\u0016,\"!!1\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006!A.\u00198h\u0015\t\tY-\u0001\u0003kCZ\f\u0017\u0002BAh\u0003\u000b\u0014q!\u00138uK\u001e,'/A\btK:$')\u001e4gKJ\u001c\u0016N_3!\u00039\u0011Xm\u0019<Ck\u001a4WM]*ju\u0016\fqB]3dm\n+hMZ3s'&TX\rI\u0001\u0012Y&\u001cH/\u001a8CC\u000e\\Gn\\4TSj,\u0017A\u00057jgR,gNQ1dW2|wmU5{K\u0002\n1B\\5p'\u0016dWm\u0019;peV\u0011\u0011q\u001c\t\u0005\u0003C\fY/\u0004\u0002\u0002d*!\u0011Q]At\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002BAu\u0003\u0013\f1A\\5p\u0013\u0011\ti/a9\u0003\u0011M+G.Z2u_J\fAB\\5p'\u0016dWm\u0019;pe\u0002\nQb]3sm\u0016\u00148\t[1o]\u0016dWCAA{!\u0011\t\t/a>\n\t\u0005e\u00181\u001d\u0002\u0014'\u0016\u0014h/\u001a:T_\u000e\\W\r^\"iC:tW\r\\\u0001\u000fg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7!\u0003)\u0001(o\\2fgN|'o]\u000b\u0003\u0005\u0003\u0001bAa\u0001\u0003\u000e\tEQB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\u000f5,H/\u00192mK*!!1BA\u0001\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u001f\u0011)AA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA.\u0003\u0014%\u0019!QC+\u0003\u0013A\u0013xnY3tg>\u0014\u0018a\u00039s_\u000e,7o]8sg\u0002\n\u0011\u0003\u001d:pG\u0016\u001c8o\u001c:t'R\f'\u000f^3e+\t\u0011i\u0002\u0005\u0003\u0003 \t5RB\u0001B\u0011\u0015\u0011\u0011\u0019C!\n\u0002\r\u0005$x.\\5d\u0015\u0011\u00119C!\u000b\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003,\u0005%\u0017\u0001B;uS2LAAa\f\u0003\"\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\f!\u0003\u001d:pG\u0016\u001c8o\u001c:t'R\f'\u000f^3eA\u0005i\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;fe6+GO]5d\u001d\u0006lW-\u0006\u0002\u00038A!!\u0011\bB%\u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0012\u0001B2pe\u0016T1!\u0019B!\u0015\u0011\u0011\u0019E!\u0012\u0002\re\fW.\\3s\u0015\t\u00119%A\u0002d_6LAAa\u0013\u0003<\tQQ*\u001a;sS\u000et\u0015-\\3\u0002=\tdwnY6fIB+'oY3oi6+G/\u001a:NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013a\u00052m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014XC\u0001B*!\u0011\u0011ID!\u0016\n\t\t]#1\b\u0002\u0006\u001b\u0016$XM]\u0001\u0015E2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM\u001d\u0011\u0002+\r,(O]3oiB\u0013xnY3tg>\u0014\u0018J\u001c3fqV\u0011\u0011\u0011C\u0001\u001aGV\u0014(/\u001a8u!J|7-Z:t_JLe\u000eZ3y?\u0012*\u0017\u000fF\u0002\u007f\u0005GB\u0011\"a\u0003)\u0003\u0003\u0005\r!!\u0005\u0002-\r,(O]3oiB\u0013xnY3tg>\u0014\u0018J\u001c3fq\u0002\n\u0001\u0003\u001e5s_R$H.\u001a3T_\u000e\\W\r^:\u0016\u0005\t-\u0004C\u0002B\u0002\u0005[\u0012\t(\u0003\u0003\u0003p\t\u0015!!\u0004)sS>\u0014\u0018\u000e^=Rk\u0016,X\rE\u0002\u0003t1j\u0011\u0001\u0001\u0002\u0013\t\u0016d\u0017-_3e\u00072|7/Z*pG.,GoE\u0005-\u0005s\u0012yH!%\u0003\u0018B\u0019qPa\u001f\n\t\tu\u0014\u0011\u0001\u0002\u0007\u0003:L(+\u001a4\u0011\r\t\u0005%1\u0012B9\u001d\u0011\u0011\u0019Ia\"\u000f\t\u0005-&QQ\u0005\u0003\u0003\u0007IAA!#\u0002\u0002\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002BG\u0005\u001f\u0013qa\u0014:eKJ,GM\u0003\u0003\u0003\n\u0006\u0005\u0001cA@\u0003\u0014&!!QSA\u0001\u0005\u001d\u0001&o\u001c3vGR\u0004BA!!\u0003\u001a&!!1\u0014BH\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019\u0019xnY6fiV\u0011!\u0011\u0015\t\u0005\u0003C\u0014\u0019+\u0003\u0003\u0003&\u0006\r(!D*pG.,Go\u00115b]:,G.A\u0004t_\u000e\\W\r\u001e\u0011\u0002#\u0015tG\r\u00165s_R$H.\u001a+j[\u0016l5/\u0006\u0002\u0003.B\u0019qPa,\n\t\tE\u0016\u0011\u0001\u0002\u0005\u0019>tw-\u0001\nf]\u0012$\u0006N]8ui2,G+[7f\u001bN\u0004CC\u0002B9\u0005o\u0013I\fC\u0004\u0003\u001eF\u0002\rA!)\t\u000f\t%\u0016\u00071\u0001\u0003.\u000691m\\7qCJ,G\u0003BA\t\u0005\u007fCqA!13\u0001\u0004\u0011\t(\u0001\u0003uQ\u0006$\u0018\u0001B2paf$bA!\u001d\u0003H\n%\u0007\"\u0003BOgA\u0005\t\u0019\u0001BQ\u0011%\u0011Ik\rI\u0001\u0002\u0004\u0011i+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t='\u0006\u0002BQ\u0005#\\#Aa5\u0011\t\tU'q\\\u0007\u0003\u0005/TAA!7\u0003\\\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005;\f\t!\u0001\u0006b]:|G/\u0019;j_:LAA!9\u0003X\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u001d\u0016\u0005\u0005[\u0013\t.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005[\u0004B!a1\u0003p&!\u0011qWAc\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa>\u0003~B\u0019qP!?\n\t\tm\u0018\u0011\u0001\u0002\u0004\u0003:L\b\"CA\u0006q\u0005\u0005\t\u0019AA\t\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\u0002!\u0019\u0019)aa\u0002\u0003x6\u0011!\u0011B\u0005\u0005\u0007\u0013\u0011IA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001f\u0007\u001fA\u0011\"a\u0003;\u0003\u0003\u0005\rAa>\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005[\u001c)\u0002C\u0005\u0002\fm\n\t\u00111\u0001\u0002\u0012\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0012\u0005AAo\\*ue&tw\r\u0006\u0002\u0003n\u00061Q-];bYN$B!!\u0010\u0004$!I\u00111\u0002 \u0002\u0002\u0003\u0007!q_\u0001\u0012i\"\u0014x\u000e\u001e;mK\u0012\u001cvnY6fiN\u0004\u0013A\u0005#fY\u0006LX\rZ\"m_N,7k\\2lKR\u00042Aa\u001dA'\u0015\u00015QFB\u001d!)\u0019yc!\u000e\u0003\"\n5&\u0011O\u0007\u0003\u0007cQAaa\r\u0002\u0002\u00059!/\u001e8uS6,\u0017\u0002BB\u001c\u0007c\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u0019Yd!\u0011\u000e\u0005\ru\"\u0002BB \u0003\u0013\f!![8\n\t\tm5Q\b\u000b\u0003\u0007S\tQ!\u00199qYf$bA!\u001d\u0004J\r-\u0003b\u0002BO\u0007\u0002\u0007!\u0011\u0015\u0005\b\u0005S\u001b\u0005\u0019\u0001BW\u0003\u001d)h.\u00199qYf$Ba!\u0015\u0004^A)qpa\u0015\u0004X%!1QKA\u0001\u0005\u0019y\u0005\u000f^5p]B9qp!\u0017\u0003\"\n5\u0016\u0002BB.\u0003\u0003\u0011a\u0001V;qY\u0016\u0014\u0004\"CB0\t\u0006\u0005\t\u0019\u0001B9\u0003\rAH\u0005M\u0001\u0010gR\f'\u000f\u001e)s_\u000e,7o]8sgR\ta\u0010F\u0002\u007f\u0007OBq!!@G\u0001\u0004\u0019I\u0007\u0005\u0004\u0004\u0006\r-$\u0011C\u0005\u0005\u0007[\u0012IAA\u0002TKF\f\u0001C]3n_Z,\u0007K]8dKN\u001cxN]:\u0015\u0007y\u001c\u0019\bC\u0004\u0004v\u001d\u0003\r!!\u0005\u0002\u0017I,Wn\u001c<f\u0007>,h\u000e^\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:\fQ\"Y<bSR\u001c\u0006.\u001e;e_^t\u0017a\u0001:v]\u0006\u0001r\u000e]3o'\u0016\u0014h/\u001a:T_\u000e\\W\r\u001e\u000b\t\u0003k\u001c\ti!\"\u0004\n\"911Q&A\u0002\u0005\u0015\u0016\u0001\u00025pgRDqaa\"L\u0001\u0004\t\t\"\u0001\u0003q_J$\bbBAl\u0017\u0002\u0007\u0011\u0011C\u0001\u0015C\u000e\u001cW\r\u001d;OK^\u001cuN\u001c8fGRLwN\\:\u0002\r\u0005\u001c7-\u001a9u)\u0011\u0019\tja%\u0011\u000b}\u001c\u0019F!)\t\u000f\rUU\n1\u0001\u0004\u0018\u0006\u00191.Z=\u0011\t\u0005\u00058\u0011T\u0005\u0005\u00077\u000b\u0019O\u0001\u0007TK2,7\r^5p].+\u00170\u0001\u0010d_:4\u0017nZ;sK\u0006\u001b7-\u001a9uK\u0012\u001cvnY6fi\u000eC\u0017M\u001c8fYR\u0019ap!)\t\u000f\r\rf\n1\u0001\u0003\"\u0006i1o\\2lKR\u001c\u0005.\u00198oK2\f\u0011d\u00197pg\u0016$\u0006N]8ui2,GmQ8o]\u0016\u001cG/[8og\u0006\u0019\u0012m]:jO:tUm^\"p]:,7\r^5p]RA\u0011QHBV\u0007[\u001b\t\fC\u0004\u0004$B\u0003\rA!)\t\u000f\r=\u0006\u000b1\u0001\u0003\u0012\u0005I\u0001O]8dKN\u001cxN\u001d\u0005\b\u0007g\u0003\u0006\u0019AA\u001f\u0003!i\u0017-\u001f\"m_\u000e\\\u0017AB<bW\u0016,\b\u000fK\u0002R\u0007s\u0003B!a1\u0004<&!1QXAc\u0005!ye/\u001a:sS\u0012,\u0017!D1eIB\u0013xnY3tg>\u00148\u000fF\u0002\u007f\u0007\u0007Dqa!2S\u0001\u0004\t\t\"\u0001\u0005u_\u000e\u0013X-\u0019;f\u00031qWm\u001e)s_\u000e,7o]8s)!\u0011\tba3\u0004P\u000eu\u0007bBBg'\u0002\u0007\u0011\u0011C\u0001\u0003S\u0012Dqa!5T\u0001\u0004\u0019\u0019.\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0004V\u000eeWBABl\u0015\r1\u0016\u0011F\u0005\u0005\u00077\u001c9N\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0004\u0004`N\u0003\ra!9\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>d\u0007\u0003BBr\u0007Wl!a!:\u000b\t\r\u001d8\u0011^\u0001\u0005CV$\bN\u0003\u0003\u0002^\u0005%\u0012\u0002BBw\u0007K\u0014\u0001cU3dkJLG/\u001f)s_R|7m\u001c7")
public abstract class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final EndPoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public abstract String metricPrefix();

    public abstract String threadPrefix();

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    public synchronized void startProcessors() {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors());
            return;
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors) {
        processors.foreach((Function1 & Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$11 -> {
            x$11.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)x$12 -> {
            x$12.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$13 -> {
                x$13.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$14 -> {
                x$14.awaitShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
                this.closeSocket(throttledSocket.socket());
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
            this.shutdownComplete();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (!BoxesRunTime.equalsNumObject((Number)this.recvBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            serverChannel.socket().setReceiveBufferSize(Predef$.MODULE$.Integer2int(this.recvBufferSize()));
        }
        try {
            serverChannel.socket().bind(socketAddress, listenBacklogSize);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.isRunning()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            return;
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
            return;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$15)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            this.closeSocket(closingSocket.socket());
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        ListenerName listenerName = this.endPoint().listenerName();
        SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
        ArrayBuffer listenerProcessors = new ArrayBuffer();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$16 -> {
            Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol);
            listenerProcessors.$plus$eq((Object)processor);
            $this.requestChannel.addProcessor(processor);
        });
        this.processors().$plus$plus$eq((IterableOnce)listenerProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)listenerProcessors);
            return;
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol) {
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append($this.threadPrefix()).append("-kafka-network-thread-").append($this.nodeId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        Object var2_2 = null;
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$15) {
        return x$15.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, EndPoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        super(connectionQuotas);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize()));
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        this.blockedPercentMeterMetricName = this.explicitMetricName("kafka.network", "Acceptor", new StringBuilder(22).append(this.metricPrefix()).append("AcceptorBlockedPercent").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.blockedPercentMeter = this.newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof DelayedCloseSocket && ((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() == this.kafka$network$Acceptor$DelayedCloseSocket$$$outer())) break block3;
                    DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
                    if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) break block3;
                    SocketChannel socketChannel = this.socket();
                    SocketChannel socketChannel2 = delayedCloseSocket.socket();
                    if ((socketChannel != null ? !socketChannel.equals(socketChannel2) : socketChannel2 != null) || !delayedCloseSocket.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

