/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import kafka.common.InconsistentNodeIdException;
import kafka.common.KafkaException;
import kafka.log.LocalLog$;
import kafka.log.LogConfig$;
import kafka.server.BrokerMetadataCheckpoint$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.server.MetaProperties$;
import kafka.server.RawMetaProperties;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.metadata.KafkaConfigSchema;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class KafkaRaftServer$ {
    public static final KafkaRaftServer$ MODULE$ = new KafkaRaftServer$();
    private static final String MetadataTopic = "__cluster_metadata";
    private static final TopicPartition MetadataPartition = new TopicPartition(MODULE$.MetadataTopic(), 0);
    private static final Uuid MetadataTopicId = Uuid.METADATA_TOPIC_ID;
    private static final KafkaConfigSchema configSchema = new KafkaConfigSchema(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.BROKER), (Object)new ConfigDef(KafkaConfig$.MODULE$.configDef())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.TOPIC), (Object)LogConfig$.MODULE$.configDefCopy())}))).asJava());

    public String MetadataTopic() {
        return MetadataTopic;
    }

    public TopicPartition MetadataPartition() {
        return MetadataPartition;
    }

    public Uuid MetadataTopicId() {
        return MetadataTopicId;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<MetaProperties, Seq<String>> initializeLogDirs(KafkaConfig config) {
        void var4_4;
        void var5_5;
        scala.collection.immutable.Seq logDirs = config.logDirs().toSet().$plus((Object)config.metadataLogDir()).toSeq();
        Tuple2<RawMetaProperties, Seq<String>> tuple2 = BrokerMetadataCheckpoint$.MODULE$.getBrokerMetadataAndOfflineDirs((Seq<String>)logDirs, false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RawMetaProperties rawMetaProperties = (RawMetaProperties)tuple2._1();
        Seq offlineDirs = (Seq)tuple2._2();
        if (var5_5.contains((Object)config.metadataLogDir())) {
            throw new KafkaException(new StringBuilder(69).append("Cannot start server since `meta.properties` could not be ").append("loaded from ").append(config.metadataLogDir()).toString());
        }
        TopicPartition logDirName_topicPartition = this.MetadataPartition();
        Object var8_6 = null;
        String metadataPartitionDirName = LocalLog$.MODULE$.logDirName(logDirName_topicPartition);
        ((scala.collection.immutable.Seq)logDirs.diff((Seq)var5_5.$colon$plus((Object)config.metadataLogDir()))).foreach((Function1 & Serializable)logDir -> {
            KafkaRaftServer$.$anonfun$initializeLogDirs$1(metadataPartitionDirName, config, logDir);
            return BoxedUnit.UNIT;
        });
        MetaProperties metaProperties = MetaProperties$.MODULE$.parse((RawMetaProperties)var4_4);
        if (config.nodeId() != metaProperties.nodeId()) {
            throw new InconsistentNodeIdException(new StringBuilder(248).append("Configured node.id `").append(config.nodeId()).append("` doesn't match stored node.id `").append(metaProperties.nodeId()).append("' in ").append("meta.properties. If you moved your data, make sure your configured controller.id matches. ").append("If you intend to create a new broker, you should remove all data in your data directories (log.dirs).").toString());
        }
        return new Tuple2((Object)metaProperties, (Object)var5_5.toSeq());
    }

    public KafkaConfigSchema configSchema() {
        return configSchema;
    }

    public static final /* synthetic */ void $anonfun$initializeLogDirs$1(String metadataPartitionDirName$1, KafkaConfig config$1, String logDir) {
        File metadataDir = new File(logDir, metadataPartitionDirName$1);
        if (metadataDir.exists()) {
            throw new KafkaException(new StringBuilder(96).append("Found unexpected metadata location in data directory `").append(metadataDir).append("` ").append("(the configured metadata directory is ").append(config$1.metadataLogDir()).append(").").toString());
        }
    }

    private KafkaRaftServer$() {
    }
}

