/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.utils.ByteUtils;

public class MessageIndexes {
    private static final List<Integer> DEFAULT_INDEX = Collections.singletonList(0);
    private List<Integer> indexes;

    public MessageIndexes(List<Integer> indexes) {
        this.indexes = indexes;
    }

    public List<Integer> indexes() {
        return this.indexes;
    }

    public byte[] toByteArray() {
        if (this.indexes.equals(DEFAULT_INDEX)) {
            ByteBuffer buffer = ByteBuffer.allocate(ByteUtils.sizeOfVarint((int)0));
            ByteUtils.writeVarint((int)0, (ByteBuffer)buffer);
            return buffer.array();
        }
        int size = ByteUtils.sizeOfVarint((int)this.indexes.size());
        for (Integer index : this.indexes) {
            size += ByteUtils.sizeOfVarint((int)index);
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        this.writeTo(buffer);
        return buffer.array();
    }

    public void writeTo(ByteBuffer buffer) {
        ByteUtils.writeVarint((int)this.indexes.size(), (ByteBuffer)buffer);
        for (Integer index : this.indexes) {
            ByteUtils.writeVarint((int)index, (ByteBuffer)buffer);
        }
    }

    public static MessageIndexes readFrom(byte[] bytes) {
        return MessageIndexes.readFrom(ByteBuffer.wrap(bytes));
    }

    public static MessageIndexes readFrom(ByteBuffer buffer) {
        int size = ByteUtils.readVarint((ByteBuffer)buffer);
        if (size == 0) {
            return new MessageIndexes(DEFAULT_INDEX);
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            indexes.add(ByteUtils.readVarint((ByteBuffer)buffer));
        }
        return new MessageIndexes(indexes);
    }
}

