/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v2;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.TopicConfigManager;
import io.confluent.kafkarest.controllers.TopicManager;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.kafkarest.entities.v2.GetTopicResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/topics")
@Consumes(value={"application/vnd.kafka.v2+json"})
@Produces(value={"application/vnd.kafka.v2+json"})
@ResourceAccesslistFeature.ResourceName(value="api.v2.topics.*")
public final class TopicsResource {
    private final Provider<TopicManager> topicManagerProvider;
    private final Provider<TopicConfigManager> topicConfigManagerProvider;

    @Inject
    public TopicsResource(Provider<TopicManager> topicManagerProvider, Provider<TopicConfigManager> topicConfigManagerProvider) {
        this.topicManagerProvider = Objects.requireNonNull(topicManagerProvider);
        this.topicConfigManagerProvider = Objects.requireNonNull(topicConfigManagerProvider);
    }

    @GET
    @PerformanceMetric(value="topics.list+v2")
    @ResourceAccesslistFeature.ResourceName(value="api.v2.topics.list")
    public void list(@Suspended AsyncResponse asyncResponse) {
        TopicManager topicManager = (TopicManager)this.topicManagerProvider.get();
        CompletionStage response = topicManager.listLocalTopics().thenApply(topics -> topics.stream().map(Topic::getName).collect(Collectors.toList()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.get+v2")
    @ResourceAccesslistFeature.ResourceName(value="api.v2.topics.get")
    public void getTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName) {
        TopicManager topicManager = (TopicManager)this.topicManagerProvider.get();
        TopicConfigManager topicConfigManager = (TopicConfigManager)this.topicConfigManagerProvider.get();
        CompletionStage topicFuture = topicManager.getLocalTopic(topicName).thenApply(topic -> (Topic)topic.orElseThrow(Errors::topicNotFoundException));
        CompletionStage response = ((CompletableFuture)((CompletableFuture)topicFuture).thenCompose(topic -> topicConfigManager.listTopicConfigs(topic.getClusterId(), topicName))).thenCombine(topicFuture, (configs, topic) -> GetTopicResponse.fromTopic(topic, configs));
        AsyncResponses.asyncResume(asyncResponse, response);
    }
}

