/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.rest.metrics.RestMetricsContext;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProducerMetrics {
    private static final Logger log = LoggerFactory.getLogger(ProducerMetrics.class);
    private static final String GROUP_NAME = "produce-api-metrics";
    private static final ImmutableMap<String, String> METRIC_TAGS = ImmutableMap.of();
    private static final int NUM_SAMPLES = 10;
    private static final long SAMPLE_WINDOW_MS = 10000L;
    private static final Sensor.RecordingLevel RECORDING_LEVEL = Sensor.RecordingLevel.INFO;
    private static final String REQUEST_SENSOR_NAME = "request-sensor";
    private static final String REQUEST_SIZE_SENSOR_NAME = "request-size-sensor";
    private static final String RESPONSE_SENSOR_NAME = "response-sensor";
    private static final String RECORD_ERROR_SENSOR_NAME = "record-error-sensor";
    private static final String REQUEST_LATENCY_SENSOR_NAME = "request-latency-sensor";
    static final String REQUEST_RATE_METRIC_NAME = "request-rate";
    private static final String REQUEST_RATE_METRIC_DOC = "The average number of requests sent per second.";
    static final String REQUEST_SIZE_AVG_METRIC_NAME = "request-size-avg";
    private static final String REQUEST_SIZE_AVG_METRIC_DOC = "The average request size in bytes.";
    static final String REQUEST_COUNT_WINDOWED_METRIC_NAME = "request-count-windowed";
    private static final String REQUEST_COUNT_WINDOWED_METRIC_DOC = "The total number of requests sent within the given window.";
    static final String RESPONSE_RATE_METRIC_NAME = "response-rate";
    private static final String RESPONSE_RATE_METRIC_DOC = "The average number of responses sent per second.";
    static final String RESPONSE_COUNT_WINDOWED_METRIC_NAME = "response-count-windowed";
    private static final String RESPONSE_COUNT_WINDOWED_METRIC_DOC = "The total number of responses sent in the given window.";
    static final String RECORD_ERROR_COUNT_WINDOWED_METRIC_NAME = "error-count-windowed";
    private static final String RECORD_ERROR_COUNT_WINDOWED_METRIC_DOC = "The total number of record sends that resulted in errors in the given window.";
    static final String RECORD_ERROR_RATE_METRIC_NAME = "record-error-rate";
    private static final String RECORD_ERROR_RATE_METRIC_DOC = "The average per-second number of record sends that resulted in errors.";
    static final String REQUEST_LATENCY_AVG_METRIC_NAME = "request-latency-avg";
    private static final String REQUEST_LATENCY_AVG_METRIC_DOC = "The average request latency";
    static final String REQUEST_LATENCY_MAX_METRIC_NAME = "request-latency-max";
    private static final String REQUEST_LATENCY_MAX_METRIC_DOC = "The max request latency";
    static final String REQUEST_LATENCY_PCT_METRIC_PREFIX = "request-latency-";
    private static final String REQUEST_LATENCY_PCT_METRIC_DOC = "Request latency percentiles.";
    private final Metrics metrics;
    private final String jmxPrefix;
    private final String requestSensorName;
    private final String requestSizeSensorName;
    private final String responseSensorName;
    private final String recordErrorSensorName;
    private final String requestLatencySensorName;

    ProducerMetrics(KafkaRestConfig config, Time time) {
        this.metrics = ProducerMetrics.createMetrics(config.getMetricsContext(), time);
        this.jmxPrefix = config.getString("metrics.jmx.prefix");
        String sensorNamePrefix = this.jmxPrefix + ":" + GROUP_NAME + ":";
        this.recordErrorSensorName = sensorNamePrefix + RECORD_ERROR_SENSOR_NAME;
        this.requestSensorName = sensorNamePrefix + REQUEST_SENSOR_NAME;
        this.requestLatencySensorName = sensorNamePrefix + REQUEST_LATENCY_SENSOR_NAME;
        this.requestSizeSensorName = sensorNamePrefix + REQUEST_SIZE_SENSOR_NAME;
        this.responseSensorName = sensorNamePrefix + RESPONSE_SENSOR_NAME;
        this.setupSensors();
    }

    private static Metrics createMetrics(RestMetricsContext metricsContext, Time time) {
        JmxReporter reporter = new JmxReporter();
        reporter.contextChange((MetricsContext)metricsContext);
        return new Metrics(new MetricConfig().samples(10).timeWindow(10000L, TimeUnit.MILLISECONDS).recordLevel(RECORDING_LEVEL), Collections.singletonList(reporter), time, (MetricsContext)metricsContext);
    }

    private void setupSensors() {
        this.setupRequestSensor();
        this.setupRequestSizeSensor();
        this.setupResponseSensor();
        this.setupRecordErrorSensor();
        this.setupRequestLatencySensor();
        log.info("Successfully registered kafka-rest produce metrics with JMX");
    }

    private void setupRequestSensor() {
        Sensor requestSensor = this.createSensor(REQUEST_SENSOR_NAME);
        this.addAvg(requestSensor, REQUEST_RATE_METRIC_NAME, REQUEST_RATE_METRIC_DOC);
        this.addWindowedCount(requestSensor, REQUEST_COUNT_WINDOWED_METRIC_NAME, REQUEST_COUNT_WINDOWED_METRIC_DOC);
    }

    private void setupRequestSizeSensor() {
        Sensor requestSizeSensor = this.createSensor(REQUEST_SIZE_SENSOR_NAME);
        this.addAvg(requestSizeSensor, REQUEST_SIZE_AVG_METRIC_NAME, REQUEST_SIZE_AVG_METRIC_DOC);
    }

    private void setupResponseSensor() {
        Sensor responseSensor = this.createSensor(RESPONSE_SENSOR_NAME);
        this.addRate(responseSensor, RESPONSE_RATE_METRIC_NAME, RESPONSE_RATE_METRIC_DOC);
        this.addWindowedCount(responseSensor, RESPONSE_COUNT_WINDOWED_METRIC_NAME, RESPONSE_COUNT_WINDOWED_METRIC_DOC);
    }

    private void setupRecordErrorSensor() {
        Sensor recordErrorSensor = this.createSensor(RECORD_ERROR_SENSOR_NAME);
        this.addRate(recordErrorSensor, RECORD_ERROR_RATE_METRIC_NAME, RECORD_ERROR_RATE_METRIC_DOC);
        this.addWindowedCount(recordErrorSensor, RECORD_ERROR_COUNT_WINDOWED_METRIC_NAME, RECORD_ERROR_COUNT_WINDOWED_METRIC_DOC);
    }

    private void setupRequestLatencySensor() {
        Sensor requestLatencySensor = this.createSensor(REQUEST_LATENCY_SENSOR_NAME);
        this.addMax(requestLatencySensor, REQUEST_LATENCY_MAX_METRIC_NAME, REQUEST_LATENCY_MAX_METRIC_DOC);
        this.addAvg(requestLatencySensor, REQUEST_LATENCY_AVG_METRIC_NAME, REQUEST_LATENCY_AVG_METRIC_DOC);
        this.addPercentiles(requestLatencySensor, REQUEST_LATENCY_PCT_METRIC_PREFIX, (Map<String, Double>)ImmutableMap.of((Object)"p95", (Object)0.95, (Object)"p99", (Object)0.99, (Object)"p999", (Object)0.999), REQUEST_LATENCY_PCT_METRIC_DOC);
    }

    private Sensor createSensor(String name) {
        return this.metrics.sensor(String.join((CharSequence)":", this.jmxPrefix, GROUP_NAME, name));
    }

    private void addAvg(Sensor sensor, String name, String doc) {
        sensor.add(this.getMetricName(name, doc), (MeasurableStat)new Avg());
    }

    private void addRate(Sensor sensor, String name, String doc) {
        sensor.add(this.getMetricName(name, doc), (MeasurableStat)new Rate());
    }

    private void addMax(Sensor sensor, String name, String doc) {
        sensor.add(this.getMetricName(name, doc), (MeasurableStat)new Max());
    }

    private void addWindowedCount(Sensor sensor, String name, String doc) {
        sensor.add(this.getMetricName(name, doc), (MeasurableStat)new WindowedCount());
    }

    private void addPercentiles(Sensor sensor, String prefix, Map<String, Double> percentiles, String doc) {
        sensor.add((CompoundStat)new Percentiles(120000, 30000.0, Percentiles.BucketSizing.CONSTANT, (Percentile[])percentiles.entrySet().stream().map(entry -> new Percentile(this.getMetricName(prefix + (String)entry.getKey(), doc), ((Double)entry.getValue()).doubleValue())).toArray(Percentile[]::new)));
    }

    private MetricName getMetricName(String name, String doc) {
        return this.metrics.metricInstance(new MetricNameTemplate(name, GROUP_NAME, doc, Collections.emptySet()), METRIC_TAGS);
    }

    void recordResponse() {
        this.recordMetric(this.responseSensorName, 1.0);
    }

    void recordRequestLatency(long value) {
        this.recordMetric(this.requestLatencySensorName, value);
    }

    void recordError() {
        this.recordMetric(this.recordErrorSensorName, 1.0);
    }

    void recordRequest() {
        this.recordMetric(this.requestSensorName, 1.0);
    }

    void recordRequestSize(double value) {
        this.recordMetric(this.requestSizeSensorName, value);
    }

    private void recordMetric(String sensorName, double value) {
        Sensor sensor = this.metrics.getSensor(sensorName);
        if (sensor != null) {
            sensor.record(value);
        }
    }
}

