/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.ArraySchemaDiff;
import io.confluent.kafka.schemaregistry.json.diff.CombinedSchemaDiff;
import io.confluent.kafka.schemaregistry.json.diff.Context;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import io.confluent.kafka.schemaregistry.json.diff.EnumSchemaDiff;
import io.confluent.kafka.schemaregistry.json.diff.NotSchemaDiff;
import io.confluent.kafka.schemaregistry.json.diff.NumberSchemaDiff;
import io.confluent.kafka.schemaregistry.json.diff.ObjectSchemaDiff;
import io.confluent.kafka.schemaregistry.json.diff.StringSchemaDiff;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;

public class SchemaDiff {
    public static final Set<Difference.Type> COMPATIBLE_CHANGES;

    public static List<Difference> compare(Schema original, Schema update) {
        Context ctx = new Context(COMPATIBLE_CHANGES);
        SchemaDiff.compare(ctx, original, update);
        return ctx.getDifferences();
    }

    static void compare(Context ctx, Schema original, Schema update) {
        Object subctx;
        CombinedSchema combinedSchema;
        if (original == null && update == null) {
            return;
        }
        if (original == null) {
            ctx.addDifference(Difference.Type.SCHEMA_ADDED);
            return;
        }
        if (update == null) {
            ctx.addDifference(Difference.Type.SCHEMA_REMOVED);
            return;
        }
        original = SchemaDiff.normalizeSchema(original);
        update = SchemaDiff.normalizeSchema(update);
        if (!(original instanceof CombinedSchema) && update instanceof CombinedSchema) {
            combinedSchema = (CombinedSchema)update;
            if (combinedSchema.getSubschemas().size() == 1) {
                subctx = ctx.getSubcontext();
                SchemaDiff.compare((Context)subctx, original, (Schema)combinedSchema.getSubschemas().iterator().next());
                if (((Context)subctx).isCompatible()) {
                    ctx.addDifferences(((Context)subctx).getDifferences());
                    return;
                }
            } else if (combinedSchema.getCriterion() == CombinedSchema.ANY_CRITERION || combinedSchema.getCriterion() == CombinedSchema.ONE_CRITERION) {
                for (Schema subschema : combinedSchema.getSubschemas()) {
                    Context subctx2 = ctx.getSubcontext();
                    SchemaDiff.compare(subctx2, original, subschema);
                    if (!subctx2.isCompatible()) continue;
                    ctx.addDifferences(subctx2.getDifferences());
                    ctx.addDifference(Difference.Type.SUM_TYPE_EXTENDED);
                    return;
                }
            }
        } else if (original instanceof CombinedSchema && !(update instanceof CombinedSchema)) {
            combinedSchema = (CombinedSchema)original;
            if (combinedSchema.getSubschemas().size() == 1) {
                subctx = ctx.getSubcontext();
                SchemaDiff.compare((Context)subctx, (Schema)combinedSchema.getSubschemas().iterator().next(), update);
                if (((Context)subctx).isCompatible()) {
                    ctx.addDifferences(((Context)subctx).getDifferences());
                    return;
                }
            } else if (combinedSchema.getCriterion() == CombinedSchema.ALL_CRITERION) {
                for (Schema subschema : combinedSchema.getSubschemas()) {
                    Context subctx3 = ctx.getSubcontext();
                    SchemaDiff.compare(subctx3, subschema, update);
                    if (!subctx3.isCompatible()) continue;
                    ctx.addDifferences(subctx3.getDifferences());
                    ctx.addDifference(Difference.Type.PRODUCT_TYPE_NARROWED);
                    return;
                }
            }
        }
        if (!original.getClass().equals(update.getClass())) {
            if (original instanceof FalseSchema || update instanceof EmptySchema) {
                return;
            }
            ctx.addDifference(Difference.Type.TYPE_CHANGED);
            return;
        }
        Context.SchemaScope schemaScope = ctx.enterSchema(original);
        Object object = null;
        try {
            if (schemaScope != null) {
                if (!Objects.equals(original.getId(), update.getId())) {
                    ctx.addDifference(Difference.Type.ID_CHANGED);
                }
                if (!Objects.equals(original.getTitle(), update.getTitle())) {
                    ctx.addDifference(Difference.Type.TITLE_CHANGED);
                }
                if (!Objects.equals(original.getDescription(), update.getDescription())) {
                    ctx.addDifference(Difference.Type.DESCRIPTION_CHANGED);
                }
                if (!Objects.equals(original.getDefaultValue(), update.getDefaultValue())) {
                    ctx.addDifference(Difference.Type.DEFAULT_CHANGED);
                }
                if (original instanceof StringSchema) {
                    StringSchemaDiff.compare(ctx, (StringSchema)original, (StringSchema)update);
                } else if (original instanceof NumberSchema) {
                    NumberSchemaDiff.compare(ctx, (NumberSchema)original, (NumberSchema)update);
                } else if (original instanceof EnumSchema) {
                    EnumSchemaDiff.compare(ctx, (EnumSchema)original, (EnumSchema)update);
                } else if (original instanceof CombinedSchema) {
                    CombinedSchemaDiff.compare(ctx, (CombinedSchema)original, (CombinedSchema)update);
                } else if (original instanceof NotSchema) {
                    NotSchemaDiff.compare(ctx, (NotSchema)original, (NotSchema)update);
                } else if (original instanceof ObjectSchema) {
                    ObjectSchemaDiff.compare(ctx, (ObjectSchema)original, (ObjectSchema)update);
                } else if (original instanceof ArraySchema) {
                    ArraySchemaDiff.compare(ctx, (ArraySchema)original, (ArraySchema)update);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (schemaScope != null) {
                if (object != null) {
                    try {
                        schemaScope.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    schemaScope.close();
                }
            }
        }
    }

    private static Schema normalizeSchema(Schema schema) {
        if (schema instanceof ReferenceSchema) {
            return ((ReferenceSchema)schema).getReferredSchema();
        }
        return schema;
    }

    static {
        HashSet<Difference.Type> changes = new HashSet<Difference.Type>();
        changes.add(Difference.Type.ID_CHANGED);
        changes.add(Difference.Type.DESCRIPTION_CHANGED);
        changes.add(Difference.Type.TITLE_CHANGED);
        changes.add(Difference.Type.DEFAULT_CHANGED);
        changes.add(Difference.Type.SCHEMA_REMOVED);
        changes.add(Difference.Type.TYPE_EXTENDED);
        changes.add(Difference.Type.MAX_LENGTH_INCREASED);
        changes.add(Difference.Type.MAX_LENGTH_REMOVED);
        changes.add(Difference.Type.MIN_LENGTH_DECREASED);
        changes.add(Difference.Type.MIN_LENGTH_REMOVED);
        changes.add(Difference.Type.PATTERN_REMOVED);
        changes.add(Difference.Type.MAXIMUM_INCREASED);
        changes.add(Difference.Type.MAXIMUM_REMOVED);
        changes.add(Difference.Type.MINIMUM_DECREASED);
        changes.add(Difference.Type.MINIMUM_REMOVED);
        changes.add(Difference.Type.EXCLUSIVE_MAXIMUM_INCREASED);
        changes.add(Difference.Type.EXCLUSIVE_MAXIMUM_REMOVED);
        changes.add(Difference.Type.EXCLUSIVE_MINIMUM_DECREASED);
        changes.add(Difference.Type.EXCLUSIVE_MINIMUM_REMOVED);
        changes.add(Difference.Type.MULTIPLE_OF_REDUCED);
        changes.add(Difference.Type.MULTIPLE_OF_REMOVED);
        changes.add(Difference.Type.REQUIRED_ATTRIBUTE_WITH_DEFAULT_ADDED);
        changes.add(Difference.Type.REQUIRED_ATTRIBUTE_REMOVED);
        changes.add(Difference.Type.DEPENDENCY_ARRAY_NARROWED);
        changes.add(Difference.Type.DEPENDENCY_ARRAY_REMOVED);
        changes.add(Difference.Type.DEPENDENCY_SCHEMA_REMOVED);
        changes.add(Difference.Type.MAX_PROPERTIES_INCREASED);
        changes.add(Difference.Type.MAX_PROPERTIES_REMOVED);
        changes.add(Difference.Type.MIN_PROPERTIES_DECREASED);
        changes.add(Difference.Type.MIN_PROPERTIES_REMOVED);
        changes.add(Difference.Type.ADDITIONAL_PROPERTIES_ADDED);
        changes.add(Difference.Type.ADDITIONAL_PROPERTIES_EXTENDED);
        changes.add(Difference.Type.PROPERTY_WITH_EMPTY_SCHEMA_ADDED_TO_OPEN_CONTENT_MODEL);
        changes.add(Difference.Type.REQUIRED_PROPERTY_WITH_DEFAULT_ADDED_TO_UNOPEN_CONTENT_MODEL);
        changes.add(Difference.Type.OPTIONAL_PROPERTY_ADDED_TO_UNOPEN_CONTENT_MODEL);
        changes.add(Difference.Type.PROPERTY_WITH_FALSE_REMOVED_FROM_CLOSED_CONTENT_MODEL);
        changes.add(Difference.Type.PROPERTY_REMOVED_FROM_OPEN_CONTENT_MODEL);
        changes.add(Difference.Type.PROPERTY_ADDED_IS_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
        changes.add(Difference.Type.PROPERTY_REMOVED_IS_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
        changes.add(Difference.Type.MAX_ITEMS_INCREASED);
        changes.add(Difference.Type.MAX_ITEMS_REMOVED);
        changes.add(Difference.Type.MIN_ITEMS_DECREASED);
        changes.add(Difference.Type.MIN_ITEMS_REMOVED);
        changes.add(Difference.Type.UNIQUE_ITEMS_REMOVED);
        changes.add(Difference.Type.ADDITIONAL_ITEMS_ADDED);
        changes.add(Difference.Type.ADDITIONAL_ITEMS_EXTENDED);
        changes.add(Difference.Type.ITEM_WITH_EMPTY_SCHEMA_ADDED_TO_OPEN_CONTENT_MODEL);
        changes.add(Difference.Type.ITEM_ADDED_TO_CLOSED_CONTENT_MODEL);
        changes.add(Difference.Type.ITEM_WITH_FALSE_REMOVED_FROM_CLOSED_CONTENT_MODEL);
        changes.add(Difference.Type.ITEM_REMOVED_FROM_OPEN_CONTENT_MODEL);
        changes.add(Difference.Type.ITEM_ADDED_IS_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
        changes.add(Difference.Type.ITEM_REMOVED_IS_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
        changes.add(Difference.Type.ENUM_ARRAY_EXTENDED);
        changes.add(Difference.Type.COMBINED_TYPE_EXTENDED);
        changes.add(Difference.Type.PRODUCT_TYPE_NARROWED);
        changes.add(Difference.Type.SUM_TYPE_EXTENDED);
        changes.add(Difference.Type.NOT_TYPE_NARROWED);
        COMPATIBLE_CHANGES = Collections.unmodifiableSet(changes);
    }
}

