/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.kafka.formatter.SchemaMessageSerializer;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.testutil.MockSchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import io.confluent.kafka.serializers.subject.SubjectNameStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.common.MessageReader;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.ShortSerializer;

public abstract class SchemaMessageReader<T>
implements MessageReader {
    public static final String VALUE_SCHEMA = "value.schema";
    public static final String KEY_SCHEMA = "key.schema";
    private String topic = null;
    private BufferedReader reader = null;
    private Boolean parseKey = false;
    private String keySeparator = "\t";
    private boolean ignoreError = false;
    protected ParsedSchema keySchema = null;
    protected ParsedSchema valueSchema = null;
    private String keySubject = null;
    private String valueSubject = null;
    private SchemaMessageSerializer<T> serializer;

    public SchemaMessageReader() {
    }

    public SchemaMessageReader(SchemaRegistryClient schemaRegistryClient, ParsedSchema keySchema, ParsedSchema valueSchema, String topic, boolean parseKey, BufferedReader reader, boolean normalizeSchema, boolean autoRegister, boolean useLatest) {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.topic = topic;
        this.keySubject = topic != null ? topic + "-key" : null;
        this.valueSubject = topic != null ? topic + "-value" : null;
        this.parseKey = parseKey;
        this.reader = reader;
        this.serializer = this.createSerializer(schemaRegistryClient, normalizeSchema, autoRegister, useLatest, null);
    }

    protected abstract SchemaMessageSerializer<T> createSerializer(SchemaRegistryClient var1, boolean var2, boolean var3, boolean var4, Serializer var5);

    public void init(InputStream inputStream, Properties props) {
        this.topic = props.getProperty("topic");
        if (this.topic == null) {
            throw new ConfigException("Missing topic!");
        }
        if (props.containsKey("parse.key")) {
            this.parseKey = props.getProperty("parse.key").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("key.separator")) {
            this.keySeparator = props.getProperty("key.separator");
        }
        if (props.containsKey("ignore.error")) {
            this.ignoreError = props.getProperty("ignore.error").trim().toLowerCase().equals("true");
        }
        this.reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        String url = props.getProperty("schema.registry.url");
        if (url == null) {
            throw new ConfigException("Missing schema registry url!");
        }
        SchemaRegistryClient schemaRegistry = this.getSchemaRegistryClient(props, url);
        Serializer keySerializer = this.getKeySerializer(props);
        boolean normalizeSchema = props.containsKey("normalize.schemas") ? Boolean.parseBoolean(props.getProperty("normalize.schemas").trim()) : false;
        boolean autoRegisterSchema = props.containsKey("auto.register") ? Boolean.parseBoolean(props.getProperty("auto.register").trim()) : (props.containsKey("auto.register.schemas") ? Boolean.parseBoolean(props.getProperty("auto.register.schemas").trim()) : true);
        boolean useLatest = props.containsKey("use.latest.version") ? Boolean.parseBoolean(props.getProperty("use.latest.version").trim()) : false;
        if (this.serializer == null) {
            this.serializer = this.createSerializer(schemaRegistry, normalizeSchema, autoRegisterSchema, useLatest, keySerializer);
        }
        AbstractKafkaSchemaSerDeConfig config = new AbstractKafkaSchemaSerDeConfig(AbstractKafkaSchemaSerDeConfig.baseConfigDef(), props, false);
        this.valueSchema = this.getSchema(schemaRegistry, props, false);
        Object valueSubjectNameStrategy = config.valueSubjectNameStrategy();
        this.valueSubject = this.getSubjectName(valueSubjectNameStrategy, this.topic, false, this.valueSchema);
        if (this.needsKeySchema()) {
            this.keySchema = this.getSchema(schemaRegistry, props, true);
            Object keySubjectNameStrategy = config.keySubjectNameStrategy();
            this.keySubject = this.getSubjectName(keySubjectNameStrategy, this.topic, true, this.keySchema);
        }
    }

    private SchemaRegistryClient getSchemaRegistryClient(Properties props, String url) {
        Map<String, Object> originals = this.getPropertiesMap(props);
        List<String> schemaRegistryUrls = Collections.singletonList(url);
        List<SchemaProvider> schemaProviders = Collections.singletonList(this.getProvider());
        String maybeMockScope = MockSchemaRegistry.validateAndMaybeGetMockScope(schemaRegistryUrls);
        Object schemaRegistry = maybeMockScope == null ? new CachedSchemaRegistryClient(url, 1000, schemaProviders, originals) : MockSchemaRegistry.getClientForScope((String)maybeMockScope, schemaProviders);
        return schemaRegistry;
    }

    private String getSubjectName(Object subjectNameStrategy, String topic, boolean isKey, ParsedSchema schema) {
        if (subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy) {
            return ((io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy)subjectNameStrategy).subjectName(topic, isKey, schema);
        }
        throw new RuntimeException("Classes extending deprecated " + SubjectNameStrategy.class.getCanonicalName() + " are not supported. Use classes extending " + io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy.class.getCanonicalName() + " instead.");
    }

    protected abstract SchemaProvider getProvider();

    protected ParsedSchema parseSchema(SchemaRegistryClient schemaRegistry, String schema, List<SchemaReference> references) {
        SchemaProvider provider = this.getProvider();
        provider.configure(Collections.singletonMap("schemaVersionFetcher", schemaRegistry));
        return (ParsedSchema)provider.parseSchema(schema, references).get();
    }

    private ParsedSchema getSchema(SchemaRegistryClient schemaRegistry, Properties props, boolean isKey) {
        ParsedSchema schema = this.getSchemaById(schemaRegistry, props, isKey);
        if (schema != null) {
            return schema;
        }
        String schemaString = this.getSchemaString(props, isKey);
        List<SchemaReference> refs = this.getSchemaReferences(props, isKey);
        return this.parseSchema(schemaRegistry, schemaString, refs);
    }

    private ParsedSchema getSchemaById(SchemaRegistryClient schemaRegistry, Properties props, boolean isKey) {
        String propKeyId = isKey ? "key.schema.id" : "value.schema.id";
        int schemaId = 0;
        try {
            if (props.containsKey(propKeyId)) {
                schemaId = Integer.parseInt(props.getProperty(propKeyId));
                return schemaRegistry.getSchemaById(schemaId);
            }
            return null;
        }
        catch (NumberFormatException e) {
            throw new SerializationException(String.format("Error parsing %s as int", propKeyId), (Throwable)e);
        }
        catch (RestClientException | IOException e) {
            throw new SerializationException(String.format("Error retrieving schema for id %d", schemaId), e);
        }
    }

    private String getSchemaString(Properties props, boolean isKey) {
        String propKeyFile;
        String propKeyRaw = isKey ? KEY_SCHEMA : VALUE_SCHEMA;
        String string = propKeyFile = isKey ? "key.schema.file" : "value.schema.file";
        if (props.containsKey(propKeyRaw)) {
            return props.getProperty(propKeyRaw);
        }
        if (props.containsKey(propKeyFile)) {
            try {
                return new String(Files.readAllBytes(Paths.get(props.getProperty(propKeyFile), new String[0])), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new ConfigException("Error reading schema from " + props.getProperty(propKeyFile));
            }
        }
        throw new ConfigException("Must provide the " + (isKey ? "key" : "value") + " schema in either " + propKeyRaw + ", " + propKeyRaw + ".id, or " + propKeyFile);
    }

    private List<SchemaReference> getSchemaReferences(Properties props, boolean isKey) {
        String propKey;
        String string = propKey = isKey ? "key.refs" : "value.refs";
        if (props.containsKey(propKey)) {
            try {
                return (List)JacksonMapper.INSTANCE.readValue(props.getProperty(propKey), (TypeReference)new TypeReference<List<SchemaReference>>(){});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptyList();
    }

    private Serializer getKeySerializer(Properties props) throws ConfigException {
        if (props.containsKey("key.serializer")) {
            try {
                return (Serializer)Class.forName((String)props.get("key.serializer")).newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Error initializing Key serializer: " + e.getMessage());
            }
        }
        return null;
    }

    private boolean needsKeySchema() {
        return this.parseKey != false && this.serializer.getKeySerializer() == null;
    }

    private Map<String, Object> getPropertiesMap(Properties props) {
        HashMap<String, Object> originals = new HashMap<String, Object>();
        for (String name : props.stringPropertyNames()) {
            originals.put(name, props.getProperty(name));
        }
        return originals;
    }

    public ProducerRecord<byte[], byte[]> readMessage() {
        try {
            byte[] serializedKey;
            String valueString;
            String line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            if (!this.parseKey.booleanValue()) {
                T value = this.readFrom(line, this.valueSchema);
                byte[] serializedValue = this.serializer.serialize(this.valueSubject, this.topic, false, value, this.valueSchema);
                return new ProducerRecord(this.topic, (Object)serializedValue);
            }
            int keyIndex = line.indexOf(this.keySeparator);
            if (keyIndex < 0) {
                if (this.ignoreError) {
                    T value = this.readFrom(line, this.valueSchema);
                    byte[] serializedValue = this.serializer.serialize(this.valueSubject, this.topic, false, value, this.valueSchema);
                    return new ProducerRecord(this.topic, (Object)serializedValue);
                }
                throw new KafkaException("No key found in line " + line);
            }
            String keyString = line.substring(0, keyIndex);
            String string = valueString = keyIndex + this.keySeparator.length() > line.length() ? "" : line.substring(keyIndex + this.keySeparator.length());
            if (this.serializer.getKeySerializer() != null) {
                serializedKey = this.serializeNonSchemaKey(keyString);
            } else {
                T key = this.readFrom(keyString, this.keySchema);
                serializedKey = this.serializer.serialize(this.keySubject, this.topic, true, key, this.keySchema);
            }
            T value = this.readFrom(valueString, this.valueSchema);
            byte[] serializedValue = this.serializer.serialize(this.valueSubject, this.topic, false, value, this.valueSchema);
            return new ProducerRecord(this.topic, (Object)serializedKey, (Object)serializedValue);
        }
        catch (IOException e) {
            throw new KafkaException("Error reading from input", (Throwable)e);
        }
    }

    private byte[] serializeNonSchemaKey(String keyString) {
        Class<?> serializerClass = this.serializer.getKeySerializer().getClass();
        if (serializerClass == LongSerializer.class) {
            Long longKey = Long.parseLong(keyString);
            return this.serializer.serializeKey(this.topic, longKey);
        }
        if (serializerClass == IntegerSerializer.class) {
            Integer intKey = Integer.parseInt(keyString);
            return this.serializer.serializeKey(this.topic, intKey);
        }
        if (serializerClass == ShortSerializer.class) {
            Short shortKey = Short.parseShort(keyString);
            return this.serializer.serializeKey(this.topic, shortKey);
        }
        return this.serializer.serializeKey(this.topic, keyString);
    }

    protected abstract T readFrom(String var1, ParsedSchema var2);

    public void close() {
        if (this.serializer != null) {
            try {
                this.serializer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while closing serializer", e);
            }
        }
    }
}

