/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.formatter.SchemaMessageReader;
import io.confluent.kafka.formatter.SchemaMessageSerializer;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import kafka.common.MessageReader;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;
import org.everit.json.schema.ValidationException;

public class JsonSchemaMessageReader
extends SchemaMessageReader<JsonNode>
implements MessageReader {
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();

    public JsonSchemaMessageReader() {
    }

    JsonSchemaMessageReader(SchemaRegistryClient schemaRegistryClient, JsonSchema keySchema, JsonSchema valueSchema, String topic, boolean parseKey, BufferedReader reader, boolean normalizeSchema, boolean autoRegister, boolean useLatest) {
        super(schemaRegistryClient, (ParsedSchema)keySchema, (ParsedSchema)valueSchema, topic, parseKey, reader, normalizeSchema, autoRegister, useLatest);
    }

    protected SchemaMessageSerializer<JsonNode> createSerializer(SchemaRegistryClient schemaRegistryClient, boolean normalizeSchema, boolean autoRegister, boolean useLatest, Serializer keySerializer) {
        return new JsonSchemaMessageSerializer(schemaRegistryClient, normalizeSchema, autoRegister, useLatest, keySerializer);
    }

    protected SchemaProvider getProvider() {
        return new JsonSchemaProvider();
    }

    protected JsonNode readFrom(String jsonString, ParsedSchema schema) {
        try {
            return objectMapper.readTree(jsonString);
        }
        catch (IOException | ValidationException e) {
            throw new SerializationException(String.format("Error serializing json %s", jsonString), e);
        }
    }

    static class JsonSchemaMessageSerializer
    extends AbstractKafkaJsonSchemaSerializer<JsonNode>
    implements SchemaMessageSerializer<JsonNode> {
        protected final Serializer keySerializer;

        JsonSchemaMessageSerializer(SchemaRegistryClient schemaRegistryClient, boolean normalizeSchema, boolean autoRegister, boolean useLatest, Serializer keySerializer) {
            this.schemaRegistry = schemaRegistryClient;
            this.normalizeSchema = normalizeSchema;
            this.autoRegisterSchema = autoRegister;
            this.useLatestVersion = useLatest;
            this.keySerializer = keySerializer;
            this.validate = true;
        }

        public Serializer getKeySerializer() {
            return this.keySerializer;
        }

        public byte[] serializeKey(String topic, Object payload) {
            return this.keySerializer.serialize(topic, payload);
        }

        public byte[] serialize(String subject, String topic, boolean isKey, JsonNode object, ParsedSchema schema) {
            return super.serializeImpl(subject, object, (JsonSchema)schema);
        }

        public void close() throws IOException {
            if (this.keySerializer != null) {
                this.keySerializer.close();
            }
            super.close();
        }
    }
}

