/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import kafka.tools.TerseFailure;
import kafka.utils.Exit$;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class FeatureCommand$ {
    public static final FeatureCommand$ MODULE$ = new FeatureCommand$();

    public void main(String[] args) {
        int res = this.mainNoExit(args, System.out);
        throw Exit$.MODULE$.exit(res, (Option<String>)None$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int mainNoExit(String[] args, PrintStream out) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-features").defaultHelp(true).description("This tool manages feature flags in Kafka.");
        parser.addArgument(new String[]{"--bootstrap-server"}).help("A comma-separated list of host:port pairs to use for establishing the connection to the Kafka cluster.").required(true);
        parser.addArgument(new String[]{"--command-config"}).type((ArgumentType)Arguments.fileType()).help("Property file containing configs to be passed to Admin Client.");
        Subparsers subparsers = parser.addSubparsers().dest("command");
        this.addDescribeParser(subparsers);
        this.addUpgradeParser(subparsers);
        this.addDowngradeParser(subparsers);
        this.addDisableParser(subparsers);
        try {
            Properties properties;
            Namespace namespace = parser.parseArgs(args);
            String command = namespace.getString("command");
            File commandConfig = (File)namespace.get("command_config");
            if (commandConfig != null) {
                if (!commandConfig.exists()) {
                    throw new TerseFailure(new StringBuilder(33).append("Properties file ").append(commandConfig.getPath()).append(" does not exists!").toString());
                }
                properties = Utils.loadProps((String)commandConfig.getPath(), null);
            } else {
                properties = new Properties();
            }
            Properties props = properties;
            props.put("bootstrap.servers", namespace.getString("bootstrap_server"));
            try (Admin admin = Admin.create((Properties)props);){
                switch (command == null ? 0 : command.hashCode()) {
                    case -231171556: {
                        if (!"upgrade".equals(command)) throw new MatchError((Object)command);
                        this.handleUpgradeOrDowngrade("upgrade", out, namespace, admin, FeatureUpdate.UpgradeType.UPGRADE);
                        return 0;
                    }
                    case 1018214091: {
                        if (!"describe".equals(command)) throw new MatchError((Object)command);
                        this.handleDescribe(out, admin);
                        return 0;
                    }
                    case 1308176501: {
                        if (!"downgrade".equals(command)) throw new MatchError((Object)command);
                        this.handleDowngrade(out, namespace, admin);
                        return 0;
                    }
                    case 1671308008: {
                        if (!"disable".equals(command)) throw new MatchError((Object)command);
                        this.handleDisable(out, namespace, admin);
                        return 0;
                    }
                    default: {
                        throw new MatchError((Object)command);
                    }
                }
            }
        }
        catch (HelpScreenException helpScreenException) {
            return 0;
        }
        catch (ArgumentParserException e) {
            System.err.println(new StringBuilder(43).append("Command line error: ").append(e.getMessage()).append(". Type --help for help.").toString());
            return 1;
        }
        catch (TerseFailure e) {
            System.err.println(e.getMessage());
            return 1;
        }
    }

    public void addDescribeParser(Subparsers subparsers) {
        subparsers.addParser("describe").help("Describes the current active feature flags.");
    }

    public void addUpgradeParser(Subparsers subparsers) {
        Subparser upgradeParser = subparsers.addParser("upgrade").help("Upgrade one or more feature flags.");
        upgradeParser.addArgument(new String[]{"--metadata"}).help("The level to which we should upgrade the metadata. For example, 3.3-IV3.").action((ArgumentAction)Arguments.store());
        upgradeParser.addArgument(new String[]{"--feature"}).help("A feature upgrade we should perform, in feature=level format. For example: `metadata.version=5`.").action((ArgumentAction)Arguments.append());
        upgradeParser.addArgument(new String[]{"--dry-run"}).help("Validate this upgrade, but do not perform it.").action((ArgumentAction)Arguments.storeTrue());
    }

    public void addDowngradeParser(Subparsers subparsers) {
        Subparser downgradeParser = subparsers.addParser("downgrade").help("Downgrade one or more feature flags.");
        downgradeParser.addArgument(new String[]{"--metadata"}).help("The level to which we should downgrade the metadata. For example, 3.3-IV0.").action((ArgumentAction)Arguments.store());
        downgradeParser.addArgument(new String[]{"--feature"}).help("A feature downgrade we should perform, in feature=level format. For example: `metadata.version=5`.").action((ArgumentAction)Arguments.append());
        downgradeParser.addArgument(new String[]{"--unsafe"}).help("Perform this downgrade even if it may irreversibly destroy metadata.").action((ArgumentAction)Arguments.storeTrue());
        downgradeParser.addArgument(new String[]{"--dry-run"}).help("Validate this downgrade, but do not perform it.").action((ArgumentAction)Arguments.storeTrue());
    }

    public void addDisableParser(Subparsers subparsers) {
        Subparser disableParser = subparsers.addParser("disable").help("Disable one or more feature flags. This is the same as downgrading the version to zero.");
        disableParser.addArgument(new String[]{"--feature"}).help("A feature flag to disable.").action((ArgumentAction)Arguments.append());
        disableParser.addArgument(new String[]{"--unsafe"}).help("Disable this feature flag even if it may irreversibly destroy metadata.").action((ArgumentAction)Arguments.storeTrue());
        disableParser.addArgument(new String[]{"--dry-run"}).help("Perform a dry-run of this disable operation.").action((ArgumentAction)Arguments.storeTrue());
    }

    public String levelToString(String feature, short level) {
        if (feature.equals("metadata.version")) {
            try {
                return MetadataVersion.fromFeatureLevel((short)level).version();
            }
            catch (Throwable throwable) {
                return new StringBuilder(10).append("UNKNOWN [").append(level).append("]").toString();
            }
        }
        return Short.toString(level);
    }

    public void handleDescribe(PrintStream out, Admin admin) {
        FeatureMetadata featureMetadata = (FeatureMetadata)admin.describeFeatures().featureMetadata().get();
        new TreeSet(featureMetadata.supportedFeatures().keySet()).forEach(x0$1 -> {
            short s;
            Option option = CollectionConverters$.MODULE$.MapHasAsScala(featureMetadata.finalizedFeatures()).asScala().get(x0$1);
            if (None$.MODULE$.equals(option)) {
                s = (short)0;
            } else if (option instanceof Some) {
                s = ((FinalizedVersionRange)((Some)option).value()).maxVersionLevel();
            } else {
                throw new MatchError((Object)option);
            }
            short finalizedLevel = s;
            SupportedVersionRange range = (SupportedVersionRange)featureMetadata.supportedFeatures().get(x0$1);
            out.printf("Feature: %s\tSupportedMinVersion: %s\tSupportedMaxVersion: %s\tFinalizedVersionLevel: %s\tEpoch: %s%n", x0$1, MODULE$.levelToString((String)x0$1, range.minVersion()), MODULE$.levelToString((String)x0$1, range.maxVersion()), MODULE$.levelToString((String)x0$1, finalizedLevel), OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(featureMetadata.finalizedFeaturesEpoch())).flatMap((Function1 & Serializable)e -> new Some((Object)e.toString())).getOrElse((Function0 & Serializable)() -> "-"));
        });
    }

    public String metadataVersionsToString(MetadataVersion first, MetadataVersion last) {
        return CollectionConverters$.MODULE$.ListHasAsScala(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])MetadataVersion.VERSIONS).toList()).asJava().subList(first.ordinal(), last.ordinal() + 1)).asScala().mkString(", ");
    }

    public void handleUpgrade(PrintStream out, Namespace namespace, Admin admin) {
        this.handleUpgradeOrDowngrade("upgrade", out, namespace, admin, FeatureUpdate.UpgradeType.UPGRADE);
    }

    public FeatureUpdate.UpgradeType downgradeType(Namespace namespace) {
        Boolean unsafe = namespace.getBoolean("unsafe");
        if (unsafe == null || !Predef$.MODULE$.Boolean2boolean(unsafe)) {
            return FeatureUpdate.UpgradeType.SAFE_DOWNGRADE;
        }
        return FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE;
    }

    public void handleDowngrade(PrintStream out, Namespace namespace, Admin admin) {
        this.handleUpgradeOrDowngrade("downgrade", out, namespace, admin, this.downgradeType(namespace));
    }

    public Tuple2<String, Object> parseNameAndLevel(String input) {
        short s;
        int equalsIndex = input.indexOf("=");
        if (equalsIndex < 0) {
            throw new TerseFailure(new StringBuilder(57).append("Can't parse feature=level string ").append(input).append(": equals sign not found.").toString());
        }
        String name = input.substring(0, equalsIndex).trim();
        String levelString = input.substring(equalsIndex + 1).trim();
        try {
            s = StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(levelString));
        }
        catch (Throwable throwable) {
            throw new TerseFailure(new StringBuilder(63).append("Can't parse feature=level string ").append(input).append(": ").append("unable to parse ").append(levelString).append(" as a short.").toString());
        }
        short level = s;
        return new Tuple2((Object)name, (Object)BoxesRunTime.boxToShort((short)level));
    }

    public void handleUpgradeOrDowngrade(String op, PrintStream out, Namespace namespace, Admin admin, FeatureUpdate.UpgradeType upgradeType) {
        HashMap<String, FeatureUpdate> updates = new HashMap<String, FeatureUpdate>();
        Option$.MODULE$.apply((Object)namespace.getString("metadata")).foreach((Function1 & Serializable)metadata -> {
            MetadataVersion metadataVersion;
            try {
                metadataVersion = MetadataVersion.fromVersionString((String)metadata);
            }
            catch (Throwable throwable) {
                throw new TerseFailure(new StringBuilder(63).append("Unsupported metadata version ").append((String)metadata).append(". Supported metadata versions are ").append(MODULE$.metadataVersionsToString(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION, MetadataVersion.latest())).toString());
            }
            MetadataVersion version = metadataVersion;
            return updates.put("metadata.version", new FeatureUpdate(version.featureLevel(), upgradeType));
        });
        Option$.MODULE$.apply((Object)namespace.getList("feature")).foreach((Function1 & Serializable)features -> {
            features.forEach(feature -> {
                void var4_4;
                Tuple2<String, Object> tuple2 = FeatureCommand$.MODULE$.parseNameAndLevel((String)feature);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                String name = (String)tuple2._1();
                short s = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (updates$1.put(var4_4, new FeatureUpdate(s, upgradeType$1)) != null) {
                    throw new TerseFailure(new StringBuilder(38).append("Feature ").append((String)var4_4).append(" was specified more than once.").toString());
                }
            });
            return BoxedUnit.UNIT;
        });
        this.update(op, out, admin, updates, Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("dry-run")));
    }

    public void handleDisable(PrintStream out, Namespace namespace, Admin admin) {
        FeatureUpdate.UpgradeType upgradeType = this.downgradeType(namespace);
        HashMap<String, FeatureUpdate> updates = new HashMap<String, FeatureUpdate>();
        Option$.MODULE$.apply((Object)namespace.getList("feature")).foreach((Function1 & Serializable)features -> {
            features.forEach(name -> {
                if (updates$2.put(name, new FeatureUpdate((short)0, upgradeType$2)) != null) {
                    throw new TerseFailure(new StringBuilder(38).append("Feature ").append((String)name).append(" was specified more than once.").toString());
                }
            });
            return BoxedUnit.UNIT;
        });
        this.update("disable", out, admin, updates, Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("dry-run")));
    }

    public void update(String op, PrintStream out, Admin admin, HashMap<String, FeatureUpdate> updates, boolean dryRun) {
        if (updates.isEmpty()) {
            throw new TerseFailure(new StringBuilder(41).append("You must specify at least one feature to ").append(op).toString());
        }
        UpdateFeaturesResult result = admin.updateFeatures(updates, new UpdateFeaturesOptions().validateOnly(dryRun));
        Map errors = (Map)CollectionConverters$.MODULE$.MapHasAsScala(result.values()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String feature = (String)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)feature), (Object)None$.MODULE$);
                }
                catch (ExecutionException e) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)feature), (Object)new Some((Object)e.getCause()));
                }
                catch (Throwable t) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)feature), (Object)new Some((Object)t));
                }
            }
            throw new MatchError(null);
        });
        IntRef numFailures = IntRef.create((int)0);
        ((List)errors.keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)feature -> {
            FeatureCommand$.$anonfun$update$2(errors, updates, dryRun, op, out, numFailures, feature);
            return BoxedUnit.UNIT;
        });
        if (numFailures.elem > 0) {
            throw new TerseFailure(new StringBuilder(29).append(numFailures.elem).append(" out of ").append(updates.size()).append(" operation(s) failed.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$update$2(Map errors$1, HashMap updates$3, boolean dryRun$1, String op$1, PrintStream out$2, IntRef numFailures$1, String feature) {
        Option maybeThrowable = (Option)errors$1.apply((Object)feature);
        short level = ((FeatureUpdate)updates$3.get(feature)).maxVersionLevel();
        if (maybeThrowable.isDefined()) {
            String helper = dryRun$1 ? "Can not" : "Could not";
            String suffix = op$1.equals("disable") ? new StringBuilder(8).append("disable ").append(feature).toString() : new StringBuilder(5).append(op$1).append(" ").append(feature).append(" to ").append(level).toString();
            out$2.println(new StringBuilder(3).append(helper).append(" ").append(suffix).append(". ").append(((Throwable)maybeThrowable.get()).getMessage()).toString());
            ++numFailures$1.elem;
            return;
        }
        String verb = dryRun$1 ? "can be" : "was";
        String obj = op$1.equals("disable") ? "disabled." : new StringBuilder(6).append(op$1).append("d to ").append(level).append(".").toString();
        out$2.println(new StringBuilder(2).append(feature).append(" ").append(verb).append(" ").append(obj).toString());
    }

    private FeatureCommand$() {
    }
}

