/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaVersionFetcher;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface SchemaRegistryClient
extends Closeable,
SchemaVersionFetcher {
    public Optional<ParsedSchema> parseSchema(String var1, String var2, List<SchemaReference> var3);

    default public Optional<ParsedSchema> parseSchema(Schema schema) {
        return this.parseSchema(schema.getSchemaType(), schema.getSchema(), schema.getReferences());
    }

    @Deprecated
    default public int register(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        return this.register(subject, new AvroSchema(schema));
    }

    public int register(String var1, ParsedSchema var2) throws IOException, RestClientException;

    default public int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public int register(String subject, org.apache.avro.Schema schema, int version, int id) throws IOException, RestClientException {
        return this.register(subject, new AvroSchema(schema), version, id);
    }

    public int register(String var1, ParsedSchema var2, int var3, int var4) throws IOException, RestClientException;

    @Deprecated
    default public org.apache.avro.Schema getByID(int id) throws IOException, RestClientException {
        return this.getById(id);
    }

    @Deprecated
    default public org.apache.avro.Schema getById(int id) throws IOException, RestClientException {
        ParsedSchema schema = this.getSchemaById(id);
        return schema instanceof AvroSchema ? ((AvroSchema)schema).rawSchema() : null;
    }

    public ParsedSchema getSchemaById(int var1) throws IOException, RestClientException;

    @Deprecated
    default public org.apache.avro.Schema getBySubjectAndID(String subject, int id) throws IOException, RestClientException {
        return this.getBySubjectAndId(subject, id);
    }

    @Deprecated
    default public org.apache.avro.Schema getBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        ParsedSchema schema = this.getSchemaBySubjectAndId(subject, id);
        return schema instanceof AvroSchema ? ((AvroSchema)schema).rawSchema() : null;
    }

    public ParsedSchema getSchemaBySubjectAndId(String var1, int var2) throws IOException, RestClientException;

    default public List<ParsedSchema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getAllSubjectsById(int var1) throws IOException, RestClientException;

    default public Collection<SubjectVersion> getAllVersionsById(int id) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        throw new UnsupportedOperationException();
    }

    public SchemaMetadata getLatestSchemaMetadata(String var1) throws IOException, RestClientException;

    public SchemaMetadata getSchemaMetadata(String var1, int var2) throws IOException, RestClientException;

    default public SchemaMetadata getSchemaMetadata(String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public int getVersion(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        return this.getVersion(subject, new AvroSchema(schema));
    }

    public int getVersion(String var1, ParsedSchema var2) throws IOException, RestClientException;

    default public int getVersion(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public List<Integer> getAllVersions(String var1) throws IOException, RestClientException;

    default public List<Integer> getAllVersions(String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public boolean testCompatibility(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        return this.testCompatibility(subject, new AvroSchema(schema));
    }

    public boolean testCompatibility(String var1, ParsedSchema var2) throws IOException, RestClientException;

    default public List<String> testCompatibilityVerbose(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.testCompatibilityVerbose(subject, schema, false);
    }

    default public List<String> testCompatibilityVerbose(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public String updateCompatibility(String var1, String var2) throws IOException, RestClientException;

    public String getCompatibility(String var1) throws IOException, RestClientException;

    default public void deleteCompatibility(String subject) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public String setMode(String var1) throws IOException, RestClientException;

    public String setMode(String var1, String var2) throws IOException, RestClientException;

    default public String setMode(String mode, String subject, boolean force) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public String getMode() throws IOException, RestClientException;

    public String getMode(String var1) throws IOException, RestClientException;

    default public void deleteMode(String subject) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getAllSubjects() throws IOException, RestClientException;

    default public Collection<String> getAllSubjects(boolean lookupDeletedSubject) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    default public Collection<String> getAllSubjectsByPrefix(String subjectPrefix) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public int getId(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        return this.getId(subject, new AvroSchema(schema));
    }

    public int getId(String var1, ParsedSchema var2) throws IOException, RestClientException;

    default public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    default public List<Integer> deleteSubject(String subject) throws IOException, RestClientException {
        return this.deleteSubject(subject, false);
    }

    default public List<Integer> deleteSubject(String subject, boolean isPermanent) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    default public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        return this.deleteSubject(requestProperties, subject, false);
    }

    default public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    default public Integer deleteSchemaVersion(String subject, String version) throws IOException, RestClientException {
        return this.deleteSchemaVersion(subject, version, false);
    }

    default public Integer deleteSchemaVersion(String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    default public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version) throws IOException, RestClientException {
        return this.deleteSchemaVersion(requestProperties, subject, version, false);
    }

    default public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public void reset();

    @Override
    default public void close() throws IOException {
    }
}

