/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import io.confluent.kafka.schemaregistry.AbstractSchemaProvider;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(ProtobufSchemaProvider.class);

    public String schemaType() {
        return "PROTOBUF";
    }

    public ParsedSchema parseSchemaOrElseThrow(Schema schema, boolean isNew, boolean normalize) {
        try {
            return new ProtobufSchema(schema.getSchema(), schema.getReferences(), this.resolveReferences(schema), null, null);
        }
        catch (Exception e) {
            log.error("Could not parse Protobuf schema", (Throwable)e);
            throw e;
        }
    }
}

