/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.config;

import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.config.SchemaRegistryConfig;
import io.confluent.kafkarest.ratelimit.RateLimitBackend;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Qualifier;
import org.glassfish.hk2.api.AnnotationLiteral;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public final class ConfigModule
extends AbstractBinder {
    private final KafkaRestConfig config;
    private final SchemaRegistryConfig schemaRegistryConfig;

    public ConfigModule(KafkaRestConfig config) {
        this.config = config;
        this.schemaRegistryConfig = new SchemaRegistryConfig(config.getSchemaRegistryConfigs());
    }

    protected void configure() {
        this.bind((Object)this.config).to(KafkaRestConfig.class);
        this.bind(this.config.getList("advertised.listeners").stream().map(URI::create).collect(Collectors.toList())).qualifiedBy((Annotation)new AdvertisedListenersConfigImpl()).to((TypeLiteral)new TypeLiteral<List<URI>>(){});
        this.bind(new HashSet(this.config.getList("api.endpoints.allowlist"))).qualifiedBy((Annotation)new ApiEndpointsAllowlistConfigImpl()).to((TypeLiteral)new TypeLiteral<Set<String>>(){});
        this.bind(new HashSet(this.config.getList("api.endpoints.blocklist"))).qualifiedBy((Annotation)new ApiEndpointsBlocklistConfigImpl()).to((TypeLiteral)new TypeLiteral<Set<String>>(){});
        this.bind(this.config.getAvroSerializerConfigs()).qualifiedBy((Annotation)new AvroSerializerConfigsImpl()).to((TypeLiteral)new TypeLiteral<Map<String, Object>>(){});
        this.bind(this.config.getString("confluent.resource.name.authority")).qualifiedBy((Annotation)new CrnAuthorityConfigImpl()).to(String.class);
        this.bind(this.config.getString("host.name")).qualifiedBy((Annotation)new HostNameConfigImpl()).to(String.class);
        this.bind(this.config.getJsonSerializerConfigs()).qualifiedBy((Annotation)new JsonSerializerConfigsImpl()).to((TypeLiteral)new TypeLiteral<Map<String, Object>>(){});
        this.bind(this.config.getJsonschemaSerializerConfigs()).qualifiedBy((Annotation)new JsonschemaSerializerConfigsImpl()).to((TypeLiteral)new TypeLiteral<Map<String, Object>>(){});
        this.bind(this.config.getList("listeners").stream().map(URI::create).collect(Collectors.toList())).qualifiedBy((Annotation)new ListenersConfigImpl()).to((TypeLiteral)new TypeLiteral<List<URI>>(){});
        this.bind(this.schemaRegistryConfig.getMaxSchemasPerSubject()).qualifiedBy((Annotation)new MaxSchemasPerSubjectConfigImpl()).to(Integer.class);
        this.bind(this.config.getInt("port")).qualifiedBy((Annotation)new PortConfigImpl()).to(Integer.class);
        this.bind(this.config.getInt("api.v3.produce.rate.limit.max.bytes.per.sec")).qualifiedBy((Annotation)new ProduceRateLimitBytesConfigImpl()).to(Integer.class);
        this.bind(this.config.getInt("api.v3.produce.rate.limit.max.requests.per.sec")).qualifiedBy((Annotation)new ProduceRateLimitCountConfigImpl()).to(Integer.class);
        this.bind(this.config.getInt("api.v3.produce.rate.limit.max.requests.global.per.sec")).qualifiedBy((Annotation)new ProduceRateLimitCountGlobalConfigImpl()).to(Integer.class);
        this.bind(this.config.getInt("api.v3.produce.rate.limit.max.bytes.global.per.sec")).qualifiedBy((Annotation)new ProduceRateLimitBytesGlobalConfigImpl()).to(Integer.class);
        this.bind(Duration.ofMillis(this.config.getInt("api.v3.produce.rate.limit.cache.expiry.ms").intValue())).qualifiedBy((Annotation)new ProduceRateLimitCacheExpiryConfigImpl()).to(Duration.class);
        this.bind(this.config.getBoolean("api.v3.produce.rate.limit.enabled")).qualifiedBy((Annotation)new ProduceRateLimitEnabledConfigImpl()).to(Boolean.class);
        this.bind(this.config.getInt("api.v3.produce.response.thread.pool.size")).qualifiedBy((Annotation)new ProduceResponseThreadPoolSizeImpl()).to(Integer.class);
        this.bind(this.config.getProducerConfigs()).qualifiedBy((Annotation)new ProducerConfigsImpl()).to((TypeLiteral)new TypeLiteral<Map<String, Object>>(){});
        this.bind(this.config.getProtobufSerializerConfigs()).qualifiedBy((Annotation)new ProtobufSerializerConfigsImpl()).to((TypeLiteral)new TypeLiteral<Map<String, Object>>(){});
        this.bind((Object)this.config.getRateLimitBackend()).to(RateLimitBackend.class);
        this.bind(this.config.getRateLimitCosts()).qualifiedBy((Annotation)new RateLimitCostsConfigImpl()).to((TypeLiteral)new TypeLiteral<Map<String, Integer>>(){});
        this.bind(this.config.getRateLimitDefaultCost()).qualifiedBy((Annotation)new RateLimitDefaultCostConfigImpl()).to(Integer.class);
        this.bind(this.config.isRateLimitEnabled()).qualifiedBy((Annotation)new RateLimitEnabledConfigImpl()).to(Boolean.class);
        this.bind(this.config.getRateLimitPermitsPerSec()).qualifiedBy((Annotation)new RateLimitPermitsPerSecConfigImpl()).to(Integer.class);
        this.bind(this.config.getRateLimitTimeout()).qualifiedBy((Annotation)new RateLimitTimeoutConfigImpl()).to(Duration.class);
        this.bind(this.config.getStreamingConnectionMaxDuration()).qualifiedBy((Annotation)new StreamingConnectionMaxDurationConfigImpl()).to(Duration.class);
        this.bind(this.config.getStreamingConnectionMaxDurationGracePeriod()).qualifiedBy((Annotation)new StreamingConnectionMaxDurationGracePeriodImpl()).to(Duration.class);
        this.bind(this.config.getSchemaRegistryConfigs()).qualifiedBy((Annotation)new SchemaRegistryConfigsImpl()).to((TypeLiteral)new TypeLiteral<Map<String, Object>>(){});
        this.bind(this.schemaRegistryConfig.requestHeaders()).qualifiedBy((Annotation)new SchemaRegistryRequestHeadersConfigImpl()).to((TypeLiteral)new TypeLiteral<Map<String, String>>(){});
        this.bind(this.schemaRegistryConfig.getSchemaRegistryUrls().stream().map(URI::create).collect(Collectors.toList())).qualifiedBy((Annotation)new SchemaRegistryUrlsConfigImpl()).to((TypeLiteral)new TypeLiteral<List<URI>>(){});
        this.bind(this.schemaRegistryConfig.getSubjectNameStrategy()).to(SubjectNameStrategy.class);
    }

    private static final class StreamingConnectionMaxDurationGracePeriodImpl
    extends AnnotationLiteral<StreamingMaxConnectionGracePeriod>
    implements StreamingMaxConnectionGracePeriod {
        private StreamingConnectionMaxDurationGracePeriodImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface StreamingMaxConnectionGracePeriod {
    }

    private static final class StreamingConnectionMaxDurationConfigImpl
    extends AnnotationLiteral<StreamingMaxConnectionDurationConfig>
    implements StreamingMaxConnectionDurationConfig {
        private StreamingConnectionMaxDurationConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface StreamingMaxConnectionDurationConfig {
    }

    private static final class SchemaRegistryUrlsConfigImpl
    extends AnnotationLiteral<SchemaRegistryUrlsConfig>
    implements SchemaRegistryUrlsConfig {
        private SchemaRegistryUrlsConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface SchemaRegistryUrlsConfig {
    }

    private static final class SchemaRegistryRequestHeadersConfigImpl
    extends AnnotationLiteral<SchemaRegistryRequestHeadersConfig>
    implements SchemaRegistryRequestHeadersConfig {
        private SchemaRegistryRequestHeadersConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface SchemaRegistryRequestHeadersConfig {
    }

    private static final class SchemaRegistryConfigsImpl
    extends AnnotationLiteral<SchemaRegistryConfigs>
    implements SchemaRegistryConfigs {
        private SchemaRegistryConfigsImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface SchemaRegistryConfigs {
    }

    private static final class RateLimitTimeoutConfigImpl
    extends AnnotationLiteral<RateLimitTimeoutConfig>
    implements RateLimitTimeoutConfig {
        private RateLimitTimeoutConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface RateLimitTimeoutConfig {
    }

    private static final class RateLimitPermitsPerSecConfigImpl
    extends AnnotationLiteral<RateLimitPermitsPerSecConfig>
    implements RateLimitPermitsPerSecConfig {
        private RateLimitPermitsPerSecConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface RateLimitPermitsPerSecConfig {
    }

    private static final class RateLimitEnabledConfigImpl
    extends AnnotationLiteral<RateLimitEnabledConfig>
    implements RateLimitEnabledConfig {
        private RateLimitEnabledConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface RateLimitEnabledConfig {
    }

    private static final class RateLimitDefaultCostConfigImpl
    extends AnnotationLiteral<RateLimitDefaultCostConfig>
    implements RateLimitDefaultCostConfig {
        private RateLimitDefaultCostConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface RateLimitDefaultCostConfig {
    }

    private static final class RateLimitCostsConfigImpl
    extends AnnotationLiteral<RateLimitCostsConfig>
    implements RateLimitCostsConfig {
        private RateLimitCostsConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface RateLimitCostsConfig {
    }

    private static final class ProtobufSerializerConfigsImpl
    extends AnnotationLiteral<ProtobufSerializerConfigs>
    implements ProtobufSerializerConfigs {
        private ProtobufSerializerConfigsImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ProtobufSerializerConfigs {
    }

    private static final class ProducerConfigsImpl
    extends AnnotationLiteral<ProducerConfigs>
    implements ProducerConfigs {
        private ProducerConfigsImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ProducerConfigs {
    }

    private static final class ProduceResponseThreadPoolSizeImpl
    extends AnnotationLiteral<ProduceResponseThreadPoolSizeConfig>
    implements ProduceResponseThreadPoolSizeConfig {
        private ProduceResponseThreadPoolSizeImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ProduceResponseThreadPoolSizeConfig {
    }

    private static final class ProduceRateLimitEnabledConfigImpl
    extends AnnotationLiteral<ProduceRateLimitEnabledConfig>
    implements ProduceRateLimitEnabledConfig {
        private ProduceRateLimitEnabledConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ProduceRateLimitEnabledConfig {
    }

    private static final class ProduceRateLimitCountGlobalConfigImpl
    extends AnnotationLiteral<ProduceRateLimitCountGlobalConfig>
    implements ProduceRateLimitCountGlobalConfig {
        private ProduceRateLimitCountGlobalConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ProduceRateLimitCountGlobalConfig {
    }

    private static final class ProduceRateLimitBytesGlobalConfigImpl
    extends AnnotationLiteral<ProduceRateLimitBytesGlobalConfig>
    implements ProduceRateLimitBytesGlobalConfig {
        private ProduceRateLimitBytesGlobalConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ProduceRateLimitBytesGlobalConfig {
    }

    private static final class ProduceRateLimitBytesConfigImpl
    extends AnnotationLiteral<ProduceRateLimitBytesConfig>
    implements ProduceRateLimitBytesConfig {
        private ProduceRateLimitBytesConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ProduceRateLimitBytesConfig {
    }

    private static final class ProduceRateLimitCountConfigImpl
    extends AnnotationLiteral<ProduceRateLimitCountConfig>
    implements ProduceRateLimitCountConfig {
        private ProduceRateLimitCountConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ProduceRateLimitCountConfig {
    }

    private static final class ProduceRateLimitCacheExpiryConfigImpl
    extends AnnotationLiteral<ProduceRateLimitCacheExpiryConfig>
    implements ProduceRateLimitCacheExpiryConfig {
        private ProduceRateLimitCacheExpiryConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ProduceRateLimitCacheExpiryConfig {
    }

    private static final class PortConfigImpl
    extends AnnotationLiteral<PortConfig>
    implements PortConfig {
        private PortConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    @Deprecated
    public static @interface PortConfig {
    }

    private static final class MaxSchemasPerSubjectConfigImpl
    extends AnnotationLiteral<MaxSchemasPerSubjectConfig>
    implements MaxSchemasPerSubjectConfig {
        private MaxSchemasPerSubjectConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface MaxSchemasPerSubjectConfig {
    }

    private static final class ListenersConfigImpl
    extends AnnotationLiteral<ListenersConfig>
    implements ListenersConfig {
        private ListenersConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ListenersConfig {
    }

    private static final class JsonschemaSerializerConfigsImpl
    extends AnnotationLiteral<JsonschemaSerializerConfigs>
    implements JsonschemaSerializerConfigs {
        private JsonschemaSerializerConfigsImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface JsonschemaSerializerConfigs {
    }

    private static final class JsonSerializerConfigsImpl
    extends AnnotationLiteral<JsonSerializerConfigs>
    implements JsonSerializerConfigs {
        private JsonSerializerConfigsImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface JsonSerializerConfigs {
    }

    private static final class HostNameConfigImpl
    extends AnnotationLiteral<HostNameConfig>
    implements HostNameConfig {
        private HostNameConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    @Deprecated
    public static @interface HostNameConfig {
    }

    private static final class CrnAuthorityConfigImpl
    extends AnnotationLiteral<CrnAuthorityConfig>
    implements CrnAuthorityConfig {
        private CrnAuthorityConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface CrnAuthorityConfig {
    }

    private static final class AvroSerializerConfigsImpl
    extends AnnotationLiteral<AvroSerializerConfigs>
    implements AvroSerializerConfigs {
        private AvroSerializerConfigsImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface AvroSerializerConfigs {
    }

    private static final class ApiEndpointsBlocklistConfigImpl
    extends AnnotationLiteral<ApiEndpointsBlocklistConfig>
    implements ApiEndpointsBlocklistConfig {
        private ApiEndpointsBlocklistConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ApiEndpointsBlocklistConfig {
    }

    private static final class ApiEndpointsAllowlistConfigImpl
    extends AnnotationLiteral<ApiEndpointsAllowlistConfig>
    implements ApiEndpointsAllowlistConfig {
        private ApiEndpointsAllowlistConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ApiEndpointsAllowlistConfig {
    }

    private static final class AdvertisedListenersConfigImpl
    extends AnnotationLiteral<AdvertisedListenersConfig>
    implements AdvertisedListenersConfig {
        private AdvertisedListenersConfigImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface AdvertisedListenersConfig {
    }
}

