/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import java.net.URL;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.secured.ConfigurationUtils;

public class CustomBearerAuthCredentialProvider
implements BearerAuthCredentialProvider {
    BearerAuthCredentialProvider customBearerAuthCredentialProvider;
    private String targetSchemaRegistry;
    private String targetIdentityPoolId;

    @Override
    public String alias() {
        return "CUSTOM";
    }

    @Override
    public String getBearerToken(URL url) {
        return this.customBearerAuthCredentialProvider.getBearerToken(url);
    }

    @Override
    public String getTargetSchemaRegistry() {
        return this.customBearerAuthCredentialProvider.getTargetSchemaRegistry() != null ? this.customBearerAuthCredentialProvider.getTargetSchemaRegistry() : this.targetSchemaRegistry;
    }

    @Override
    public String getTargetIdentityPoolId() {
        return this.customBearerAuthCredentialProvider.getTargetIdentityPoolId() != null ? this.customBearerAuthCredentialProvider.getTargetIdentityPoolId() : this.targetIdentityPoolId;
    }

    public void configure(Map<String, ?> map) {
        ConfigurationUtils cu = new ConfigurationUtils(map);
        String className = cu.validateString("bearer.auth.custom.provider.class");
        try {
            this.customBearerAuthCredentialProvider = (BearerAuthCredentialProvider)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ConfigException(String.format("Unable to instantiate an object of class %s, failed with exception: ", "bearer.auth.custom.provider.class") + e.getMessage());
        }
        this.targetSchemaRegistry = cu.validateString("bearer.auth.logical.cluster", false);
        this.targetIdentityPoolId = cu.validateString("bearer.auth.identity.pool.id", false);
        this.customBearerAuthCredentialProvider.configure(map);
    }
}

