/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.TxnMetadata;
import kafka.log.UnifiedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rMw!\u00027n\u0011\u0003\u0011h!\u0002;n\u0011\u0003)\b\"\u0002?\u0002\t\u0003i\bb\u0002@\u0002\u0005\u0004%\ta \u0005\t\u0003\u000f\t\u0001\u0015!\u0003\u0002\u0002!I\u0011\u0011B\u0001C\u0002\u0013%\u00111\u0002\u0005\t\u0003'\t\u0001\u0015!\u0003\u0002\u000e!I\u0011QC\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003S\t\u0001\u0015!\u0003\u0002\u001a!I\u00111F\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003[\t\u0001\u0015!\u0003\u0002\u001a!I\u0011qF\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003c\t\u0001\u0015!\u0003\u0002\u001a!I\u00111G\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003k\t\u0001\u0015!\u0003\u0002\u001a!I\u0011qG\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003s\t\u0001\u0015!\u0003\u0002\u001a!I\u00111H\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003{\t\u0001\u0015!\u0003\u0002\u001a!I\u0011qH\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003\u0003\n\u0001\u0015!\u0003\u0002\u001a!I\u00111I\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003\u000b\n\u0001\u0015!\u0003\u0002\u001a!I\u0011qI\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003\u0013\n\u0001\u0015!\u0003\u0002\u001a!I\u00111J\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003\u001b\n\u0001\u0015!\u0003\u0002\u001a!I\u0011qJ\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003#\n\u0001\u0015!\u0003\u0002\u001a!A\u00111K\u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002V\u0005\u0001\u000b\u0011BA\u0001\u0011!\t9&\u0001b\u0001\n\u0013y\b\u0002CA-\u0003\u0001\u0006I!!\u0001\t\u0011\u0005m\u0013A1A\u0005\n}D\u0001\"!\u0018\u0002A\u0003%\u0011\u0011\u0001\u0005\n\u0003?\n!\u0019!C\u0001\u0003CB\u0001\"!!\u0002A\u0003%\u00111\r\u0005\n\u0003\u0007\u000b!\u0019!C\u0001\u0003CB\u0001\"!\"\u0002A\u0003%\u00111\r\u0005\b\u0003\u000f\u000bA\u0011AAE\u0011\u001d\tI,\u0001C\u0005\u0003wCq!a8\u0002\t\u0013\t\t\u000f\u0003\u0005\u0002l\u0006!\t!\\Aw\r\u0015!X\u000eAA\u0000\u0011)\u0011ia\u000bBC\u0002\u0013\u0005!q\u0002\u0005\u000b\u00053Y#\u0011!Q\u0001\n\tE\u0001B\u0003B\u000eW\t\u0005\r\u0011\"\u0001\u0003\u001e!Q!qD\u0016\u0003\u0002\u0004%\tA!\t\t\u0015\t\u001d2F!A!B\u0013\ti\u000bC\u0005\u00032-\u0012)\u0019!C\u0001\u007f\"Q!1G\u0016\u0003\u0002\u0003\u0006I!!\u0001\t\u0013\tU2F!b\u0001\n\u0003y\bB\u0003B\u001cW\t\u0005\t\u0015!\u0003\u0002\u0002!Q!\u0011H\u0016\u0003\u0006\u0004%\tAa\u000f\t\u0015\t\u001d3F!A!\u0002\u0013\u0011i\u0004\u0003\u0004}W\u0011\u0005!\u0011\n\u0005\n\u0005/Z\u0003\u0019!C\u0005\u00053B\u0011Ba\u001c,\u0001\u0004%IA!\u001d\t\u0011\tU4\u0006)Q\u0005\u00057B\u0011Ba\u001e,\u0005\u0004%IA!\u001f\t\u0011\tm4\u0006)A\u0005\u0003\u0013D\u0011B! ,\u0001\u0004%IAa \t\u0013\t\u00055\u00061A\u0005\n\t\r\u0005\u0002\u0003BDW\u0001\u0006K!!7\t\u0013\t%5\u00061A\u0005\n\t}\u0004\"\u0003BFW\u0001\u0007I\u0011\u0002BG\u0011!\u0011\tj\u000bQ!\n\u0005e\u0007\"\u0003BJW\u0001\u0007I\u0011\u0002B@\u0011%\u0011)j\u000ba\u0001\n\u0013\u00119\n\u0003\u0005\u0003\u001c.\u0002\u000b\u0015BAm\u0011%\u0011yj\u000bb\u0001\n\u0013\u0011\t\u000b\u0003\u0005\u00032.\u0002\u000b\u0011\u0002BR\u0011%\u0011\u0019l\u000bb\u0001\n\u0013\u0011\t\u000b\u0003\u0005\u00036.\u0002\u000b\u0011\u0002BR\u0011\u001d\u00119l\u000bC\u0001\u0005sCqAa2,\t\u0013\u0011I\r\u0003\u0005\u0003L.\"\t!\u001cBg\u0011\u001d\u0011)n\u000bC\u0001\u0005/DqAa;,\t\u0003\u0011i\u000f\u0003\u0005\u0003t.\"\t!\u001cB{\u0011\u001d\u0011Ip\u000bC\u0001\u0005\u007fBqAa?,\t\u0003\u0011i\u0010C\u0004\u0004\n-\"\taa\u0003\t\u000f\r51\u0006\"\u0003\u0004\u0010!A1\u0011D\u0016\u0005\u00025\u001cY\u0002C\u0004\u0004\"-\"Iaa\t\t\u000f\r-2\u0006\"\u0001\u0004.!91\u0011G\u0016\u0005\u0002\rM\u0002bBB\u001fW\u0011\u00051q\b\u0005\b\u0007+ZC\u0011AB,\u0011\u001d\u0019if\u000bC\u0005\u0007?Bqa!\u0019,\t\u0003\u0019\u0019\u0007C\u0004\u0004j-\"\taa\u001b\t\u000f\rE4\u0006\"\u0001\u0004`!911O\u0016\u0005\u0002\rU\u0004bBB>W\u0011\u0005!Q\u001f\u0005\b\u0007{ZC\u0011\u0001B{\u0011!\u0019yh\u000bC\u0001[\u000e\u0005\u0005bBBEW\u0011\u000511\u0012\u0005\b\u0007\u001f[C\u0011BBI\u0011\u001d\u0019)j\u000bC\u0001\u0007/Cqaa',\t\u0003\u0019i\nC\u0004\u0004*.\"\taa+\t\u000f\r=6\u0006\"\u0001\u00042\"91qW\u0016\u0005\n\re\u0006bBB^W\u0011%1\u0011\u0018\u0005\b\u0007{[C\u0011BB`\u0011!\u0019)m\u000bC\u0001[\u000e\u001d\u0017\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'O\u0003\u0002o_\u0006\u0019An\\4\u000b\u0003A\fQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002t\u00035\tQN\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\n\u0003\u0003Y\u0004\"a\u001e>\u000e\u0003aT\u0011!_\u0001\u0006g\u000e\fG.Y\u0005\u0003wb\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001s\u0003]a\u0015\r^3Ue\u0006t7/Y2uS>t')\u001e4gKJl5/\u0006\u0002\u0002\u0002A\u0019q/a\u0001\n\u0007\u0005\u0015\u0001PA\u0002J]R\f\u0001\u0004T1uKR\u0013\u0018M\\:bGRLwN\u001c\"vM\u001a,'/T:!\u0003]\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|GOV3sg&|g.\u0006\u0002\u0002\u000eA\u0019q/a\u0004\n\u0007\u0005E\u0001PA\u0003TQ>\u0014H/\u0001\rQe>$WoY3s':\f\u0007o\u001d5piZ+'o]5p]\u0002\nABV3sg&|gNR5fY\u0012,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005!A.\u00198h\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003;\u0011aa\u0015;sS:<\u0017!\u0004,feNLwN\u001c$jK2$\u0007%\u0001\u0005De\u000e4\u0015.\u001a7e\u0003%\u0019%o\u0019$jK2$\u0007%A\bQe>$WoY3s\u0013\u00124\u0015.\u001a7e\u0003A\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0007%A\tMCN$8+Z9vK:\u001cWMR5fY\u0012\f!\u0003T1tiN+\u0017/^3oG\u00164\u0015.\u001a7eA\u0005\u0011\u0002K]8ek\u000e,'/\u00129pG\"4\u0015.\u001a7e\u0003M\u0001&o\u001c3vG\u0016\u0014X\t]8dQ\u001aKW\r\u001c3!\u0003=a\u0015m\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0017\u0001\u0005'bgR|eMZ:fi\u001aKW\r\u001c3!\u0003AyeMZ:fi\u0012+G\u000e^1GS\u0016dG-A\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\u0002\na\u0002V5nKN$\u0018-\u001c9GS\u0016dG-A\bUS6,7\u000f^1na\u001aKW\r\u001c3!\u0003Q\u0001&o\u001c3vG\u0016\u0014XI\u001c;sS\u0016\u001ch)[3mI\u0006)\u0002K]8ek\u000e,'/\u00128ue&,7OR5fY\u0012\u0004\u0013!F\"p_J$\u0017N\\1u_J,\u0005o\\2i\r&,G\u000eZ\u0001\u0017\u0007>|'\u000fZ5oCR|'/\u00129pG\"4\u0015.\u001a7eA\u0005Q2)\u001e:sK:$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$h)[3mI\u0006Y2)\u001e:sK:$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$h)[3mI\u0002\nQBV3sg&|gn\u00144gg\u0016$\u0018A\u0004,feNLwN\\(gMN,G\u000fI\u0001\n\u0007J\u001cwJ\u001a4tKR\f!b\u0011:d\u001f\u001a47/\u001a;!\u0003U\u0001&o\u001c3vG\u0016\u0014XI\u001c;sS\u0016\u001cxJ\u001a4tKR\fa\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G\u000fI\u0001\u001c!J|G-^2feNs\u0017\r]:i_R,e\u000e\u001e:z'\u000eDW-\\1\u0016\u0005\u0005\r\u0004\u0003BA3\u0003{j!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0006if\u0004Xm\u001d\u0006\u0005\u0003[\ny'\u0001\u0005qe>$xnY8m\u0015\u0011\t\t(a\u001d\u0002\r\r|W.\\8o\u0015\r\u0001\u0018Q\u000f\u0006\u0005\u0003o\nI(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003w\n1a\u001c:h\u0013\u0011\ty(a\u001a\u0003\rM\u001b\u0007.Z7b\u0003q\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nC\u0002\nA\u0003U5e':\f\u0007o\u001d5pi6\u000b\u0007oU2iK6\f\u0017!\u0006)jINs\u0017\r]:i_Rl\u0015\r]*dQ\u0016l\u0017\rI\u0001\re\u0016\fGm\u00158baNDw\u000e\u001e\u000b\u0005\u0003\u0017\u000bI\u000b\u0005\u0004\u0002\u000e\u0006u\u00151\u0015\b\u0005\u0003\u001f\u000bIJ\u0004\u0003\u0002\u0012\u0006]UBAAJ\u0015\r\t)*]\u0001\u0007yI|w\u000e\u001e \n\u0003eL1!a'y\u0003\u001d\u0001\u0018mY6bO\u0016LA!a(\u0002\"\nA\u0011\n^3sC\ndWMC\u0002\u0002\u001cb\u00042a]AS\u0013\r\t9+\u001c\u0002\u0013!J|G-^2feN#\u0018\r^3F]R\u0014\u0018\u0010C\u0004\u0002,\u001e\u0002\r!!,\u0002\t\u0019LG.\u001a\t\u0005\u0003_\u000b),\u0004\u0002\u00022*!\u00111WA\u0011\u0003\tIw.\u0003\u0003\u00028\u0006E&\u0001\u0002$jY\u0016\fQb\u001e:ji\u0016\u001cf.\u00199tQ>$HCBA_\u0003\u0007\f)\rE\u0002x\u0003\u007fK1!!1y\u0005\u0011)f.\u001b;\t\u000f\u0005-\u0006\u00061\u0001\u0002.\"9\u0011q\u0019\u0015A\u0002\u0005%\u0017aB3oiJLWm\u001d\t\t\u0003\u0017\f).!7\u0002$6\u0011\u0011Q\u001a\u0006\u0005\u0003\u001f\f\t.A\u0004nkR\f'\r\\3\u000b\u0007\u0005M\u00070\u0001\u0006d_2dWm\u0019;j_:LA!a6\u0002N\n\u0019Q*\u00199\u0011\u0007]\fY.C\u0002\u0002^b\u0014A\u0001T8oO\u0006q\u0011n]*oCB\u001c\bn\u001c;GS2,G\u0003BAr\u0003S\u00042a^As\u0013\r\t9\u000f\u001f\u0002\b\u0005>|G.Z1o\u0011\u001d\tY+\u000ba\u0001\u0003[\u000b\u0011\u0003\\5tiNs\u0017\r]:i_R4\u0015\u000e\\3t)\u0011\ty/a?\u0011\r\u00055\u0015\u0011_A{\u0013\u0011\t\u00190!)\u0003\u0007M+\u0017\u000fE\u0002t\u0003oL1!!?n\u00051\u0019f.\u00199tQ>$h)\u001b7f\u0011\u001d\tiP\u000ba\u0001\u0003[\u000b1\u0001Z5s'\u0011YcO!\u0001\u0011\t\t\r!\u0011B\u0007\u0003\u0005\u000bQ1Aa\u0002p\u0003\u0015)H/\u001b7t\u0013\u0011\u0011YA!\u0002\u0003\u000f1{wmZ5oO\u0006qAo\u001c9jGB\u000b'\u000f^5uS>tWC\u0001B\t!\u0011\u0011\u0019B!\u0006\u000e\u0005\u0005=\u0014\u0002\u0002B\f\u0003_\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003\u001dyFn\\4ESJ,\"!!,\u0002\u0017}cwn\u001a#je~#S-\u001d\u000b\u0005\u0003{\u0013\u0019\u0003C\u0005\u0003&=\n\t\u00111\u0001\u0002.\u0006\u0019\u0001\u0010J\u0019\u0002\u0011}cwn\u001a#je\u0002B3\u0001\rB\u0016!\r9(QF\u0005\u0004\u0005_A(\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002/5\f\u0007\u0010\u0016:b]N\f7\r^5p]RKW.Z8vi6\u001b\u0018\u0001G7bqR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'tA\u0005IR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'t\u0003ii\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:!\u0003\u0011!\u0018.\\3\u0016\u0005\tu\u0002\u0003\u0002B \u0005\u0007j!A!\u0011\u000b\t\t\u001d\u0011qN\u0005\u0005\u0005\u000b\u0012\tE\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004C\u0003\u0004B&\u0005\u001b\u0012yE!\u0015\u0003T\tU\u0003CA:,\u0011\u001d\u0011ia\u000ea\u0001\u0005#AqAa\u00078\u0001\u0004\ti\u000bC\u0004\u00032]\u0002\r!!\u0001\t\u000f\tUr\u00071\u0001\u0002\u0002!9!\u0011H\u001cA\u0002\tu\u0012!C:oCB\u001c\bn\u001c;t+\t\u0011Y\u0006\u0005\u0005\u0003^\t\u001d$1NA{\u001b\t\u0011yF\u0003\u0003\u0003b\t\r\u0014AC2p]\u000e,(O]3oi*!!QMA\u0011\u0003\u0011)H/\u001b7\n\t\t%$q\f\u0002\u0016\u0007>t7-\u001e:sK:$8k[5q\u0019&\u001cH/T1q!\u0011\tYB!\u001c\n\t\u0005u\u0017QD\u0001\u000eg:\f\u0007o\u001d5piN|F%Z9\u0015\t\u0005u&1\u000f\u0005\n\u0005KI\u0014\u0011!a\u0001\u00057\n!b\u001d8baNDw\u000e^:!\u0003%\u0001(o\u001c3vG\u0016\u00148/\u0006\u0002\u0002J\u0006Q\u0001O]8ek\u000e,'o\u001d\u0011\u0002\u001b1\f7\u000f^'ba>3gm]3u+\t\tI.A\tmCN$X*\u00199PM\u001a\u001cX\r^0%KF$B!!0\u0003\u0006\"I!Q\u0005 \u0002\u0002\u0003\u0007\u0011\u0011\\\u0001\u000fY\u0006\u001cH/T1q\u001f\u001a47/\u001a;!\u00039a\u0017m\u001d;T]\u0006\u0004xJ\u001a4tKR\f!\u0003\\1tiNs\u0017\r](gMN,Go\u0018\u0013fcR!\u0011Q\u0018BH\u0011%\u0011)#QA\u0001\u0002\u0004\tI.A\bmCN$8K\\1q\u001f\u001a47/\u001a;!\u0003YyG\u000eZ3tiRCh\u000eT1tiRKW.Z:uC6\u0004\u0018AG8mI\u0016\u001cH\u000f\u0016=o\u0019\u0006\u001cH\u000fV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BA_\u00053C\u0011B!\nE\u0003\u0003\u0005\r!!7\u0002/=dG-Z:u)btG*Y:u)&lWm\u001d;b[B\u0004\u0003fA#\u0003,\u0005YqN\\4pS:<G\u000b\u001f8t+\t\u0011\u0019\u000b\u0005\u0005\u0003&\n\u001d\u0016\u0011\u001cBV\u001b\t\u0011\u0019'\u0003\u0003\u0003*\n\r$a\u0002+sK\u0016l\u0015\r\u001d\t\u0004g\n5\u0016b\u0001BX[\nYA\u000b\u001f8NKR\fG-\u0019;b\u00031ygnZ8j]\u001e$\u0006P\\:!\u0003A)hN]3qY&\u001c\u0017\r^3e)bt7/A\tv]J,\u0007\u000f\\5dCR,G\r\u0016=og\u0002\n!\u0003[1t\u0019\u0006$X\r\u0016:b]N\f7\r^5p]R!\u00111\u001dB^\u0011\u001d\u0011iL\u0013a\u0001\u00033\fQbY;se\u0016tG\u000fV5nK6\u001b\bf\u0001&\u0003BB!!1\u0001Bb\u0013\u0011\u0011)M!\u0002\u0003\u0015QD'/Z1eg\u00064W-A\u0007m_\u0006$7K\\1qg\"|Go\u001d\u000b\u0003\u00057\nAC]3n_Z,7\u000b\u001e:bsNs\u0017\r]:i_R\u001cH\u0003BA_\u0005\u001fDqA!5M\u0001\u0004\u0011\u0019.\u0001\ntK\u001elWM\u001c;CCN,wJ\u001a4tKR\u001c\bCBAG\u0003c\fI.A\ngSJ\u001cH/\u00168ti\u0006\u0014G.Z(gMN,G/\u0006\u0002\u0003ZB)qOa7\u0003`&\u0019!Q\u001c=\u0003\r=\u0003H/[8o!\u0011\u0011\tOa:\u000e\u0005\t\r(b\u0001Bs_\u000611/\u001a:wKJLAA!;\u0003d\n\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0002-=t\u0007*[4i/\u0006$XM]7be.,\u0006\u000fZ1uK\u0012$B!!0\u0003p\"9!\u0011\u001f(A\u0002\u0005e\u0017!\u00045jO\"<\u0016\r^3s[\u0006\u00148.\u0001\u000bgSJ\u001cH/\u00168eK\u000eLG-\u001a3PM\u001a\u001cX\r^\u000b\u0003\u0005o\u0004Ra\u001eBn\u00033\fA\"\\1q\u000b:$wJ\u001a4tKR\fq\"Y2uSZ,\u0007K]8ek\u000e,'o]\u000b\u0003\u0005\u007f\u0004\u0002b!\u0001\u0004\b\u0005e\u00171U\u0007\u0003\u0007\u0007QAa!\u0002\u0002R\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003/\u001c\u0019!A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\u0005\r\u0018\u0001\u00057pC\u00124%o\\7T]\u0006\u00048\u000f[8u)\u0019\til!\u0005\u0004\u0016!911C*A\u0002\u0005e\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0007/\u0019\u0006\u0019AAm\u0003-\u0019WO\u001d:f]R$\u0016.\\3\u0002#1|\u0017\r\u001a)s_\u0012,8-\u001a:F]R\u0014\u0018\u0010\u0006\u0003\u0002>\u000eu\u0001bBB\u0010)\u0002\u0007\u00111U\u0001\u0006K:$(/_\u0001\u0012SN\u0004&o\u001c3vG\u0016\u0014X\t\u001f9je\u0016$GCBAr\u0007K\u00199\u0003C\u0004\u0003>V\u0003\r!!7\t\u000f\r%R\u000b1\u0001\u0002$\u0006i\u0001O]8ek\u000e,'o\u0015;bi\u0016\faC]3n_Z,W\t\u001f9je\u0016$\u0007K]8ek\u000e,'o\u001d\u000b\u0005\u0003{\u001by\u0003C\u0004\u0003>Z\u0003\r!!7\u0002#Q\u0014XO\\2bi\u0016\fe\u000e\u001a*fY>\fG\r\u0006\u0005\u0002>\u000eU2qGB\u001e\u0011\u001d\u0019\u0019b\u0016a\u0001\u00033Dqa!\u000fX\u0001\u0004\tI.\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0003>^\u0003\r!!7\u0002\u001bA\u0014X\r]1sKV\u0003H-\u0019;f)\u0019\u0019\tea\u0012\u0004LA\u00191oa\u0011\n\u0007\r\u0015SN\u0001\nQe>$WoY3s\u0003B\u0004XM\u001c3J]\u001a|\u0007bBB%1\u0002\u0007\u0011\u0011\\\u0001\u000baJ|G-^2fe&#\u0007bBB'1\u0002\u00071qJ\u0001\u0007_JLw-\u001b8\u0011\u0007M\u001c\t&C\u0002\u0004T5\u0014A\"\u00119qK:$wJ]5hS:\fa!\u001e9eCR,G\u0003BA_\u00073Bqaa\u0017Z\u0001\u0004\u0019\t%\u0001\u0006baB,g\u000eZ%oM>\f\u0001$\u001e9eCR,w\n\u001c3fgR$\u0006P\u001c+j[\u0016\u001cH/Y7q)\t\ti,\u0001\nva\u0012\fG/Z'ba\u0016sGm\u00144gg\u0016$H\u0003BA_\u0007KBqaa\u001a\\\u0001\u0004\tI.\u0001\u0006mCN$xJ\u001a4tKR\f\u0011\u0002\\1ti\u0016sGO]=\u0015\t\r54q\u000e\t\u0006o\nm\u00171\u0015\u0005\b\u0007\u0013b\u0006\u0019AAm\u00031!\u0018m[3T]\u0006\u00048\u000f[8u\u0003=)\b\u000fZ1uKB\u000b'/\u001a8u\t&\u0014H\u0003BA_\u0007oBqa!\u001f_\u0001\u0004\ti+A\u0005qCJ,g\u000e\u001e#je\u0006!B.\u0019;fgR\u001cf.\u00199tQ>$xJ\u001a4tKR\fAc\u001c7eKN$8K\\1qg\"|Go\u00144gg\u0016$\u0018!F:oCB\u001c\bn\u001c;GS2,gi\u001c:PM\u001a\u001cX\r\u001e\u000b\u0005\u0007\u0007\u001b)\tE\u0003x\u00057\f)\u0010C\u0004\u0004\b\u0006\u0004\r!!7\u0002\r=4gm]3u\u0003myg\u000eT8h'R\f'\u000f^(gMN,G/\u00138de\u0016lWM\u001c;fIR!\u0011QXBG\u0011\u001d\u0019\u0019B\u0019a\u0001\u00033\faD]3n_Z,WK\u001c:fa2L7-\u0019;fIR\u0013\u0018M\\:bGRLwN\\:\u0015\t\u0005u61\u0013\u0005\b\u0007\u000f\u001b\u0007\u0019AAm\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0003\u0002>\u000ee\u0005bBBDI\u0002\u0007\u0011\u0011\\\u0001\u0011Y\u0006\u001cHo\u0015;bE2,wJ\u001a4tKR$B!!7\u0004 \"91\u0011U3A\u0002\r\r\u0016\u0001D2p[BdW\r^3e)bt\u0007cA:\u0004&&\u00191qU7\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\u0002\u0017\r|W\u000e\u001d7fi\u0016$\u0006P\u001c\u000b\u0005\u0003{\u001bi\u000bC\u0004\u0004\"\u001a\u0004\raa)\u0002+\u0011,G.\u001a;f':\f\u0007o\u001d5piN\u0014UMZ8sKR!\u0011QXBZ\u0011\u001d\u00199i\u001aa\u0001\u00033D3a\u001aBa\u0003IyG\u000eZ3tiNs\u0017\r]:i_R4\u0015\u000e\\3\u0016\u0005\r\r\u0015A\u00057bi\u0016\u001cHo\u00158baNDw\u000e\u001e$jY\u0016\fqC]3n_Z,\u0017I\u001c3EK2,G/Z*oCB\u001c\bn\u001c;\u0015\t\u0005u6\u0011\u0019\u0005\b\u0007\u0007T\u0007\u0019AAm\u00039\u0019h.\u00199tQ>$xJ\u001a4tKR\f\u0001E]3n_Z,\u0017I\u001c3NCJ\\7K\\1qg\"|GOR8s\t\u0016dW\r^5p]R!11QBe\u0011\u001d\u0019\u0019m\u001ba\u0001\u00033D3aKBg!\u0011\u0011\u0019aa4\n\t\rE'Q\u0001\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File _logDir;
    private final int maxTransactionTimeoutMs;
    private final int maxProducerIdExpirationMs;
    private final Time time;
    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private volatile long oldestTxnLastTimestamp;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    public static int LateTransactionBufferMs() {
        return ProducerStateManager$.MODULE$.LateTransactionBufferMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File _logDir() {
        return this._logDir;
    }

    public void _logDir_$eq(File x$1) {
        this._logDir = x$1;
    }

    public int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    public Time time() {
        return this.time;
    }

    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots() {
        return this.snapshots;
    }

    private void snapshots_$eq(ConcurrentSkipListMap<Long, SnapshotFile> x$1) {
        this.snapshots = x$1;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private long oldestTxnLastTimestamp() {
        return this.oldestTxnLastTimestamp;
    }

    private void oldestTxnLastTimestamp_$eq(long x$1) {
        this.oldestTxnLastTimestamp = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    public boolean hasLateTransaction(long currentTimeMs) {
        long lastTimestamp = this.oldestTxnLastTimestamp();
        return lastTimestamp > 0L && currentTimeMs - lastTimestamp > (long)(this.maxTransactionTimeoutMs() + ProducerStateManager$.MODULE$.LateTransactionBufferMs());
    }

    private ConcurrentSkipListMap<Long, SnapshotFile> loadSnapshots() {
        ConcurrentSkipListMap<Long, SnapshotFile> tm = new ConcurrentSkipListMap<Long, SnapshotFile>();
        ProducerStateManager$.MODULE$.listSnapshotFiles(this._logDir()).foreach((Function1 & Serializable)f -> tm.put(Predef$.MODULE$.long2Long(f.offset()), (SnapshotFile)f));
        return tm;
    }

    public void removeStraySnapshots(Seq<Object> segmentBaseOffsets) {
        None$ maxSegmentBaseOffset = segmentBaseOffsets.isEmpty() ? None$.MODULE$ : new Some(segmentBaseOffsets.max((Ordering)Ordering.Long$.MODULE$));
        Set baseOffsets = segmentBaseOffsets.toSet();
        ObjectRef latestStraySnapshot = ObjectRef.create((Object)None$.MODULE$);
        ConcurrentSkipListMap<Long, SnapshotFile> ss = this.loadSnapshots();
        CollectionConverters$.MODULE$.CollectionHasAsScala(ss.values()).asScala().foreach((Function1 & Serializable)snapshot -> {
            ProducerStateManager.$anonfun$removeStraySnapshots$1(latestStraySnapshot, baseOffsets, ss, snapshot);
            return BoxedUnit.UNIT;
        });
        ((Option)latestStraySnapshot.elem).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())).foreach((Function1)((JFunction1.mcVJ.sp & Serializable)arg_0 -> ProducerStateManager.$anonfun$removeStraySnapshots$3((Option)maxSegmentBaseOffset, ss, arg_0)));
        this.snapshots_$eq(ss);
    }

    public Option<LogOffsetMetadata> firstUnstableOffset() {
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        if (unreplicatedFirstOffset.isEmpty()) {
            return undecidedFirstOffset;
        }
        if (undecidedFirstOffset.isEmpty()) {
            return unreplicatedFirstOffset;
        }
        if (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset()) {
            return undecidedFirstOffset;
        }
        return unreplicatedFirstOffset;
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        Option<SnapshotFile> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            SnapshotFile snapshot = (SnapshotFile)((Some)option).value();
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(snapshot).append("'").toString());
                ((Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshot.file()).filter((Function1 & Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, currentTime, producerEntry)))).foreach((Function1 & Serializable)entry -> {
                    this.loadProducerEntry(entry);
                    return BoxedUnit.UNIT;
                });
                this.lastSnapOffset_$eq(snapshot.offset());
                this.lastMapOffset_$eq(this.lastSnapOffset());
                this.updateOldestTxnTimestamp();
                return;
            }
            catch (CorruptSnapshotException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(snapshot.file()).append("': ").append(e.getMessage()).toString());
                this.removeAndDeleteSnapshot(snapshot.offset());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset);
            this.lastMapOffset_$eq(logStartOffset);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().$minus$minus$eq((IterableOnce)((MapOps)this.producers().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, x0$1)))).keySet());
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.snapshots().values()).asScala().foreach((Function1 & Serializable)snapshot -> {
            ProducerStateManager.$anonfun$truncateAndReload$1(this, logEndOffset, logStartOffset, snapshot);
            return BoxedUnit.UNIT;
        });
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.updateOldestTxnTimestamp();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
            return;
        }
        this.onLogStartOffsetIncremented(logStartOffset);
    }

    public ProducerAppendInfo prepareUpdate(long producerId, AppendOrigin origin) {
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, origin);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").append("for partition ").append(this.topicPartition()).toString());
        }
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            ((ProducerStateEntry)((Some)option).value()).update(updatedEntry);
        } else if (None$.MODULE$.equals(option)) {
            this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        appendInfo.startedTransactions().foreach((Function1 & Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
        this.updateOldestTxnTimestamp();
    }

    private void updateOldestTxnTimestamp() {
        Map.Entry<Object, TxnMetadata> firstEntry = this.ongoingTxns().firstEntry();
        if (firstEntry == null) {
            this.oldestTxnLastTimestamp_$eq(-1L);
            return;
        }
        TxnMetadata oldestTxnMetadata = firstEntry.getValue();
        this.oldestTxnLastTimestamp_$eq(BoxesRunTime.unboxToLong((Object)this.producers().get((Object)BoxesRunTime.boxToLong((long)oldestTxnMetadata.producerId())).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.lastTimestamp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.lastMapOffset() > this.lastSnapOffset()) {
            SnapshotFile snapshotFile = SnapshotFile$.MODULE$.apply(UnifiedLog$.MODULE$.producerSnapshotFile(this._logDir(), this.lastMapOffset()));
            long start = this.time().hiResClockMs();
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile.file(), this.producers());
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Wrote producer snapshot at offset ").append(this.lastMapOffset()).append(" with ").append(this.producers().size()).append(" producer ids in ").append(this.time().hiResClockMs() - start).append(" ms.").toString());
            this.snapshots().put(Predef$.MODULE$.long2Long(snapshotFile.offset()), snapshotFile);
            this.lastSnapOffset_$eq(this.lastMapOffset());
            return;
        }
    }

    public void updateParentDir(File parentDir) {
        this._logDir_$eq(parentDir);
        this.snapshots().forEach((x$8, s) -> s.updateParentDir(parentDir));
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.offset()));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.offset()));
    }

    public Option<SnapshotFile> snapshotFileForOffset(long offset) {
        return Option$.MODULE$.apply((Object)this.snapshots().get(BoxesRunTime.boxToLong((long)offset)));
    }

    public void onLogStartOffsetIncremented(long logStartOffset) {
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> logStartOffset)));
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getValue().lastOffset().exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$11 -> x$11 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncateFullyAndStartAt(long offset) {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.snapshots().values()).asScala().foreach((Function1 & Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(offset);
        this.updateOldestTxnTimestamp();
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        return BoxesRunTime.unboxToLong((Object)CollectionConverters$.MODULE$.CollectionHasAsScala(this.ongoingTxns().values()).asScala().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$lastStableOffset$1(completedTxn, x$12))).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$lastStableOffset$2(x$13))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> completedTxn.lastOffset() + 1L));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
        this.updateOldestTxnTimestamp();
    }

    public void deleteSnapshotsBefore(long offset) {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.snapshots().subMap((Object)Predef$.MODULE$.long2Long(0L), (Object)Predef$.MODULE$.long2Long(offset)).values()).asScala().foreach((Function1 & Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
    }

    private Option<SnapshotFile> oldestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().firstEntry()).map((Function1 & Serializable)x$14 -> (SnapshotFile)x$14.getValue());
    }

    private Option<SnapshotFile> latestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().lastEntry()).map((Function1 & Serializable)x$15 -> (SnapshotFile)x$15.getValue());
    }

    private void removeAndDeleteSnapshot(long snapshotOffset) {
        Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).foreach((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.deleteIfExists()));
    }

    public Option<SnapshotFile> removeAndMarkSnapshotForDeletion(long snapshotOffset) {
        return Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).flatMap((Function1 & Serializable)snapshot -> {
            try {
                snapshot.renameTo(UnifiedLog$.MODULE$.DeletedFileSuffix());
                return new Some(snapshot);
            }
            catch (NoSuchFileException noSuchFileException) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Failed to rename producer state snapshot ").append(snapshot.file().getAbsoluteFile()).append(" with deletion suffix because it was already deleted").toString());
                return None$.MODULE$;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$1(ObjectRef latestStraySnapshot$1, Set baseOffsets$1, ConcurrentSkipListMap ss$1, SnapshotFile snapshot) {
        long key = snapshot.offset();
        Option option = (Option)latestStraySnapshot$1.elem;
        if (option instanceof Some) {
            SnapshotFile prev = (SnapshotFile)((Some)option).value();
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                prev.deleteIfExists();
                ss$1.remove(BoxesRunTime.boxToLong((long)prev.offset()));
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$3(Option maxSegmentBaseOffset$1, ConcurrentSkipListMap ss$1, long strayOffset) {
        maxSegmentBaseOffset$1.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)maxOffset -> {
            if (strayOffset < maxOffset) {
                Option$.MODULE$.apply(ss$1.remove(BoxesRunTime.boxToLong((long)strayOffset))).foreach((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.deleteIfExists()));
                return;
            }
        });
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long currentTime$1, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ProducerStateEntry lastEntry = (ProducerStateEntry)x0$1._2();
            return $this.isProducerExpired(currentTimeMs$1, lastEntry);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$truncateAndReload$1(ProducerStateManager $this, long logEndOffset$1, long logStartOffset$1, SnapshotFile snapshot) {
        if (snapshot.offset() > logEndOffset$1 || snapshot.offset() <= logStartOffset$1) {
            $this.removeAndDeleteSnapshot(snapshot.offset());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$lastStableOffset$1(CompletedTxn completedTxn$1, TxnMetadata x$12) {
        return x$12.producerId() != completedTxn$1.producerId();
    }

    public static final /* synthetic */ long $anonfun$lastStableOffset$2(TxnMetadata x$13) {
        return x$13.firstOffset().messageOffset();
    }

    public ProducerStateManager(TopicPartition topicPartition, File _logDir, int maxTransactionTimeoutMs, int maxProducerIdExpirationMs, Time time) {
        this.topicPartition = topicPartition;
        this._logDir = _logDir;
        this.maxTransactionTimeoutMs = maxTransactionTimeoutMs;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.snapshots = (ConcurrentSkipListMap)Predef$.MODULE$.locally(this.loadSnapshots());
        this.producers = (Map)Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.oldestTxnLastTimestamp = -1L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

