/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.LoggingFaultHandler;
import org.apache.kafka.server.fault.ProcessExitingFaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0015e\u0001\u0002\u001f>\u0001\tC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t/\u0002\u0011\t\u0011)A\u00051\"AA\r\u0001B\u0001B\u0003%Q\rC\u0003t\u0001\u0011\u0005A\u000f\u0003\u0006z\u0001A\u0005\t1!Q\u0001\niD\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u000f\u0005\u0005\u0002\u0001)A\u0005{\"I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0002!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111\u0006\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\u0012!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00024!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002D!I\u0011\u0011\u0011\u0001C\u0002\u0013%\u00111\u0011\u0005\t\u00037\u0003\u0001\u0015!\u0003\u0002\u0006\"I\u0011Q\u0014\u0001C\u0002\u0013%\u0011q\u0014\u0005\t\u0003S\u0003\u0001\u0015!\u0003\u0002\"\"I\u00111\u0016\u0001C\u0002\u0013%\u0011Q\u0016\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u00020\"9\u0011\u0011\u0018\u0001\u0005B\u0005m\u0006bBAb\u0001\u0011\u0005\u00131\u0018\u0005\b\u0003\u000b\u0004A\u0011IA^\u000f\u001d\t9-\u0010E\u0001\u0003\u00134a\u0001P\u001f\t\u0002\u0005-\u0007BB:\u001b\t\u0003\ti\rC\u0005\u0002Pj\u0011\r\u0011\"\u0001\u0002R\"A\u0011q\u001b\u000e!\u0002\u0013\t\u0019\u000eC\u0005\u0002Zj\u0011\r\u0011\"\u0001\u0002\\\"A\u0011Q\u001d\u000e!\u0002\u0013\ti\u000eC\u0005\u0002hj\u0011\r\u0011\"\u0001\u0002j\"A\u0011\u0011\u001f\u000e!\u0002\u0013\tYOB\u0005\u0002tj\u0001\n1%\t\u0002v\u001e9!Q\u000e\u000e\t\u0002\nmaaBA}5!\u0005\u00151 \u0005\u0007g\u0012\"\tA!\u0007\t\u000f\tuA\u0005\"\u0011\u0003 !I!\u0011\u0005\u0013\u0002\u0002\u0013\u0005\u0013\u0011\u001b\u0005\n\u0005G!\u0013\u0011!C\u0001\u0005KA\u0011B!\f%\u0003\u0003%\tAa\f\t\u0013\teB%!A\u0005B\tm\u0002\"\u0003B\"I\u0005\u0005I\u0011\u0001B#\u0011%\u0011y\u0005JA\u0001\n\u0003\u0012\t\u0006C\u0005\u0003T\u0011\n\t\u0011\"\u0003\u0003V\u001d9!q\u000e\u000e\t\u0002\n\rda\u0002B/5!\u0005%q\f\u0005\u0007g>\"\tA!\u0019\t\u000f\tuq\u0006\"\u0011\u0003 !I!\u0011E\u0018\u0002\u0002\u0013\u0005\u0013\u0011\u001b\u0005\n\u0005Gy\u0013\u0011!C\u0001\u0005KA\u0011B!\f0\u0003\u0003%\tA!\u001a\t\u0013\ter&!A\u0005B\tm\u0002\"\u0003B\"_\u0005\u0005I\u0011\u0001B5\u0011%\u0011yeLA\u0001\n\u0003\u0012\t\u0006C\u0005\u0003T=\n\t\u0011\"\u0003\u0003V!9!\u0011\u000f\u000e\u0005\u0002\tM\u0004\"\u0003B<5\t\u0007I\u0011\u0001B=\u0011!\u0011\u0019I\u0007Q\u0001\n\tm$aD&bM.\f'+\u00194u'\u0016\u0014h/\u001a:\u000b\u0005yz\u0014AB:feZ,'OC\u0001A\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\"J\u001bB\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n1\u0011I\\=SK\u001a\u0004\"AS&\u000e\u0003uJ!\u0001T\u001f\u0003\rM+'O^3s!\tq\u0015+D\u0001P\u0015\t\u0001v(A\u0003vi&d7/\u0003\u0002S\u001f\n9Aj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u0002K+&\u0011a+\u0010\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0003uS6,\u0007CA-c\u001b\u0005Q&B\u0001)\\\u0015\taV,\u0001\u0004d_6lwN\u001c\u0006\u0003\u0001zS!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111M\u0017\u0002\u0005)&lW-\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqB\u0019AI\u001a5\n\u0005\u001d,%AB(qi&|g\u000e\u0005\u0002ja:\u0011!N\u001c\t\u0003W\u0016k\u0011\u0001\u001c\u0006\u0003[\u0006\u000ba\u0001\u0010:p_Rt\u0014BA8F\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=,\u0015A\u0002\u001fj]&$h\b\u0006\u0003vm^D\bC\u0001&\u0001\u0011\u0015\u0019F\u00011\u0001U\u0011\u00159F\u00011\u0001Y\u0011\u0015!G\u00011\u0001f\u0003\rAH%\r\t\b\tnl\u0018\u0011AA\t\u0013\taXI\u0001\u0004UkBdWm\r\t\u0003\u0015zL!a`\u001f\u0003\u001d5+G/\u0019)s_B,'\u000f^5fgB!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011!\u00032p_R\u001cHO]1q\u0015\r\tY!X\u0001\t[\u0016$\u0018\rZ1uC&!\u0011qBA\u0003\u0005E\u0011un\u001c;tiJ\f\u0007/T3uC\u0012\fG/\u0019\t\u0006\u0003'\tI\u0002[\u0007\u0003\u0003+Q1!a\u0006F\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t)BA\u0002TKF\f\u0011\"\\3uCB\u0013x\u000e]:\u0016\u0003u\f!\"\\3uCB\u0013x\u000e]:!\u0003E\u0011wn\u001c;tiJ\f\u0007/T3uC\u0012\fG/Y\u000b\u0003\u0003\u0003\t!CY8piN$(/\u00199NKR\fG-\u0019;bA\u0005YqN\u001a4mS:,G)\u001b:t+\t\t\t\"\u0001\u0007pM\u001ad\u0017N\\3ESJ\u001c\b%A\u0004nKR\u0014\u0018nY:\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003si!!a\u000e\u000b\u0007\u0005=2,\u0003\u0003\u0002<\u0005]\"aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005a2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,WCAA\"!\u0019\t)%a\u0015\u0002X5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0014\u0002P\u0005!Q\u000f^5m\u0015\t\t\t&\u0001\u0003kCZ\f\u0017\u0002BA+\u0003\u000f\u0012\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!!\tI&a\u0017\u0002`\u0005-TBAA&\u0013\u0011\ti&a\u0013\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\u0011\t)'a\u0014\u0002\t1\fgnZ\u0005\u0005\u0003S\n\u0019GA\u0004J]R,w-\u001a:\u0011\t\u00055\u0014\u0011\u0010\b\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111O/\u0002\tI\fg\r^\u0005\u0005\u0003o\n\t(\u0001\u0006SC\u001a$8i\u001c8gS\u001eLA!a\u001f\u0002~\tY\u0011\t\u001a3sKN\u001c8\u000b]3d\u0015\u0011\t9(!\u001d\u0002;\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sK\u0002\n1B]1gi6\u000bg.Y4feV\u0011\u0011Q\u0011\t\u0007\u0003\u000f\u000bY)a$\u000e\u0005\u0005%%bAA:\u007f%!\u0011QRAE\u0005AY\u0015MZ6b%\u00064G/T1oC\u001e,'\u000f\u0005\u0003\u0002\u0012\u0006]UBAAJ\u0015\ra\u0016Q\u0013\u0006\u0003}uKA!!'\u0002\u0014\n!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:\fAB]1gi6\u000bg.Y4fe\u0002\naA\u0019:pW\u0016\u0014XCAAQ!\u0011!e-a)\u0011\u0007)\u000b)+C\u0002\u0002(v\u0012AB\u0011:pW\u0016\u00148+\u001a:wKJ\fqA\u0019:pW\u0016\u0014\b%\u0001\u0006d_:$(o\u001c7mKJ,\"!a,\u0011\t\u00113\u0017\u0011\u0017\t\u0004\u0015\u0006M\u0016bAA[{\t\u00012i\u001c8ue>dG.\u001a:TKJ4XM]\u0001\fG>tGO]8mY\u0016\u0014\b%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005u\u0006c\u0001#\u0002@&\u0019\u0011\u0011Y#\u0003\tUs\u0017\u000e^\u0001\tg\",H\u000fZ8x]\u0006i\u0011m^1jiNCW\u000f\u001e3po:\fqbS1gW\u0006\u0014\u0016M\u001a;TKJ4XM\u001d\t\u0003\u0015j\u0019\"AG\"\u0015\u0005\u0005%\u0017!D'fi\u0006$\u0017\r^1U_BL7-\u0006\u0002\u0002TB!\u0011\u0011MAk\u0013\r\t\u00181M\u0001\u000f\u001b\u0016$\u0018\rZ1uCR{\u0007/[2!\u0003EiU\r^1eCR\f\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003;\u0004B!a8\u0002b6\t1,C\u0002\u0002dn\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\nNKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u0004\u0013aD'fi\u0006$\u0017\r^1U_BL7-\u00133\u0016\u0005\u0005-\b\u0003BAp\u0003[L1!a<\\\u0005\u0011)V/\u001b3\u0002!5+G/\u00193bi\u0006$v\u000e]5d\u0013\u0012\u0004#a\u0003)s_\u000e,7o\u001d*pY\u0016\u001c\"AI\"*\u0007\t\"sF\u0001\u0006Ce>\\WM\u001d*pY\u0016\u001c\u0002\u0002J\"\u0002~\n\u0005!q\u0001\t\u0004\u0003\u007f\u0014S\"\u0001\u000e\u0011\u0007\u0011\u0013\u0019!C\u0002\u0003\u0006\u0015\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003\n\tMa\u0002\u0002B\u0006\u0005\u001fq1a\u001bB\u0007\u0013\u00051\u0015b\u0001B\t\u000b\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u000b\u0005/\u0011AbU3sS\u0006d\u0017N_1cY\u0016T1A!\u0005F)\t\u0011Y\u0002E\u0002\u0002\u0000\u0012\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002Q\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\n\u0011\u0007\u0011\u0013I#C\u0002\u0003,\u0015\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\r\u00038A\u0019AIa\r\n\u0007\tURIA\u0002B]fD\u0001\"_\u0015\u0002\u0002\u0003\u0007!qE\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\b\t\u0007\u0003'\u0011yD!\r\n\t\t\u0005\u0013Q\u0003\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003H\t5\u0003c\u0001#\u0003J%\u0019!1J#\u0003\u000f\t{w\u000e\\3b]\"A\u0011pKA\u0001\u0002\u0004\u0011\t$\u0001\u0005iCND7i\u001c3f)\t\u00119#\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003XA!\u0011\u0011\rB-\u0013\u0011\u0011Y&a\u0019\u0003\r=\u0013'.Z2u\u00059\u0019uN\u001c;s_2dWM\u001d*pY\u0016\u001c\u0002bL\"\u0002~\n\u0005!q\u0001\u000b\u0003\u0005G\u00022!a@0)\u0011\u0011\tDa\u001a\t\u0011e$\u0014\u0011!a\u0001\u0005O!BAa\u0012\u0003l!A\u0011PNA\u0001\u0002\u0004\u0011\t$\u0001\u0006Ce>\\WM\u001d*pY\u0016\fabQ8oiJ|G\u000e\\3s%>dW-A\tj]&$\u0018.\u00197ju\u0016dun\u001a#jeN$2A\u001fB;\u0011\u0015\u0019\u0016\b1\u0001U\u00031\u0019wN\u001c4jON\u001b\u0007.Z7b+\t\u0011Y\b\u0005\u0003\u0003~\t}TBAA\u0005\u0013\u0011\u0011\t)!\u0003\u0003#-\u000bgm[1D_:4\u0017nZ*dQ\u0016l\u0017-A\u0007d_:4\u0017nZ*dQ\u0016l\u0017\r\t")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple3 x$1;
    private final MetaProperties metaProps;
    private final BootstrapMetadata bootstrapMetadata;
    private final Seq<String> offlineDirs;
    private final Metrics metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaConfigSchema configSchema() {
        return KafkaRaftServer$.MODULE$.configSchema();
    }

    public static Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> initializeLogDirs(KafkaConfig config) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(config);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaProperties metaProps() {
        return this.metaProps;
    }

    private BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private Seq<String> offlineDirs() {
        return this.offlineDirs;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.raftManager().startup();
        this.controller().foreach((Function1 & Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.raftManager().shutdown();
        this.controller().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, Level.WARN);
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public KafkaRaftServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        None$ none$;
        None$ none$2;
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(26).append("[KafkaRaftServer nodeId=").append(config.nodeId()).append("] ").toString());
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> tuple3 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties metaProps = (MetaProperties)tuple3._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple3._2();
        Seq offlineDirs = (Seq)tuple3._3();
        this.x$1 = new Tuple3((Object)metaProps, (Object)bootstrapMetadata, (Object)offlineDirs);
        this.metaProps = (MetaProperties)this.x$1._1();
        this.bootstrapMetadata = (BootstrapMetadata)this.x$1._2();
        this.offlineDirs = (Seq)this.x$1._3();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaProps().clusterId());
        this.controllerQuorumVotersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections(config.quorumVoters()));
        this.raftManager = new KafkaRaftManager(this.metaProps(), config, new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), time, this.metrics(), threadNamePrefix, this.controllerQuorumVotersFuture());
        if (config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
            Metrics apply_metrics = this.metrics();
            Object var15_8 = null;
            BrokerServerMetrics brokerMetrics = new BrokerServerMetrics(apply_metrics);
            ProcessExitingFaultHandler fatalFaultHandler = new ProcessExitingFaultHandler();
            LoggingFaultHandler metadataLoadingFaultHandler = new LoggingFaultHandler("metadata loading", () -> brokerMetrics.metadataLoadErrorCount().getAndIncrement());
            LoggingFaultHandler metadataApplyingFaultHandler = new LoggingFaultHandler("metadata application", () -> brokerMetrics.metadataApplyErrorCount().getAndIncrement());
            none$2 = new Some((Object)new BrokerServer(config, this.metaProps(), this.raftManager(), time, this.metrics(), brokerMetrics, threadNamePrefix, this.offlineDirs(), this.controllerQuorumVotersFuture(), (FaultHandler)fatalFaultHandler, (FaultHandler)metadataLoadingFaultHandler, (FaultHandler)metadataApplyingFaultHandler));
        } else {
            none$2 = this.broker = None$.MODULE$;
        }
        if (config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
            QuorumControllerMetrics controllerMetrics = new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry(), time);
            LoggingFaultHandler metadataFaultHandler = new LoggingFaultHandler("controller metadata", () -> controllerMetrics.incrementMetadataErrorCount());
            ProcessExitingFaultHandler fatalFaultHandler = new ProcessExitingFaultHandler();
            none$ = new Some((Object)new ControllerServer(this.metaProps(), config, this.raftManager(), time, this.metrics(), (ControllerMetrics)controllerMetrics, threadNamePrefix, this.controllerQuorumVotersFuture(), KafkaRaftServer$.MODULE$.configSchema(), this.raftManager().apiVersions(), this.bootstrapMetadata(), (FaultHandler)metadataFaultHandler, (FaultHandler)fatalFaultHandler));
        } else {
            none$ = None$.MODULE$;
        }
        this.controller = none$;
    }

    public static interface ProcessRole {
    }
}

