/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.common.memory.MemoryPool;

public class BatchMemoryPool
implements MemoryPool {
    private final ReentrantLock lock;
    private final Deque<ByteBuffer> free;
    private final int maxRetainedBatches;
    private final int batchSize;
    private int numAllocatedBatches = 0;

    public BatchMemoryPool(int maxRetainedBatches, int batchSize) {
        this.maxRetainedBatches = maxRetainedBatches;
        this.batchSize = batchSize;
        this.free = new ArrayDeque<ByteBuffer>(maxRetainedBatches);
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer tryAllocate(int sizeBytes) {
        if (sizeBytes > this.batchSize) {
            throw new IllegalArgumentException("Cannot allocate buffers larger than max batch size of " + this.batchSize);
        }
        this.lock.lock();
        try {
            ByteBuffer buffer = this.free.poll();
            if (buffer == null) {
                buffer = ByteBuffer.allocate(this.batchSize);
                ++this.numAllocatedBatches;
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void release(ByteBuffer previouslyAllocated) {
        this.lock.lock();
        try {
            previouslyAllocated.clear();
            if (previouslyAllocated.limit() != this.batchSize) {
                throw new IllegalArgumentException("Released buffer with unexpected size " + previouslyAllocated.limit());
            }
            if (this.free.size() >= this.maxRetainedBatches) {
                --this.numAllocatedBatches;
            } else {
                this.free.offer(previouslyAllocated);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public long size() {
        this.lock.lock();
        try {
            long l = (long)this.numAllocatedBatches * (long)this.batchSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long availableMemory() {
        return Long.MAX_VALUE;
    }

    public boolean isOutOfMemory() {
        return false;
    }
}

