/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules;

import io.confluent.kafka.schemaregistry.rules.FieldRuleExecutor;
import io.confluent.kafka.schemaregistry.rules.FieldTransform;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRedactionExecutor
extends FieldRuleExecutor {
    private static final Logger log = LoggerFactory.getLogger(FieldRedactionExecutor.class);
    public static final String TYPE = "REDACT";
    private static final String REDACTED_STRING = "<REDACTED>";
    private static final byte[] REDACTED_BYTES = "<REDACTED>".getBytes(StandardCharsets.UTF_8);

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public FieldRedactionExecutorTransform newTransform(RuleContext ctx) throws RuleException {
        FieldRedactionExecutorTransform transform = new FieldRedactionExecutorTransform();
        transform.init(ctx);
        return transform;
    }

    public static class FieldRedactionExecutorTransform
    implements FieldTransform {
        @Override
        public Object transform(RuleContext ctx, RuleContext.FieldContext fieldCtx, Object fieldValue) throws RuleException {
            if (fieldValue == null) {
                return null;
            }
            switch (fieldCtx.getType()) {
                case STRING: {
                    return FieldRedactionExecutor.REDACTED_STRING;
                }
                case BYTES: {
                    return REDACTED_BYTES;
                }
            }
            return fieldValue;
        }

        @Override
        public void close() {
        }
    }
}

