/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.tools;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.common.utils.AbstractPerformanceTest;
import io.confluent.common.utils.PerformanceStats;
import io.confluent.kafkarest.entities.v2.ConsumerSubscriptionRecord;
import io.confluent.kafkarest.entities.v2.ConsumerSubscriptionResponse;
import io.confluent.kafkarest.entities.v2.CreateConsumerInstanceRequest;
import io.confluent.kafkarest.entities.v2.CreateConsumerInstanceResponse;
import io.confluent.rest.entities.ErrorMessage;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

@SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
public class ConsumerPerformance
extends AbstractPerformanceTest {
    private static final Random RANDOM = new Random();
    long targetRecords;
    long recordsPerSec;
    ObjectMapper serializer = new ObjectMapper();
    String targetUrl;
    String instanceUrl;
    long consumedRecords = 0L;
    private final ObjectMapper jsonDeserializer = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage: java " + ConsumerPerformance.class.getName() + " rest_url topic_name num_records target_records_sec");
            System.exit(1);
        }
        String baseUrl = args[0];
        String topic = args[1];
        int numRecords = Integer.parseInt(args[2]);
        int throughput = Integer.parseInt(args[3]);
        ConsumerPerformance perf = new ConsumerPerformance(baseUrl, topic, numRecords, throughput);
        perf.run();
        perf.close();
    }

    public ConsumerPerformance(String baseUrl, String topic, long numRecords, long recordsPerSec) throws Exception {
        super(numRecords);
        this.targetRecords = numRecords;
        this.recordsPerSec = recordsPerSec;
        String groupId = "rest-perf-consumer-" + RANDOM.nextInt(100000);
        CreateConsumerInstanceRequest consumerConfig = new CreateConsumerInstanceRequest(null, null, null, "earliest", null, null, null);
        byte[] createPayload = this.serializer.writeValueAsBytes((Object)consumerConfig);
        CreateConsumerInstanceResponse createResponse = this.request(baseUrl + "/consumers/" + groupId, "POST", createPayload, Integer.toString(createPayload.length), new TypeReference<CreateConsumerInstanceResponse>(){});
        this.instanceUrl = baseUrl + "/consumers/" + groupId + "/instances/" + createResponse.getInstanceId();
        ConsumerSubscriptionRecord consumerSubscriptionRecord = new ConsumerSubscriptionRecord(Arrays.asList(topic), null);
        byte[] subscribePayload = this.serializer.writeValueAsBytes((Object)consumerSubscriptionRecord);
        this.request(this.instanceUrl + "/subscription", "POST", subscribePayload, Integer.toString(subscribePayload.length), new TypeReference<ConsumerSubscriptionResponse>(){});
        this.targetUrl = this.instanceUrl + "/records";
        this.request(this.targetUrl + "?max_bytes=100", "GET", null, null, new TypeReference<List<UndecodedConsumerRecord>>(){});
    }

    protected void doIteration(PerformanceStats.Callback cb) {
        List<UndecodedConsumerRecord> records = this.request(this.targetUrl, "GET", null, null, new TypeReference<List<UndecodedConsumerRecord>>(){});
        long bytes = 0L;
        for (UndecodedConsumerRecord record : records) {
            bytes += (long)(record.value.length() * 3 / 4);
        }
        this.consumedRecords += (long)records.size();
        cb.onCompletion(records.size(), bytes);
    }

    protected void close() {
        this.request(this.instanceUrl, "DELETE", null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T request(String target, String method, byte[] entity, String entityLength, TypeReference<T> responseFormat) {
        HttpURLConnection connection = null;
        try {
            int responseStatus;
            URL url = new URL(target);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method);
            if (!method.equals("GET")) {
                connection.setRequestProperty("Content-Type", "application/vnd.kafka.v2+json");
            }
            if (entityLength != null) {
                connection.setRequestProperty("Content-Length", entityLength);
            }
            connection.setDoInput(true);
            connection.setUseCaches(false);
            if (entity != null) {
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                os.write(entity);
                os.flush();
                os.close();
            }
            if ((responseStatus = connection.getResponseCode()) >= 400) {
                InputStream es = connection.getErrorStream();
                ErrorMessage errorMessage = (ErrorMessage)this.jsonDeserializer.readValue(es, ErrorMessage.class);
                es.close();
                throw new RuntimeException(String.format("Unexpected HTTP error status %d for %s request to %s: %s", responseStatus, method, target, errorMessage.getMessage()));
            }
            if (responseStatus != 204) {
                InputStream is = connection.getInputStream();
                Object result = this.serializer.readValue(is, responseFormat);
                is.close();
                Object object = result;
                return (T)object;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            T t = null;
            return t;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected boolean finished(int iteration) {
        return this.consumedRecords >= this.targetRecords;
    }

    protected boolean runningFast(int iteration, float elapsed) {
        return (float)this.consumedRecords / elapsed > (float)this.recordsPerSec;
    }

    protected float getTargetIterationRate(int iteration, float elapsed) {
        if (iteration == 0) {
            return 1.0f;
        }
        float recordsPerIteration = (float)this.consumedRecords / (float)iteration;
        return (float)this.recordsPerSec / recordsPerIteration;
    }

    private static class UndecodedConsumerRecord {
        public String topic;
        public String key;
        public String value;
        public int partition;
        public long offset;

        private UndecodedConsumerRecord() {
        }
    }
}

