/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafkarest.response.JsonStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;

public final class JsonStreamMessageBodyReader
implements MessageBodyReader<JsonStream<?>> {
    private final ObjectMapper objectMapper;

    public JsonStreamMessageBodyReader(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonStream.class.equals(type) && MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType);
    }

    public JsonStream<?> readFrom(Class<JsonStream<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        JavaType wrappedType = this.objectMapper.constructType(genericType).containedType(0);
        return new JsonStream(() -> {
            try {
                JsonParser parser = this.objectMapper.createParser(entityStream);
                return this.objectMapper.readValues(parser, wrappedType);
            }
            catch (IOException e) {
                throw new BadRequestException("Unexpected error while starting JSON stream: ", (Throwable)e);
            }
        });
    }
}

