/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.PartitionManager;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.v3.GetPartitionResponse;
import io.confluent.kafkarest.entities.v3.ListPartitionsResponse;
import io.confluent.kafkarest.entities.v3.PartitionData;
import io.confluent.kafkarest.entities.v3.PartitionDataList;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/partitions")
@ResourceAccesslistFeature.ResourceName(value="api.v3.partitions.*")
public final class PartitionsResource {
    private final Provider<PartitionManager> partitionManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public PartitionsResource(Provider<PartitionManager> partitionManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.partitionManager = Objects.requireNonNull(partitionManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.partitions.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.partitions.list")
    public void listPartitions(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName) {
        CompletionStage response = ((PartitionManager)this.partitionManager.get()).listPartitions(clusterId, topicName).thenApply(partitions -> ListPartitionsResponse.create((PartitionDataList)((PartitionDataList.Builder)((PartitionDataList.Builder)PartitionDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "topics", topicName, "partitions")).build())).setData(partitions.stream().map(this::toPartitionData).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{partitionId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.partitions.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.partitions.get")
    public void getPartition(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="partitionId") Integer partitionId) {
        CompletionStage response = ((CompletableFuture)((PartitionManager)this.partitionManager.get()).getPartition(clusterId, topicName, partitionId).thenApply(partition -> (Partition)partition.orElseThrow(NotFoundException::new))).thenApply(partition -> GetPartitionResponse.create(this.toPartitionData((Partition)partition)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private PartitionData toPartitionData(Partition partition) {
        return PartitionsResource.toPartitionData(this.crnFactory, this.urlFactory, partition);
    }

    static PartitionData toPartitionData(CrnFactory crnFactory, UrlFactory urlFactory, Partition partition) {
        PartitionData.Builder partitionData = ((PartitionData.Builder)PartitionData.fromPartition(partition).setMetadata(Resource.Metadata.builder().setSelf(urlFactory.create("v3", "clusters", partition.getClusterId(), "topics", partition.getTopicName(), "partitions", Integer.toString(partition.getPartitionId()))).setResourceName(crnFactory.create("kafka", partition.getClusterId(), "topic", partition.getTopicName(), "partition", Integer.toString(partition.getPartitionId()))).build())).setReplicas(Resource.Relationship.create(urlFactory.create("v3", "clusters", partition.getClusterId(), "topics", partition.getTopicName(), "partitions", Integer.toString(partition.getPartitionId()), "replicas"))).setReassignment(Resource.Relationship.create(urlFactory.create("v3", "clusters", partition.getClusterId(), "topics", partition.getTopicName(), "partitions", Integer.toString(partition.getPartitionId()), "reassignment")));
        partition.getLeader().map(replica -> Resource.Relationship.create(urlFactory.create("v3", "clusters", partition.getClusterId(), "topics", partition.getTopicName(), "partitions", Integer.toString(partition.getPartitionId()), "replicas", Integer.toString(replica.getBrokerId())))).ifPresent(partitionData::setLeader);
        return partitionData.build();
    }
}

