/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.raft.KafkaRaftManager;
import kafka.server.DynamicBrokerConfig;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tmf\u0001B\"E\u0001%C\u0001B\u0016\u0001\u0003\u0006\u0004%Ia\u0016\u0005\t9\u0002\u0011\t\u0011)A\u00051\"AQ\f\u0001BC\u0002\u0013\u0005a\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003`\u0011!\u0019\u0007A!b\u0001\n\u0003!\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u0011I\u0004!Q1A\u0005\nMD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\tw\u0002\u0011)\u0019!C\u0001y\"I\u0011q\u0003\u0001\u0003\u0002\u0003\u0006I! \u0005\u000b\u00033\u0001!Q1A\u0005\u0002\u0005m\u0001BCA4\u0001\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u0011\u0011\u000e\u0001\u0003\u0006\u0004%\t!a\u001b\t\u0015\u0005M\u0004A!A!\u0002\u0013\ti\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u0013\u0005%\u0005A1A\u0005\n\u0005-\u0005\u0002CAJ\u0001\u0001\u0006I!!$\t\u0013\u0005U\u0005\u00011A\u0005\n\u0005]\u0005\"CAP\u0001\u0001\u0007I\u0011BAQ\u0011!\ti\u000b\u0001Q!\n\u0005e\u0005\"CAX\u0001\u0001\u0007I\u0011BAL\u0011%\t\t\f\u0001a\u0001\n\u0013\t\u0019\f\u0003\u0005\u00028\u0002\u0001\u000b\u0015BAM\u0011%\tI\f\u0001a\u0001\n\u0013\t9\nC\u0005\u0002<\u0002\u0001\r\u0011\"\u0003\u0002>\"A\u0011\u0011\u0019\u0001!B\u0013\tI\n\u0003\u0005\u0002D\u0002\u0011\r\u0011\"\u0001X\u0011\u001d\t)\r\u0001Q\u0001\naC\u0001\"a2\u0001\u0005\u0004%\ta\u0016\u0005\b\u0003\u0013\u0004\u0001\u0015!\u0003Y\u0011\u001d9\b\u00011A\u0005\u0002MD\u0011\"a3\u0001\u0001\u0004%\t!!4\t\u000f\u0005E\u0007\u0001)Q\u0005i\"Y\u00111\u001c\u0001A\u0002\u0003\u0007I\u0011AAo\u0011-\t)\u0010\u0001a\u0001\u0002\u0004%\t!a>\t\u0017\u0005m\b\u00011A\u0001B\u0003&\u0011q\u001c\u0005\f\u0003\u007f\u0004\u0001\u0019!a\u0001\n\u0003\u0011\t\u0001C\u0006\u0003\u0010\u0001\u0001\r\u00111A\u0005\u0002\tE\u0001b\u0003B\u000b\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0007A1B!\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\u001c!Y!\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011\u0001B\u0016\u0011-\u0011y\u0003\u0001a\u0001\u0002\u0003\u0006KA!\b\t\u0017\tM\u0002\u00011AA\u0002\u0013\u0005!Q\u0007\u0005\f\u0005\u000b\u0002\u0001\u0019!a\u0001\n\u0003\u00119\u0005C\u0006\u0003L\u0001\u0001\r\u0011!Q!\n\t]\u0002\"\u0003B(\u0001\t\u0007I\u0011\u0001B)\u0011!\u0011y\u0006\u0001Q\u0001\n\tM\u0003b\u0003B1\u0001\u0001\u0007\t\u0019!C\u0001\u0005GB1B!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003t!Y!q\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B3\u0011-\u0011Y\b\u0001a\u0001\u0002\u0004%\tA! \t\u0017\t\u0015\u0005\u00011AA\u0002\u0013\u0005!q\u0011\u0005\f\u0005\u0017\u0003\u0001\u0019!A!B\u0013\u0011y\bC\u0004\u0003\u0010\u0002!\tA!%\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\"9!q\u0013\u0001\u0005\u0002\tU\u0005b\u0002BM\u0001\u0011\u0005!Q\u0013\u0005\b\u00057\u0003A\u0011\u0001BK\u0011\u001d\u0011i\n\u0001C\u0001\u0005?CqA!,\u0001\t\u0003\u0011y\nC\u0004\u00030\u0002!\tAa(\t\u000f\tE\u0006\u0001\"\u0001\u0003 \"9!1\u0017\u0001\u0005\u0002\t}\u0005b\u0002B[\u0001\u0011%!Q\u0013\u0005\b\u0005o\u0003A\u0011\u0001BK\u0011\u001d\u0011I\f\u0001C\u0005\u0005+\u0013Ab\u00155be\u0016$7+\u001a:wKJT!!\u0012$\u0002\rM,'O^3s\u0015\u00059\u0015!B6bM.\f7\u0001A\n\u0004\u0001)\u0003\u0006CA&O\u001b\u0005a%\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c%AB!osJ+g\r\u0005\u0002R)6\t!K\u0003\u0002T\r\u0006)Q\u000f^5mg&\u0011QK\u0015\u0002\b\u0019><w-\u001b8h\u0003I\u0019\b.\u0019:fIN+'O^3s\u0007>tg-[4\u0016\u0003a\u0003\"!\u0017.\u000e\u0003\u0011K!a\u0017#\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0014g\"\f'/\u001a3TKJ4XM]\"p]\u001aLw\rI\u0001\n[\u0016$\u0018\r\u0015:paN,\u0012a\u0018\t\u00033\u0002L!!\u0019#\u0003\u001d5+G/\u0019)s_B,'\u000f^5fg\u0006QQ.\u001a;b!J|\u0007o\u001d\u0011\u0002\tQLW.Z\u000b\u0002KB\u0011am\\\u0007\u0002O*\u00111\u000b\u001b\u0006\u0003S*\faaY8n[>t'BA$l\u0015\taW.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0006\u0019qN]4\n\u0005A<'\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n\u0001bX7fiJL7m]\u000b\u0002iB\u0011Q\u000f_\u0007\u0002m*\u0011q\u000f[\u0001\b[\u0016$(/[2t\u0013\tIhOA\u0004NKR\u0014\u0018nY:\u0002\u0013}kW\r\u001e:jGN\u0004\u0013\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y+\u0005i\b\u0003B&\u007f\u0003\u0003I!a '\u0003\r=\u0003H/[8o!\u0011\t\u0019!!\u0005\u000f\t\u0005\u0015\u0011Q\u0002\t\u0004\u0003\u000faUBAA\u0005\u0015\r\tY\u0001S\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=A*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\t)B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001fa\u0015!\u0005;ie\u0016\fGMT1nKB\u0013XMZ5yA\u0005a2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,WCAA\u000f!\u0019\ty\"!\f\u000225\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\n\u0002*\u0005!Q\u000f^5m\u0015\t\tY#\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003C\u0011\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!!\t\u0019$!\u000e\u0002:\u0005\u0015SBAA\u0013\u0013\u0011\t9$!\n\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\u0011\ty$!\u000b\u0002\t1\fgnZ\u0005\u0005\u0003\u0007\niDA\u0004J]R,w-\u001a:\u0011\t\u0005\u001d\u0013\u0011\r\b\u0005\u0003\u0013\nYF\u0004\u0003\u0002L\u0005]c\u0002BA'\u0003+rA!a\u0014\u0002T9!\u0011qAA)\u0013\u0005q\u0017B\u00017n\u0013\t95.C\u0002\u0002Z)\fAA]1gi&!\u0011QLA0\u0003)\u0011\u0016M\u001a;D_:4\u0017n\u001a\u0006\u0004\u00033R\u0017\u0002BA2\u0003K\u00121\"\u00113ee\u0016\u001c8o\u00159fG*!\u0011QLA0\u0003u\u0019wN\u001c;s_2dWM])v_J,XNV8uKJ\u001ch)\u001e;ve\u0016\u0004\u0013a\u00054bk2$\b*\u00198eY\u0016\u0014h)Y2u_JLXCAA7!\rI\u0016qN\u0005\u0004\u0003c\"%a\u0005$bk2$\b*\u00198eY\u0016\u0014h)Y2u_JL\u0018\u0001\u00064bk2$\b*\u00198eY\u0016\u0014h)Y2u_JL\b%\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003s\nY(! \u0002\u0000\u0005\u0005\u00151QAC\u0003\u000f\u0003\"!\u0017\u0001\t\u000bY{\u0001\u0019\u0001-\t\u000bu{\u0001\u0019A0\t\u000b\r|\u0001\u0019A3\t\u000bI|\u0001\u0019\u0001;\t\u000bm|\u0001\u0019A?\t\u000f\u0005eq\u00021\u0001\u0002\u001e!9\u0011\u0011N\bA\u0002\u00055\u0014A\u00037pO\u000e{g\u000e^3yiV\u0011\u0011Q\u0012\t\u0004M\u0006=\u0015bAAIO\nQAj\\4D_:$X\r\u001f;\u0002\u00171|wmQ8oi\u0016DH\u000fI\u0001\bgR\f'\u000f^3e+\t\tI\nE\u0002L\u00037K1!!(M\u0005\u001d\u0011un\u001c7fC:\f1b\u001d;beR,Gm\u0018\u0013fcR!\u00111UAU!\rY\u0015QU\u0005\u0004\u0003Oc%\u0001B+oSRD\u0011\"a+\u0014\u0003\u0003\u0005\r!!'\u0002\u0007a$\u0013'\u0001\u0005ti\u0006\u0014H/\u001a3!\u00031)8/\u001a3Cs\n\u0013xn[3s\u0003A)8/\u001a3Cs\n\u0013xn[3s?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0006U\u0006\"CAV-\u0005\u0005\t\u0019AAM\u00035)8/\u001a3Cs\n\u0013xn[3sA\u0005\u0001Ro]3e\u0005f\u001cuN\u001c;s_2dWM]\u0001\u0015kN,GMQ=D_:$(o\u001c7mKJ|F%Z9\u0015\t\u0005\r\u0016q\u0018\u0005\n\u0003WK\u0012\u0011!a\u0001\u00033\u000b\u0011#^:fI\nK8i\u001c8ue>dG.\u001a:!\u00031\u0011'o\\6fe\u000e{gNZ5h\u00035\u0011'o\\6fe\u000e{gNZ5hA\u0005\u00012m\u001c8ue>dG.\u001a:D_:4\u0017nZ\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8gS\u001e\u0004\u0013aC7fiJL7m]0%KF$B!a)\u0002P\"A\u00111\u0016\u0011\u0002\u0002\u0003\u0007A/\u0001\u0005nKR\u0014\u0018nY:!Q\r\t\u0013Q\u001b\t\u0004\u0017\u0006]\u0017bAAm\u0019\nAao\u001c7bi&dW-A\u0006sC\u001a$X*\u00198bO\u0016\u0014XCAAp!\u0019\t\t/!:\u0002j6\u0011\u00111\u001d\u0006\u0004\u000332\u0015\u0002BAt\u0003G\u0014\u0001cS1gW\u0006\u0014\u0016M\u001a;NC:\fw-\u001a:\u0011\t\u0005-\u0018\u0011_\u0007\u0003\u0003[T1![Ax\u0015\t)%.\u0003\u0003\u0002t\u00065(\u0001F!qS6+7o]1hK\u0006sGMV3sg&|g.A\bsC\u001a$X*\u00198bO\u0016\u0014x\fJ3r)\u0011\t\u0019+!?\t\u0013\u0005-6%!AA\u0002\u0005}\u0017\u0001\u0004:bMRl\u0015M\\1hKJ\u0004\u0003f\u0001\u0013\u0002V\u0006i!M]8lKJlU\r\u001e:jGN,\"Aa\u0001\u0011\t\t\u0015!1B\u0007\u0003\u0005\u000fQ1A!\u0003E\u0003!iW\r^1eCR\f\u0017\u0002\u0002B\u0007\u0005\u000f\u00111C\u0011:pW\u0016\u00148+\u001a:wKJlU\r\u001e:jGN\f\u0011C\u0019:pW\u0016\u0014X*\u001a;sS\u000e\u001cx\fJ3r)\u0011\t\u0019Ka\u0005\t\u0013\u0005-f%!AA\u0002\t\r\u0011A\u00042s_.,'/T3ue&\u001c7\u000f\t\u0015\u0004O\u0005U\u0017!E2p]R\u0014x\u000e\u001c7fe6+GO]5dgV\u0011!Q\u0004\t\u0005\u0005?\u0011)#\u0004\u0002\u0003\")\u0019!1\u00056\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u0003(\t\u0005\"aF)v_J,XnQ8oiJ|G\u000e\\3s\u001b\u0016$(/[2t\u0003U\u0019wN\u001c;s_2dWM]'fiJL7m]0%KF$B!a)\u0003.!I\u00111V\u0015\u0002\u0002\u0003\u0007!QD\u0001\u0013G>tGO]8mY\u0016\u0014X*\u001a;sS\u000e\u001c\b\u0005K\u0002+\u0003+\fa\u0001\\8bI\u0016\u0014XC\u0001B\u001c!\u0011\u0011ID!\u0011\u000e\u0005\tm\"\u0002\u0002B\u001a\u0005{Q1Aa\u0010k\u0003\u0015IW.Y4f\u0013\u0011\u0011\u0019Ea\u000f\u0003\u001d5+G/\u00193bi\u0006du.\u00193fe\u0006QAn\\1eKJ|F%Z9\u0015\t\u0005\r&\u0011\n\u0005\n\u0003Wc\u0013\u0011!a\u0001\u0005o\tq\u0001\\8bI\u0016\u0014\b\u0005K\u0002.\u0003+\fac\u001d8baNDw\u000e^:ES\u0006\u0014G.\u001a3SK\u0006\u001cxN\\\u000b\u0003\u0005'\u0002bA!\u0016\u0003\\\u0005\u0005QB\u0001B,\u0015\u0011\u0011I&!\t\u0002\r\u0005$x.\\5d\u0013\u0011\u0011iFa\u0016\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\fqc\u001d8baNDw\u000e^:ES\u0006\u0014G.\u001a3SK\u0006\u001cxN\u001c\u0011\u0002\u001fMt\u0017\r]:i_R,U.\u001b;uKJ,\"A!\u001a\u0011\t\t\u001d$QN\u0007\u0003\u0005SRAAa\u001b\u0003>\u0005I\u0001/\u001e2mSNDWM]\u0005\u0005\u0005_\u0012IGA\bT]\u0006\u00048\u000f[8u\u000b6LG\u000f^3s\u0003M\u0019h.\u00199tQ>$X)\\5ui\u0016\u0014x\fJ3r)\u0011\t\u0019K!\u001e\t\u0013\u0005-\u0016'!AA\u0002\t\u0015\u0014\u0001E:oCB\u001c\bn\u001c;F[&$H/\u001a:!Q\r\u0011\u0014Q[\u0001\u0012g:\f\u0007o\u001d5pi\u001e+g.\u001a:bi>\u0014XC\u0001B@!\u0011\u00119G!!\n\t\t\r%\u0011\u000e\u0002\u0012':\f\u0007o\u001d5pi\u001e+g.\u001a:bi>\u0014\u0018!F:oCB\u001c\bn\u001c;HK:,'/\u0019;pe~#S-\u001d\u000b\u0005\u0003G\u0013I\tC\u0005\u0002,R\n\t\u00111\u0001\u0003\u0000\u0005\u00112O\\1qg\"|GoR3oKJ\fGo\u001c:!Q\r)\u0014Q[\u0001\u0007SN,6/\u001a3\u0015\u0005\u0005e\u0015AD:uCJ$hi\u001c:Ce>\\WM\u001d\u000b\u0003\u0003G\u000b!c\u001d;beR4uN]\"p]R\u0014x\u000e\u001c7fe\u0006i1\u000f^8q\r>\u0014(I]8lKJ\f\u0011c\u001d;pa\u001a{'oQ8oiJ|G\u000e\\3s\u0003]\u0011\u0018M\u001a;NC:\fw-\u001a:GCVdG\u000fS1oI2,'/\u0006\u0002\u0003\"B!!1\u0015BU\u001b\t\u0011)K\u0003\u0003\u0003(\u0006=\u0018!\u00024bk2$\u0018\u0002\u0002BV\u0005K\u0013ABR1vYRD\u0015M\u001c3mKJ\f!$\\3uC\u0012\fG/\u0019'pC\u0012,'OR1vYRD\u0015M\u001c3mKJ\fQ%\u001b8ji&\fGN\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rT8bI\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u00029E,xN];n\u0007>tGO]8mY\u0016\u0014h)Y;mi\"\u000bg\u000e\u001a7fe\u0006qR.\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001b8h\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u0006gR\f'\u000f^\u0001\u0014K:\u001cXO]3O_R\u0014\u0016M\u001a;MK\u0006$WM]\u0001\u0005gR|\u0007\u000f")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaProperties metaProps;
    private final Time time;
    private final Metrics _metrics;
    private final Option<String> threadNamePrefix;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final FaultHandlerFactory faultHandlerFactory;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private final KafkaConfig controllerConfig;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile QuorumControllerMetrics controllerMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDiabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaProperties metaProps() {
        return this.metaProps;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public Option<String> threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public QuorumControllerMetrics controllerMetrics() {
        return this.controllerMetrics;
    }

    public void controllerMetrics_$eq(QuorumControllerMetrics x$1) {
        this.controllerMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    public AtomicReference<String> snapshotsDiabledReason() {
        return this.snapshotsDiabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    public SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    public void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    public synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public FaultHandler raftManagerFaultHandler() {
        return this.faultHandlerFactory().build("raft manager", true, () -> {});
    }

    public FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$), () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataLoaderFaultHandler$2(x$7)));
                Option$.MODULE$.apply((Object)this.controllerMetrics()).foreach((Function1 & Serializable)x$8 -> {
                    x$8.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDiabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$initialBrokerMetadataLoadFaultHandler$2(x$9)));
                Option$.MODULE$.apply((Object)this.controllerMetrics()).foreach((Function1 & Serializable)x$10 -> {
                    x$10.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDiabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler quorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerMetrics()).foreach((Function1 & Serializable)x$11 -> {
                    x$11.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDiabledReason().compareAndSet(null, "quorum controller fault");
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataPublishingFaultHandler$2(x$12)));
                Option$.MODULE$.apply((Object)this.controllerMetrics()).foreach((Function1 & Serializable)x$13 -> {
                    x$13.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    private synchronized void start() {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
                Metrics apply_metrics = this.metrics();
                Object var5_1 = null;
                this.brokerMetrics_$eq(new BrokerServerMetrics(apply_metrics));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
                this.controllerMetrics_$eq(new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry(), this.time()));
            }
            KafkaRaftManager<ApiMessageAndVersion> _raftManager = new KafkaRaftManager<ApiMessageAndVersion>(this.metaProps(), this.sharedServerConfig(), (RecordSerde<ApiMessageAndVersion>)new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), this.threadNamePrefix(), this.controllerQuorumVotersFuture(), this.raftManagerFaultHandler());
            this.raftManager_$eq(_raftManager);
            _raftManager.startup();
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
                MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.metaProps().nodeId()).setTime(this.time()).setThreadNamePrefix((String)this.threadNamePrefix().getOrElse((Function0 & Serializable)() -> "")).setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> _raftManager.client().highWatermark());
                if (this.brokerMetrics() != null) {
                    loaderBuilder.setMetadataLoaderMetrics((MetadataLoaderMetrics)this.brokerMetrics());
                }
                this.loader_$eq(loaderBuilder.build());
                this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.metaProps().nodeId()).setRaftClient(_raftManager.client()).build());
                this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.metaProps().nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDiabledReason()).build());
                _raftManager.register((RaftClient.Listener<ApiMessageAndVersion>)this.loader());
                try {
                    this.loader().installPublishers(Collections.singletonList(this.snapshotGenerator()));
                }
                catch (Throwable t) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    throw new RuntimeException("Unable to install metadata publishers.", t);
                }
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.stop();
            return;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        Option$.MODULE$.apply(this.raftManager()).foreach((Function1 & Serializable)_raftManager -> {
            SharedServer.$anonfun$ensureNotRaftLeader$1(this, _raftManager);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().beginShutdown(), this, Level.WARN);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().beginShutdown(), this, Level.WARN);
        }
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().close(), this, Level.WARN);
            this.loader_$eq(null);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().close(), this, Level.WARN);
            this.snapshotGenerator_$eq(null);
        }
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftManager().shutdown(), this, Level.WARN);
            this.raftManager_$eq(null);
        }
        if (this.controllerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerMetrics().close(), this, Level.WARN);
            this.controllerMetrics_$eq(null);
        }
        if (this.brokerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.brokerMetrics().close(), this, Level.WARN);
            this.brokerMetrics_$eq(null);
        }
        if (this.metrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.metrics().close(), this, Level.WARN);
            this.metrics_$eq(null);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, Level.WARN);
        this.started_$eq(false);
    }

    public static final /* synthetic */ long $anonfun$metadataLoaderFaultHandler$2(BrokerServerMetrics x$7) {
        return x$7.metadataLoadErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$initialBrokerMetadataLoadFaultHandler$2(BrokerServerMetrics x$9) {
        return x$9.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$metadataPublishingFaultHandler$2(BrokerServerMetrics x$12) {
        return x$12.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ void $anonfun$ensureNotRaftLeader$1(SharedServer $this, KafkaRaftManager _raftManager) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> _raftManager.shutdown(), $this, Level.WARN);
        $this.raftManager_$eq(null);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaProperties metaProps, Time time, Metrics _metrics, Option<String> threadNamePrefix, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandlerFactory faultHandlerFactory) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaProps = metaProps;
        this.time = time;
        this._metrics = _metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.faultHandlerFactory = faultHandlerFactory;
        this.logContext = new LogContext(new StringBuilder(19).append("[SharedServer id=").append(sharedServerConfig.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.controllerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.metrics = _metrics;
        this.snapshotsDiabledReason = new AtomicReference<Object>(null);
    }
}

