/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.ConfigSource;
import io.confluent.kafkarest.entities.v3.BrokerConfigData;
import io.confluent.kafkarest.entities.v3.ConfigSynonymData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_BrokerConfigData
extends BrokerConfigData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final String name;
    private final Optional<String> value;
    private final boolean default0;
    private final boolean readOnly;
    private final boolean sensitive;
    private final ConfigSource source;
    private final ImmutableList<ConfigSynonymData> synonyms;
    private final int brokerId;

    private AutoValue_BrokerConfigData(String kind, Resource.Metadata metadata, String clusterId, String name, Optional<String> value, boolean default0, boolean readOnly, boolean sensitive, ConfigSource source, ImmutableList<ConfigSynonymData> synonyms, int brokerId) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.name = name;
        this.value = value;
        this.default0 = default0;
        this.readOnly = readOnly;
        this.sensitive = sensitive;
        this.source = source;
        this.synonyms = synonyms;
        this.brokerId = brokerId;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="value")
    public Optional<String> getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="is_default")
    public boolean isDefault() {
        return this.default0;
    }

    @Override
    @JsonProperty(value="is_read_only")
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    @JsonProperty(value="is_sensitive")
    public boolean isSensitive() {
        return this.sensitive;
    }

    @Override
    @JsonProperty(value="source")
    public ConfigSource getSource() {
        return this.source;
    }

    @Override
    @JsonProperty(value="synonyms")
    public ImmutableList<ConfigSynonymData> getSynonyms() {
        return this.synonyms;
    }

    @Override
    @JsonProperty(value="broker_id")
    public int getBrokerId() {
        return this.brokerId;
    }

    public String toString() {
        return "BrokerConfigData{kind=" + this.kind + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", name=" + this.name + ", value=" + this.value + ", default=" + this.default0 + ", readOnly=" + this.readOnly + ", sensitive=" + this.sensitive + ", source=" + (Object)((Object)this.source) + ", synonyms=" + this.synonyms + ", brokerId=" + this.brokerId + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BrokerConfigData) {
            BrokerConfigData that = (BrokerConfigData)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.name.equals(that.getName()) && this.value.equals(that.getValue()) && this.default0 == that.isDefault() && this.readOnly == that.isReadOnly() && this.sensitive == that.isSensitive() && this.source.equals((Object)that.getSource()) && this.synonyms.equals(that.getSynonyms()) && this.brokerId == that.getBrokerId();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.value.hashCode();
        h$ *= 1000003;
        h$ ^= this.default0 ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.readOnly ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.sensitive ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.source.hashCode();
        h$ *= 1000003;
        h$ ^= this.synonyms.hashCode();
        h$ *= 1000003;
        return h$ ^= this.brokerId;
    }

    static final class Builder
    extends BrokerConfigData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private String name;
        private Optional<String> value = Optional.empty();
        private Boolean default0;
        private Boolean readOnly;
        private Boolean sensitive;
        private ConfigSource source;
        private ImmutableList<ConfigSynonymData> synonyms;
        private Integer brokerId;

        Builder() {
        }

        @Override
        public BrokerConfigData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public BrokerConfigData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public BrokerConfigData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public BrokerConfigData.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public BrokerConfigData.Builder setValue(@Nullable String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @Override
        public BrokerConfigData.Builder setDefault(boolean default0) {
            this.default0 = default0;
            return this;
        }

        @Override
        public BrokerConfigData.Builder setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Override
        public BrokerConfigData.Builder setSensitive(boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        @Override
        public BrokerConfigData.Builder setSource(ConfigSource source) {
            if (source == null) {
                throw new NullPointerException("Null source");
            }
            this.source = source;
            return this;
        }

        @Override
        public BrokerConfigData.Builder setSynonyms(List<ConfigSynonymData> synonyms) {
            this.synonyms = ImmutableList.copyOf(synonyms);
            return this;
        }

        @Override
        public BrokerConfigData.Builder setBrokerId(int brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        @Override
        public BrokerConfigData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.default0 == null) {
                missing = missing + " default";
            }
            if (this.readOnly == null) {
                missing = missing + " readOnly";
            }
            if (this.sensitive == null) {
                missing = missing + " sensitive";
            }
            if (this.source == null) {
                missing = missing + " source";
            }
            if (this.synonyms == null) {
                missing = missing + " synonyms";
            }
            if (this.brokerId == null) {
                missing = missing + " brokerId";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BrokerConfigData(this.kind, this.metadata, this.clusterId, this.name, this.value, this.default0, this.readOnly, this.sensitive, this.source, this.synonyms, this.brokerId);
        }
    }
}

