/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.PartitionReplica;
import io.confluent.kafkarest.entities.v3.AutoValue_ReplicaData;
import io.confluent.kafkarest.entities.v3.Resource;

@AutoValue
public abstract class ReplicaData
extends Resource {
    ReplicaData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="topic_name")
    public abstract String getTopicName();

    @JsonProperty(value="partition_id")
    public abstract int getPartitionId();

    @JsonProperty(value="broker_id")
    public abstract int getBrokerId();

    @JsonProperty(value="is_leader")
    public abstract boolean isLeader();

    @JsonProperty(value="is_in_sync")
    public abstract boolean isInSync();

    @JsonProperty(value="broker")
    public abstract Resource.Relationship getBroker();

    public static Builder builder() {
        return new AutoValue_ReplicaData.Builder().setKind("KafkaReplica");
    }

    public static Builder fromPartitionReplica(PartitionReplica replica) {
        return ReplicaData.builder().setClusterId(replica.getClusterId()).setTopicName(replica.getTopicName()).setPartitionId(replica.getPartitionId()).setBrokerId(replica.getBrokerId()).setLeader(replica.isLeader()).setInSync(replica.isInSync());
    }

    @JsonCreator
    static ReplicaData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="topic_name") String topicName, @JsonProperty(value="partition_id") int partitionId, @JsonProperty(value="broker_id") int brokerId, @JsonProperty(value="is_leader") boolean isLeader, @JsonProperty(value="is_in_sync") boolean isInSync, @JsonProperty(value="broker") Resource.Relationship broker) {
        return ((Builder)((Builder)ReplicaData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setTopicName(topicName).setPartitionId(partitionId).setBrokerId(brokerId).setLeader(isLeader).setInSync(isInSync).setBroker(broker).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setTopicName(String var1);

        public abstract Builder setPartitionId(int var1);

        public abstract Builder setBrokerId(int var1);

        public abstract Builder setLeader(boolean var1);

        public abstract Builder setInSync(boolean var1);

        public abstract Builder setBroker(Resource.Relationship var1);

        public abstract ReplicaData build();
    }
}

