/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.extension;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public final class EnumConverterProvider
implements ParamConverterProvider {
    private static final Table<Class<?>, String, Enum<?>> enumMapper = Tables.synchronizedTable((Table)HashBasedTable.create());

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!Enum.class.isAssignableFrom(rawType)) {
            return null;
        }
        EnumConverter converter = new EnumConverter(rawType);
        if (enumMapper.containsRow(rawType)) {
            return converter;
        }
        List jsonValueMethods = Arrays.stream(rawType.getMethods()).filter(method -> method.getAnnotation(JsonValue.class) != null).collect(Collectors.toList());
        if (jsonValueMethods.size() > 1) {
            throw new RuntimeException("Multiple methods annotated with @JsonValue in " + rawType.getName());
        }
        if (jsonValueMethods.isEmpty()) {
            for (T constant : rawType.getEnumConstants()) {
                Enum casted = (Enum)constant;
                enumMapper.put(rawType, (Object)casted.name().toUpperCase(), (Object)casted);
            }
            return converter;
        }
        Method jsonValueMethod = (Method)jsonValueMethods.get(0);
        for (T constant : rawType.getEnumConstants()) {
            String returnedValue;
            try {
                returnedValue = (String)jsonValueMethod.invoke(constant, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("@JsonValue annotated method in %s is not public.", rawType.getName()));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(String.format("@JsonValue annotated method in %s does not return String.", rawType.getName()));
            }
            enumMapper.put(rawType, (Object)returnedValue.toUpperCase(), (Object)((Enum)constant));
        }
        return converter;
    }

    private static final class EnumConverter<T extends Enum<T>>
    implements ParamConverter<T> {
        private final Class<T> enumClass;

        private EnumConverter(Class<T> enumClass) {
            this.enumClass = Objects.requireNonNull(enumClass);
        }

        public T fromString(String value) {
            if (value == null) {
                return null;
            }
            Enum cached = (Enum)enumMapper.get(this.enumClass, (Object)value.toUpperCase());
            if (cached == null) {
                throw new WebApplicationException(String.format("The valid values for %s do not include '%s'", this.enumClass.getSimpleName(), value), Response.Status.NOT_FOUND.getStatusCode());
            }
            return (T)cached;
        }

        public String toString(T value) {
            throw new UnsupportedOperationException();
        }
    }
}

