/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ConsumerGroupManager;
import io.confluent.kafkarest.entities.ConsumerGroup;
import io.confluent.kafkarest.entities.v3.ConsumerGroupData;
import io.confluent.kafkarest.entities.v3.ConsumerGroupDataList;
import io.confluent.kafkarest.entities.v3.GetConsumerGroupResponse;
import io.confluent.kafkarest.entities.v3.ListConsumerGroupsResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/consumer-groups")
@ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-groups.*")
public final class ConsumerGroupsResource {
    private final Provider<ConsumerGroupManager> consumerGroupManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ConsumerGroupsResource(Provider<ConsumerGroupManager> consumerGroupManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.consumerGroupManager = Objects.requireNonNull(consumerGroupManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.consumer-groups.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-groups.list")
    public void listConsumerGroups(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((ConsumerGroupManager)this.consumerGroupManager.get()).listConsumerGroups(clusterId).thenApply(consumerGroups -> ListConsumerGroupsResponse.create((ConsumerGroupDataList)((ConsumerGroupDataList.Builder)((ConsumerGroupDataList.Builder)ConsumerGroupDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "consumer-groups")).build())).setData(consumerGroups.stream().map(consumerGroup -> this.toConsumerGroupData(clusterId, (ConsumerGroup)consumerGroup)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{consumerGroupId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.consumer-groups.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-groups.get")
    public void getConsumerGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId) {
        CompletionStage response = ((CompletableFuture)((ConsumerGroupManager)this.consumerGroupManager.get()).getConsumerGroup(clusterId, consumerGroupId).thenApply(consumerGroup -> (ConsumerGroup)consumerGroup.orElseThrow(NotFoundException::new))).thenApply(consumerGroup -> GetConsumerGroupResponse.create(this.toConsumerGroupData(clusterId, (ConsumerGroup)consumerGroup)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ConsumerGroupData toConsumerGroupData(String clusterId, ConsumerGroup consumerGroup) {
        return ((ConsumerGroupData.Builder)ConsumerGroupData.fromConsumerGroup(consumerGroup).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "consumer-groups", consumerGroup.getConsumerGroupId())).setResourceName(this.crnFactory.create("kafka", clusterId, "consumer-group", consumerGroup.getConsumerGroupId())).build())).setCoordinator(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", clusterId, "brokers", Integer.toString(consumerGroup.getCoordinator().getBrokerId())))).setConsumers(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", clusterId, "consumer-groups", consumerGroup.getConsumerGroupId(), "consumers"))).setLagSummary(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", clusterId, "consumer-groups", consumerGroup.getConsumerGroupId(), "lag-summary"))).build();
    }
}

