/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;

public class AssignmentMemberSpec {
    final Optional<String> instanceId;
    final Optional<String> rackId;
    final Collection<String> subscribedTopics;
    final Collection<TopicPartition> targetPartitions;

    public AssignmentMemberSpec(Optional<String> instanceId, Optional<String> rackId, Collection<String> subscribedTopics, Collection<TopicPartition> targetPartitions) {
        Objects.requireNonNull(instanceId);
        Objects.requireNonNull(rackId);
        Objects.requireNonNull(subscribedTopics);
        Objects.requireNonNull(targetPartitions);
        this.instanceId = instanceId;
        this.rackId = rackId;
        this.subscribedTopics = subscribedTopics;
        this.targetPartitions = targetPartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignmentMemberSpec that = (AssignmentMemberSpec)o;
        if (!this.instanceId.equals(that.instanceId)) {
            return false;
        }
        if (!this.rackId.equals(that.rackId)) {
            return false;
        }
        if (!this.subscribedTopics.equals(that.subscribedTopics)) {
            return false;
        }
        return this.targetPartitions.equals(that.targetPartitions);
    }

    public int hashCode() {
        int result = this.instanceId.hashCode();
        result = 31 * result + this.rackId.hashCode();
        result = 31 * result + this.subscribedTopics.hashCode();
        result = 31 * result + this.targetPartitions.hashCode();
        return result;
    }

    public String toString() {
        return "AssignmentMemberSpec(instanceId=" + this.instanceId + ", rackId=" + this.rackId + ", subscribedTopics=" + this.subscribedTopics + ", targetPartitions=" + this.targetPartitions + ')';
    }
}

