/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.config.SchemaRegistryConfig;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKafkaRestContext
implements KafkaRestContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultKafkaRestContext.class);
    private final KafkaRestConfig config;
    private KafkaConsumerManager kafkaConsumerManager;
    private SchemaRegistryClient schemaRegistryClient;

    public DefaultKafkaRestContext(KafkaRestConfig config) {
        log.debug("Creating context with config: {}", (Object)config);
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public KafkaRestConfig getConfig() {
        return this.config;
    }

    @Override
    public synchronized KafkaConsumerManager getKafkaConsumerManager() {
        if (this.kafkaConsumerManager == null) {
            this.kafkaConsumerManager = new KafkaConsumerManager(this.config);
        }
        return this.kafkaConsumerManager;
    }

    @Override
    public Admin getAdmin() {
        return AdminClient.create((Properties)this.config.getAdminProperties());
    }

    @Override
    public Producer<byte[], byte[]> getProducer() {
        return new KafkaProducer(this.config.getProducerConfigs(), (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    @Override
    public SchemaRegistryClient getSchemaRegistryClient() {
        if (!this.config.isSchemaRegistryEnabled()) {
            return null;
        }
        if (this.schemaRegistryClient == null) {
            SchemaRegistryConfig schemaRegistryConfig = new SchemaRegistryConfig(this.config.getSchemaRegistryConfigs());
            List schemaRegistryUrls = schemaRegistryConfig.getSchemaRegistryUrls().stream().map(URI::create).map(Object::toString).collect(Collectors.toList());
            this.schemaRegistryClient = new CachedSchemaRegistryClient(schemaRegistryUrls, schemaRegistryConfig.getMaxSchemasPerSubject(), SchemaRegistryConfig.SCHEMA_PROVIDERS, this.config.getSchemaRegistryConfigs(), schemaRegistryConfig.requestHeaders());
        }
        return this.schemaRegistryClient;
    }

    @Override
    public void shutdown() {
        log.debug("Shutting down");
        if (this.kafkaConsumerManager != null) {
            this.kafkaConsumerManager.shutdown();
        }
    }
}

