/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafkarest.response.JsonStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;

public final class JsonStreamMessageBodyReader
implements MessageBodyReader<JsonStream<?>> {
    private final ObjectMapper objectMapper;

    public JsonStreamMessageBodyReader(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonStream.class.equals(type) && MediaType.APPLICATION_JSON_TYPE.getType().equalsIgnoreCase(mediaType.getType()) && MediaType.APPLICATION_JSON_TYPE.getSubtype().equalsIgnoreCase(mediaType.getSubtype());
    }

    public JsonStream<?> readFrom(Class<JsonStream<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        String charset;
        if (mediaType.getParameters() != null && (charset = (String)mediaType.getParameters().get("charset")) != null && !charset.equalsIgnoreCase("UTF-8") && !charset.equalsIgnoreCase("ISO-8859-1")) {
            throw new WebApplicationException("Unsupported charset in Content-Type header. Supports \"UTF-8\" and \"ISO-8859-1\".", Response.Status.BAD_REQUEST);
        }
        JavaType wrappedType = this.objectMapper.constructType(genericType).containedType(0);
        return new JsonStream(() -> {
            try {
                JsonParser parser = this.objectMapper.createParser(entityStream);
                return this.objectMapper.readValues(parser, wrappedType);
            }
            catch (IOException e) {
                throw new BadRequestException("Unexpected error while starting JSON stream: ", (Throwable)e);
            }
        });
    }
}

