/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.epoch;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.slf4j.Logger;

public class LeaderEpochFileCache {
    private final TopicPartition topicPartition;
    private final LeaderEpochCheckpoint checkpoint;
    private final Logger log;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final TreeMap<Integer, EpochEntry> epochs = new TreeMap();

    public LeaderEpochFileCache(TopicPartition topicPartition, LeaderEpochCheckpoint checkpoint) {
        this.checkpoint = checkpoint;
        this.topicPartition = topicPartition;
        LogContext logContext = new LogContext("[LeaderEpochCache " + topicPartition + "] ");
        this.log = logContext.logger(LeaderEpochFileCache.class);
        checkpoint.read().forEach(this::assign);
    }

    public void assign(int epoch, long startOffset) {
        EpochEntry entry = new EpochEntry(epoch, startOffset);
        if (this.assign(entry)) {
            this.log.debug("Appended new epoch entry {}. Cache now contains {} entries.", (Object)entry, (Object)this.epochs.size());
            this.flush();
        }
    }

    public void assign(List<EpochEntry> entries) {
        entries.forEach(entry -> {
            if (this.assign((EpochEntry)entry)) {
                this.log.debug("Appended new epoch entry {}. Cache now contains {} entries.", entry, (Object)this.epochs.size());
            }
        });
        if (!entries.isEmpty()) {
            this.flush();
        }
    }

    private boolean isUpdateNeeded(EpochEntry entry) {
        return this.latestEntry().map(epochEntry -> entry.epoch != epochEntry.epoch || entry.startOffset < epochEntry.startOffset).orElse(true);
    }

    private boolean assign(EpochEntry entry) {
        if (entry.epoch < 0 || entry.startOffset < 0L) {
            throw new IllegalArgumentException("Received invalid partition leader epoch entry " + entry);
        }
        if (!this.isUpdateNeeded(entry)) {
            return false;
        }
        this.lock.writeLock().lock();
        try {
            if (this.isUpdateNeeded(entry)) {
                this.maybeTruncateNonMonotonicEntries(entry);
                this.epochs.put(entry.epoch, entry);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void maybeTruncateNonMonotonicEntries(EpochEntry newEntry) {
        List<EpochEntry> removedEpochs = this.removeFromEnd(entry -> entry.epoch >= newEntry.epoch || entry.startOffset >= newEntry.startOffset);
        if (removedEpochs.size() > 1 || !removedEpochs.isEmpty() && removedEpochs.get((int)0).startOffset != newEntry.startOffset) {
            this.log.warn("New epoch entry {} caused truncation of conflicting entries {}. Cache now contains {} entries.", new Object[]{newEntry, removedEpochs, this.epochs.size()});
        }
    }

    private List<EpochEntry> removeFromEnd(Predicate<EpochEntry> predicate) {
        return this.removeWhileMatching(this.epochs.descendingMap().entrySet().iterator(), predicate);
    }

    private List<EpochEntry> removeFromStart(Predicate<EpochEntry> predicate) {
        return this.removeWhileMatching(this.epochs.entrySet().iterator(), predicate);
    }

    private List<EpochEntry> removeWhileMatching(Iterator<Map.Entry<Integer, EpochEntry>> iterator, Predicate<EpochEntry> predicate) {
        ArrayList<EpochEntry> removedEpochs = new ArrayList<EpochEntry>();
        while (iterator.hasNext()) {
            EpochEntry entry = iterator.next().getValue();
            if (predicate.test(entry)) {
                removedEpochs.add(entry);
                iterator.remove();
                continue;
            }
            return removedEpochs;
        }
        return removedEpochs;
    }

    public LeaderEpochFileCache cloneWithLeaderEpochCheckpoint(LeaderEpochCheckpoint leaderEpochCheckpoint) {
        this.flushTo(leaderEpochCheckpoint);
        return new LeaderEpochFileCache(this.topicPartition, leaderEpochCheckpoint);
    }

    public boolean nonEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = !this.epochs.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<EpochEntry> latestEntry() {
        this.lock.readLock().lock();
        try {
            Optional<EpochEntry> optional = Optional.ofNullable(this.epochs.lastEntry()).map(Map.Entry::getValue);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public OptionalInt latestEpoch() {
        Optional<EpochEntry> entry = this.latestEntry();
        return entry.isPresent() ? OptionalInt.of(entry.get().epoch) : OptionalInt.empty();
    }

    public OptionalInt previousEpoch() {
        this.lock.readLock().lock();
        try {
            Optional lowerEntry = this.latestEntry().flatMap(entry -> Optional.ofNullable(this.epochs.lowerEntry(entry.epoch)));
            OptionalInt optionalInt = lowerEntry.isPresent() ? OptionalInt.of((Integer)((Map.Entry)lowerEntry.get()).getKey()) : OptionalInt.empty();
            return optionalInt;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<EpochEntry> earliestEntry() {
        this.lock.readLock().lock();
        try {
            Optional<EpochEntry> optional = Optional.ofNullable(this.epochs.firstEntry()).map(x -> (EpochEntry)x.getValue());
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public OptionalInt previousEpoch(int epoch) {
        this.lock.readLock().lock();
        try {
            OptionalInt optionalInt = LeaderEpochFileCache.toOptionalInt(this.epochs.lowerKey(epoch));
            return optionalInt;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public OptionalInt nextEpoch(int epoch) {
        this.lock.readLock().lock();
        try {
            OptionalInt optionalInt = LeaderEpochFileCache.toOptionalInt(this.epochs.higherKey(epoch));
            return optionalInt;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static OptionalInt toOptionalInt(Integer value) {
        return value != null ? OptionalInt.of(value) : OptionalInt.empty();
    }

    public Optional<EpochEntry> epochEntry(int epoch) {
        this.lock.readLock().lock();
        try {
            Optional<EpochEntry> optional = Optional.ofNullable(this.epochs.get(epoch));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Integer, Long> endOffsetFor(int requestedEpoch, long logEndOffset) {
        this.lock.readLock().lock();
        try {
            Map.Entry<Integer, EpochEntry> floorEntry;
            Map.Entry<Integer, EpochEntry> higherEntry;
            AbstractMap.SimpleImmutableEntry<Integer, Long> epochAndOffset = null;
            epochAndOffset = requestedEpoch == -1 ? new AbstractMap.SimpleImmutableEntry<Integer, Long>(-1, -1L) : (this.latestEpoch().isPresent() && this.latestEpoch().getAsInt() == requestedEpoch ? new AbstractMap.SimpleImmutableEntry<Integer, Long>(requestedEpoch, logEndOffset) : ((higherEntry = this.epochs.higherEntry(requestedEpoch)) == null ? new AbstractMap.SimpleImmutableEntry<Integer, Long>(-1, -1L) : ((floorEntry = this.epochs.floorEntry(requestedEpoch)) == null ? new AbstractMap.SimpleImmutableEntry<Integer, Long>(requestedEpoch, higherEntry.getValue().startOffset) : new AbstractMap.SimpleImmutableEntry<Integer, Long>(floorEntry.getValue().epoch, higherEntry.getValue().startOffset))));
            if (this.log.isTraceEnabled()) {
                this.log.trace("Processed end offset request for epoch {} and returning epoch {} with end offset {} from epoch cache of size {}}", new Object[]{requestedEpoch, epochAndOffset.getKey(), epochAndOffset.getValue(), this.epochs.size()});
            }
            AbstractMap.SimpleImmutableEntry<Integer, Long> simpleImmutableEntry = epochAndOffset;
            return simpleImmutableEntry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateFromEnd(long endOffset) {
        this.lock.writeLock().lock();
        try {
            Optional<EpochEntry> epochEntry = this.latestEntry();
            if (endOffset >= 0L && epochEntry.isPresent() && epochEntry.get().startOffset >= endOffset) {
                List<EpochEntry> removedEntries = this.removeFromEnd(x -> x.startOffset >= endOffset);
                this.flush();
                this.log.debug("Cleared entries {} from epoch cache after truncating to end offset {}, leaving {} entries in the cache.", new Object[]{removedEntries, endOffset, this.epochs.size()});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateFromStart(long startOffset) {
        this.lock.writeLock().lock();
        try {
            List<EpochEntry> removedEntries = this.removeFromStart(entry -> entry.startOffset <= startOffset);
            if (!removedEntries.isEmpty()) {
                EpochEntry firstBeforeStartOffset = removedEntries.get(removedEntries.size() - 1);
                EpochEntry updatedFirstEntry = new EpochEntry(firstBeforeStartOffset.epoch, startOffset);
                this.epochs.put(updatedFirstEntry.epoch, updatedFirstEntry);
                this.flush();
                this.log.debug("Cleared entries {} and rewrote first entry {} after truncating to start offset {}, leaving {} in the cache.", new Object[]{removedEntries, updatedFirstEntry, startOffset, this.epochs.size()});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionalInt epochForOffset(long offset) {
        this.lock.readLock().lock();
        try {
            OptionalInt previousEpoch = OptionalInt.empty();
            for (EpochEntry epochEntry : this.epochs.values()) {
                int epoch = epochEntry.epoch;
                long startOffset = epochEntry.startOffset;
                if (startOffset == offset) {
                    OptionalInt optionalInt = OptionalInt.of(epoch);
                    return optionalInt;
                }
                if (startOffset > offset) {
                    OptionalInt optionalInt = previousEpoch;
                    return optionalInt;
                }
                previousEpoch = OptionalInt.of(epoch);
            }
            OptionalInt optionalInt = previousEpoch;
            return optionalInt;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public LeaderEpochFileCache writeTo(LeaderEpochCheckpoint leaderEpochCheckpoint) {
        this.lock.readLock().lock();
        try {
            leaderEpochCheckpoint.write(this.epochEntries());
            LeaderEpochFileCache leaderEpochFileCache = new LeaderEpochFileCache(this.topicPartition, leaderEpochCheckpoint);
            return leaderEpochFileCache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clearAndFlush() {
        this.lock.writeLock().lock();
        try {
            this.epochs.clear();
            this.flush();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.epochs.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<EpochEntry> epochEntries() {
        this.lock.readLock().lock();
        try {
            ArrayList<EpochEntry> arrayList = new ArrayList<EpochEntry>(this.epochs.values());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void flushTo(LeaderEpochCheckpoint leaderEpochCheckpoint) {
        this.lock.readLock().lock();
        try {
            leaderEpochCheckpoint.write(this.epochs.values());
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void flush() {
        this.flushTo(this.checkpoint);
    }
}

