/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tmg!\u0002\u0015*\u0003\u0003q\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t1\u0002\u0011\t\u0011)A\u00053\"AA\f\u0001B\u0001B\u0003%Q\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0004i\u0001\t\u0007I\u0011A5\t\r5\u0004\u0001\u0015!\u0003k\u0011\u001dq\u0007A1A\u0005\u0002=Dq!!\u000b\u0001A\u0003%\u0001\u000fC\u0005\u0002,\u0001\u0011\r\u0011\"\u0001\u0002.!A\u0011\u0011\t\u0001!\u0002\u0013\ty\u0003C\u0005\u0002D\u0001\u0011\r\u0011\"\u0001\u0002F!A\u0011Q\n\u0001!\u0002\u0013\t9\u0005C\u0005\u0002P\u0001\u0011\r\u0011\"\u0001\u0002R!A\u00111\r\u0001!\u0002\u0013\t\u0019\u0006C\u0006\u0002f\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0004bCA5\u0001\u0001\u0007\t\u0019!C\u0005\u0003WB!\"a\u001e\u0001\u0001\u0004\u0005\t\u0015)\u0003G\u0011\u001d\tI\b\u0001D\u0001\u0003wB\u0011\"!1\u0001#\u0003%\t!a1\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011Q\u001c\u0001\u0005\u0002\u0005m\u0007bBAp\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u00119\u0002\u0001C\u0001\u00053AqAa\u0006\u0001\t\u0003\u0011)\u0003C\u0004\u0003\u0018\u0001!\tA!\u000b\t\u000f\t}\u0003\u0001\"\u0003\u0003b!9!\u0011\u000e\u0001\u0007\u0002\t-\u0004b\u0002B>\u0001\u0011%!Q\u0010\u0005\b\u0005\u0007\u0003a\u0011\u0001BC\u0011\u001d\u0011\t\n\u0001C\u0005\u0005'CqA!'\u0001\r\u0003\u0011Y\nC\u0004\u0003H\u0002!\tA!3\b\u0013\t5\u0017&!A\t\u0002\t=g\u0001\u0003\u0015*\u0003\u0003E\tA!5\t\r\u0001,C\u0011\u0001Bj\u0011%\u0011).JI\u0001\n\u0003\u00119N\u0001\u0013BEN$(/Y2u\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i\u0015\tQ3&\u0001\u0006d_:$(o\u001c7mKJT\u0011\u0001L\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001q&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005YJT\"A\u001c\u000b\u0005aZ\u0013!B;uS2\u001c\u0018B\u0001\u001e8\u0005\u001daunZ4j]\u001e\faaY8oM&<\u0007CA\u001fA\u001b\u0005q$BA ,\u0003\u0019\u0019XM\u001d<fe&\u0011\u0011I\u0010\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\tnKR\fG-\u0019;b!J|g/\u001b3feB\u0019\u0001\u0007\u0012$\n\u0005\u0015\u000b$!\u0003$v]\u000e$\u0018n\u001c81!\t9\u0005*D\u0001*\u0013\tI\u0015F\u0001\rD_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2\u001cuN\u001c;fqR\fq#\\3uC\u0012\fG/\u0019,feNLwN\u001c)s_ZLG-\u001a:\u0011\u0007A\"E\n\u0005\u0002N-6\taJ\u0003\u0002P!\u000611m\\7n_:T!aP)\u000b\u00051\u0012&BA*U\u0003\u0019\t\u0007/Y2iK*\tQ+A\u0002pe\u001eL!a\u0016(\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\f\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s!\t9%,\u0003\u0002\\S\t\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0002\u001f-\u0014\u0018M\u001a;D_:$(o\u001c7mKJ\u0004\"\u0001\r0\n\u0005}\u000b$a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\t\u001cG-\u001a4h!\t9\u0005\u0001C\u0003<\r\u0001\u0007A\bC\u0003C\r\u0001\u00071\tC\u0003K\r\u0001\u00071\nC\u0003Y\r\u0001\u0007\u0011\fC\u0004]\rA\u0005\t\u0019A/\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0003)\u0004\"\u0001M6\n\u00051\f$aA%oi\u0006i1m\u001c8ue>dG.\u001a:JI\u0002\na\u0003\\3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgRl\u0015\r]\u000b\u0002aB!\u0011O\u001e6y\u001b\u0005\u0011(BA:u\u0003\u001diW\u000f^1cY\u0016T!!^\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002xe\n\u0019Q*\u00199\u0011\tE4\u0018P \t\u0003url\u0011a\u001f\u0006\u0003\u001fFK!!`>\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0019q0a\t\u000f\t\u0005\u0005\u0011Q\u0004\b\u0005\u0003\u0007\tIB\u0004\u0003\u0002\u0006\u0005]a\u0002BA\u0004\u0003+qA!!\u0003\u0002\u00149!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u00105\na\u0001\u0010:p_Rt\u0014\"A+\n\u0005M#\u0016B\u0001\u0017S\u0013\ty\u0015+C\u0002\u0002\u001cm\fq!\\3tg\u0006<W-\u0003\u0003\u0002 \u0005\u0005\u0012a\u0006'fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$H)\u0019;b\u0015\r\tYb_\u0005\u0005\u0003K\t9C\u0001\u000eMK\u0006$WM]!oI&\u001b(\u000fU1si&$\u0018n\u001c8Ti\u0006$XM\u0003\u0003\u0002 \u0005\u0005\u0012a\u00067fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$X*\u00199!\u0003U\u0019Ho\u001c9SKBd\u0017nY1SKF,Xm\u001d;NCB,\"!a\f\u0011\u000bE4(.!\r\u0011\u000bE4\u00180a\r\u0011\t\u0005U\u00121\b\b\u0005\u0003\u0003\t9$\u0003\u0003\u0002:\u0005\u0005\u0012AF*u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgR$\u0015\r^1\n\t\u0005u\u0012q\b\u0002\u001a'R|\u0007OU3qY&\u001c\u0017\rU1si&$\u0018n\u001c8Ti\u0006$XM\u0003\u0003\u0002:\u0005\u0005\u0012AF:u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgRl\u0015\r\u001d\u0011\u0002=U\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\n\u0013xn[3s'\u0016$XCAA$!\u0011\t\u0018\u0011\n6\n\u0007\u0005-#OA\u0002TKR\fq$\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHO\u0011:pW\u0016\u00148+\u001a;!\u0003\u0015*\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0004\u0016M\u001d;ji&|g.\u00138g_6\u000b\u0007/\u0006\u0002\u0002TA)\u0011O^=\u0002VA!\u0011qKA/\u001d\u0011\t\t!!\u0017\n\t\u0005m\u0013\u0011E\u0001\u001a+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002`\u0005\u0005$\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\u0006\u0005\u00037\n\t#\u0001\u0014va\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;QCJ$\u0018\u000e^5p]&sgm\\'ba\u0002\n\u0001#\\3uC\u0012\fG/Y%ogR\fgnY3\u0016\u0003\u0019\u000bA#\\3uC\u0012\fG/Y%ogR\fgnY3`I\u0015\fH\u0003BA7\u0003g\u00022\u0001MA8\u0013\r\t\t(\r\u0002\u0005+:LG\u000f\u0003\u0005\u0002vI\t\t\u00111\u0001G\u0003\rAH%M\u0001\u0012[\u0016$\u0018\rZ1uC&s7\u000f^1oG\u0016\u0004\u0013aC:f]\u0012\u0014V-];fgR$\u0002\"!\u001c\u0002~\u0005\u0005\u0015\u0011\u0017\u0005\u0007\u0003\u007f\"\u0002\u0019\u00016\u0002\u0011\t\u0014xn[3s\u0013\u0012Dq!a!\u0015\u0001\u0004\t))A\u0004sKF,Xm\u001d;1\t\u0005\u001d\u0015q\u0014\t\u0007\u0003\u0013\u000b)*a'\u000f\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bS1!a$|\u0003!\u0011X-];fgR\u001c\u0018\u0002BAJ\u0003\u001b\u000ba#\u00112tiJ\f7\r^\"p]R\u0014x\u000e\u001c*fcV,7\u000f^\u0005\u0005\u0003/\u000bIJA\u0004Ck&dG-\u001a:\u000b\t\u0005M\u0015Q\u0012\t\u0005\u0003;\u000by\n\u0004\u0001\u0005\u0019\u0005\u0005\u0016\u0011QA\u0001\u0002\u0003\u0015\t!a)\u0003\u0007}#C'\u0005\u0003\u0002&\u0006-\u0006c\u0001\u0019\u0002(&\u0019\u0011\u0011V\u0019\u0003\u000f9{G\u000f[5oOB!\u00111RAW\u0013\u0011\ty+!$\u0003-\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c;s_2\u0014V-];fgRD\u0011\"a-\u0015!\u0003\u0005\r!!.\u0002\u0011\r\fG\u000e\u001c2bG.\u0004r\u0001MA\\\u0003w\u000bi'C\u0002\u0002:F\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\u0005-\u0015QX\u0005\u0005\u0003\u007f\u000biI\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\u0006)2/\u001a8e%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u001aTCAAcU\u0011\t),a2,\u0005\u0005%\u0007\u0003BAf\u0003+l!!!4\u000b\t\u0005=\u0017\u0011[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a52\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003/\fiMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001B\\3x\u0005\u0006$8\r\u001b\u000b\u0003\u0003[\nQa\u00197fCJ\f\u0001%\u00193e\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f\u001e$pe\n\u0013xn[3sgRa\u0011QNAr\u0003_\f\u00190!@\u0003\b!9\u0011Q\u001d\rA\u0002\u0005\u001d\u0018!\u00032s_.,'/\u00133t!\u0015\tI/a;k\u001b\u0005!\u0018bAAwi\n\u00191+Z9\t\r\u0005E\b\u00041\u0001z\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!>\u0019\u0001\u0004\t90A\u000emK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\t\u0004\u000f\u0006e\u0018bAA~S\tYB*Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"Dq!a@\u0019\u0001\u0004\u0011\t!A\tsKBd\u0017nY1BgNLwM\\7f]R\u00042a\u0012B\u0002\u0013\r\u0011)!\u000b\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bB\u0002B\u00051\u0001\u0007Q,A\u0003jg:+w/A\u0010bI\u0012\u001cFo\u001c9SKBd\u0017nY1SKF,Xm\u001d;G_J\u0014%o\\6feN$\u0002\"!\u001c\u0003\u0010\tE!1\u0003\u0005\b\u0003KL\u0002\u0019AAt\u0011\u0019\t\t0\u0007a\u0001s\"1!QC\rA\u0002u\u000bq\u0002Z3mKR,\u0007+\u0019:uSRLwN\\\u0001#C\u0012$W\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$hi\u001c:Ce>\\WM]:\u0015\r\u00055$1\u0004B\u000f\u0011\u001d\t)O\u0007a\u0001\u0003ODqAa\b\u001b\u0001\u0004\u0011\t#\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R!!;\u0003$eL1!a\u0013u)\u0011\tiGa\n\t\u000f\u0005\u00158\u00041\u0001\u0002hR!\u0012Q\u000eB\u0016\u0005[\u0011\tD!\u000e\u0003:\tu\"\u0011\tB,\u00057Bq!!:\u001d\u0001\u0004\t9\u000f\u0003\u0004\u00030q\u0001\rA[\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\"1!1\u0007\u000fA\u0002e\f\u0011\u0002]1si&$\u0018n\u001c8\t\r\t]B\u00041\u0001k\u0003\u0019aW-\u00193fe\"1!1\b\u000fA\u0002)\f1\u0002\\3bI\u0016\u0014X\t]8dQ\"1!q\b\u000fA\u0002)\fa\u0002]1si&$\u0018n\u001c8Fa>\u001c\u0007\u000eC\u0004\u0003Dq\u0001\rA!\u0012\u0002\t%\u001c(o\u001d\t\u0006\u0005\u000f\u0012\tF\u001b\b\u0005\u0005\u0013\u0012iE\u0004\u0003\u0002\f\t-\u0013\"\u0001\u001a\n\u0007\t=\u0013'A\u0004qC\u000e\\\u0017mZ3\n\t\tM#Q\u000b\u0002\u0005\u0019&\u001cHOC\u0002\u0003PEBqA!\u0017\u001d\u0001\u0004\t9/\u0001\u0005sKBd\u0017nY1t\u0011\u001d\u0011i\u0006\ba\u0001\u0003O\fqb\u001c4gY&tWMU3qY&\u001c\u0017m]\u0001\u0018g\u0016tG\rT3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgR$b!!\u001c\u0003d\t\u0015\u0004B\u0002B\u0018;\u0001\u0007!\u000e\u0003\u0004\u0003hu\u0001\r!W\u0001\u000fgR\fG/Z\"iC:<W\rT8h\u0003iA\u0017M\u001c3mK2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKN\u0004xN\\:f)\u0019\tiG!\u001c\u0003x!9!q\u000e\u0010A\u0002\tE\u0014\u0001\u0003:fgB|gn]3\u0011\t\u0005-%1O\u0005\u0005\u0005k\niI\u0001\u000bMK\u0006$WM]!oI&\u001b(OU3ta>t7/\u001a\u0005\u0007\u0005sr\u0002\u0019\u00016\u0002\r\t\u0014xn[3s\u0003i\u0019XM\u001c3Va\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;t)\u0019\tiGa \u0003\u0002\"1!qF\u0010A\u0002)DaAa\u001a \u0001\u0004I\u0016\u0001\b5b]\u0012dW-\u00169eCR,W*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a\u000b\u0007\u0003[\u00129Ia$\t\u000f\t=\u0004\u00051\u0001\u0003\nB!\u00111\u0012BF\u0013\u0011\u0011i)!$\u0003-U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016DaA!\u001f!\u0001\u0004Q\u0017aF:f]\u0012\u001cFo\u001c9SKBd\u0017nY1SKF,Xm\u001d;t)\u0019\tiG!&\u0003\u0018\"1!qF\u0011A\u0002)DaAa\u001a\"\u0001\u0004I\u0016!\u00075b]\u0012dWm\u0015;paJ+\u0007\u000f\\5dCJ+7\u000f]8og\u0016$\u0002\"!\u001c\u0003\u001e\n\u001d&\u0011\u0016\u0005\b\u0005?\u0013\u0003\u0019\u0001BQ\u0003M\u0019Ho\u001c9SKBd\u0017nY1SKN\u0004xN\\:f!\u0011\tYIa)\n\t\t\u0015\u0016Q\u0012\u0002\u0014'R|\u0007OU3qY&\u001c\u0017MU3ta>t7/\u001a\u0005\u0007\u0003\u007f\u0012\u0003\u0019\u00016\t\u000f\t-&\u00051\u0001\u0003.\u0006\u0001\u0003/\u0019:uSRLwN\\#se>\u00148OR8s\t\u0016dW\r^5oOR{\u0007/[2t!\u001d\u0011yKa.z\u0005wsAA!-\u00034B\u0019\u00111B\u0019\n\u0007\tU\u0016'\u0001\u0004Qe\u0016$WMZ\u0005\u0004o\ne&b\u0001B[cA!!Q\u0018Bb\u001b\t\u0011yLC\u0002\u0003Bn\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005\u000b\u0014yL\u0001\u0004FeJ|'o]\u0001\u0016g\u0016tGMU3rk\u0016\u001cHo\u001d+p\u0005J|7.\u001a:t)\u0011\tiGa3\t\r\t=2\u00051\u0001k\u0003\u0011\n%m\u001d;sC\u000e$8i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007CA$&'\t)s\u0006\u0006\u0002\u0003P\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"A!7+\u0007u\u000b9\r")
public abstract class AbstractControllerBrokerRequestBatch
implements Logging {
    private final KafkaConfig config;
    private final Function0<ControllerChannelContext> metadataProvider;
    private final Function0<MetadataVersion> metadataVersionProvider;
    private final StateChangeLogger stateChangeLogger;
    private final boolean kraftController;
    private final int controllerId;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> stopReplicaRequestMap;
    private final scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet;
    private final scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap;
    private ControllerChannelContext metadataInstance;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return false;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap() {
        return this.leaderAndIsrRequestMap;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> stopReplicaRequestMap() {
        return this.stopReplicaRequestMap;
    }

    public scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet() {
        return this.updateMetadataRequestBrokerSet;
    }

    public scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap() {
        return this.updateMetadataRequestPartitionInfoMap;
    }

    private ControllerChannelContext metadataInstance() {
        return this.metadataInstance;
    }

    private void metadataInstance_$eq(ControllerChannelContext x$1) {
        this.metadataInstance = x$1;
    }

    public abstract void sendRequest(int var1, AbstractControlRequest.Builder<? extends AbstractControlRequest> var2, Function1<AbstractResponse, BoxedUnit> var3);

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void newBatch() {
        if (this.leaderAndIsrRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(135).append("Controller to broker state change requests batch is not empty while creating ").append("a new one. Some LeaderAndIsr state changes ").append(this.leaderAndIsrRequestMap()).append(" might be lost ").toString());
        }
        if (this.stopReplicaRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(134).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some StopReplica state changes ").append(this.stopReplicaRequestMap()).append(" might be lost ").toString());
        }
        if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(169).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some UpdateMetadata state changes to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" with partition info ").append(this.updateMetadataRequestPartitionInfoMap()).append(" might be lost ").toString());
        }
        this.metadataInstance_$eq((ControllerChannelContext)this.metadataProvider.apply());
    }

    public void clear() {
        this.leaderAndIsrRequestMap().clear();
        this.stopReplicaRequestMap().clear();
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
        this.metadataInstance_$eq(null);
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, ReplicaAssignment replicaAssignment, boolean isNew) {
        ((IterableOnceOps)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$5 -> x$5 >= 0)).foreach((Function1 & Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$2(this, topicPartition, leaderIsrAndControllerEpoch, replicaAssignment, isNew, BoxesRunTime.unboxToInt((Object)brokerId)));
        this.addUpdateMetadataRequestForBrokers((Seq<Object>)this.metadataInstance().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition) {
        int leaderEpoch = this.metadataInstance().leaderEpoch(topicPartition);
        ((IterableOnceOps)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 >= 0)).foreach((Function1 & Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addStopReplicaRequestForBrokers$2(this, topicPartition, leaderEpoch, deletePartition, BoxesRunTime.unboxToInt((Object)brokerId)));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((IterableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$9 -> x$9 >= 0));
        partitions.foreach((Function1 & Serializable)partition -> {
            AbstractControllerBrokerRequestBatch.$anonfun$addUpdateMetadataRequestForBrokers$2(this, brokerIds, partition);
            return BoxedUnit.UNIT;
        });
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((IterableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$11 -> x$11 >= 0));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, int controllerEpoch, TopicPartition partition, int leader, int leaderEpoch, int partitionEpoch, List<Object> isrs, Seq<Object> replicas, Seq<Object> offlineReplicas) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((IterableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$12 -> x$12 >= 0));
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(partition.topic()).setPartitionIndex(partition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isrs.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setZkVersion(partitionEpoch).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setOfflineReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)offlineReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
        this.updateMetadataRequestPartitionInfoMap().put((Object)partition, (Object)partitionStateInfo);
    }

    private void sendLeaderAndIsrRequest(int controllerEpoch, StateChangeLogger stateChangeLog) {
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        int leaderAndIsrRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? 7 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_2_IV0) ? 6 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV1) ? 5 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? 4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV0) ? 3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? 2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_1_0_IV0) ? 1 : 0))))));
        this.leaderAndIsrRequestMap().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1$adapted(this, stateChangeLog, (short)leaderAndIsrRequestVersion, controllerEpoch, arg_0, arg_1), arg_0, arg_1));
        this.leaderAndIsrRequestMap().clear();
    }

    public abstract void handleLeaderAndIsrResponse(LeaderAndIsrResponse var1, int var2);

    private void sendUpdateMetadataRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        stateChangeLog.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Sending UpdateMetadata request to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" ").append("for ").append(this.updateMetadataRequestPartitionInfoMap().size()).append(" partitions").toString());
        Buffer partitionStates = this.updateMetadataRequestPartitionInfoMap().values().toBuffer();
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        int updateMetadataRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? 8 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV1) ? 7 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? 6 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? 5 : (metadataVersion.isAtLeast(MetadataVersion.IBP_1_0_IV0) ? 4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_2_IV0) ? 3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_0_IV1) ? 2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_9_0) ? 1 : 0)))))));
        Buffer liveBrokers = this.metadataInstance().liveOrShuttingDownBrokers().iterator().map(arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$2((short)updateMetadataRequestVersion, arg_0)).toBuffer();
        this.updateMetadataRequestBrokerSet().intersect(this.metadataInstance().liveOrShuttingDownBrokerIds()).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$4(this, partitionStates, (short)updateMetadataRequestVersion, controllerEpoch, liveBrokers, arg_0)));
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    public abstract void handleUpdateMetadataResponse(UpdateMetadataResponse var1, int var2);

    private void sendStopReplicaRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        boolean traceEnabled = stateChangeLog.isTraceEnabled();
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        short stopReplicaRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? (short)4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_6_IV0) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? (short)1 : 0)));
        this.stopReplicaRequestMap().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(brokerId, partitionStates) -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$2(this, traceEnabled, stateChangeLog, stopReplicaRequestVersion, controllerEpoch, BoxesRunTime.unboxToInt((Object)brokerId), partitionStates);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        this.stopReplicaRequestMap().clear();
    }

    public abstract void handleStopReplicaResponse(StopReplicaResponse var1, int var2, scala.collection.immutable.Map<TopicPartition, Errors> var3);

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(controllerEpoch);
            this.sendLeaderAndIsrRequest(controllerEpoch, stateChangeLog);
            this.sendUpdateMetadataRequests(controllerEpoch, stateChangeLog);
            this.sendStopReplicaRequests(controllerEpoch, stateChangeLog);
            return;
        }
        catch (Throwable e) {
            if (this.leaderAndIsrRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(100).append("Haven't been able to send leader and isr requests, current state of ").append("the map is ").append(this.leaderAndIsrRequestMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(124).append("Haven't been able to send metadata update requests to brokers ").append(this.updateMetadataRequestBrokerSet()).append(", ").append("current state of the partition info is ").append(this.updateMetadataRequestPartitionInfoMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.stopReplicaRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(98).append("Haven't been able to send stop replica requests, current state of ").append("the map is ").append(this.stopReplicaRequestMap()).append(". Exception message: ").append(e).toString());
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ Option $anonfun$addLeaderAndIsrRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, ReplicaAssignment replicaAssignment$1, boolean isNew$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.leaderAndIsrRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.empty());
        boolean alreadyNew = result.get((Object)topicPartition$1).exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isNew()));
        LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch$1.leaderAndIsr();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topicPartition$1.topic()).setPartitionIndex(topicPartition$1.partition()).setControllerEpoch(leaderIsrAndControllerEpoch$1.controllerEpoch()).setLeader(leaderAndIsr.leader()).setLeaderEpoch(leaderAndIsr.leaderEpoch()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaderAndIsr.isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setPartitionEpoch(leaderAndIsr.partitionEpoch()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment$1.replicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment$1.addingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment$1.removingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setIsNew(isNew$1 || alreadyNew);
        if (((MetadataVersion)$this.metadataVersionProvider.apply()).isAtLeast(MetadataVersion.IBP_3_2_IV0)) {
            partitionState.setLeaderRecoveryState(leaderAndIsr.leaderRecoveryState().value());
        }
        return result.put((Object)topicPartition$1, (Object)partitionState);
    }

    public static final /* synthetic */ Option $anonfun$addStopReplicaRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$2, int leaderEpoch$1, boolean deletePartition$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.stopReplicaRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.empty());
        boolean alreadyDelete = result.get((Object)topicPartition$2).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.deletePartition()));
        return result.put((Object)topicPartition$2, (Object)new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(topicPartition$2.partition()).setLeaderEpoch(leaderEpoch$1).setDeletePartition(alreadyDelete || deletePartition$1));
    }

    public static final /* synthetic */ void $anonfun$addUpdateMetadataRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, Seq brokerIds$1, TopicPartition partition) {
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
        boolean beingDeleted = $this.metadataInstance().isTopicQueuedUpForDeletion(partition.topic());
        Option<LeaderIsrAndControllerEpoch> option = $this.metadataInstance().partitionLeadershipInfo(partition);
        if (option instanceof Some && (leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value()) != null) {
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            int controllerEpoch = leaderIsrAndControllerEpoch.controllerEpoch();
            Seq<Object> replicas = $this.metadataInstance().partitionReplicaAssignment(partition);
            Seq offlineReplicas = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable)x$10 -> !$this.metadataInstance().isReplicaOnline(x$10, partition));
            LeaderAndIsr updatedLeaderAndIsr = beingDeleted ? LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr()) : leaderAndIsr;
            $this.addUpdateMetadataRequestForBrokers((Seq<Object>)brokerIds$1, controllerEpoch, partition, updatedLeaderAndIsr.leader(), updatedLeaderAndIsr.leaderEpoch(), updatedLeaderAndIsr.partitionEpoch(), updatedLeaderAndIsr.isr(), replicas, (Seq<Object>)offlineReplicas);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Leader not yet assigned for partition ").append(partition).append(". Skip sending UpdateMetadataRequest.").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$2(scala.collection.mutable.Set leaderIds$1, int broker$2, IntRef numBecomeLeaders$1, StateChangeLogger stateChangeLog$1, TopicPartition topicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState state) {
        String typeOfRequest;
        String string;
        leaderIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)state.leader()));
        if (broker$2 == state.leader()) {
            ++numBecomeLeaders$1.elem;
            string = "become-leader";
        } else {
            string = typeOfRequest = "become-follower";
        }
        if (stateChangeLog$1.isTraceEnabled()) {
            stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Sending ").append(typeOfRequest).append(" LeaderAndIsr request ").append(state).append(" to broker ").append(broker$2).append(" for partition ").append(topicPartition).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$10(AbstractControllerBrokerRequestBatch $this, int broker$2, AbstractResponse r) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)r;
        $this.handleLeaderAndIsrResponse(leaderAndIsrResponse, broker$2);
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$1(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, int broker, scala.collection.mutable.Map leaderAndIsrPartitionStates) {
        if ($this.metadataInstance().liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)broker))) {
            scala.collection.mutable.Set leaderIds = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
            IntRef numBecomeLeaders = IntRef.create((int)0);
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, state) -> {
                AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$2(leaderIds, broker, numBecomeLeaders, stateChangeLog$1, topicPartition, state);
                return BoxedUnit.UNIT;
            };
            leaderAndIsrPartitionStates.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var13_8 = null;
            stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(91).append("Sending LeaderAndIsr request to broker ").append(broker).append(" with ").append(numBecomeLeaders$1.elem).append(" become-leader ").append("and ").append(leaderAndIsrPartitionStates.size() - numBecomeLeaders$1.elem).append(" become-follower partitions").toString());
            Set leaders = (Set)((IterableOps)$this.metadataInstance().liveOrShuttingDownBrokers().filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)leaderIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).map((Function1 & Serializable)x$13 -> x$13.node($this.config.interBrokerListenerName()));
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
            scala.collection.immutable.Map topicIds = ((IterableOnceOps)((IterableOnceOps)leaderAndIsrPartitionStates.keys().map((Function1 & Serializable)x$14 -> x$14.topic())).toSet().map((Function1 & Serializable)topic -> new Tuple2(topic, $this.metadataInstance().topicIds().getOrElse(topic, (Function0 & Serializable)() -> Uuid.ZERO_UUID)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            LeaderAndIsrRequest.Builder leaderAndIsrRequestBuilder = new LeaderAndIsrRequest.Builder(leaderAndIsrRequestVersion$1, $this.controllerId(), controllerEpoch$1, brokerEpoch, CollectionConverters$.MODULE$.BufferHasAsJava(leaderAndIsrPartitionStates.values().toBuffer()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)topicIds).asJava(), (Collection)CollectionConverters$.MODULE$.SetHasAsJava(leaders).asJava(), $this.kraftController);
            $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)leaderAndIsrRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable)r -> {
                AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$10($this, broker, r);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$sendUpdateMetadataRequests$2(short updateMetadataRequestVersion$1, Broker broker) {
        Seq seq;
        if (updateMetadataRequestVersion$1 == 0) {
            SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
            Node node = broker.node(listenerName);
            seq = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(node.host()).setPort(node.port()).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$);
        } else {
            seq = (Seq)broker.endPoints().map((Function1 & Serializable)endpoint -> new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id).setListener(endpoint.listenerName().value()));
        }
        Seq endpoints = seq;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(broker.id()).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava(endpoints).asJava()).setRack((String)broker.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$8(AbstractControllerBrokerRequestBatch $this, int broker$3, AbstractResponse r) {
        UpdateMetadataResponse updateMetadataResponse = (UpdateMetadataResponse)r;
        $this.handleUpdateMetadataResponse(updateMetadataResponse, broker$3);
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$4(AbstractControllerBrokerRequestBatch $this, Buffer partitionStates$1, short updateMetadataRequestVersion$1, int controllerEpoch$2, Buffer liveBrokers$1, int broker) {
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
        scala.collection.immutable.Map topicIds = ((IterableOnceOps)((IterableOps)((IterableOps)((SeqOps)partitionStates$1.map((Function1 & Serializable)x$15 -> x$15.topicName())).distinct()).filter(arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$6$adapted($this.metadataInstance().topicIds(), arg_0))).map((Function1 & Serializable)topic -> new Tuple2(topic, $this.metadataInstance().topicIds().apply(topic)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        UpdateMetadataRequest.Builder updateMetadataRequestBuilder = new UpdateMetadataRequest.Builder(updateMetadataRequestVersion$1, $this.controllerId(), controllerEpoch$2, brokerEpoch, CollectionConverters$.MODULE$.BufferHasAsJava(partitionStates$1).asJava(), CollectionConverters$.MODULE$.BufferHasAsJava(liveBrokers$1).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)topicIds).asJava(), $this.kraftController);
        $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)updateMetadataRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable)r -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$8($this, broker, r);
            return BoxedUnit.UNIT;
        });
    }

    private final void responseCallback$1(int brokerId, Function1 isPartitionDeleted, AbstractResponse response) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map partitionErrorsForDeletingTopics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        stopReplicaResponse.partitionErrors().forEach(pe -> {
            TopicPartition tp = new TopicPartition(pe.topicName(), pe.partitionIndex());
            if (this.metadataInstance().isTopicDeletionInProgress(pe.topicName()) && BoxesRunTime.unboxToBoolean((Object)isPartitionDeleted.apply((Object)tp))) {
                partitionErrorsForDeletingTopics.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.forCode((short)pe.errorCode())));
                return;
            }
        });
        if (partitionErrorsForDeletingTopics.nonEmpty()) {
            this.handleStopReplicaResponse(stopReplicaResponse, brokerId, (scala.collection.immutable.Map<TopicPartition, Errors>)partitionErrorsForDeletingTopics.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$5(scala.collection.mutable.Map stopReplicaTopicState$1, TopicPartition topicPartition, StopReplicaRequestData.StopReplicaPartitionState partitionState) {
        return ((StopReplicaRequestData.StopReplicaTopicState)stopReplicaTopicState$1.getOrElseUpdate((Object)topicPartition.topic(), (Function0 & Serializable)() -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topicPartition.topic()))).partitionStates().add(partitionState);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$8(scala.collection.mutable.Map partitionStates$2, TopicPartition tp) {
        return partitionStates$2.get((Object)tp).exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.deletePartition()));
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$11(IntRef numPartitionStateWithDelete$1, scala.collection.mutable.Map topicStatesWithDelete$1, IntRef numPartitionStateWithoutDelete$1, scala.collection.mutable.Map topicStatesWithoutDelete$1, TopicPartition topicPartition, StopReplicaRequestData.StopReplicaPartitionState partitionState) {
        scala.collection.mutable.Map map;
        if (partitionState.deletePartition()) {
            ++numPartitionStateWithDelete$1.elem;
            map = topicStatesWithDelete$1;
        } else {
            ++numPartitionStateWithoutDelete$1.elem;
            map = topicStatesWithoutDelete$1;
        }
        return ((StopReplicaRequestData.StopReplicaTopicState)map.getOrElseUpdate((Object)topicPartition.topic(), (Function0 & Serializable)() -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topicPartition.topic()))).partitionStates().add(partitionState);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$14(TopicPartition x$17) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$2(AbstractControllerBrokerRequestBatch $this, boolean traceEnabled$1, StateChangeLogger stateChangeLog$2, short stopReplicaRequestVersion$1, int controllerEpoch$3, int brokerId, scala.collection.mutable.Map partitionStates) {
        if ($this.metadataInstance().liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
            if (traceEnabled$1) {
                Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, partitionState) -> {
                    stateChangeLog$2.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Sending StopReplica request ").append(partitionState).append(" to ").append("broker ").append(brokerId$2).append(" for partition ").append(topicPartition).toString());
                    return BoxedUnit.UNIT;
                };
                partitionStates.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
                Object var19_7 = null;
            }
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            if (stopReplicaRequestVersion$1 >= 3) {
                scala.collection.mutable.Map stopReplicaTopicState = (scala.collection.mutable.Map)Map$.MODULE$.empty();
                Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, partitionState) -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$5(stopReplicaTopicState, topicPartition, partitionState));
                partitionStates.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
                Object var20_10 = null;
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Sending StopReplica request for ").append(partitionStates.size()).append(" ").append("replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, false, CollectionConverters$.MODULE$.BufferHasAsJava(stopReplicaTopicState.values().toBuffer()).asJava(), $this.kraftController);
                Function1 & Serializable intersect = (Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$8(partitionStates, tp));
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable)response -> {
                    $this.responseCallback$1(brokerId, intersect, response);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            IntRef numPartitionStateWithDelete = IntRef.create((int)0);
            IntRef numPartitionStateWithoutDelete = IntRef.create((int)0);
            scala.collection.mutable.Map topicStatesWithDelete = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            scala.collection.mutable.Map topicStatesWithoutDelete = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, partitionState) -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$11(numPartitionStateWithDelete, topicStatesWithDelete, numPartitionStateWithoutDelete, topicStatesWithoutDelete, topicPartition, partitionState));
            partitionStates.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var21_17 = null;
            if (topicStatesWithDelete.nonEmpty()) {
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Sending StopReplica request (delete = true) for ").append(numPartitionStateWithDelete$1.elem).append(" replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, true, CollectionConverters$.MODULE$.BufferHasAsJava(topicStatesWithDelete.values().toBuffer()).asJava(), $this.kraftController);
                Function1 & Serializable intersect = (Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$14(x$17));
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable)response -> {
                    $this.responseCallback$1(brokerId, intersect, response);
                    return BoxedUnit.UNIT;
                });
            }
            if (topicStatesWithoutDelete.nonEmpty()) {
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Sending StopReplica request (delete = false) for ").append(numPartitionStateWithoutDelete$1.elem).append(" replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, false, CollectionConverters$.MODULE$.BufferHasAsJava(topicStatesWithoutDelete.values().toBuffer()).asJava(), $this.kraftController);
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, $this.sendRequest$default$3());
                return;
            }
            return;
        }
    }

    public AbstractControllerBrokerRequestBatch(KafkaConfig config, Function0<ControllerChannelContext> metadataProvider, Function0<MetadataVersion> metadataVersionProvider, StateChangeLogger stateChangeLogger, boolean kraftController) {
        this.config = config;
        this.metadataProvider = metadataProvider;
        this.metadataVersionProvider = metadataVersionProvider;
        this.stateChangeLogger = stateChangeLogger;
        this.kraftController = kraftController;
        this.controllerId = config.brokerId();
        this.leaderAndIsrRequestMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.stopReplicaRequestMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.updateMetadataRequestBrokerSet = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
        this.updateMetadataRequestPartitionInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$sendLeaderAndIsrRequest$1$adapted(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, Object broker, scala.collection.mutable.Map leaderAndIsrPartitionStates) {
        AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1($this, stateChangeLog$1, leaderAndIsrRequestVersion$1, controllerEpoch$1, BoxesRunTime.unboxToInt((Object)broker), leaderAndIsrPartitionStates);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$sendUpdateMetadataRequests$6$adapted(Map eta$0$1$1, String key) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains((Object)key));
    }
}

