/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.storage.internals.log.LeaderHwChange;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;

public class LogAppendInfo {
    public static final LogAppendInfo UNKNOWN_LOG_APPEND_INFO = new LogAppendInfo(Optional.empty(), -1L, OptionalInt.empty(), -1L, -1L, -1L, -1L, RecordConversionStats.EMPTY, CompressionType.NONE, CompressionType.NONE, -1, -1, false, -1L);
    private Optional<LogOffsetMetadata> firstOffset;
    private long lastOffset;
    private long maxTimestamp;
    private long offsetOfMaxTimestamp;
    private long logAppendTime;
    private long logStartOffset;
    private RecordConversionStats recordConversionStats;
    private final OptionalInt lastLeaderEpoch;
    private final CompressionType sourceCompression;
    private final CompressionType targetCompression;
    private final int shallowCount;
    private final int validBytes;
    private final boolean offsetsMonotonic;
    private final long lastOffsetOfFirstBatch;
    private final List<ProduceResponse.RecordError> recordErrors;
    private final String errorMessage;
    private final LeaderHwChange leaderHwChange;

    public LogAppendInfo(Optional<LogOffsetMetadata> firstOffset, long lastOffset, OptionalInt lastLeaderEpoch, long maxTimestamp, long offsetOfMaxTimestamp, long logAppendTime, long logStartOffset, RecordConversionStats recordConversionStats, CompressionType sourceCompression, CompressionType targetCompression, int shallowCount, int validBytes, boolean offsetsMonotonic, long lastOffsetOfFirstBatch) {
        this(firstOffset, lastOffset, lastLeaderEpoch, maxTimestamp, offsetOfMaxTimestamp, logAppendTime, logStartOffset, recordConversionStats, sourceCompression, targetCompression, shallowCount, validBytes, offsetsMonotonic, lastOffsetOfFirstBatch, Collections.emptyList(), null, LeaderHwChange.NONE);
    }

    public LogAppendInfo(Optional<LogOffsetMetadata> firstOffset, long lastOffset, OptionalInt lastLeaderEpoch, long maxTimestamp, long offsetOfMaxTimestamp, long logAppendTime, long logStartOffset, RecordConversionStats recordConversionStats, CompressionType sourceCompression, CompressionType targetCompression, int shallowCount, int validBytes, boolean offsetsMonotonic, long lastOffsetOfFirstBatch, List<ProduceResponse.RecordError> recordErrors, String errorMessage, LeaderHwChange leaderHwChange) {
        this.firstOffset = firstOffset;
        this.lastOffset = lastOffset;
        this.lastLeaderEpoch = lastLeaderEpoch;
        this.maxTimestamp = maxTimestamp;
        this.offsetOfMaxTimestamp = offsetOfMaxTimestamp;
        this.logAppendTime = logAppendTime;
        this.logStartOffset = logStartOffset;
        this.recordConversionStats = recordConversionStats;
        this.sourceCompression = sourceCompression;
        this.targetCompression = targetCompression;
        this.shallowCount = shallowCount;
        this.validBytes = validBytes;
        this.offsetsMonotonic = offsetsMonotonic;
        this.lastOffsetOfFirstBatch = lastOffsetOfFirstBatch;
        this.recordErrors = recordErrors;
        this.errorMessage = errorMessage;
        this.leaderHwChange = leaderHwChange;
    }

    public Optional<LogOffsetMetadata> firstOffset() {
        return this.firstOffset;
    }

    public void setFirstOffset(Optional<LogOffsetMetadata> firstOffset) {
        this.firstOffset = firstOffset;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public void setLastOffset(long lastOffset) {
        this.lastOffset = lastOffset;
    }

    public OptionalInt lastLeaderEpoch() {
        return this.lastLeaderEpoch;
    }

    public long maxTimestamp() {
        return this.maxTimestamp;
    }

    public void setMaxTimestamp(long maxTimestamp) {
        this.maxTimestamp = maxTimestamp;
    }

    public long offsetOfMaxTimestamp() {
        return this.offsetOfMaxTimestamp;
    }

    public void setOffsetOfMaxTimestamp(long offsetOfMaxTimestamp) {
        this.offsetOfMaxTimestamp = offsetOfMaxTimestamp;
    }

    public long logAppendTime() {
        return this.logAppendTime;
    }

    public void setLogAppendTime(long logAppendTime) {
        this.logAppendTime = logAppendTime;
    }

    public long logStartOffset() {
        return this.logStartOffset;
    }

    public void setLogStartOffset(long logStartOffset) {
        this.logStartOffset = logStartOffset;
    }

    public RecordConversionStats recordConversionStats() {
        return this.recordConversionStats;
    }

    public void setRecordConversionStats(RecordConversionStats recordConversionStats) {
        this.recordConversionStats = recordConversionStats;
    }

    public CompressionType sourceCompression() {
        return this.sourceCompression;
    }

    public CompressionType targetCompression() {
        return this.targetCompression;
    }

    public int shallowCount() {
        return this.shallowCount;
    }

    public int validBytes() {
        return this.validBytes;
    }

    public boolean offsetsMonotonic() {
        return this.offsetsMonotonic;
    }

    public List<ProduceResponse.RecordError> recordErrors() {
        return this.recordErrors;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public LeaderHwChange leaderHwChange() {
        return this.leaderHwChange;
    }

    public long firstOrLastOffsetOfFirstBatch() {
        return this.firstOffset.map(x -> x.messageOffset).orElse(this.lastOffsetOfFirstBatch);
    }

    public long numMessages() {
        if (this.firstOffset.isPresent() && this.firstOffset.get().messageOffset >= 0L && this.lastOffset >= 0L) {
            return this.lastOffset - this.firstOffset.get().messageOffset + 1L;
        }
        return 0L;
    }

    public LogAppendInfo copy(LeaderHwChange newLeaderHwChange) {
        return new LogAppendInfo(this.firstOffset, this.lastOffset, this.lastLeaderEpoch, this.maxTimestamp, this.offsetOfMaxTimestamp, this.logAppendTime, this.logStartOffset, this.recordConversionStats, this.sourceCompression, this.targetCompression, this.shallowCount, this.validBytes, this.offsetsMonotonic, this.lastOffsetOfFirstBatch, this.recordErrors, this.errorMessage, newLeaderHwChange);
    }

    public static LogAppendInfo unknownLogAppendInfoWithLogStartOffset(long logStartOffset) {
        return new LogAppendInfo(Optional.empty(), -1L, OptionalInt.empty(), -1L, -1L, -1L, logStartOffset, RecordConversionStats.EMPTY, CompressionType.NONE, CompressionType.NONE, -1, -1, false, -1L);
    }

    public static LogAppendInfo unknownLogAppendInfoWithAdditionalInfo(long logStartOffset, List<ProduceResponse.RecordError> recordErrors, String errorMessage) {
        return new LogAppendInfo(Optional.empty(), -1L, OptionalInt.empty(), -1L, -1L, -1L, logStartOffset, RecordConversionStats.EMPTY, CompressionType.NONE, CompressionType.NONE, -1, -1, false, -1L, recordErrors, errorMessage, LeaderHwChange.NONE);
    }

    public String toString() {
        return "LogAppendInfo(firstOffset=" + this.firstOffset + ", lastOffset=" + this.lastOffset + ", lastLeaderEpoch=" + this.lastLeaderEpoch + ", maxTimestamp=" + this.maxTimestamp + ", offsetOfMaxTimestamp=" + this.offsetOfMaxTimestamp + ", logAppendTime=" + this.logAppendTime + ", logStartOffset=" + this.logStartOffset + ", recordConversionStats=" + this.recordConversionStats + ", sourceCompression=" + this.sourceCompression + ", targetCompression=" + this.targetCompression + ", shallowCount=" + this.shallowCount + ", validBytes=" + this.validBytes + ", offsetsMonotonic=" + this.offsetsMonotonic + ", lastOffsetOfFirstBatch=" + this.lastOffsetOfFirstBatch + ", recordErrors=" + this.recordErrors + ", errorMessage='" + this.errorMessage + '\'' + ", leaderHwChange=" + (Object)((Object)this.leaderHwChange) + ')';
    }
}

