/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.AutoValue_ProduceResult;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.RecordMetadata;

@AutoValue
public abstract class ProduceResult {
    ProduceResult() {
    }

    public abstract int getPartitionId();

    public abstract long getOffset();

    public abstract Optional<Instant> getTimestamp();

    public abstract int getSerializedKeySize();

    public abstract int getSerializedValueSize();

    public abstract Instant getCompletionTimestamp();

    public static ProduceResult create(int partitionId, long offset, @Nullable Instant timestamp, int serializedKeySize, int serializedValueSize, Instant completionTimestamp) {
        return new AutoValue_ProduceResult(partitionId, offset, Optional.ofNullable(timestamp), serializedKeySize, serializedValueSize, completionTimestamp);
    }

    public static ProduceResult fromRecordMetadata(RecordMetadata metadata, Instant completionTimestamp) {
        return ProduceResult.create(metadata.partition(), metadata.offset(), metadata.hasTimestamp() ? Instant.ofEpochMilli(metadata.timestamp()) : null, metadata.serializedKeySize(), metadata.serializedValueSize(), completionTimestamp);
    }

    public static ProduceResult fromRecordMetadata(RecordMetadata metadata) {
        return ProduceResult.create(metadata.partition(), metadata.offset(), metadata.hasTimestamp() ? Instant.ofEpochMilli(metadata.timestamp()) : null, metadata.serializedKeySize(), metadata.serializedValueSize(), Instant.now());
    }
}

