/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.metadata.storage.CommittedOffsetsFile;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataTopicPartitioner;
import org.apache.kafka.server.log.remote.metadata.storage.RemotePartitionMetadataEventHandler;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataSerde;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsumerTask
implements Runnable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerTask.class);
    private static final long POLL_INTERVAL_MS = 100L;
    private final RemoteLogMetadataSerde serde = new RemoteLogMetadataSerde();
    private final KafkaConsumer<byte[], byte[]> consumer;
    private final RemotePartitionMetadataEventHandler remotePartitionMetadataEventHandler;
    private final RemoteLogMetadataTopicPartitioner topicPartitioner;
    private final Time time;
    private volatile boolean closing = false;
    private volatile boolean assignPartitions = false;
    private final Object assignPartitionsLock = new Object();
    private volatile Set<Integer> assignedMetaPartitions = Collections.emptySet();
    private Set<TopicIdPartition> assignedTopicPartitions = Collections.emptySet();
    private final Map<Integer, Long> partitionToConsumedOffsets = new ConcurrentHashMap<Integer, Long>();
    private Map<Integer, Long> lastSyncedPartitionToConsumedOffsets = Collections.emptyMap();
    private final long committedOffsetSyncIntervalMs;
    private CommittedOffsetsFile committedOffsetsFile;
    private long lastSyncedTimeMs;

    public ConsumerTask(KafkaConsumer<byte[], byte[]> consumer, RemotePartitionMetadataEventHandler remotePartitionMetadataEventHandler, RemoteLogMetadataTopicPartitioner topicPartitioner, Path committedOffsetsPath, Time time, long committedOffsetSyncIntervalMs) {
        this.consumer = Objects.requireNonNull(consumer);
        this.remotePartitionMetadataEventHandler = Objects.requireNonNull(remotePartitionMetadataEventHandler);
        this.topicPartitioner = Objects.requireNonNull(topicPartitioner);
        this.time = Objects.requireNonNull(time);
        this.committedOffsetSyncIntervalMs = committedOffsetSyncIntervalMs;
        this.initializeConsumerAssignment(committedOffsetsPath);
    }

    private void initializeConsumerAssignment(Path committedOffsetsPath) {
        try {
            this.committedOffsetsFile = new CommittedOffsetsFile(committedOffsetsPath.toFile());
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
        Map<Object, Object> committedOffsets = Collections.emptyMap();
        try {
            committedOffsets = this.committedOffsetsFile.readEntries();
        }
        catch (IOException e) {
            log.error("Encountered error while building committed offsets from the file. Consumer will consume from the earliest offset for the assigned partitions.", (Throwable)e);
        }
        if (!committedOffsets.isEmpty()) {
            Set<Object> earlierAssignedPartitions = committedOffsets.keySet();
            this.assignedMetaPartitions = Collections.unmodifiableSet(earlierAssignedPartitions);
            Set metadataTopicPartitions = earlierAssignedPartitions.stream().map(x -> new TopicPartition("__remote_log_metadata", x.intValue())).collect(Collectors.toSet());
            this.consumer.assign(metadataTopicPartitions);
            for (Map.Entry<Object, Object> entry : committedOffsets.entrySet()) {
                this.partitionToConsumedOffsets.put((Integer)entry.getKey(), (Long)entry.getValue());
                this.consumer.seek(new TopicPartition("__remote_log_metadata", ((Integer)entry.getKey()).intValue()), ((Long)entry.getValue()).longValue());
            }
            this.lastSyncedPartitionToConsumedOffsets = Collections.unmodifiableMap(committedOffsets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("Started Consumer task thread.");
        this.lastSyncedTimeMs = this.time.milliseconds();
        try {
            while (!this.closing) {
                this.maybeWaitForPartitionsAssignment();
                log.info("Polling consumer to receive remote log metadata topic records");
                ConsumerRecords consumerRecords = this.consumer.poll(Duration.ofMillis(100L));
                for (ConsumerRecord record : consumerRecords) {
                    this.processConsumerRecord((ConsumerRecord<byte[], byte[]>)record);
                }
                this.maybeSyncCommittedDataAndOffsets(false);
            }
        }
        catch (Exception e) {
            log.error("Error occurred in consumer task, close:[{}]", (Object)this.closing, (Object)e);
        }
        finally {
            this.maybeSyncCommittedDataAndOffsets(true);
            this.closeConsumer();
            log.info("Exiting from consumer task thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConsumerRecord(ConsumerRecord<byte[], byte[]> record) {
        RemoteLogMetadata remoteLogMetadata = this.serde.deserialize((byte[])record.value());
        Object object = this.assignPartitionsLock;
        synchronized (object) {
            if (this.assignedTopicPartitions.contains(remoteLogMetadata.topicIdPartition())) {
                this.remotePartitionMetadataEventHandler.handleRemoteLogMetadata(remoteLogMetadata);
            } else {
                log.debug("This event {} is skipped as the topic partition is not assigned for this instance.", (Object)remoteLogMetadata);
            }
            this.partitionToConsumedOffsets.put(record.partition(), record.offset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSyncCommittedDataAndOffsets(boolean forceSync) {
        boolean noConsumedOffsetUpdates = this.partitionToConsumedOffsets.equals(this.lastSyncedPartitionToConsumedOffsets);
        if (noConsumedOffsetUpdates || !forceSync && this.time.milliseconds() - this.lastSyncedTimeMs < this.committedOffsetSyncIntervalMs) {
            log.debug("Skip syncing committed offsets, noConsumedOffsetUpdates: {}, forceSync: {}", (Object)noConsumedOffsetUpdates, (Object)forceSync);
            return;
        }
        try {
            Object object = this.assignPartitionsLock;
            synchronized (object) {
                for (TopicIdPartition topicIdPartition : this.assignedTopicPartitions) {
                    int metadataPartition = this.topicPartitioner.metadataPartition(topicIdPartition);
                    Long offset = this.partitionToConsumedOffsets.get(metadataPartition);
                    if (offset != null) {
                        this.remotePartitionMetadataEventHandler.syncLogMetadataSnapshot(topicIdPartition, metadataPartition, offset);
                        continue;
                    }
                    log.debug("Skipping syncup of the remote-log-metadata-file for partition:{} , with remote log metadata partition{}, and no offset", (Object)topicIdPartition, (Object)metadataPartition);
                }
                this.committedOffsetsFile.writeEntries(this.partitionToConsumedOffsets);
                this.lastSyncedPartitionToConsumedOffsets = new HashMap<Integer, Long>(this.partitionToConsumedOffsets);
            }
            this.lastSyncedTimeMs = this.time.milliseconds();
        }
        catch (IOException e) {
            throw new KafkaException("Error encountered while writing committed offsets to a local file", (Throwable)e);
        }
    }

    private void closeConsumer() {
        log.info("Closing the consumer instance");
        try {
            this.consumer.close(Duration.ofSeconds(30L));
        }
        catch (Exception e) {
            log.error("Error encountered while closing the consumer", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeWaitForPartitionsAssignment() {
        Set<Integer> assignedMetaPartitionsSnapshot = Collections.emptySet();
        Object object = this.assignPartitionsLock;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            while (this.assignedMetaPartitions.isEmpty()) {
                log.debug("Waiting for assigned remote log metadata partitions..");
                try {
                    this.assignPartitionsLock.wait();
                    if (!this.closing) continue;
                    return;
                }
                catch (InterruptedException e) {
                    throw new KafkaException((Throwable)e);
                }
            }
            if (this.assignPartitions) {
                assignedMetaPartitionsSnapshot = new HashSet<Integer>(this.assignedMetaPartitions);
                this.partitionToConsumedOffsets.entrySet().removeIf(entry -> !this.assignedMetaPartitions.contains(entry.getKey()));
                this.assignPartitions = false;
            }
        }
        if (!assignedMetaPartitionsSnapshot.isEmpty()) {
            this.executeReassignment(assignedMetaPartitionsSnapshot);
        }
    }

    private void executeReassignment(Set<Integer> assignedMetaPartitionsSnapshot) {
        Set assignedMetaTopicPartitions = assignedMetaPartitionsSnapshot.stream().map(partitionNum -> new TopicPartition("__remote_log_metadata", partitionNum.intValue())).collect(Collectors.toSet());
        log.info("Reassigning partitions to consumer task [{}]", assignedMetaTopicPartitions);
        this.consumer.assign(assignedMetaTopicPartitions);
    }

    public void addAssignmentsForPartitions(Set<TopicIdPartition> partitions) {
        this.updateAssignmentsForPartitions(partitions, Collections.emptySet());
    }

    public void removeAssignmentsForPartitions(Set<TopicIdPartition> partitions) {
        this.updateAssignmentsForPartitions(Collections.emptySet(), partitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAssignmentsForPartitions(Set<TopicIdPartition> addedPartitions, Set<TopicIdPartition> removedPartitions) {
        log.info("Updating assignments for addedPartitions: {} and removedPartition: {}", addedPartitions, removedPartitions);
        Objects.requireNonNull(addedPartitions, "addedPartitions must not be null");
        Objects.requireNonNull(removedPartitions, "removedPartitions must not be null");
        if (addedPartitions.isEmpty() && removedPartitions.isEmpty()) {
            return;
        }
        Object object = this.assignPartitionsLock;
        synchronized (object) {
            HashSet<TopicIdPartition> updatedReassignedPartitions = new HashSet<TopicIdPartition>(this.assignedTopicPartitions);
            updatedReassignedPartitions.addAll(addedPartitions);
            updatedReassignedPartitions.removeAll(removedPartitions);
            HashSet<Integer> updatedAssignedMetaPartitions = new HashSet<Integer>();
            for (TopicIdPartition tp : updatedReassignedPartitions) {
                updatedAssignedMetaPartitions.add(this.topicPartitioner.metadataPartition(tp));
            }
            for (TopicIdPartition removedPartition : removedPartitions) {
                this.remotePartitionMetadataEventHandler.clearTopicPartition(removedPartition);
            }
            this.assignedTopicPartitions = Collections.unmodifiableSet(updatedReassignedPartitions);
            log.debug("Assigned topic partitions: {}", this.assignedTopicPartitions);
            if (!updatedAssignedMetaPartitions.equals(this.assignedMetaPartitions)) {
                this.assignedMetaPartitions = Collections.unmodifiableSet(updatedAssignedMetaPartitions);
                log.debug("Assigned metadata topic partitions: {}", this.assignedMetaPartitions);
                this.assignPartitions = true;
                this.assignPartitionsLock.notifyAll();
            } else {
                log.debug("No change in assigned metadata topic partitions: {}", this.assignedMetaPartitions);
            }
        }
    }

    public Optional<Long> receivedOffsetForPartition(int partition) {
        return Optional.ofNullable(this.partitionToConsumedOffsets.get(partition));
    }

    public boolean isPartitionAssigned(int partition) {
        return this.assignedMetaPartitions.contains(partition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closing) {
            Object object = this.assignPartitionsLock;
            synchronized (object) {
                this.closing = true;
                this.consumer.wakeup();
                this.assignPartitionsLock.notifyAll();
            }
        }
    }
}

