/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.SessionTrackerImpl;
import org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderSessionTracker
extends UpgradeableSessionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderSessionTracker.class);
    private final SessionTrackerImpl globalSessionTracker;
    private final long serverId;

    public LeaderSessionTracker(SessionTracker.SessionExpirer expirer, ConcurrentMap<Long, Integer> sessionsWithTimeouts, int tickTime, long id, boolean localSessionsEnabled, ZooKeeperServerListener listener) {
        this.globalSessionTracker = new SessionTrackerImpl(expirer, sessionsWithTimeouts, tickTime, id, listener);
        this.localSessionsEnabled = localSessionsEnabled;
        if (this.localSessionsEnabled) {
            this.createLocalSessionTracker(expirer, tickTime, id, listener);
        }
        this.serverId = id;
    }

    @Override
    public void removeSession(long sessionId) {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.removeSession(sessionId);
        }
        this.globalSessionTracker.removeSession(sessionId);
    }

    @Override
    public void start() {
        this.globalSessionTracker.start();
        if (this.localSessionTracker != null) {
            this.localSessionTracker.start();
        }
    }

    @Override
    public void shutdown() {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.shutdown();
        }
        this.globalSessionTracker.shutdown();
    }

    @Override
    public boolean isGlobalSession(long sessionId) {
        return this.globalSessionTracker.isTrackingSession(sessionId);
    }

    @Override
    public boolean trackSession(long sessionId, int sessionTimeout) {
        boolean tracked = this.globalSessionTracker.trackSession(sessionId, sessionTimeout);
        if (this.localSessionsEnabled && tracked) {
            LOG.info("Tracking global session 0x{}", (Object)Long.toHexString(sessionId));
        }
        return tracked;
    }

    @Override
    public synchronized boolean commitSession(long sessionId, int sessionTimeout) {
        boolean added = this.globalSessionTracker.commitSession(sessionId, sessionTimeout);
        if (added) {
            LOG.info("Committing global session 0x{}", (Object)Long.toHexString(sessionId));
        }
        if (this.localSessionsEnabled) {
            this.removeLocalSession(sessionId);
            this.finishedUpgrading(sessionId);
        }
        return added;
    }

    @Override
    public boolean touchSession(long sessionId, int sessionTimeout) {
        if (this.localSessionTracker != null && this.localSessionTracker.touchSession(sessionId, sessionTimeout)) {
            return true;
        }
        return this.globalSessionTracker.touchSession(sessionId, sessionTimeout);
    }

    @Override
    public long createSession(int sessionTimeout) {
        if (this.localSessionsEnabled) {
            return this.localSessionTracker.createSession(sessionTimeout);
        }
        return this.globalSessionTracker.createSession(sessionTimeout);
    }

    public static long getServerIdFromSessionId(long sessionId) {
        return sessionId >> 56;
    }

    @Override
    public void checkSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException, KeeperException.UnknownSessionException {
        if (this.localSessionTracker != null) {
            try {
                this.localSessionTracker.checkSession(sessionId, owner);
                if (!this.isGlobalSession(sessionId)) {
                    return;
                }
            }
            catch (KeeperException.UnknownSessionException unknownSessionException) {
                // empty catch block
            }
        }
        try {
            this.globalSessionTracker.checkSession(sessionId, owner);
            return;
        }
        catch (KeeperException.UnknownSessionException unknownSessionException) {
            if (!this.localSessionsEnabled || LeaderSessionTracker.getServerIdFromSessionId(sessionId) == this.serverId) {
                throw new KeeperException.SessionExpiredException();
            }
            return;
        }
    }

    @Override
    public void checkGlobalSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        try {
            this.globalSessionTracker.checkSession(sessionId, owner);
        }
        catch (KeeperException.UnknownSessionException e) {
            throw new KeeperException.SessionExpiredException();
        }
    }

    @Override
    public void setOwner(long sessionId, Object owner) throws KeeperException.SessionExpiredException {
        if (this.localSessionTracker != null) {
            try {
                this.localSessionTracker.setOwner(sessionId, owner);
                return;
            }
            catch (KeeperException.SessionExpiredException sessionExpiredException) {
                // empty catch block
            }
        }
        this.globalSessionTracker.setOwner(sessionId, owner);
    }

    @Override
    public void dumpSessions(PrintWriter pwriter) {
        if (this.localSessionTracker != null) {
            pwriter.print("Local ");
            this.localSessionTracker.dumpSessions(pwriter);
            pwriter.print("Global ");
        }
        this.globalSessionTracker.dumpSessions(pwriter);
    }

    @Override
    public void setSessionClosing(long sessionId) {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.setSessionClosing(sessionId);
        }
        this.globalSessionTracker.setSessionClosing(sessionId);
    }

    @Override
    public Map<Long, Set<Long>> getSessionExpiryMap() {
        Map<Long, Set<Long>> sessionExpiryMap = this.localSessionTracker != null ? this.localSessionTracker.getSessionExpiryMap() : new TreeMap<Long, Set<Long>>();
        sessionExpiryMap.putAll(this.globalSessionTracker.getSessionExpiryMap());
        return sessionExpiryMap;
    }

    @Override
    public Set<Long> globalSessions() {
        return this.globalSessionTracker.globalSessions();
    }
}

