/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r\u001dc\u0001\u0002\"D\u0001!C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tU\u0002\u0011)\u0019!C\u0001W\"A!\u0010\u0001B\u0001B\u0003%A\u000e\u0003\u0005|\u0001\t\u0015\r\u0011\"\u0001}\u0011%\t)\u0002\u0001B\u0001B\u0003%Q\u0010\u0003\u0006\u0002\u0018\u0001\u0011)\u0019!C\u0001\u00033A!\"!\t\u0001\u0005\u0003\u0005\u000b\u0011BA\u000e\u0011)\t\u0019\u0003\u0001B\u0001B\u0003%\u0011Q\u0005\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011)\ty\u0004\u0001b\u0001\n\u0003\u0019\u0015\u0011\t\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002D!I\u00111\u000b\u0001A\u0002\u0013%\u0011Q\u000b\u0005\n\u0003/\u0002\u0001\u0019!C\u0005\u00033Bq!!\u001a\u0001A\u0003&A\f\u0003\u0006\u0002p\u0001\u0011\r\u0011\"\u0001D\u0003cB\u0001\"!\u001f\u0001A\u0003%\u00111\u000f\u0005\u000b\u0003w\u0002!\u0019!C\u0001\u0007\u0006u\u0004\u0002CAC\u0001\u0001\u0006I!a \t\u0015\u0005\u001d\u0005A1A\u0005\u0002\r\u000bI\t\u0003\u0005\u0003d\u0001\u0001\u000b\u0011BAF\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005OB\u0001B!\u001f\u0001\t\u0003\u0019%1\u0010\u0005\b\u0005{\u0002A\u0011\u0001B\u0003\u0011\u001d\u0011y\b\u0001C\u0001\u0005\u000bAqA!!\u0001\t\u0003\u0012\u0019\tC\u0004\u0003\f\u0002!\tE!$\t\u000f\te\u0005\u0001\"\u0011\u0003\u001c\"9!1\u0015\u0001\u0005\u0002\t\u0015\u0006b\u0002BU\u0001\u0011\u0005!1\u0016\u0005\n\u0005w\u0003\u0011\u0013!C\u0001\u0005{CqAa5\u0001\t\u0003\u0011)\u000eC\u0004\u0003b\u0002!\tAa9\t\u000f\t%\b\u0001\"\u0001\u0003l\"9!Q\u001f\u0001\u0005\u0002\t]\bb\u0002B~\u0001\u0011\u0005!Q \u0005\b\u0007\u0013\u0001A\u0011AB\u0006\u0011%\u0019)\u0002AI\u0001\n\u0003\u00199\u0002C\u0004\u0004\u001c\u0001!\ta!\b\t\u0011\r\u001d\u0002\u0001\"\u0001F\u0003+B\u0001b!\u000b\u0001\t\u0003\u0019%1\u0010\u0004\b\u00037\u0003\u0001aQAO\u0011)\tY+\u000bB\u0001B\u0003%\u0011Q\u0016\u0005\b\u0003_IC\u0011AAZ\u0011\u001d\t9,\u000bC)\u0003sC\u0011\"a2*\u0005\u0004%\t!!3\t\u0011\u0005E\u0017\u0006)A\u0005\u0003\u0017D\u0011\"a5*\u0001\u0004%\t!!6\t\u0013\u0005u\u0017\u00061A\u0005\u0002\u0005}\u0007\u0002CArS\u0001\u0006K!a6\t\u0013\u0005\u001d\u0018\u00061A\u0005\u0002\u0005%\b\"CAyS\u0001\u0007I\u0011AAz\u0011!\t90\u000bQ!\n\u0005-\bbBA~S\u0011%\u0011Q \u0005\b\u0005\u0007IC\u0011\tB\u0003\u0011\u001d\u00119!\u000bC\u0005\u0005\u0013AqA!\u0005*\t\u0013\u0011I\u0001C\u0004\u0003$%\"IA!\n\t\u000f\tE\u0012\u0006\"\u0001\u00034\u001d911F\"\t\u0002\r5bA\u0002\"D\u0011\u0003\u0019y\u0003C\u0004\u00020q\"\ta!\r\t\u0013\rMBH1A\u0005\u0002\rU\u0002\u0002CB\u001dy\u0001\u0006Iaa\u000e\t\u000f\rmB\b\"\u0001\u0004>!I1\u0011\t\u001f\u0012\u0002\u0013\u000511\t\u0002\u000b\u0019><7\t\\3b]\u0016\u0014(B\u0001#F\u0003\rawn\u001a\u0006\u0002\r\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001J\u001fV\u0003\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013a!\u00118z%\u00164\u0007C\u0001)T\u001b\u0005\t&B\u0001*F\u0003\u0015)H/\u001b7t\u0013\t!\u0016KA\u0004M_\u001e<\u0017N\\4\u0011\u0005YKV\"A,\u000b\u0005a+\u0015AB:feZ,'/\u0003\u0002[/\n!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\fQ\"\u001b8ji&\fGnQ8oM&<\u0007CA/i\u001b\u0005q&B\u0001#`\u0015\t\u0001\u0017-A\u0005j]R,'O\\1mg*\u0011!mY\u0001\bgR|'/Y4f\u0015\t1EM\u0003\u0002fM\u00061\u0011\r]1dQ\u0016T\u0011aZ\u0001\u0004_J<\u0017BA5_\u00055\u0019E.Z1oKJ\u001cuN\u001c4jO\u00069An\\4ESJ\u001cX#\u00017\u0011\u00075\u0004(/D\u0001o\u0015\ty7*\u0001\u0006d_2dWm\u0019;j_:L!!\u001d8\u0003\u0007M+\u0017\u000f\u0005\u0002tq6\tAO\u0003\u0002vm\u0006\u0011\u0011n\u001c\u0006\u0002o\u0006!!.\u0019<b\u0013\tIHO\u0001\u0003GS2,\u0017\u0001\u00037pO\u0012K'o\u001d\u0011\u0002\t1|wm]\u000b\u0002{B1\u0001K`A\u0001\u0003\u001bI!a`)\u0003\tA{w\u000e\u001c\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA2\u0002\r\r|W.\\8o\u0013\u0011\tY!!\u0002\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011qBA\t\u001b\u0005\u0019\u0015bAA\n\u0007\nQQK\\5gS\u0016$Gj\\4\u0002\u000b1|wm\u001d\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\t\tY\u0002E\u0002^\u0003;I1!a\b_\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0013\u0001\u0002;j[\u0016\u0004B!a\n\u0002,5\u0011\u0011\u0011\u0006\u0006\u0004%\u0006\u0015\u0011\u0002BA\u0017\u0003S\u0011A\u0001V5nK\u00061A(\u001b8jiz\"B\"a\r\u00026\u0005]\u0012\u0011HA\u001e\u0003{\u00012!a\u0004\u0001\u0011\u0015Y\u0016\u00021\u0001]\u0011\u0015Q\u0017\u00021\u0001m\u0011\u0015Y\u0018\u00021\u0001~\u0011\u001d\t9\"\u0003a\u0001\u00037A\u0011\"a\t\n!\u0003\u0005\r!!\n\u0002\u00195,GO]5dg\u001e\u0013x.\u001e9\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001bj!!a\u0012\u000b\t\u0005%\u00131J\u0001\b[\u0016$(/[2t\u0015\tA6-\u0003\u0003\u0002P\u0005\u001d#!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\naaY8oM&<W#\u0001/\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002\\\u0005\u0005\u0004c\u0001&\u0002^%\u0019\u0011qL&\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003Gj\u0011\u0011!a\u00019\u0006\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA!\u001aa\"!\u001b\u0011\u0007)\u000bY'C\u0002\u0002n-\u0013\u0001B^8mCRLG.Z\u0001\u000fG2,\u0017M\\3s\u001b\u0006t\u0017mZ3s+\t\t\u0019\b\u0005\u0003\u0002\u0010\u0005U\u0014bAA<\u0007\n\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0002\u001f\rdW-\u00198fe6\u000bg.Y4fe\u0002\n\u0011\u0002\u001e5s_R$H.\u001a:\u0016\u0005\u0005}\u0004c\u0001)\u0002\u0002&\u0019\u00111Q)\u0003\u0013QC'o\u001c;uY\u0016\u0014\u0018A\u0003;ie>$H\u000f\\3sA\u0005A1\r\\3b]\u0016\u00148/\u0006\u0002\u0002\fB1\u0011QRAJ\u0003/k!!a$\u000b\u0007\u0005Ee.A\u0004nkR\f'\r\\3\n\t\u0005U\u0015q\u0012\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002\u0002\u001a&j\u0011\u0001\u0001\u0002\u000e\u00072,\u0017M\\3s)\"\u0014X-\u00193\u0014\t%\nyj\u0014\t\u0005\u0003C\u000b9+\u0004\u0002\u0002$*!\u0011QUA&\u0003\u0011)H/\u001b7\n\t\u0005%\u00161\u0015\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-\u0001\u0005uQJ,\u0017\rZ%e!\rQ\u0015qV\u0005\u0004\u0003c[%aA%oiR!\u0011qSA[\u0011\u001d\tYk\u000ba\u0001\u0003[\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\t\tY\f\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\tM^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002F\u0006}&AB*ue&tw-A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u0005-\u0007\u0003BA\b\u0003\u001bL1!a4D\u0005\u001d\u0019E.Z1oKJ\f\u0001b\u00197fC:,'\u000fI\u0001\nY\u0006\u001cHo\u0015;biN,\"!a6\u0011\t\u0005=\u0011\u0011\\\u0005\u0004\u00037\u001c%\u0001D\"mK\u0006tWM]*uCR\u001c\u0018!\u00047bgR\u001cF/\u0019;t?\u0012*\u0017\u000f\u0006\u0003\u0002\\\u0005\u0005\b\"CA2a\u0005\u0005\t\u0019AAl\u0003)a\u0017m\u001d;Ti\u0006$8\u000f\t\u0015\u0004c\u0005%\u0014!\u00057bgR\u0004&/Z\"mK\u0006t7\u000b^1ugV\u0011\u00111\u001e\t\u0005\u0003\u001f\ti/C\u0002\u0002p\u000e\u0013Q\u0002\u0015:f\u00072,\u0017M\\*uCR\u001c\u0018!\u00067bgR\u0004&/Z\"mK\u0006t7\u000b^1ug~#S-\u001d\u000b\u0005\u00037\n)\u0010C\u0005\u0002dM\n\t\u00111\u0001\u0002l\u0006\u0011B.Y:u!J,7\t\\3b]N#\u0018\r^:!Q\r!\u0014\u0011N\u0001\nG\",7m\u001b#p]\u0016$B!a\u0017\u0002\u0000\"9!\u0011A\u001bA\u0002\u0005\u0005\u0011A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0007I><vN]6\u0015\u0005\u0005m\u0013\u0001\u0006;ss\u000ecW-\u00198GS2$\b.[3ti2{w\r\u0006\u0002\u0003\fA\u0019!J!\u0004\n\u0007\t=1JA\u0004C_>dW-\u00198\u0002#\rdW-\u00198GS2$\b.[3ti2{w\rK\u00039\u0005+\u0011\t\u0003E\u0003K\u0005/\u0011Y\"C\u0002\u0003\u001a-\u0013a\u0001\u001e5s_^\u001c\b\u0003BA\b\u0005;I1Aa\bD\u0005QaunZ\"mK\u0006t\u0017N\\4Fq\u000e,\u0007\u000f^5p]\u000e\u0012!1D\u0001\tG2,\u0017M\u001c'pOR!\u00111\fB\u0014\u0011\u001d\u0011I#\u000fa\u0001\u0005W\t\u0011b\u00197fC:\f'\r\\3\u0011\t\u0005=!QF\u0005\u0004\u0005_\u0019%A\u0003'pOR{7\t\\3b]\u0006Y!/Z2pe\u0012\u001cF/\u0019;t)1\tYF!\u000e\u0003:\tE#1\fB0\u0011\u001d\u00119D\u000fa\u0001\u0003[\u000b!!\u001b3\t\u000f\tm\"\b1\u0001\u0003>\u0005!a.Y7f!\u0011\u0011yD!\u0014\u000f\t\t\u0005#\u0011\n\t\u0004\u0005\u0007ZUB\u0001B#\u0015\r\u00119eR\u0001\u0007yI|w\u000e\u001e \n\u0007\t-3*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\u0014yEC\u0002\u0003L-CqAa\u0015;\u0001\u0004\u0011)&\u0001\u0003ge>l\u0007c\u0001&\u0003X%\u0019!\u0011L&\u0003\t1{gn\u001a\u0005\b\u0005;R\u0004\u0019\u0001B+\u0003\t!x\u000eC\u0004\u0003bi\u0002\r!a6\u0002\u000bM$\u0018\r^:\u0002\u0013\rdW-\u00198feN\u0004\u0013!F7bq>3XM]\"mK\u0006tWM\u001d+ie\u0016\fGm\u001d\u000b\u0005\u0003[\u0013I\u0007C\u0004\u0003lU\u0001\rA!\u001c\u0002\u0003\u0019\u0004rA\u0013B8\u0003/\u0013\u0019(C\u0002\u0003r-\u0013\u0011BR;oGRLwN\\\u0019\u0011\u0007)\u0013)(C\u0002\u0003x-\u0013a\u0001R8vE2,\u0017a\u00043fC\u0012$\u0006N]3bI\u000e{WO\u001c;\u0016\u0005\u00055\u0016aB:uCJ$X\u000f]\u0001\tg\",H\u000fZ8x]\u0006)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cXC\u0001BC!\u0015i'q\u0011B\u001f\u0013\r\u0011II\u001c\u0002\u0004'\u0016$\u0018a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\u0011\tYFa$\t\u000f\tE%\u00041\u0001\u0003\u0014\u0006Ia.Z<D_:4\u0017n\u001a\t\u0004-\nU\u0015b\u0001BL/\nY1*\u00194lC\u000e{gNZ5h\u0003-\u0011XmY8oM&<WO]3\u0015\r\u0005m#Q\u0014BQ\u0011\u001d\u0011yj\u0007a\u0001\u0005'\u000b\u0011b\u001c7e\u0007>tg-[4\t\u000f\tE5\u00041\u0001\u0003\u0014\u0006i\u0011MY8si\u000ecW-\u00198j]\u001e$B!a\u0017\u0003(\"9!\u0011\u0001\u000fA\u0002\u0005\u0005\u0011!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugR1\u00111\fBW\u0005cCaAa,\u001e\u0001\u0004\u0011\u0018a\u00023bi\u0006$\u0015N\u001d\u0005\n\u0005gk\u0002\u0013!a\u0001\u0005k\u000b\u0011\u0003]1si&$\u0018n\u001c8U_J+Wn\u001c<f!\u0015Q%qWA\u0001\u0013\r\u0011Il\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u00027U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yL\u000b\u0003\u00036\n\u00057F\u0001Bb!\u0011\u0011)Ma4\u000e\u0005\t\u001d'\u0002\u0002Be\u0005\u0017\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t57*\u0001\u0006b]:|G/\u0019;j_:LAA!5\u0003H\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\u0005dG/\u001a:DQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\u000b\t\u00037\u00129N!7\u0003^\"9!\u0011A\u0010A\u0002\u0005\u0005\u0001B\u0002Bn?\u0001\u0007!/\u0001\u0007t_V\u00148-\u001a'pO\u0012K'\u000f\u0003\u0004\u0003`~\u0001\rA]\u0001\u000bI\u0016\u001cH\u000fT8h\t&\u0014\u0018a\u00055b]\u0012dW\rT8h\t&\u0014h)Y5mkJ,G\u0003BA.\u0005KDqAa:!\u0001\u0004\u0011i$A\u0002eSJ\fq#\\1zE\u0016$&/\u001e8dCR,7\t[3dWB|\u0017N\u001c;\u0015\u0011\u0005m#Q\u001eBx\u0005cDaAa,\"\u0001\u0004\u0011\bb\u0002B\u0001C\u0001\u0007\u0011\u0011\u0001\u0005\b\u0005g\f\u0003\u0019\u0001B+\u0003\u0019ygMZ:fi\u0006)\u0012MY8si\u0006sG\rU1vg\u0016\u001cE.Z1oS:<G\u0003BA.\u0005sDqA!\u0001#\u0001\u0004\t\t!\u0001\bsKN,X.Z\"mK\u0006t\u0017N\\4\u0015\t\u0005m#q \u0005\b\u0007\u0003\u0019\u0003\u0019AB\u0002\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b#B7\u0004\u0006\u0005\u0005\u0011bAB\u0004]\nA\u0011\n^3sC\ndW-\u0001\u0007bo\u0006LGo\u00117fC:,G\r\u0006\u0005\u0003\f\r51qBB\t\u0011\u001d\u0011\t\u0001\na\u0001\u0003\u0003AqAa=%\u0001\u0004\u0011)\u0006C\u0005\u0004\u0014\u0011\u0002\n\u00111\u0001\u0003V\u0005IQ.\u0019=XC&$Xj]\u0001\u0017C^\f\u0017\u000e^\"mK\u0006tW\r\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u0004\u0016\u0005\u0005+\u0012\t-\u0001\u0014qCV\u001cXm\u00117fC:Lgn\u001a$pe:{gnQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]N$\"aa\b\u0011\u000b5\u001c)a!\t\u0011\u000f)\u001b\u0019#!\u0001\u0002\u000e%\u00191QE&\u0003\rQ+\b\u000f\\33\u00035\u0019WO\u001d:f]R\u001cuN\u001c4jO\u0006a1\r\\3b]\u0016\u00148i\\;oi\u0006QAj\\4DY\u0016\fg.\u001a:\u0011\u0007\u0005=Ah\u0005\u0002=\u0013R\u00111QF\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u00199\u0004E\u0003n\u0005\u000f\u000bY,\u0001\fSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:!\u00035\u0019G.Z1oKJ\u001cuN\u001c4jOR\u0019Ala\u0010\t\u000f\u0005M\u0003\t1\u0001\u0003\u0014\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"a!\u0012+\t\u0005\u0015\"\u0011\u0019")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    public static CleanerConfig cleanerConfig(KafkaConfig config) {
        return LogCleaner$.MODULE$.cleanerConfig(config);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) * 100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$3() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable)x$2 -> x$2.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$9() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) / 1000;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge("max-buffer-utilization-percent", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("cleaner-recopy-percent", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("max-clean-time-secs", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("max-compaction-delay-secs", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("DeadThreadCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                LogCleaner logCleaner = this.$outer;
                if (logCleaner == null) {
                    throw null;
                }
                return logCleaner.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, UnifiedLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable)x$10 -> (TopicPartition)x$10._1())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                UnifiedLog log = (UnifiedLog)x0$1._2();
                try {
                    return log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(Time.SYSTEM);
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

