/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.TopicManager;
import io.confluent.kafkarest.entities.Acl;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.PartitionReplica;
import io.confluent.kafkarest.entities.Topic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;

final class TopicManagerImpl
implements TopicManager {
    private final Admin adminClient;
    private final ClusterManager clusterManager;

    @Inject
    TopicManagerImpl(Admin adminClient, ClusterManager clusterManager) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.clusterManager = Objects.requireNonNull(clusterManager);
    }

    @Override
    public CompletableFuture<List<Topic>> listTopics(String clusterId, boolean includeAuthorizedOperations) {
        return ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenCompose(cluster -> KafkaFutures.toCompletableFuture(this.adminClient.listTopics().listings()))).thenCompose(topicListings -> {
            if (topicListings == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return this.describeTopics(clusterId, topicListings.stream().map(TopicListing::name).collect(Collectors.toList()), includeAuthorizedOperations);
        });
    }

    @Override
    public CompletableFuture<List<Topic>> listLocalTopics() {
        return this.clusterManager.getLocalCluster().thenCompose(cluster -> KafkaFutures.toCompletableFuture(this.adminClient.listTopics().listings()).thenCompose(topicListings -> {
            if (topicListings == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return this.describeTopics(cluster.getClusterId(), topicListings.stream().map(TopicListing::name).collect(Collectors.toList()), false);
        }));
    }

    @Override
    public CompletableFuture<Optional<Topic>> getTopic(String clusterId, String topicName, boolean includeAuthorizedOperations) {
        Objects.requireNonNull(topicName);
        return ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenCompose(cluster -> this.describeTopics(clusterId, Collections.singletonList(topicName), includeAuthorizedOperations))).thenApply(topics -> {
            if (topics == null || topics.isEmpty()) {
                return Optional.empty();
            }
            if (topics.size() > 1) {
                throw new IllegalStateException(String.format("More than one topic exists with name %s in cluster %s.", topicName, clusterId));
            }
            return Optional.of(topics.get(0));
        });
    }

    @Override
    public CompletableFuture<Optional<Topic>> getLocalTopic(String topicName) {
        Objects.requireNonNull(topicName);
        return ((CompletableFuture)this.clusterManager.getLocalCluster().thenCompose(cluster -> this.describeTopics(cluster.getClusterId(), Collections.singletonList(topicName), false))).thenApply(topics -> {
            if (topics == null || topics.isEmpty()) {
                return Optional.empty();
            }
            if (topics.size() > 1) {
                throw new IllegalStateException(String.format("More than one topic exists with name %s.", topicName));
            }
            return Optional.of(topics.get(0));
        });
    }

    private CompletableFuture<List<Topic>> describeTopics(String clusterId, List<String> topicNames, boolean includeAuthorizedOperations) {
        return KafkaFutures.toCompletableFuture(this.adminClient.describeTopics(topicNames, new DescribeTopicsOptions().includeAuthorizedOperations(includeAuthorizedOperations)).allTopicNames()).thenApply(topics -> topics.values().stream().map(topicDescription -> TopicManagerImpl.toTopic(clusterId, topicDescription)).collect(Collectors.toList()));
    }

    private static Topic toTopic(String clusterId, TopicDescription topicDescription) {
        return Topic.create(clusterId, topicDescription.name(), topicDescription.partitions().stream().map(partition -> TopicManagerImpl.toPartition(clusterId, topicDescription.name(), partition)).collect(Collectors.toList()), (short)((TopicPartitionInfo)topicDescription.partitions().get(0)).replicas().size(), topicDescription.isInternal(), topicDescription.authorizedOperations() == null ? Collections.emptySet() : topicDescription.authorizedOperations().stream().map(Acl.Operation::fromAclOperation).collect(Collectors.toSet()));
    }

    private static Partition toPartition(String clusterId, String topicName, TopicPartitionInfo partitionInfo) {
        HashSet inSyncReplicas = new HashSet(partitionInfo.isr());
        ArrayList<PartitionReplica> replicas = new ArrayList<PartitionReplica>();
        for (Node replica : partitionInfo.replicas()) {
            replicas.add(PartitionReplica.create(clusterId, topicName, partitionInfo.partition(), replica.id(), replica.equals((Object)partitionInfo.leader()), inSyncReplicas.contains(replica)));
        }
        return Partition.create(clusterId, topicName, partitionInfo.partition(), replicas);
    }

    @Override
    public CompletableFuture<Void> createTopic(String clusterId, String topicName, Optional<Integer> partitionsCount, Optional<Short> replicationFactor, Map<Integer, List<Integer>> replicasAssignments, Map<String, Optional<String>> configs) {
        return this.createTopic2(clusterId, topicName, partitionsCount, replicationFactor, replicasAssignments, configs, false).thenAccept(unused -> {});
    }

    @Override
    public CompletableFuture<Topic> createTopic2(String clusterId, String topicName, Optional<Integer> partitionsCount, Optional<Short> replicationFactor, Map<Integer, List<Integer>> replicasAssignments, Map<String, Optional<String>> configs, boolean validateOnly) {
        Objects.requireNonNull(topicName);
        HashMap nullableConfigs = new HashMap();
        configs.forEach((key, value) -> {
            String cfr_ignored_0 = nullableConfigs.put(key, value.orElse(null));
        });
        NewTopic createTopicRequest = replicasAssignments.isEmpty() ? new NewTopic(topicName, partitionsCount, replicationFactor).configs(nullableConfigs) : new NewTopic(topicName, replicasAssignments).configs(nullableConfigs);
        return ((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenCompose(cluster -> this.createTopicInternal(clusterId, topicName, createTopicRequest, partitionsCount, replicationFactor, validateOnly));
    }

    private CompletableFuture<Topic> createTopicInternal(String clusterId, String topicName, NewTopic createTopicRequest, Optional<Integer> requestPartitionsCount, Optional<Short> requestReplicationFactor, boolean validateOnly) {
        CreateTopicsResult createTopicsResult = this.adminClient.createTopics(Collections.singletonList(createTopicRequest), new CreateTopicsOptions().validateOnly(validateOnly));
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(Topic.builder()).thenCombine((CompletionStage)KafkaFutures.toCompletableFuture(createTopicsResult.all()), (topicBuilder, unused) -> topicBuilder.setClusterId(clusterId).setName(topicName).setInternal(false).setAuthorizedOperations(Collections.emptySet()))).thenCombine(this.extractConfigFromResultUnlessNotAuthorized((KafkaFuture<Integer>)createTopicsResult.numPartitions(topicName), requestPartitionsCount), (topicBuilder, responseNumPartitions) -> {
            ArrayList<Partition> dummyPartitions = new ArrayList<Partition>((int)responseNumPartitions);
            for (int i = 0; i < responseNumPartitions; ++i) {
                dummyPartitions.add(Partition.create(clusterId, topicName, i, Collections.emptyList()));
            }
            return topicBuilder.addAllPartitions(dummyPartitions);
        })).thenCombine(this.extractConfigFromResultUnlessNotAuthorized((KafkaFuture<Integer>)createTopicsResult.replicationFactor(topicName), requestReplicationFactor), (topicBuilder, responseReplicationFactor) -> topicBuilder.setReplicationFactor(responseReplicationFactor.shortValue()))).thenApply(Topic.Builder::build);
    }

    private CompletableFuture<Integer> extractConfigFromResultUnlessNotAuthorized(KafkaFuture<Integer> configFuture, Optional<? extends Number> defaultValue) {
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        configFuture.whenComplete((value, exception) -> {
            if (exception == null) {
                completableFuture.complete((Integer)value);
            } else if (defaultValue.isPresent()) {
                completableFuture.complete(((Number)defaultValue.get()).intValue());
            } else {
                completableFuture.complete(0);
            }
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<Void> deleteTopic(String clusterId, String topicName) {
        Objects.requireNonNull(topicName);
        return ((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenCompose(cluster -> KafkaFutures.toCompletableFuture(this.adminClient.deleteTopics(Collections.singletonList(topicName)).all()));
    }

    @Override
    public CompletableFuture<Void> updateTopicPartitionsCount(String topicName, Integer partitionsCount) {
        Map<String, NewPartitions> newPartitionsMap = Collections.singletonMap(topicName, NewPartitions.increaseTo((int)partitionsCount));
        return KafkaFutures.toCompletableFuture(this.adminClient.createPartitions(newPartitionsMap).all());
    }
}

