/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.DeleteRecordsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DeleteRecordsCommand$ {
    public static final DeleteRecordsCommand$ MODULE$ = new DeleteRecordsCommand$();
    private static final int EarliestVersion = 1;

    public int EarliestVersion() {
        return EarliestVersion;
    }

    public void main(String[] args) {
        this.execute(args, System.out);
    }

    public Seq<Tuple2<TopicPartition, Object>> parseOffsetJsonStringWithoutDedup(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt((Object)((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
            } else if (None$.MODULE$.equals(option2)) {
                n = this.EarliestVersion();
            } else {
                throw new MatchError(option2);
            }
            int version = n;
            return this.parseJsonData(version, js);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("The input string is not a valid JSON");
        }
        throw new MatchError(option);
    }

    public Seq<Tuple2<TopicPartition, Object>> parseJsonData(int version, JsonValue js) {
        switch (version) {
            case 1: {
                Option<JsonValue> option = js.asJsonObject().get("partitions");
                if (option instanceof Some) {
                    return ((JsonValue)((Some)option).value()).asJsonArray().iterator().map((Function1 & Serializable)x$1 -> x$1.asJsonObject()).map((Function1 & Serializable)partitionJs -> {
                        String topic = partitionJs.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                        int partition = BoxesRunTime.unboxToInt((Object)partitionJs.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                        long offset = BoxesRunTime.unboxToLong((Object)partitionJs.apply("offset").to(DecodeJson$DecodeLong$.MODULE$));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToLong((long)offset));
                    }).toBuffer();
                }
                throw new AdminOperationException("Missing partitions field");
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    public void execute(String[] args, PrintStream out) {
        DeleteRecordsCommand.DeleteRecordsCommandOptions opts = new DeleteRecordsCommand.DeleteRecordsCommandOptions(args);
        Admin adminClient = this.createAdminClient(opts);
        String offsetJsonString = Utils.readFileAsString((String)((String)opts.options.valueOf(opts.offsetJsonFileOpt())));
        Seq<Tuple2<TopicPartition, Object>> offsetSeq = this.parseOffsetJsonStringWithoutDedup(offsetJsonString);
        Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates((Iterable)offsetSeq.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (TopicPartition)x0$1._1();
            }
            throw new MatchError(null);
        }));
        if (duplicatePartitions.nonEmpty()) {
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset json file contains duplicate topic partitions: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
        }
        java.util.Map recordsToDelete = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)offsetSeq.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$2._1();
                long offset = x0$2._2$mcJ$sp();
                return new Tuple2((Object)topicPartition, (Object)RecordsToDelete.beforeOffset((long)offset));
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        out.println("Executing records delete operation");
        DeleteRecordsResult deleteRecordsResult = adminClient.deleteRecords(recordsToDelete);
        out.println("Records delete operation completed:");
        deleteRecordsResult.lowWatermarks().forEach((tp, partitionResult) -> {
            try {
                out.println(new StringBuilder(27).append("partition: ").append(tp).append("\tlow_watermark: ").append(((DeletedRecords)partitionResult.get()).lowWatermark()).toString());
                return;
            }
            catch (Exception e) {
                out.println(new StringBuilder(19).append("partition: ").append(tp).append("\terror: ").append(e.getMessage()).toString());
                return;
            }
        });
        adminClient.close();
    }

    private Admin createAdminClient(DeleteRecordsCommand.DeleteRecordsCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt())), null) : new Properties();
        props.put("bootstrap.servers", opts.options.valueOf(opts.bootstrapServerOpt()));
        return Admin.create((Properties)props);
    }

    private DeleteRecordsCommand$() {
    }
}

