/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinatorAdapter$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.util.FutureUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r%t!\u0002\u0012$\u0011\u0003Qc!\u0002\u0017$\u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004\"\u0002\u001c\u0002\t\u00039d!\u0002\u0017$\u0001\rJ\u0004\u0002\u0003\u0014\u0005\u0005\u000b\u0007I\u0011B'\t\u0011A#!\u0011!Q\u0001\n9C\u0001\"\u0015\u0003\u0003\u0006\u0004%IA\u0015\u0005\t7\u0012\u0011\t\u0011)A\u0005'\")A\u0007\u0002C\u00019\")q\f\u0002C!A\")A\u0010\u0002C!{\"9\u0011\u0011\u0004\u0003\u0005B\u0005m\u0001bBA\u0019\t\u0011\u0005\u00131\u0007\u0005\b\u0003\u000f\"A\u0011IA%\u0011\u001d\ti\u0006\u0002C!\u0003?Bq!a\u001d\u0005\t\u0003\n)\bC\u0004\u0002.\u0012!\t%a,\t\u000f\u0005\u001dG\u0001\"\u0011\u0002J\"9\u0011Q\u001e\u0003\u0005B\u0005=\bb\u0002B\u0006\t\u0011%!Q\u0002\u0005\b\u0005o!A\u0011\tB\u001d\u0011\u001d\u0011y\u0005\u0002C!\u0005#BqAa\u001a\u0005\t\u0013\u0011I\u0007C\u0004\u0003\u001c\u0012!\tE!(\t\u000f\tMF\u0001\"\u0011\u00036\"9!\u0011\u0018\u0003\u0005B\tm\u0006b\u0002Bm\t\u0011\u0005#1\u001c\u0005\b\u0005K$A\u0011\tBt\u0011\u001d\u0011\t\u0010\u0002C!\u0005gDqAa@\u0005\t\u0003\u001a\t\u0001C\u0004\u0004\u001e\u0011!\tea\b\t\u000f\r\u001dB\u0001\"\u0011\u0004*!911\b\u0003\u0005B\ru\u0012aF$s_V\u00048i\\8sI&t\u0017\r^8s\u0003\u0012\f\u0007\u000f^3s\u0015\t!S%A\u0003he>,\bO\u0003\u0002'O\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005A\u0013!B6bM.\f7\u0001\u0001\t\u0003W\u0005i\u0011a\t\u0002\u0018\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\fE-\u00199uKJ\u001c\"!\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!&A\u0003baBd\u0017\u0010F\u00059\u0007\u007f\u0019ye!\u0017\u0004\\A\u00111\u0006B\n\u0004\ti\u0012\u0005CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0011a\u0017M\\4\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u0010\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\r[U\"\u0001#\u000b\u0005\u0011*%B\u0001\u0014G\u0015\tAsI\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<\u0017B\u0001'E\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'/F\u0001O!\tYs*\u0003\u0002MG\u0005a1m\\8sI&t\u0017\r^8sA\u0005!A/[7f+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0015)H/\u001b7t\u0015\tAf)\u0001\u0004d_6lwN\\\u0005\u00035V\u0013A\u0001V5nK\u0006)A/[7fAQ\u0019\u0001(\u00180\t\u000b\u0019J\u0001\u0019\u0001(\t\u000bEK\u0001\u0019A*\u0002-\r|gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR$2!Y8x!\r\u0011w-[\u0007\u0002G*\u0011A-Z\u0001\u000bG>t7-\u001e:sK:$(B\u00014?\u0003\u0011)H/\u001b7\n\u0005!\u001c'!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\u0011!.\\\u0007\u0002W*\u0011AnV\u0001\b[\u0016\u001c8/Y4f\u0013\tq7N\u0001\u0012D_:\u001cX/\\3s\u000fJ|W\u000f\u001d%fCJ$(-Z1u%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006a*\u0001\r!]\u0001\bG>tG/\u001a=u!\t\u0011X/D\u0001t\u0015\t!x+\u0001\u0005sKF,Xm\u001d;t\u0013\t18O\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000baT\u0001\u0019A=\u0002\u000fI,\u0017/^3tiB\u0011!N_\u0005\u0003w.\u0014\u0011eQ8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r\u001e*fcV,7\u000f\u001e#bi\u0006\f\u0011B[8j]\u001e\u0013x.\u001e9\u0015\u000fy\f)!a\u0002\u0002\u0010A\u0019!mZ@\u0011\u0007)\f\t!C\u0002\u0002\u0004-\u0014QCS8j]\u001e\u0013x.\u001e9SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0003q\u0017\u0001\u0007\u0011\u000f\u0003\u0004y\u0017\u0001\u0007\u0011\u0011\u0002\t\u0004U\u0006-\u0011bAA\u0007W\n!\"j\\5o\u000fJ|W\u000f\u001d*fcV,7\u000f\u001e#bi\u0006Dq!!\u0005\f\u0001\u0004\t\u0019\"\u0001\bck\u001a4WM]*vaBd\u0017.\u001a:\u0011\u0007Q\u000b)\"C\u0002\u0002\u0018U\u0013aBQ;gM\u0016\u00148+\u001e9qY&,'/A\u0005ts:\u001cwI]8vaRA\u0011QDA\u0013\u0003O\ty\u0003\u0005\u0003cO\u0006}\u0001c\u00016\u0002\"%\u0019\u00111E6\u0003+MKhnY$s_V\u0004(+Z:q_:\u001cX\rR1uC\")\u0001\u000f\u0004a\u0001c\"1\u0001\u0010\u0004a\u0001\u0003S\u00012A[A\u0016\u0013\r\tic\u001b\u0002\u0015'ft7m\u0012:pkB\u0014V-];fgR$\u0015\r^1\t\u000f\u0005EA\u00021\u0001\u0002\u0014\u0005I\u0001.Z1si\n,\u0017\r\u001e\u000b\u0007\u0003k\ti$a\u0010\u0011\t\t<\u0017q\u0007\t\u0004U\u0006e\u0012bAA\u001eW\n)\u0002*Z1si\n,\u0017\r\u001e*fgB|gn]3ECR\f\u0007\"\u00029\u000e\u0001\u0004\t\bB\u0002=\u000e\u0001\u0004\t\t\u0005E\u0002k\u0003\u0007J1!!\u0012l\u0005QAU-\u0019:uE\u0016\fGOU3rk\u0016\u001cH\u000fR1uC\u0006QA.Z1wK\u001e\u0013x.\u001e9\u0015\r\u0005-\u00131KA+!\u0011\u0011w-!\u0014\u0011\u0007)\fy%C\u0002\u0002R-\u0014a\u0003T3bm\u0016<%o\\;q%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006a:\u0001\r!\u001d\u0005\u0007q:\u0001\r!a\u0016\u0011\u0007)\fI&C\u0002\u0002\\-\u0014Q\u0003T3bm\u0016<%o\\;q%\u0016\fX/Z:u\t\u0006$\u0018-\u0001\u0006mSN$xI]8vaN$b!!\u0019\u0002j\u0005-\u0004\u0003\u00022h\u0003G\u00022A[A3\u0013\r\t9g\u001b\u0002\u0017\u0019&\u001cHo\u0012:pkB\u001c(+Z:q_:\u001cX\rR1uC\")\u0001o\u0004a\u0001c\"1\u0001p\u0004a\u0001\u0003[\u00022A[A8\u0013\r\t\th\u001b\u0002\u0016\u0019&\u001cHo\u0012:pkB\u001c(+Z9vKN$H)\u0019;b\u00039!Wm]2sS\n,wI]8vaN$b!a\u001e\u0002\u0010\u0006E\u0005\u0003\u00022h\u0003s\u0002b!a\u001f\u0002~\u0005\u0005U\"A3\n\u0007\u0005}TM\u0001\u0003MSN$\b\u0003BAB\u0003\u0013s1A[AC\u0013\r\t9i[\u0001\u001b\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003\u0017\u000biI\u0001\bEKN\u001c'/\u001b2fI\u001e\u0013x.\u001e9\u000b\u0007\u0005\u001d5\u000eC\u0003q!\u0001\u0007\u0011\u000fC\u0004\u0002\u0014B\u0001\r!!&\u0002\u0011\u001d\u0014x.\u001e9JIN\u0004b!a\u001f\u0002~\u0005]\u0005\u0003BAM\u0003OsA!a'\u0002$B\u0019\u0011Q\u0014\u0019\u000e\u0005\u0005}%bAAQS\u00051AH]8pizJ1!!*1\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011VAV\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0015\u0019\u0002\u0019\u0011,G.\u001a;f\u000fJ|W\u000f]:\u0015\u0011\u0005E\u0016\u0011YAb\u0003\u000b\u0004BAY4\u00024B!\u0011QWA^\u001d\rQ\u0017qW\u0005\u0004\u0003s[\u0017\u0001\u0007#fY\u0016$Xm\u0012:pkB\u001c(+Z:q_:\u001cX\rR1uC&!\u0011QXA`\u0005y!U\r\\3uC\ndWm\u0012:pkB\u0014Vm];mi\u000e{G\u000e\\3di&|gNC\u0002\u0002:.DQ\u0001]\tA\u0002EDq!a%\u0012\u0001\u0004\t)\nC\u0004\u0002\u0012E\u0001\r!a\u0005\u0002\u001f\u0019,Go\u00195BY2|eMZ:fiN$\u0002\"a3\u0002^\u0006}\u00171\u001d\t\u0005E\u001e\fi\r\u0005\u0004\u0002|\u0005u\u0014q\u001a\t\u0005\u0003#\f9ND\u0002k\u0003'L1!!6l\u0003]yeMZ:fi\u001a+Go\u00195SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002Z\u0006m'!G(gMN,GOR3uG\"\u0014Vm\u001d9p]N,Gk\u001c9jGNT1!!6l\u0011\u0015\u0001(\u00031\u0001r\u0011\u001d\t\tO\u0005a\u0001\u0003/\u000bqa\u001a:pkBLE\rC\u0004\u0002fJ\u0001\r!a:\u0002\u001bI,\u0017/^5sKN#\u0018M\u00197f!\ry\u0013\u0011^\u0005\u0004\u0003W\u0004$a\u0002\"p_2,\u0017M\\\u0001\rM\u0016$8\r[(gMN,Go\u001d\u000b\u000b\u0003\u0017\f\t0a=\u0002v\n%\u0001\"\u00029\u0014\u0001\u0004\t\bbBAq'\u0001\u0007\u0011q\u0013\u0005\b\u0003o\u001c\u0002\u0019AA}\u0003\u0019!x\u000e]5dgB1\u00111PA?\u0003w\u0004B!!@\u0003\u00049\u0019!.a@\n\u0007\t\u00051.\u0001\fPM\u001a\u001cX\r\u001e$fi\u000eD'+Z9vKN$H)\u0019;b\u0013\u0011\u0011)Aa\u0002\u00031=3gm]3u\r\u0016$8\r\u001b*fcV,7\u000f\u001e+pa&\u001c7OC\u0002\u0003\u0002-Dq!!:\u0014\u0001\u0004\t9/A\tiC:$G.\u001a$fi\u000eDwJ\u001a4tKR$\u0002\"a3\u0003\u0010\tE!1\u0003\u0005\b\u0003C$\u0002\u0019AAL\u0011\u001d\t)\u000f\u0006a\u0001\u0003ODqA!\u0006\u0015\u0001\u0004\u00119\"\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004Ra\fB\r\u0005;I1Aa\u00071\u0005\u0019y\u0005\u000f^5p]B1!q\u0004B\u0015\u0005_qAA!\t\u0003&9!\u0011Q\u0014B\u0012\u0013\u0005\t\u0014b\u0001B\u0014a\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0016\u0005[\u00111aU3r\u0015\r\u00119\u0003\r\t\u0005\u0005c\u0011\u0019$D\u0001X\u0013\r\u0011)d\u0016\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u00035\u0019w.\\7ji>3gm]3ugRA!1\bB\"\u0005\u000b\u0012i\u0005\u0005\u0003cO\nu\u0002c\u00016\u0003@%\u0019!\u0011I6\u00031=3gm]3u\u0007>lW.\u001b;SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0003q+\u0001\u0007\u0011\u000f\u0003\u0004y+\u0001\u0007!q\t\t\u0004U\n%\u0013b\u0001B&W\n9rJ\u001a4tKR\u001cu.\\7jiJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\b\u0003#)\u0002\u0019AA\n\u0003i\u0019w.\\7jiR\u0013\u0018M\\:bGRLwN\\1m\u001f\u001a47/\u001a;t)!\u0011\u0019Fa\u0017\u0003^\t\u0015\u0004\u0003\u00022h\u0005+\u00022A\u001bB,\u0013\r\u0011If\u001b\u0002\u001c)btwJ\u001a4tKR\u001cu.\\7jiJ+7\u000f]8og\u0016$\u0015\r^1\t\u000bA4\u0002\u0019A9\t\ra4\u0002\u0019\u0001B0!\rQ'\u0011M\u0005\u0004\u0005GZ'A\u0007+y]>3gm]3u\u0007>lW.\u001b;SKF,Xm\u001d;ECR\f\u0007bBA\t-\u0001\u0007\u00111C\u0001\u0018GJ,\u0017\r^3PM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006$bBa\u001b\u0003v\t}$1\u0011BG\u0005#\u0013)\n\u0005\u0003\u0003n\tETB\u0001B8\u0015\tAv%\u0003\u0003\u0003t\t=$!E(gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\"9!qO\fA\u0002\te\u0014!D2veJ,g\u000e\u001e+j[\u0016l5\u000fE\u00020\u0005wJ1A! 1\u0005\u0011auN\\4\t\u000f\t\u0005u\u00031\u0001\u0003z\u00051qN\u001a4tKRDqA!\"\u0018\u0001\u0004\u00119)A\u0006mK\u0006$WM]#q_\u000eD\u0007cA\u0018\u0003\n&\u0019!1\u0012\u0019\u0003\u0007%sG\u000fC\u0004\u0003\u0010^\u0001\r!a&\u0002\u00115,G/\u00193bi\u0006DqAa%\u0018\u0001\u0004\u0011I(A\bd_6l\u0017\u000e\u001e+j[\u0016\u001cH/Y7q\u0011\u001d\u00119j\u0006a\u0001\u00053\u000bq\"\u001a=qSJ,G+[7fgR\fW\u000e\u001d\t\u0006_\te!\u0011P\u0001\u000eI\u0016dW\r^3PM\u001a\u001cX\r^:\u0015\u0011\t}%q\u0015BU\u0005c\u0003BAY4\u0003\"B\u0019!Na)\n\u0007\t\u00156N\u0001\rPM\u001a\u001cX\r\u001e#fY\u0016$XMU3ta>t7/\u001a#bi\u0006DQ\u0001\u001d\rA\u0002EDa\u0001\u001f\rA\u0002\t-\u0006c\u00016\u0003.&\u0019!qV6\u0003/=3gm]3u\t\u0016dW\r^3SKF,Xm\u001d;ECR\f\u0007bBA\t1\u0001\u0007\u00111C\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0005\u0005\u000f\u00139\fC\u0004\u0002bf\u0001\r!a&\u0002-=tGK]1og\u0006\u001cG/[8o\u0007>l\u0007\u000f\\3uK\u0012$\u0002B!0\u0003D\n\u001d'q\u001a\t\u0004_\t}\u0016b\u0001Baa\t!QK\\5u\u0011\u001d\u0011)M\u0007a\u0001\u0005s\n!\u0002\u001d:pIV\u001cWM]%e\u0011\u001d\u0011)B\u0007a\u0001\u0005\u0013\u0004Ra\u000fBf\u0005_I1A!4=\u0005!IE/\u001a:bE2,\u0007b\u0002Bi5\u0001\u0007!1[\u0001\u0012iJ\fgn]1di&|gNU3tk2$\bc\u0001:\u0003V&\u0019!q[:\u0003#Q\u0013\u0018M\\:bGRLwN\u001c*fgVdG/A\np]B\u000b'\u000f^5uS>t7\u000fR3mKR,G\r\u0006\u0004\u0003>\nu'1\u001d\u0005\b\u0005?\\\u0002\u0019\u0001Bq\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bCBA>\u0003{\u0012y\u0003C\u0004\u0002\u0012m\u0001\r!a\u0005\u0002\u0015=tW\t\\3di&|g\u000e\u0006\u0004\u0003>\n%(Q\u001e\u0005\b\u0005Wd\u0002\u0019\u0001BD\u0003m9'o\\;q\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t\u0017J\u001c3fq\"9!q\u001e\u000fA\u0002\t\u001d\u0015!I4s_V\u0004X*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0017!D8o%\u0016\u001c\u0018n\u001a8bi&|g\u000e\u0006\u0004\u0003>\nU(q\u001f\u0005\b\u0005Wl\u0002\u0019\u0001BD\u0011\u001d\u0011y/\ba\u0001\u0005s\u0004B!a\u001f\u0003|&\u0019!Q`3\u0003\u0017=\u0003H/[8oC2Le\u000e^\u0001\u0013_:tUm^'fi\u0006$\u0017\r^1J[\u0006<W\r\u0006\u0004\u0003>\u000e\r11\u0003\u0005\b\u0007\u000bq\u0002\u0019AB\u0004\u0003!qWm^%nC\u001e,\u0007\u0003BB\u0005\u0007\u001fi!aa\u0003\u000b\u0007\r5a)A\u0003j[\u0006<W-\u0003\u0003\u0004\u0012\r-!!D'fi\u0006$\u0017\r^1J[\u0006<W\rC\u0004\u0004\u0016y\u0001\raa\u0006\u0002\u000b\u0011,G\u000e^1\u0011\t\r%1\u0011D\u0005\u0005\u00077\u0019YAA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\u0001\u001aOJ|W\u000f]'fi\u0006$\u0017\r^1U_BL7mQ8oM&<7\u000f\u0006\u0002\u0004\"A!\u00111PB\u0012\u0013\r\u0019)#\u001a\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018aB:uCJ$X\u000f\u001d\u000b\u0005\u0005{\u001bY\u0003C\u0004\u0004.\u0001\u0002\raa\f\u0002A\u001d\u0014x.\u001e9NKR\fG-\u0019;b)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\t\u0005\u0007c\u00199$\u0004\u0002\u00044)\u00191QG3\u0002\u0011\u0019,hn\u0019;j_:LAa!\u000f\u00044\tY\u0011J\u001c;TkB\u0004H.[3s\u0003!\u0019\b.\u001e;e_^tGC\u0001B_\u0011\u001d\u0019\te\u0001a\u0001\u0007\u0007\naaY8oM&<\u0007\u0003BB#\u0007\u0017j!aa\u0012\u000b\u0007\r%s%\u0001\u0004tKJ4XM]\u0005\u0005\u0007\u001b\u001a9EA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bBB)\u0007\u0001\u000711K\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\u0011\u0019)e!\u0016\n\t\r]3q\t\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u0015\t6\u00011\u0001T\u0011\u001d\u0019if\u0001a\u0001\u0007?\nq!\\3ue&\u001c7\u000f\u0005\u0003\u0004b\r\u0015TBAB2\u0015\r\u0019ifV\u0005\u0005\u0007O\u001a\u0019GA\u0004NKR\u0014\u0018nY:")
public class GroupCoordinatorAdapter
implements org.apache.kafka.coordinator.group.GroupCoordinator {
    private final GroupCoordinator coordinator;
    private final Time time;

    public static GroupCoordinatorAdapter apply(KafkaConfig config, ReplicaManager replicaManager, Time time, Metrics metrics) {
        return GroupCoordinatorAdapter$.MODULE$.apply(config, replicaManager, time, metrics);
    }

    private GroupCoordinator coordinator() {
        return this.coordinator;
    }

    private Time time() {
        return this.time;
    }

    public CompletableFuture<ConsumerGroupHeartbeatResponseData> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.CONSUMER_GROUP_HEARTBEAT.name).append(" API.").toString()));
    }

    public CompletableFuture<JoinGroupResponseData> joinGroup(RequestContext context, JoinGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<JoinGroupResponseData> future = new CompletableFuture<JoinGroupResponseData>();
        Option groupInstanceId = Option$.MODULE$.apply((Object)request.groupInstanceId());
        boolean requireKnownMemberId = context.apiVersion() >= 4 && groupInstanceId.isEmpty();
        List protocols = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(request.protocols().valuesList()).asScala().map((Function1 & Serializable)protocol -> new Tuple2((Object)protocol.name(), (Object)protocol.metadata()))).toList();
        boolean supportSkippingAssignment = context.apiVersion() >= 9;
        this.coordinator().handleJoinGroup(request.groupId(), request.memberId(), (Option<String>)groupInstanceId, requireKnownMemberId, supportSkippingAssignment, context.clientId(), context.clientAddress.toString(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), request.protocolType(), (List<Tuple2<String, byte[]>>)protocols, (Function1<JoinGroupResult, BoxedUnit>)(Function1 & Serializable)joinResult -> {
            GroupCoordinatorAdapter.callback$1(joinResult, future);
            return BoxedUnit.UNIT;
        }, (Option<String>)Option$.MODULE$.apply((Object)request.reason()), new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<SyncGroupResponseData> syncGroup(RequestContext context, SyncGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<SyncGroupResponseData> future = new CompletableFuture<SyncGroupResponseData>();
        Builder assignmentMap = Map$.MODULE$.newBuilder();
        request.assignments().forEach(assignment -> assignmentMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignment.memberId()), (Object)assignment.assignment())));
        this.coordinator().handleSyncGroup(request.groupId(), request.generationId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.protocolType()), (Option<String>)Option$.MODULE$.apply((Object)request.protocolName()), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), (Map<String, byte[]>)((Map)assignmentMap.result()), (Function1<SyncGroupResult, BoxedUnit>)(Function1 & Serializable)syncGroupResult -> {
            GroupCoordinatorAdapter.callback$2(syncGroupResult, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<HeartbeatResponseData> heartbeat(RequestContext context, HeartbeatRequestData request) {
        CompletableFuture<HeartbeatResponseData> future = new CompletableFuture<HeartbeatResponseData>();
        this.coordinator().handleHeartbeat(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            future.complete(new HeartbeatResponseData().setErrorCode(error.code()));
            return BoxedUnit.UNIT;
        });
        return future;
    }

    public CompletableFuture<LeaveGroupResponseData> leaveGroup(RequestContext context, LeaveGroupRequestData request) {
        CompletableFuture<LeaveGroupResponseData> future = new CompletableFuture<LeaveGroupResponseData>();
        this.coordinator().handleLeaveGroup(request.groupId(), (List<LeaveGroupRequestData.MemberIdentity>)CollectionConverters$.MODULE$.ListHasAsScala(request.members()).asScala().toList(), (Function1<LeaveGroupResult, BoxedUnit>)(Function1 & Serializable)leaveGroupResult -> {
            GroupCoordinatorAdapter.callback$3(leaveGroupResult, future);
            return BoxedUnit.UNIT;
        });
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<ListGroupsResponseData> listGroups(RequestContext context, ListGroupsRequestData request) {
        void var5_5;
        void var4_4;
        Tuple2<Errors, List<GroupOverview>> tuple2 = this.coordinator().handleListGroups((Set<String>)((Set)Option$.MODULE$.apply((Object)request.statesFilter()).map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1).asScala().toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        List groups = (List)tuple2._2();
        ListGroupsResponseData response = new ListGroupsResponseData().setErrorCode(var4_4.code());
        var5_5.foreach((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$listGroups$3(response, group)));
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<java.util.List<DescribeGroupsResponseData.DescribedGroup>> describeGroups(RequestContext context, java.util.List<String> groupIds) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(groupIds).asScala().map((Function1 & Serializable)groupId -> this.describeGroup$1((String)groupId))).asJava());
    }

    public CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection> deleteGroups(RequestContext context, java.util.List<String> groupIds, BufferSupplier bufferSupplier) {
        DeleteGroupsResponseData.DeletableGroupResultCollection results = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        this.coordinator().handleDeleteGroups((Set<String>)CollectionConverters$.MODULE$.ListHasAsScala(groupIds).asScala().toSet(), new RequestLocal(bufferSupplier)).foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(groupId, error) -> BoxesRunTime.boxToBoolean((boolean)results.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId).setErrorCode(error.code()))), arg_0, arg_1));
        return CompletableFuture.completedFuture(results);
    }

    public CompletableFuture<java.util.List<OffsetFetchResponseData.OffsetFetchResponseTopics>> fetchAllOffsets(RequestContext context, String groupId, boolean requireStable) {
        return this.handleFetchOffset(groupId, requireStable, (Option<scala.collection.immutable.Seq<TopicPartition>>)None$.MODULE$);
    }

    public CompletableFuture<java.util.List<OffsetFetchResponseData.OffsetFetchResponseTopics>> fetchOffsets(RequestContext context, String groupId, java.util.List<OffsetFetchRequestData.OffsetFetchRequestTopics> topics, boolean requireStable) {
        ArrayBuffer topicPartitions = new ArrayBuffer();
        topics.forEach(topic -> topic.partitionIndexes().forEach(partition -> topicPartitions.$plus$eq((Object)new TopicPartition(topic.name(), Predef$.MODULE$.Integer2int(partition)))));
        return this.handleFetchOffset(groupId, requireStable, (Option<scala.collection.immutable.Seq<TopicPartition>>)new Some((Object)topicPartitions.toSeq()));
    }

    /*
     * WARNING - void declaration
     */
    private CompletableFuture<java.util.List<OffsetFetchResponseData.OffsetFetchResponseTopics>> handleFetchOffset(String groupId, boolean requireStable, Option<scala.collection.immutable.Seq<TopicPartition>> partitions) {
        void var5_5;
        Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>> tuple2 = this.coordinator().handleFetchOffsets(groupId, requireStable, partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map results = (Map)tuple2._2();
        CompletableFuture<java.util.List<OffsetFetchResponseData.OffsetFetchResponseTopics>> future = new CompletableFuture<java.util.List<OffsetFetchResponseData.OffsetFetchResponseTopics>>();
        void v0 = var5_5;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally(var5_5.exception());
        } else {
            void var6_6;
            ArrayList topicsList = new ArrayList();
            HashMap topicsMap = new HashMap();
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(tp, offset) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$handleFetchOffset$1(topicsMap, topicsList, tp, offset));
            var6_6.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var11_11 = null;
            future.complete(topicsList);
        }
        return future;
    }

    public CompletableFuture<OffsetCommitResponseData> commitOffsets(RequestContext context, OffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<OffsetCommitResponseData> future = new CompletableFuture<OffsetCommitResponseData>();
        long l = request.retentionTimeMs();
        None$ expireTimeMs = -1L == l ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(currentTimeMs + l)));
        HashMap partitions = new HashMap();
        request.topics().forEach(arg_0 -> GroupCoordinatorAdapter.$anonfun$commitOffsets$2(this, partitions, currentTimeMs, (Option)expireTimeMs, arg_0));
        this.coordinator().handleCommitOffsets(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable)commitStatus -> {
            GroupCoordinatorAdapter.callback$4(commitStatus, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<TxnOffsetCommitResponseData> commitTransactionalOffsets(RequestContext context, TxnOffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<TxnOffsetCommitResponseData> future = new CompletableFuture<TxnOffsetCommitResponseData>();
        HashMap partitions = new HashMap();
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)this.createOffsetAndMetadata(currentTimeMs, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), -1L, (Option<Object>)None$.MODULE$)));
        }));
        this.coordinator().handleTxnCommitOffsets(request.groupId(), request.producerId(), request.producerEpoch(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable)results -> {
            GroupCoordinatorAdapter.callback$5(results, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    private OffsetAndMetadata createOffsetAndMetadata(long currentTimeMs, long offset, int leaderEpoch, String metadata, long commitTimestamp, Option<Object> expireTimestamp) {
        String string;
        Optional<Integer> optional;
        switch (leaderEpoch) {
            case -1: {
                optional = Optional.empty();
                break;
            }
            default: {
                optional = Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch));
            }
        }
        switch (metadata == null ? 0 : metadata.hashCode()) {
            case 0: {
                if (metadata == null) {
                    string = OffsetAndMetadata$.MODULE$.NoMetadata();
                    break;
                }
            }
            default: {
                string = metadata;
            }
        }
        return new OffsetAndMetadata(offset, optional, string, -1L == commitTimestamp ? currentTimeMs : commitTimestamp, expireTimestamp);
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<OffsetDeleteResponseData> deleteOffsets(RequestContext context, OffsetDeleteRequestData request, BufferSupplier bufferSupplier) {
        void var7_7;
        CompletableFuture<OffsetDeleteResponseData> future = new CompletableFuture<OffsetDeleteResponseData>();
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> partitions.$plus$eq((Object)new TopicPartition(topic.name(), partition.partitionIndex()))));
        Tuple2<Errors, Map<TopicPartition, Errors>> tuple2 = this.coordinator().handleDeleteOffsets(request.groupId(), (Seq<TopicPartition>)partitions, new RequestLocal(bufferSupplier));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors groupError = (Errors)tuple2._1();
        Map topicPartitionResults = (Map)tuple2._2();
        void v0 = var7_7;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally(var7_7.exception());
        } else {
            void var8_8;
            OffsetDeleteResponseData response = new OffsetDeleteResponseData();
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$deleteOffsets$3(response, topicPartition, error));
            var8_8.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var11_11 = null;
            future.complete(response);
        }
        return future;
    }

    public int partitionFor(String groupId) {
        return this.coordinator().partitionFor(groupId);
    }

    public void onTransactionCompleted(long producerId, java.lang.Iterable<TopicPartition> partitions, TransactionResult transactionResult) {
        this.coordinator().scheduleHandleTxnCompletion(producerId, (Iterable<TopicPartition>)CollectionConverters$.MODULE$.IterableHasAsScala(partitions).asScala(), transactionResult);
    }

    public void onPartitionsDeleted(java.util.List<TopicPartition> topicPartitions, BufferSupplier bufferSupplier) {
        this.coordinator().handleDeletedPartitions((Seq<TopicPartition>)CollectionConverters$.MODULE$.ListHasAsScala(topicPartitions).asScala(), new RequestLocal(bufferSupplier));
    }

    public void onElection(int groupMetadataPartitionIndex, int groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onElection(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onResignation(int groupMetadataPartitionIndex, OptionalInt groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onResignation(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
    }

    public Properties groupMetadataTopicConfigs() {
        return this.coordinator().offsetsTopicConfigs();
    }

    public void startup(IntSupplier groupMetadataTopicPartitionCount) {
        this.coordinator().startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> groupMetadataTopicPartitionCount.getAsInt(), this.coordinator().startup$default$2());
    }

    public void shutdown() {
        this.coordinator().shutdown();
    }

    private static final void callback$1(JoinGroupResult joinResult, CompletableFuture future$1) {
        future$1.complete(new JoinGroupResponseData().setErrorCode(joinResult.error().code()).setGenerationId(joinResult.generationId()).setProtocolType((String)joinResult.protocolType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setProtocolName((String)joinResult.protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setLeader(joinResult.leaderId()).setSkipAssignment(joinResult.skipAssignment()).setMemberId(joinResult.memberId()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava(joinResult.members()).asJava()));
    }

    private static final void callback$2(SyncGroupResult syncGroupResult, CompletableFuture future$2) {
        future$2.complete(new SyncGroupResponseData().setErrorCode(syncGroupResult.error().code()).setProtocolType((String)syncGroupResult.protocolType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setProtocolName((String)syncGroupResult.protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setAssignment(syncGroupResult.memberAssignment()));
    }

    private static final void callback$3(LeaveGroupResult leaveGroupResult, CompletableFuture future$4) {
        future$4.complete(new LeaveGroupResponseData().setErrorCode(leaveGroupResult.topLevelError().code()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaveGroupResult.memberResponses().map((Function1 & Serializable)member -> new LeaveGroupResponseData.MemberResponse().setErrorCode(member.error().code()).setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$listGroups$3(ListGroupsResponseData response$1, GroupOverview group) {
        return response$1.groups().add(new ListGroupsResponseData.ListedGroup().setGroupId(group.groupId()).setProtocolType(group.protocolType()).setGroupState(group.state()));
    }

    /*
     * WARNING - void declaration
     */
    private final DescribeGroupsResponseData.DescribedGroup describeGroup$1(String groupId) {
        void var4_4;
        void var3_3;
        Tuple2<Errors, GroupSummary> tuple2 = this.coordinator().handleDescribeGroup(groupId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        GroupSummary summary = (GroupSummary)tuple2._2();
        return new DescribeGroupsResponseData.DescribedGroup().setErrorCode(var3_3.code()).setGroupId(groupId).setGroupState(var4_4.state()).setProtocolType(var4_4.protocolType()).setProtocolData(var4_4.protocol()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)var4_4.members().map((Function1 & Serializable)member -> new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setClientId(member.clientId()).setClientHost(member.clientHost()).setMemberAssignment(member.assignment()).setMemberMetadata(member.metadata()))).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchOffset$1(HashMap topicsMap$1, ArrayList topicsList$1, TopicPartition tp, OffsetFetchResponse.PartitionData offset) {
        OffsetFetchResponseData.OffsetFetchResponseTopics offsetFetchResponseTopics;
        Option option = topicsMap$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetFetchResponseTopics = (OffsetFetchResponseData.OffsetFetchResponseTopics)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetFetchResponseData.OffsetFetchResponseTopics topicOffsets = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(tp.topic());
            topicsMap$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)topicOffsets));
            topicsList$1.add(topicOffsets);
            offsetFetchResponseTopics = topicOffsets;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetFetchResponseTopics.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp.partition()).setMetadata(offset.metadata).setCommittedOffset(offset.offset).setCommittedLeaderEpoch(Predef$.MODULE$.Integer2int(offset.leaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1)))).setErrorCode(offset.error.code()));
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$1(HashMap byTopics$1, OffsetCommitResponseData response$2, TopicIdPartition tp, Errors error) {
        OffsetCommitResponseData.OffsetCommitResponseTopic offsetCommitResponseTopic;
        Option option = byTopics$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetCommitResponseTopic = (OffsetCommitResponseData.OffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetCommitResponseData.OffsetCommitResponseTopic newTopic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(tp.topic());
            byTopics$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$2.topics().add(newTopic);
            offsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetCommitResponseTopic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    private static final void callback$4(scala.collection.immutable.Map commitStatus, CompletableFuture future$5) {
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitOffsets$1(byTopics, response, tp, error));
        commitStatus.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var4_4 = null;
        future$5.complete(response);
    }

    public static final /* synthetic */ void $anonfun$commitOffsets$2(GroupCoordinatorAdapter $this, HashMap partitions$1, long currentTimeMs$1, Option expireTimeMs$1, OffsetCommitRequestData.OffsetCommitRequestTopic topic) {
        topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)$this.createOffsetAndMetadata(currentTimeMs$1, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), partition.commitTimestamp(), (Option<Object>)expireTimeMs$1)));
        });
    }

    public static final /* synthetic */ boolean $anonfun$commitTransactionalOffsets$1(HashMap byTopics$2, TxnOffsetCommitResponseData response$3, TopicIdPartition tp, Errors error) {
        TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic txnOffsetCommitResponseTopic;
        Option option = byTopics$2.get((Object)tp.topic());
        if (option instanceof Some) {
            txnOffsetCommitResponseTopic = (TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic newTopic = new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(tp.topic());
            byTopics$2.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$3.topics().add(newTopic);
            txnOffsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return txnOffsetCommitResponseTopic.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    private static final void callback$5(scala.collection.immutable.Map results, CompletableFuture future$6) {
        TxnOffsetCommitResponseData response = new TxnOffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitTransactionalOffsets$1(byTopics, response, tp, error));
        results.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var4_4 = null;
        future$6.complete(response);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOffsets$3(OffsetDeleteResponseData response$4, TopicPartition topicPartition, Errors error) {
        OffsetDeleteResponseData.OffsetDeleteResponseTopic topic = response$4.topics().find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topicPartition.topic());
            response$4.topics().add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(topicPartition.partition()).setErrorCode(error.code()));
    }

    public GroupCoordinatorAdapter(GroupCoordinator coordinator, Time time) {
        this.coordinator = coordinator;
        this.time = time;
    }
}

