/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.ratelimit.RateLimitModule;
import io.confluent.kafkarest.ratelimit.RequestRateLimiter;
import io.confluent.kafkarest.ratelimit.RequestRateLimiterCacheLoader;
import java.time.Duration;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

public class ProduceRateLimiters {
    private final boolean rateLimitingEnabled;
    private final LoadingCache<String, RequestRateLimiter> countCache;
    private final LoadingCache<String, RequestRateLimiter> bytesCache;
    private final Provider<RequestRateLimiter> bytesLimiterGlobal;
    private final Provider<RequestRateLimiter> countLimiterGlobal;

    @Inject
    public ProduceRateLimiters(@RateLimitModule.ProduceRateLimiterCount Provider<RequestRateLimiter> countLimiterProvider, @RateLimitModule.ProduceRateLimiterBytes Provider<RequestRateLimiter> bytesLimiterProvider, @RateLimitModule.ProduceRateLimiterCountGlobal Provider<RequestRateLimiter> countLimiterGlobal, @RateLimitModule.ProduceRateLimiterBytesGlobal Provider<RequestRateLimiter> bytesLimiterGlobal, @ConfigModule.ProduceRateLimitEnabledConfig Boolean produceRateLimitEnabledConfig, @ConfigModule.ProduceRateLimitCacheExpiryConfig Duration produceRateLimitCacheExpiryConfig) {
        this.rateLimitingEnabled = Objects.requireNonNull(produceRateLimitEnabledConfig);
        this.countLimiterGlobal = Objects.requireNonNull(countLimiterGlobal);
        this.bytesLimiterGlobal = Objects.requireNonNull(bytesLimiterGlobal);
        this.countCache = CacheBuilder.newBuilder().expireAfterAccess(produceRateLimitCacheExpiryConfig).build((CacheLoader)new RequestRateLimiterCacheLoader(countLimiterProvider));
        this.bytesCache = CacheBuilder.newBuilder().expireAfterAccess(produceRateLimitCacheExpiryConfig).build((CacheLoader)new RequestRateLimiterCacheLoader(bytesLimiterProvider));
    }

    public void rateLimit(String clusterId, long requestSize) {
        if (!this.rateLimitingEnabled) {
            return;
        }
        ((RequestRateLimiter)this.countLimiterGlobal.get()).rateLimit(1);
        ((RequestRateLimiter)this.bytesLimiterGlobal.get()).rateLimit(Math.toIntExact(requestSize));
        RequestRateLimiter countRateLimiter = (RequestRateLimiter)this.countCache.getUnchecked((Object)clusterId);
        RequestRateLimiter byteRateLimiter = (RequestRateLimiter)this.bytesCache.getUnchecked((Object)clusterId);
        countRateLimiter.rateLimit(1);
        byteRateLimiter.rateLimit(Math.toIntExact(requestSize));
    }

    public void clear() {
        this.countCache.invalidateAll();
        this.bytesCache.invalidateAll();
    }
}

